/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import se.ericsson.security.launcher.ApplicationFile;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.CachedFile;
import se.ericsson.security.utils.EmLogger;

public class CachedJarFile
extends CachedFile {
    private static final EmLogger LOG = EmLogger.LAUNCHER;

    public CachedJarFile(String fileName, boolean setDataFromManifest) throws CacheException {
        super(fileName);
        if (setDataFromManifest) {
            this.readRevisionFromFile();
        } else {
            this.readRevisionFromPath();
        }
        LOG.fine("Found " + this.getAttributes().getProductNumber() + " " + this.getAttributes().getRevision() + " for " + fileName, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readRevisionFromFile() throws CacheException {
        block28: {
            block24: {
                file = new File(this.getFileName());
                if (file.isDirectory()) {
                    this.setAttributes(new ApplicationFile(file.getName(), file.getPath(), "UNKNOWN", "UNKNOWN"));
                    CachedJarFile.LOG.fine("readRevisionFromFile() failed - got directory, not file: " + file, new Object[0]);
                    return;
                }
                if (!file.isFile() || !file.canRead()) {
                    this.setAttributes(new ApplicationFile(file.getName(), file.getPath(), "UNKNOWN", "UNKNOWN"));
                    CachedJarFile.LOG.warning("readRevisionFromFile() failed - Can't read file: " + file, new Object[0]);
                    throw new CacheException("Can't read jar file '" + file + "'!");
                }
                in = null;
                jis = null;
                try {
                    try {
                        in = new FileInputStream(file);
                        jis = new JarInputStream(in);
                        mf = jis.getManifest();
                        if (mf == null) {
                            throw new CacheException("No manifest found in " + file.getName());
                        }
                        mainattributes = mf.getMainAttributes();
                        productNumber = mainattributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        revision = mainattributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        if (revision == null) {
                            throw new CacheException("No revision info found in manifest of " + file.getName());
                        }
                        if (productNumber == null) {
                            throw new CacheException("No product number found in manifest of " + file.getName());
                        }
                        this.setAttributes(new ApplicationFile(file.getName(), file.getPath(), productNumber, revision));
                        CachedJarFile.LOG.fine("Found " + this.getAttributes().getProductNumber() + " " + this.getAttributes().getRevision() + " in " + file.getName(), new Object[0]);
                    }
                    catch (IOException ioe) {
                        throw new CacheException("Failed to get read versionfile " + file.getName(), (Throwable)ioe);
                    }
                    var9_9 = null;
                    if (jis == null) break block24;
                }
                catch (Throwable var8_31) {
                    block26: {
                        var9_10 = null;
                        if (jis != null) {
                            try {
                                try {
                                    jis.close();
                                }
                                catch (IOException ioe /* !! */ ) {
                                    CachedJarFile.LOG.warning("Failed to close jarinputstream for " + file.getName(), new Object[0]);
                                    var12_15 = null;
                                    jis = null;
                                    break block26;
                                }
                                var12_14 = null;
                                jis = null;
                            }
                            catch (Throwable var11_20) {
                                var12_16 = null;
                                jis = null;
                                throw var11_20;
                            }
                        }
                    }
                    if (in == null) throw var8_31;
                    try {
                        try {
                            in.close();
                        }
                        catch (IOException ioe /* !! */ ) {
                            CachedJarFile.LOG.warning("Failed to close inpustream for " + file.getName(), new Object[0]);
                            var14_26 = null;
                            in = null;
                            throw var8_31;
                        }
                        catch (NullPointerException ioe /* !! */ ) {
                            CachedJarFile.LOG.fine("Triggered bug in jvm for " + file.getName(), new Object[0]);
                            var14_27 = null;
                            in = null;
                            throw var8_31;
                        }
                        var14_25 = null;
                        in = null;
                        throw var8_31;
                    }
                    catch (Throwable var13_30) {
                        var14_28 = null;
                        in = null;
                        throw var13_30;
                    }
                }
                try {}
                catch (Throwable var11_19) {
                    var12_13 = null;
                    jis = null;
                    throw var11_19;
                }
                try {}
                catch (IOException ioe /* !! */ ) {
                    CachedJarFile.LOG.warning("Failed to close jarinputstream for " + file.getName(), new Object[0]);
                    var12_12 = null;
                    jis = null;
                    break block24;
                }
                jis.close();
                var12_11 = null;
                jis = null;
            }
            if (in == null) return;
            try {}
            catch (Throwable var13_29) {
                var14_24 = null;
                in = null;
                throw var13_29;
            }
            ** try [egrp 5[TRYBLOCK] [7, 8 : 541->545)] { 
lbl111:
            // 1 sources

            break block28;
lbl112:
            // 1 sources

            catch (IOException ioe /* !! */ ) {
                CachedJarFile.LOG.warning("Failed to close inpustream for " + file.getName(), new Object[0]);
                return;
            }
lbl116:
            // 1 sources

            catch (NullPointerException ioe /* !! */ ) {
                CachedJarFile.LOG.fine("Triggered bug in jvm for " + file.getName(), new Object[0]);
                return;
            }
        }
        in.close();
    }

    protected void readRevisionFromPath() throws CacheException {
        File prodDir;
        String productNumber = "UNKNOWN";
        String revision = "UNKNOWN";
        File jarFile = new File(this.getFileName());
        File revDir = jarFile.getParentFile();
        if (revDir != null && (prodDir = revDir.getParentFile()) != null) {
            productNumber = prodDir.getName();
            revision = revDir.getName();
        }
        this.setAttributes(new ApplicationFile(jarFile.getName(), jarFile.getPath(), productNumber, revision));
    }
}

