/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import se.ericsson.security.launcher.cache.VerifyException;
import se.ericsson.security.launcher.util.SecurityLogTool;
import se.ericsson.security.utils.EmLogger;

public class LocalJarFileVerifier {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private String jarFileWithPath;
    private String jarFileName;
    private X509Certificate lastValidatedLeafCert = null;

    public void verifyLauncherCertificate(String jarFileWithPath) {
        LOG.fine("Validating local launcher.jar file", new Object[0]);
        CodeSource thisCodeSource = this.getClass().getProtectionDomain().getCodeSource();
        Certificate[] certificates = thisCodeSource.getCertificates();
        if (null == certificates) {
            return;
        }
        ArrayList<X509Certificate> expiredCerts = new ArrayList<X509Certificate>();
        for (int i = 0; i < certificates.length; ++i) {
            if (certificates[i] instanceof X509Certificate) {
                X509Certificate x509Cert = (X509Certificate)certificates[i];
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateException ce) {
                    LOG.severe("The certificate of launcher.jar has expired, please update launcher.jar or reinstall EM.", new Object[0]);
                    LOG.severe("Certificate with SubjectDN = " + x509Cert.getSubjectDN() + " is not valid, " + ce, new Object[0]);
                    expiredCerts.add(x509Cert);
                }
                continue;
            }
            LOG.severe("Trusted Certificate from launcher is not X509. Type= " + certificates[i].getType(), new Object[0]);
        }
        File launcherFile = new File(jarFileWithPath);
        if (expiredCerts.size() > 0) {
            SecurityLogTool.writeEMSecurityLog(jarFileWithPath, expiredCerts, "LOCAL", "clientLauncher", launcherFile.getName());
        }
        SecurityLogTool.putDataIntoList(launcherFile.getName(), "LOCAL", "clientLauncher");
        LOG.fine("Validate launcher.jar file end", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void verifyJarFile(File localFile) throws VerifyException {
        block26: {
            IOException ioe22;
            int progress;
            JarInputStream jarIs;
            FileInputStream fis;
            block23: {
                LOG.info("Validating local file " + localFile, new Object[0]);
                this.jarFileWithPath = localFile.getAbsolutePath();
                this.jarFileName = localFile.getName();
                fis = null;
                jarIs = null;
                progress = 0;
                int read = 0;
                byte[] buffer = new byte[8192];
                fis = new FileInputStream(localFile);
                jarIs = new JarInputStream((InputStream)fis, true);
                JarEntry je = jarIs.getNextJarEntry();
                while (je != null) {
                    while ((read = jarIs.read(buffer, 0, buffer.length)) != -1) {
                        progress += read;
                    }
                    if (!je.isDirectory()) {
                        this.verifyJarEntry(je);
                    }
                    je = jarIs.getNextJarEntry();
                }
                buffer = null;
                Object var9_10 = null;
                if (fis == null) break block23;
                try {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe22) {
                        LOG.severe("Failed to close fileinputstream " + localFile + ioe22.toString(), new Object[0]);
                        Object var12_13 = null;
                        fis = null;
                        break block23;
                    }
                    Object var12_12 = null;
                    fis = null;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    fis = null;
                    throw throwable;
                }
            }
            if (jarIs != null) {
                try {
                    try {
                        jarIs.close();
                    }
                    catch (IOException ioe22) {
                        LOG.fine("Failed to close jarinputstream " + localFile + ioe22.toString(), new Object[0]);
                        Object var14_23 = null;
                        jarIs = null;
                    }
                    Object var14_22 = null;
                    jarIs = null;
                }
                catch (Throwable throwable) {
                    Object var14_24 = null;
                    jarIs = null;
                    throw throwable;
                }
            }
            break block26;
            {
                catch (VerifyException ve) {
                    LOG.warning("Could not verify file, progress :" + progress, new Object[0]);
                    throw ve;
                }
                catch (IOException ie) {
                    throw new VerifyException("Failed to verify ", (Throwable)ie);
                }
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var9_11 = null;
                if (fis != null) {
                    try {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe22) {
                            LOG.severe("Failed to close fileinputstream " + localFile + ioe22.toString(), new Object[0]);
                            Object var12_16 = null;
                            fis = null;
                        }
                        Object var12_15 = null;
                        fis = null;
                    }
                    catch (Throwable throwable2) {
                        Object var12_17 = null;
                        fis = null;
                        throw throwable2;
                    }
                }
                if (jarIs != null) {
                    try {
                        try {
                            jarIs.close();
                        }
                        catch (IOException ioe22) {
                            LOG.fine("Failed to close jarinputstream " + localFile + ioe22.toString(), new Object[0]);
                            Object var14_26 = null;
                            jarIs = null;
                        }
                        Object var14_25 = null;
                        jarIs = null;
                    }
                    catch (Throwable throwable3) {
                        Object var14_27 = null;
                        jarIs = null;
                        throw throwable3;
                    }
                }
                throw throwable;
            }
        }
    }

    private void verifyJarEntry(JarEntry je) throws VerifyException {
        Certificate[] codeCerts = null;
        try {
            codeCerts = this.getCodeSigners(je);
            if (codeCerts == null || codeCerts.length == 0) {
                if (!je.getName().startsWith("META-INF/")) {
                    throw new VerifyException("Unsigned jar entry :" + je.getName());
                }
            } else {
                this.checkCodeCerts(codeCerts);
            }
        }
        catch (VerifyException ve) {
            VerifyException e = new VerifyException("Failed to verify entry " + je.getName(), (Throwable)ve);
            throw e;
        }
    }

    private Certificate[] getCodeSigners(JarEntry je) throws VerifyException {
        if (this.isRunningJava5()) {
            LOG.finer("Java 5 detected.", new Object[0]);
            try {
                Method getCodeSigners = je.getClass().getMethod("getCodeSigners", new Class[0]);
                Object[] signers = (Object[])getCodeSigners.invoke((Object)je, new Object[0]);
                if (signers == null || signers.length == 0) {
                    return null;
                }
                if (signers.length != 1) {
                    throw new VerifyException("Ambigously signed entry: " + je.getName());
                }
                Method getSignerCertPath = signers[0].getClass().getMethod("getSignerCertPath", new Class[0]);
                CertPath certPath = (CertPath)getSignerCertPath.invoke(signers[0], new Object[0]);
                List<? extends Certificate> certs = certPath.getCertificates();
                Certificate[] codeCerts = new Certificate[certs.size()];
                certs.toArray(codeCerts);
                return codeCerts;
            }
            catch (SecurityException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new VerifyException("Unable to perform verification", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new VerifyException("Unable to perform verification, InvocationTargetException:", e.getCause());
            }
        }
        return je.getCertificates();
    }

    private boolean isRunningJava5() {
        try {
            JarEntry.class.getMethod("getCodeSigners", new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            LOG.fine("Cannot determine if running Java 5.", new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void checkCodeCerts(Certificate[] codeCerts) throws VerifyException {
        boolean isContain = SecurityLogTool.isContainLMName(this.jarFileName);
        if (this.lastValidatedLeafCert != null && codeCerts[0].equals(this.lastValidatedLeafCert) && isContain) {
            return;
        }
        int[] rootCertsIndex = this.getCodeCertsRoots(codeCerts);
        for (int i = 0; i < rootCertsIndex.length; ++i) {
            int leaf = i == 0 ? 0 : (rootCertsIndex[i] == rootCertsIndex[i - 1] + 1 ? rootCertsIndex[i] : rootCertsIndex[i - 1] + 1);
            if (this.lastValidatedLeafCert != null && codeCerts[leaf].equals(this.lastValidatedLeafCert) && isContain) {
                return;
            }
            if (!this.validateChain(codeCerts, leaf, rootCertsIndex[i])) continue;
            this.lastValidatedLeafCert = (X509Certificate)codeCerts[leaf];
            LOG.fine("Last Validated Leaf Cert set to " + this.lastValidatedLeafCert.getSubjectDN(), new Object[0]);
            SecurityLogTool.putDataIntoList(this.jarFileName, "LOCAL", "nodeLauncher");
            return;
        }
        throw new VerifyException("Could not verify code signing certs");
    }

    private boolean validateChain(Certificate[] codeCerts, int leafindex, int rootindex) {
        ArrayList<X509Certificate> expiredCerts = new ArrayList<X509Certificate>();
        for (int i = leafindex; i <= rootindex; ++i) {
            X509Certificate cert = (X509Certificate)codeCerts[i];
            try {
                cert.checkValidity();
                continue;
            }
            catch (CertificateExpiredException e) {
                LOG.warning("Certificate has expired " + cert + e.toString(), new Object[0]);
                expiredCerts.add(cert);
                continue;
            }
            catch (CertificateException e) {
                LOG.severe("Certificate not valid " + cert + e.toString(), new Object[0]);
                expiredCerts.add(cert);
            }
        }
        if (expiredCerts.size() > 0) {
            SecurityLogTool.writeEMSecurityLog(this.jarFileWithPath, expiredCerts, "LOCAL", "nodeLauncher", this.jarFileName);
        }
        return true;
    }

    private int[] getCodeCertsRoots(Certificate[] certs) throws VerifyException {
        LOG.fine("Certificate chain has length " + certs.length, new Object[0]);
        Vector<Integer> result = new Vector<Integer>(1);
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate cert = (X509Certificate)certs[i];
            if (!((Object)cert.getSubjectDN()).equals(cert.getIssuerDN())) continue;
            LOG.fine("Added Root Code Signing CA " + cert.getSubjectDN(), new Object[0]);
            result.addElement(new Integer(i));
        }
        if (result.size() == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("No root certificates found among: \n");
            for (int i = 0; i < certs.length; ++i) {
                sb.append(((X509Certificate)certs[i]).getSubjectDN()).append("\n");
            }
            LOG.severe(sb.toString(), new Object[0]);
            throw new VerifyException("Incomplete certificate chain. No root certificate found");
        }
        int[] indexarray = new int[result.size()];
        for (int i = 0; i < indexarray.length; ++i) {
            indexarray[i] = (Integer)result.elementAt(i);
        }
        return indexarray;
    }
}

