/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.eprops;

import java.util.Map;
import se.ericsson.security.launcher.eprops.AbstractionLevel;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EKey;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.eprops.ExceptionProperty;

public abstract class EPrinter {
    protected StringBuilder buffer = new StringBuilder();

    abstract void printTitle(String var1);

    abstract void printKey(String var1);

    abstract void printValue(String var1);

    boolean isLevelOkToPrint(AbstractionLevel al, EProps ep) {
        return true;
    }

    public String print(EProps ep) {
        this.printAll(ep);
        return this.toString();
    }

    public void freeBuffer() {
        this.buffer = new StringBuilder();
    }

    void print(ExceptionProperty prop) {
        this.printKey(prop.key.NAME);
        this.printValue(prop.value);
    }

    private void printAll(EProps ep) {
        if (ep == null || ep.isEmpty()) {
            return;
        }
        AbstractionLevel lastAL = ((EKey)ep.firstKey()).ABSTRACTION_LEVEL;
        EProps levelProps = new EProps();
        for (Map.Entry entry : ep.entrySet()) {
            EKey key = (EKey)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.ABSTRACTION_LEVEL.equals(lastAL)) {
                this.printLevel(lastAL, levelProps);
                lastAL = key.ABSTRACTION_LEVEL;
            }
            levelProps.put(key, value);
        }
        this.printLevel(lastAL, levelProps);
    }

    private void printLevel(AbstractionLevel al, EProps ep) {
        if (!this.isLevelOkToPrint(al, ep)) {
            return;
        }
        this.printTitle(al.TITLE);
        for (Map.Entry entry : ep.entrySet()) {
            EKey key = (EKey)entry.getKey();
            String value = (String)entry.getValue();
            this.printKey(key.NAME);
            this.printValue(value);
        }
        ep.clear();
    }

    void printIndented(String text, String afterNewLine) {
        if (text != null && !text.equals("")) {
            int firstNL = text.indexOf(10);
            if (firstNL == -1) {
                this.buffer.append(text);
            } else {
                int buffSize = text.length() + 10 * afterNewLine.length();
                StringBuffer valueBuffer = new StringBuffer(buffSize);
                valueBuffer.append(text);
                int nextNL = firstNL;
                while (nextNL != -1) {
                    valueBuffer.insert(nextNL + 1, afterNewLine);
                    nextNL = valueBuffer.indexOf("\n", nextNL + afterNewLine.length());
                }
                this.buffer.append(valueBuffer);
            }
        }
    }

    void printRightPadded(String text, char c, int newStringLength) {
        int newLength = this.buffer.length() + newStringLength;
        this.buffer.append(text).append(c);
        while (this.buffer.length() < newLength) {
            this.buffer.append(c);
        }
    }

    void print(String text) {
        this.buffer.append(text);
    }

    void print(StringBuffer text) {
        this.buffer.append(text);
    }

    public int length() {
        return this.buffer.length();
    }

    public String toString() {
        return this.buffer.toString();
    }

    public static class ExceptionMessage
    extends EPrinter {
        static final String STACKDUMP_KEY_INDENTION = "   ";
        int keyWidth = 24;

        void printTitle(String title) {
        }

        void printKey(String key) {
            this.print("\n");
            this.print(STACKDUMP_KEY_INDENTION);
            this.printRightPadded(key, ' ', this.keyWidth);
            this.print(": ");
        }

        void printValue(String value) {
            this.printIndented(value, "      ");
        }
    }

    public static class ErrorPopUpDetails
    extends ErrorPopUpMain {
        boolean isLevelOkToPrint(AbstractionLevel al, EProps ep) {
            boolean isDisplayed = al.PRESENTATION_LEVEL != EKEY.PL_NONE;
            return isDisplayed;
        }

        void printTitle(String title) {
            this.print("\n\n ");
            this.print(title);
            this.print("\n ");
            this.printRightPadded("", '=', title.length());
        }
    }

    public static class ErrorPopUpMain
    extends EPrinter {
        static final String POPUP_VALUE_INDENTION = "    ";

        boolean isLevelOkToPrint(AbstractionLevel al, EProps ep) {
            boolean isDisplayed = al.PRESENTATION_LEVEL == EKEY.PL_MESSAGE;
            return isDisplayed;
        }

        void printTitle(String title) {
        }

        void printKey(String key) {
            this.print("\n\n ");
            this.print(key);
            this.print(":");
        }

        void printValue(String value) {
            this.print("\n");
            this.print(POPUP_VALUE_INDENTION);
            this.printIndented(value, POPUP_VALUE_INDENTION);
        }

        public String print(EProps ep) {
            super.print(ep);
            if (this.buffer.length() == 0 || this.buffer.charAt(this.buffer.length() - 1) != '\n') {
                this.print("\n");
            }
            return this.toString();
        }
    }
}

