/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.eprops;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.security.launcher.eprops.EKey;
import se.ericsson.security.launcher.eprops.EPropsChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EProps
extends TreeMap<EKey, String> {
    private static EProps revisionProperties = new EProps();
    private static final long serialVersionUID = 1922843339066600739L;

    public EProps() {
    }

    public EProps(EProps otherEProps) {
        this();
        this.putAll(otherEProps);
    }

    public String getProperty(EKey key) {
        return (String)this.get(key);
    }

    @Override
    public String put(EKey key, String value) {
        String oldValue = super.put(key, String.valueOf(value));
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends EKey, ? extends String> map) {
        if (map instanceof EProps) {
            super.putAll(map);
        } else {
            for (Map.Entry<? extends EKey, ? extends String> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void set(EKey key, Object value) {
        super.put(key, String.valueOf(value));
    }

    public void setUnlessNull(EKey key, Object value) {
        if (value == null) {
            return;
        }
        this.set(key, value);
    }

    public void setUnlessEmpty(EKey key, Object value) {
        if (value == null) {
            return;
        }
        if ("".equals(value.toString())) {
            return;
        }
        this.set(key, value);
    }

    public void setUnlessSet(EKey key, Object value) {
        String oldValue = this.getProperty(key);
        if (oldValue != null) {
            return;
        }
        this.setUnlessEmpty(key, value);
    }

    public void prepend(EKey key, String value, String delimiter) {
        if (value == null || "".equals(value)) {
            return;
        }
        String oldValue = this.getProperty(key);
        if (oldValue == null) {
            oldValue = "";
        }
        if (delimiter == null || "".equals(oldValue)) {
            delimiter = "";
        }
        this.set(key, value + delimiter + oldValue);
    }

    public EProps append(EKey key, String delimiter, String value) {
        if (value == null || "".equals(value)) {
            return this;
        }
        String oldValue = this.getProperty(key);
        if (oldValue == null) {
            oldValue = "";
        }
        if (delimiter == null || "".equals(oldValue)) {
            delimiter = "";
        }
        this.set(key, oldValue + delimiter + value);
        return this;
    }

    public EProps append(EKey key, String value) {
        return this.append(key, "\n", value);
    }

    public EProps setStackTrace(EKey key, Throwable throwable) {
        String stackTrace = EProps.getStackTrace(throwable);
        this.set(key, stackTrace);
        return this;
    }

    public int maxKeyLength() {
        int max = 0;
        for (EKey key : this.keySet()) {
            int newMax = key.NAME.length();
            if (max >= newMax) continue;
            max = newMax;
        }
        return max;
    }

    public static String getStackTrace(Throwable throwable) {
        String dump = null;
        if (throwable != null) {
            StringWriter eStrW = new StringWriter(1024);
            throwable.printStackTrace(new PrintWriter(eStrW));
            StringBuffer sb = eStrW.getBuffer();
            String withTab = "\tat ";
            String withSpace = "        at ";
            int i = sb.lastIndexOf(withTab);
            while (i != -1) {
                sb.replace(i, i + withTab.length(), withSpace);
                i = sb.lastIndexOf(withTab, i);
            }
            dump = sb.toString();
        }
        return dump;
    }

    public static Throwable getDeepestException(Throwable deepestFound) {
        for (Throwable t = deepestFound; t != null; t = t.getCause()) {
            deepestFound = t;
        }
        return deepestFound;
    }

    static EProps valueOf(Throwable throwable) {
        EProps ep = EPropsChain.copyProperties(throwable, true);
        return ep;
    }

    @Override
    public String toString() {
        String STACKDUMP_KEY_INDENTION = "   ";
        String STACKDUMP_VALUE_INDENTION = "      ";
        int keyWidth = this.maxKeyLength();
        if (keyWidth > 24) {
            keyWidth = 24;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : super.entrySet()) {
            String keyName = ((EKey)entry.getKey()).NAME;
            sb.append("\n").append("   ");
            sb.append(keyName);
            for (int i = keyName.length(); i < keyWidth; ++i) {
                sb.append(' ');
            }
            sb.append(" : ");
            StringBuilder vb = new StringBuilder((String)entry.getValue());
            for (int i = 0; i <= vb.length() && (i = vb.indexOf("\n", i)) != -1; i += 1 + "      ".length()) {
                vb.insert(i + 1, "      ");
            }
            String indentedValue = vb.toString().trim();
            sb.append(indentedValue);
        }
        return sb.toString();
    }

    public static EProps getRevisionProperties() {
        return revisionProperties;
    }
}

