/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.eprops;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EKey;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.eprops.ErrorPopUpPrinter;
import se.ericsson.security.launcher.eprops.ExceptionIfc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EPropsChain
implements EKEY {
    private final String detailMessage;
    private final Throwable myException;
    private final EProps properties = new EProps();
    private EProps cashedEPropsUnion = null;
    private String cashedPopUpMessage = null;
    private String cashedPopUpDetails = null;
    private String cashedExceptionMessage = null;

    public EPropsChain(String message, Throwable owner, EProps eProps) {
        this.detailMessage = message;
        this.myException = owner;
        if (eProps != null) {
            this.properties.putAll(eProps);
        }
    }

    private synchronized void invalidateCash() {
        this.cashedEPropsUnion = null;
        this.cashedPopUpMessage = null;
        this.cashedPopUpDetails = null;
        this.cashedExceptionMessage = null;
    }

    public void set(EKey key, Object value) {
        this.properties.set(key, value);
        this.invalidateCash();
    }

    public void putAll(EProps other) {
        this.properties.putAll(other);
        this.invalidateCash();
    }

    public String get(EKey key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(boolean deep, EKey key, String defaultValue) {
        String value = (String)this.properties.get(key);
        if (value == null && deep) {
            for (Throwable cause = this.getCause(); value == null && cause != null; cause = cause.getCause()) {
                EPropsChain causeProps = EPropsChain.getEPropsChain(cause);
                if (causeProps == null) continue;
                value = causeProps.get(key);
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    EProps get() {
        return this.properties;
    }

    protected EProps copyProperties(boolean deep) {
        return EPropsChain.copyProperties(this.myException, deep);
    }

    static EProps copyProperties(Throwable throwable, boolean deep) {
        if (!deep) {
            return new EProps(EPropsChain.getLocalEProps(throwable));
        }
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            list.add(t);
        }
        EProps union = new EProps();
        for (Throwable t : list) {
            EProps localProps = EPropsChain.getLocalEProps(t);
            union.putAll(localProps);
        }
        return union;
    }

    public synchronized EProps getEPropsUnion() {
        if (this.cashedEPropsUnion == null) {
            this.cashedEPropsUnion = this.copyProperties(true);
            this.cashedEPropsUnion.putAll(EProps.getRevisionProperties());
        }
        return this.cashedEPropsUnion;
    }

    public synchronized String getPopUpMessge() {
        if (this.cashedPopUpMessage == null) {
            ErrorPopUpPrinter buffer = new ErrorPopUpPrinter(this.myException);
            this.cashedPopUpMessage = buffer.getPopUpMessge();
        }
        return this.cashedPopUpMessage;
    }

    public synchronized String getPopUpDetails() {
        if (this.cashedPopUpDetails == null) {
            ErrorPopUpPrinter buffer = new ErrorPopUpPrinter(this.myException);
            this.cashedPopUpDetails = buffer.getPopUpDetails();
        }
        return this.cashedPopUpDetails;
    }

    public synchronized String getExceptionMessage() {
        if (this.detailMessage == null && this.properties.isEmpty()) {
            return null;
        }
        if (this.cashedExceptionMessage == null) {
            EProps eProps = new EProps(this.properties);
            StringBuilder buffer = new StringBuilder();
            if (this.detailMessage != null) {
                buffer.append(this.detailMessage);
            }
            buffer.append(eProps.toString());
            this.cashedExceptionMessage = buffer.toString();
        }
        return this.cashedExceptionMessage;
    }

    public Throwable getException() {
        return this.myException;
    }

    private synchronized Throwable getCause() {
        return this.myException == null ? null : this.myException.getCause();
    }

    synchronized Throwable getDeepestException() {
        Throwable deepestFound;
        for (Throwable t = deepestFound = this.myException; t != null; t = t.getCause()) {
            deepestFound = t;
        }
        return deepestFound;
    }

    public String getStackTrace() {
        return EPropsChain.getStackTrace(this.myException);
    }

    public static String getStackTrace(Throwable throwable) {
        String dump = null;
        if (throwable != null) {
            StringWriter eStrW = new StringWriter(1024);
            throwable.printStackTrace(new PrintWriter(eStrW));
            StringBuffer sb = eStrW.getBuffer();
            String withTab = "\tat ";
            String withSpace = "        at ";
            int i = sb.lastIndexOf(withTab);
            while (i != -1) {
                sb.replace(i, i + withTab.length(), withSpace);
                i = sb.lastIndexOf(withTab, i);
            }
            dump = sb.toString();
        }
        return dump;
    }

    private static List<Throwable> getCauseList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            list.add(t);
        }
        return list;
    }

    private static EPropsChain getEPropsChain(Throwable throwable) {
        EPropsChain returned = throwable == null || !(throwable instanceof ExceptionIfc) ? null : ((ExceptionIfc)((Object)throwable)).getEPropsChain();
        return returned;
    }

    private static EProps getLocalEProps(Throwable throwable) {
        EPropsChain chain = EPropsChain.getEPropsChain(throwable);
        if (chain != null) {
            return chain.properties;
        }
        return new EProps();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        for (Throwable t : EPropsChain.getCauseList(this.myException)) {
            sb.append(t.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

