/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.cache.CacheException;
import se.ericsson.security.launcher.cache.CachedJarFile;
import se.ericsson.security.launcher.util.LauncherTool;
import se.ericsson.security.launcher.util.LoadmoduleData;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityLogTool {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private static String ipAddress = "";
    private static String certificateExpiredLogDir = "";
    public static List<LoadmoduleData> jarFilesList = new ArrayList<LoadmoduleData>();
    public static final String VALIDATE_SCENARIO_LOCAL = "LOCAL";
    public static final String VALIDATE_SCENARIO_DOWNLOAD = "DOWNLOAD";
    public static final String CLIENT_LAUNCHER = "clientLauncher";
    public static final String NODE_LAUNCHER = "nodeLauncher";
    public static boolean isUseClientLauncher = false;
    public static boolean isUpdateLauncher = false;
    private static final String CHANG_LINE_SYMBOL = "\r\n";
    private static final long FILE_SIZE_MAX = 0x200000L;
    private static final String SECURITY_LOG_ONE = "EM Security log1";
    private static final int SIGN_CERTIFICATE_INDEX = 0;
    private static final String LAUNCHER_JAR_NAME = "launcher.jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized void writeWarningInfo(String jarFileWithPath, List<X509Certificate> expiredCerts, String jarFileName) {
        block49: {
            StringBuffer sb = new StringBuffer();
            sb.append(System.getProperty("user.home"));
            sb.append(System.getProperty("file.separator"));
            sb.append("Ericsson");
            sb.append(System.getProperty("file.separator"));
            sb.append("Logs");
            sb.append(System.getProperty("file.separator"));
            certificateExpiredLogDir = sb.toString();
            File emSecurityLog1 = new File(certificateExpiredLogDir + SECURITY_LOG_ONE);
            File lockFile = new File(sb.toString() + ".lock");
            BufferedWriter bw = null;
            FileLock lock = null;
            AbstractInterruptibleChannel channel = null;
            FileOutputStream fo = null;
            File dirFile = emSecurityLog1.getParentFile();
            if (!dirFile.exists() && dirFile.mkdirs()) {
                LOG.info("Logs directory create success", new Object[0]);
            }
            if (!emSecurityLog1.exists() && emSecurityLog1.createNewFile()) {
                LOG.info("EM Security log create success", new Object[0]);
            }
            if (!lockFile.exists() && lockFile.createNewFile()) {
                LOG.info("EM lock file create success", new Object[0]);
                if (LauncherTool.runningOnWindows()) {
                    LOG.info("attrib +H \"" + lockFile.getAbsolutePath() + "\"", new Object[0]);
                    Runtime.getRuntime().exec("attrib +H \"" + lockFile.getAbsolutePath() + "\"");
                }
            }
            fo = new FileOutputStream(lockFile, true);
            channel = fo.getChannel();
            lock = ((FileChannel)channel).lock();
            LOG.info("current file size : " + emSecurityLog1.length(), new Object[0]);
            if (emSecurityLog1.length() > 0x200000L) {
                SecurityLogTool.handleLogFile(emSecurityLog1);
            }
            bw = new BufferedWriter(new FileWriter(emSecurityLog1, true));
            StringBuffer content = SecurityLogTool.createEntryByCertificate(jarFileWithPath, expiredCerts, jarFileName);
            bw.write(content.toString());
            bw.flush();
            Object var13_14 = null;
            try {
                if (null != lock) {
                    lock.release();
                }
            }
            catch (IOException e2) {
                LOG.severe("have IOException when lock release  : " + e2, new Object[0]);
            }
            try {
                if (null != channel) {
                    channel.close();
                }
            }
            catch (IOException e2) {
                LOG.severe("have IOException when channel close : " + e2, new Object[0]);
            }
            try {
                if (null != fo) {
                    fo.close();
                }
            }
            catch (IOException e2) {
                LOG.severe("have IOException when fileOutputStream close : " + e2, new Object[0]);
            }
            try {
                if (null != bw) {
                    bw.close();
                }
                break block49;
            }
            catch (IOException e2) {
                LOG.severe("have IOException when bufferedWriter close : " + e2, new Object[0]);
            }
            break block49;
            {
                catch (IOException e) {
                    LOG.severe("have IOException : " + e, new Object[0]);
                    Object var13_15 = null;
                    try {
                        if (null != lock) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when lock release  : " + e2, new Object[0]);
                    }
                    try {
                        if (null != channel) {
                            channel.close();
                        }
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when channel close : " + e2, new Object[0]);
                    }
                    try {
                        if (null != fo) {
                            fo.close();
                        }
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when fileOutputStream close : " + e2, new Object[0]);
                    }
                    try {
                        if (null != bw) {
                            bw.close();
                        }
                        break block49;
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when bufferedWriter close : " + e2, new Object[0]);
                    }
                    break block49;
                }
                catch (Exception e) {
                    LOG.severe("have Exception : " + e, new Object[0]);
                    Object var13_16 = null;
                    try {
                        if (null != lock) {
                            lock.release();
                        }
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when lock release  : " + e2, new Object[0]);
                    }
                    try {
                        if (null != channel) {
                            channel.close();
                        }
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when channel close : " + e2, new Object[0]);
                    }
                    try {
                        if (null != fo) {
                            fo.close();
                        }
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when fileOutputStream close : " + e2, new Object[0]);
                    }
                    try {
                        if (null != bw) {
                            bw.close();
                        }
                        break block49;
                    }
                    catch (IOException e2) {
                        LOG.severe("have IOException when bufferedWriter close : " + e2, new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    if (null != lock) {
                        lock.release();
                    }
                }
                catch (IOException e2) {
                    LOG.severe("have IOException when lock release  : " + e2, new Object[0]);
                }
                try {
                    if (null != channel) {
                        channel.close();
                    }
                }
                catch (IOException e2) {
                    LOG.severe("have IOException when channel close : " + e2, new Object[0]);
                }
                try {
                    if (null != fo) {
                        fo.close();
                    }
                }
                catch (IOException e2) {
                    LOG.severe("have IOException when fileOutputStream close : " + e2, new Object[0]);
                }
                try {
                    if (null != bw) {
                        bw.close();
                    }
                }
                catch (IOException e2) {
                    LOG.severe("have IOException when bufferedWriter close : " + e2, new Object[0]);
                }
                throw throwable;
            }
        }
    }

    public static void setIpAddress(String ipAddress) {
        if ("".equals(SecurityLogTool.ipAddress)) {
            SecurityLogTool.ipAddress = ipAddress;
        }
    }

    private static CachedJarFile getCachedJarFileWithLaunch() {
        URL launcherUrl = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        String launcherFile = launcherUrl.getPath().replaceAll("%20", " ");
        return SecurityLogTool.getCachedJarFile(launcherFile);
    }

    private static CachedJarFile getCachedJarFile(String file) {
        try {
            CachedJarFile thisLauncherFile = new CachedJarFile(file, true);
            return thisLauncherFile;
        }
        catch (CacheException e) {
            LOG.info("have CacheException : " + e, new Object[0]);
            return null;
        }
    }

    public static void writeEMSecurityLog(String jarFileWithPath, List<X509Certificate> certs, String scenario, String launcherType, String jarFileName) {
        LOG.info("jarFileWithPath : " + jarFileWithPath + ", jarFileName : " + jarFileName, new Object[0]);
        LOG.info("scenario : " + scenario + ", launcherType : " + launcherType, new Object[0]);
        if (LAUNCHER_JAR_NAME.equals(jarFileName)) {
            SecurityLogTool.writeEMSecurityLogForLauncher(jarFileWithPath, certs, scenario, launcherType, jarFileName);
        } else {
            SecurityLogTool.writeEMSecurityLogForLM(jarFileWithPath, certs, jarFileName);
        }
    }

    private static void writeEMSecurityLogForLauncher(String jarFileWithPath, List<X509Certificate> certs, String scenario, String launcherType, String jarFileName) {
        boolean isWriteLog = true;
        for (LoadmoduleData lm : jarFilesList) {
            if (!LAUNCHER_JAR_NAME.equals(lm.getName()) || !scenario.equals(lm.getScenario()) || !launcherType.equals(lm.getLauncherType())) continue;
            isWriteLog = false;
            break;
        }
        if (isWriteLog) {
            SecurityLogTool.writeWarningInfo(jarFileWithPath, certs, jarFileName);
        }
    }

    private static void writeEMSecurityLogForLM(String jarFileWithPath, List<X509Certificate> certs, String jarFileName) {
        boolean isWriteLog = true;
        for (LoadmoduleData lm : jarFilesList) {
            if (!jarFileName.equals(lm.getName())) continue;
            isWriteLog = false;
            break;
        }
        if (isWriteLog) {
            SecurityLogTool.writeWarningInfo(jarFileWithPath, certs, jarFileName);
        }
    }

    public static boolean isContainLMName(String jarName) {
        for (LoadmoduleData lm : jarFilesList) {
            if (!jarName.equals(lm.getName())) continue;
            return true;
        }
        return false;
    }

    public static synchronized void putDataIntoList(String jarFileName, String scenario, String launcherType) {
        if (LAUNCHER_JAR_NAME.equals(jarFileName)) {
            SecurityLogTool.putLauncherIntoList(jarFileName, scenario, launcherType);
        } else {
            SecurityLogTool.putLoadModuleIntoList(jarFileName, scenario);
        }
        LOG.info("after putDataIntoList, jarFilesList : " + jarFilesList, new Object[0]);
    }

    public static String transmitLauncherData() {
        StringBuffer sb = new StringBuffer();
        for (LoadmoduleData lm : jarFilesList) {
            if (!LAUNCHER_JAR_NAME.equals(lm.getName())) continue;
            sb.append('-');
            sb.append(lm.getScenario());
            sb.append('_');
            sb.append(lm.getLauncherType());
        }
        String value = sb.toString();
        if (value.length() > 0) {
            return sb.toString().substring(1);
        }
        return "";
    }

    public static void parseLauncherData(String transmitData) {
        if ("".equals(transmitData) || null == transmitData) {
            return;
        }
        String[] datas = transmitData.split("-");
        if (datas.length == 0) {
            return;
        }
        for (int i = 0; i < datas.length; ++i) {
            String[] launcherData = datas[i].split("_");
            if (launcherData.length != 2) continue;
            jarFilesList.add(new LoadmoduleData(LAUNCHER_JAR_NAME, launcherData[0], launcherData[1]));
        }
    }

    public static String getLauncherTypeInTrustedCertificate() {
        String launcherType = "";
        launcherType = isUpdateLauncher ? (isUseClientLauncher ? CLIENT_LAUNCHER : NODE_LAUNCHER) : CLIENT_LAUNCHER;
        return launcherType;
    }

    private static void putLauncherIntoList(String jarName, String scenario, String launcherType) {
        boolean isNeedPutLauncher = true;
        for (LoadmoduleData lm : jarFilesList) {
            if (!LAUNCHER_JAR_NAME.equals(lm.getName()) || !scenario.equals(lm.getScenario()) || !launcherType.equals(lm.getLauncherType())) continue;
            isNeedPutLauncher = false;
            break;
        }
        if (isNeedPutLauncher) {
            jarFilesList.add(new LoadmoduleData(jarName, scenario, launcherType));
        }
    }

    private static void putLoadModuleIntoList(String jarName, String scenario) {
        boolean isNeedPutLM = true;
        for (LoadmoduleData lm : jarFilesList) {
            if (!jarName.equals(lm.getName())) continue;
            isNeedPutLM = false;
            break;
        }
        if (isNeedPutLM) {
            jarFilesList.add(new LoadmoduleData(jarName, scenario));
        }
    }

    private static void handleLogFile(File emSecurityLog1) {
        LOG.info("current file size is larger than 2M. ", new Object[0]);
        File emSecurityLog0 = new File(certificateExpiredLogDir + "EM Security log0");
        if (emSecurityLog0.exists() && emSecurityLog0.delete()) {
            LOG.info("delete EM Security log0 sucess", new Object[0]);
        }
        if (emSecurityLog1.renameTo(emSecurityLog0)) {
            LOG.info("emSecurityLog1 renameTo emSecurityLog0 sucess", new Object[0]);
        }
        File emSecurityLog1New = new File(certificateExpiredLogDir + SECURITY_LOG_ONE);
        try {
            if (emSecurityLog1New.createNewFile()) {
                LOG.info("emSecurityLog1New create sucess", new Object[0]);
            }
        }
        catch (IOException e) {
            LOG.severe("have IOException when createNewFile : " + e, new Object[0]);
        }
    }

    private static StringBuffer createEntryByCertificate(String jarFileWithPath, List<X509Certificate> expiredCerts, String jarFileName) {
        StringBuffer content = new StringBuffer();
        content.append("Timestamp : ");
        content.append(new Date().toString());
        content.append(", Node address : ");
        content.append(ipAddress);
        content.append(',');
        CachedJarFile launcherFile = SecurityLogTool.getCachedJarFileWithLaunch();
        if (null != launcherFile) {
            content.append(" EM launcher's product number and revision : ");
            content.append(launcherFile.getAttributes().getProductNumber() + " " + launcherFile.getAttributes().getRevision());
        }
        content.append(CHANG_LINE_SYMBOL);
        CachedJarFile lmJarFile = SecurityLogTool.getCachedJarFile(jarFileWithPath);
        if (null != lmJarFile) {
            content.append("The loadmodule's name : " + jarFileName);
            content.append(", Product number and revision : " + lmJarFile.getAttributes().getProductNumber() + " " + lmJarFile.getAttributes().getRevision());
            content.append(CHANG_LINE_SYMBOL);
        }
        Iterator<X509Certificate> it = expiredCerts.iterator();
        int index = 0;
        while (it.hasNext()) {
            X509Certificate cert = it.next();
            if (index == 0) {
                content.append("The signing certificate's subjectDN for " + jarFileName + " : ");
            } else {
                content.append("The certificate's subjectDN : ");
            }
            content.append(cert.getSubjectX500Principal().toString());
            content.append(", The issuer certificate's subjectDN : ");
            content.append(cert.getIssuerX500Principal().toString());
            content.append(CHANG_LINE_SYMBOL);
            content.append("Valid from: ");
            content.append(cert.getNotBefore().toString());
            content.append(" until: ");
            content.append(cert.getNotAfter().toString());
            content.append(CHANG_LINE_SYMBOL);
            ++index;
        }
        content.append(CHANG_LINE_SYMBOL);
        return content;
    }
}

