/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Random;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.starter.AuthRequest;
import se.ericsson.security.starter.AuthSecret;
import se.ericsson.security.starter.Response;

public class Authenticator {
    final int MIN_LENGTH = 6;
    final int MAX_LENGTH = 25;
    private static Authenticator theInstance = null;
    private String secretStringPrefix;
    private static int LONG_SIZE = Long.toHexString(Long.MAX_VALUE).length();
    private static int INTEGER_SIZE = Integer.toHexString(Integer.MAX_VALUE).length();

    public static Authenticator getInstance() {
        if (theInstance == null) {
            theInstance = new Authenticator();
        }
        return theInstance;
    }

    public void init(String filePath, String networkElement) {
        String tmpPath = filePath + File.separator + ".secret_string" + networkElement;
        this.secretStringPrefix = tmpPath.substring(0, 2) + tmpPath.substring(2).replaceAll(":", "_");
    }

    private byte[] generateRandomString() {
        Random rcg = new Random(System.currentTimeMillis());
        int nextR = rcg.nextInt();
        if (nextR < 0) {
            nextR = 0 - nextR;
        }
        int length = 6 + nextR % 19;
        byte[] toReturn = new byte[length];
        rcg = new Random(System.currentTimeMillis() + 1L);
        for (int i = 0; i < length; ++i) {
            toReturn[i] = (byte)rcg.nextInt();
        }
        return toReturn;
    }

    private boolean isProtected(String fileName) {
        try {
            if (!EmasUtilities.runningOnWindows()) {
                Process pr = Runtime.getRuntime().exec("ls -l " + fileName);
                BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                String fileInfo = br.readLine();
                if (fileInfo == null) {
                    return false;
                }
                int space = fileInfo.indexOf(" ");
                if (space == -1) {
                    return false;
                }
                String rights = fileInfo.substring(0, space);
                if (!rights.equals("-rw-------")) {
                    return false;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void setProtected(String fileName) {
        try {
            if (!EmasUtilities.runningOnWindows()) {
                Process pr = Runtime.getRuntime().exec("chmod 600 " + fileName);
                pr.waitFor();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Response authenticateTheClient(ObjectOutputStream theOOS, ObjectInputStream theOIS, int clientPort) {
        int i;
        String timeHexString = Long.toHexString(System.currentTimeMillis());
        String portHexString = Integer.toHexString(clientPort);
        StringBuffer paddedString = new StringBuffer(timeHexString);
        for (i = timeHexString.length(); i < LONG_SIZE; ++i) {
            paddedString.insert(0, "0");
        }
        paddedString.append(".");
        for (i = portHexString.length(); i < INTEGER_SIZE; ++i) {
            paddedString.append("0");
        }
        paddedString.append(portHexString);
        String generated = paddedString.toString();
        String s_s_fn = this.secretStringPrefix + generated;
        Response resp = new Response(1, "Authentication failed; connection refused");
        try {
            int timeoutCounter;
            File s_s = new File(s_s_fn);
            Object clAuth = null;
            FileOutputStream secretStrFile = new FileOutputStream(s_s);
            this.setProtected(s_s_fn);
            byte[] secretWritten = this.generateRandomString();
            secretStrFile.write(secretWritten);
            secretStrFile.close();
            theOOS.writeObject(generated);
            theOOS.flush();
            for (timeoutCounter = 0; timeoutCounter < 100; ++timeoutCounter) {
                if (theOIS.available() < 1) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                theOIS.read();
                break;
            }
            if (timeoutCounter >= 100) {
                return resp;
            }
            s_s.delete();
            clAuth = theOIS.readObject();
            if (clAuth instanceof AuthSecret) {
                byte[] secretRead = ((AuthSecret)clAuth).getSecret();
                if (secretRead.length == secretWritten.length) {
                    for (i = 0; i < secretWritten.length; ++i) {
                        if (secretRead[i] == secretWritten[i]) continue;
                        return resp;
                    }
                    resp.setStatus(0);
                    resp.setMsg("OK");
                    return resp;
                }
                return resp;
            }
            return resp;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return resp;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return resp;
        }
    }

    public boolean authenticateTowardsServer(Socket socket, ObjectInputStream in, ObjectOutputStream out) {
        byte[] secret = new byte[]{};
        try {
            out.writeObject(new AuthRequest(System.getProperty("user.name") + "@" + socket.getLocalPort()));
            out.flush();
            Object resp = in.readObject();
            if (resp instanceof String) {
                String name_end = (String)resp;
                String file_name = this.secretStringPrefix + name_end;
                File s_file = new File(file_name);
                if (!this.isProtected(file_name)) {
                    s_file.delete();
                    return false;
                }
                FileInputStream fis = new FileInputStream(s_file);
                secret = new byte[fis.available()];
                fis.read(secret);
                fis.close();
                out.write(0);
                out.flush();
                out.writeObject(new AuthSecret(secret));
                out.flush();
                resp = in.readObject();
                if (resp instanceof Response) {
                    Response resp_ = (Response)resp;
                    return resp_.getStatus() == 0;
                }
                return false;
            }
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return false;
    }
}

