/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter;

import se.ericsson.security.launcher.ExceptionHandlerInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.utils.EmLogger;

public class ServerThreadGroup
extends ThreadGroup {
    private static final EmLogger LOG = EmLogger.STARTER;
    Launchable theSetter;
    ExceptionHandlerInterface excHandler;

    public ServerThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
    }

    public ServerThreadGroup(String name) {
        super(name);
    }

    public ServerThreadGroup() {
        super("ServerThreadGroup-default");
    }

    public void setExceptionHandler(Launchable appl, ExceptionHandlerInterface eh) {
        if (this.theSetter == null) {
            this.theSetter = appl;
            this.excHandler = eh;
        } else if (this.theSetter.equals(appl)) {
            this.excHandler = eh;
        }
    }

    public void uncaughtException(Thread t, Throwable w) {
        try {
            LOG.fine("STG: t=" + t.getName(), new Object[0]);
            LOG.fine("STG: tg=" + t.getThreadGroup().getName(), new Object[0]);
            if (this.excHandler != null) {
                LOG.fine("Handling the uncaught exception by calling the exception handler registered by the application " + this.theSetter.getClass().getName(), new Object[0]);
                this.excHandler.handleException(w);
            } else {
                LOG.severe("No exception handler was set; delegating to the parent ThreadGroup", new Object[0]);
                this.getParent().uncaughtException(t, w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

