/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.starter.investigator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.EnumSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.cache.VerifyException;
import se.ericsson.security.launcher.download.DownloadManager;
import se.ericsson.security.launcher.download.SimpleDownloadListener;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.launcher.util.PropertyManager;
import se.ericsson.security.starter.investigator.NodeType;
import se.ericsson.security.utils.EmLogger;

public class NodeTypeInvestigator {
    private static final EmLogger LOGGER = EmLogger.STARTER;
    private static final String fileAlwaysExistingOnCppNode = "/cello/ior_files/nameroot.ior";
    private static final String fileAlwaysExistingOnRbsG2Node = "/em/clitool_config.xml";
    private static final String XML_FILE_SUFFIX = ".xml";
    private Launcher myFileHandler;

    public void init() {
        ClassLoader loader = NodeTypeInvestigator.class.getClassLoader();
        this.myFileHandler = Launcher.getInstance(loader);
    }

    public boolean contactWithNode(URL urlToNode) {
        LOGGER.finer("NodeTypeInvestigator, contactWithNode urlToNode: " + urlToNode + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        boolean contact = false;
        contact = this.fileAvailableOnNode(fileAlwaysExistingOnCppNode, urlToNode);
        if (!contact) {
            contact = this.fileAvailableOnNode(fileAlwaysExistingOnRbsG2Node, urlToNode);
        }
        return contact;
    }

    public NodeType getNodeType(URL urlToNode) {
        LOGGER.finer("NodeTypeInvestigator, getNodeType, urlToNode is: " + urlToNode + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        EnumSet<NodeType> excludeTypeSet = EnumSet.of(NodeType.UNKNOWN);
        EnumSet<NodeType> types = EnumSet.complementOf(excludeTypeSet);
        NodeType type = NodeType.UNKNOWN;
        if (this.contactWithNode(urlToNode)) {
            for (NodeType tmpNodeType : types) {
                if (!this.fileAvailableOnNode(tmpNodeType.FILE_PATH_SPECIFIC_FOR_THIS_NODE_TYPE, urlToNode)) continue;
                type = tmpNodeType;
                break;
            }
        }
        LOGGER.finer("NodeTypeInvestigator, getNodeType returning: " + (Object)((Object)type), new Object[0]);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileAvailableOnNode(String fileOnNode, URL urlToNode) {
        boolean contact;
        block6: {
            contact = false;
            URLConnection connection = null;
            try {
                block5: {
                    try {
                        HttpURLConnection httpURLConnection;
                        int responseCode;
                        LOGGER.finer("Investigating if we have a file " + fileOnNode + " on the node: " + urlToNode, new Object[0]);
                        URL url = new URL(urlToNode, fileOnNode);
                        LOGGER.finest("url: " + url, new Object[0]);
                        connection = url.openConnection();
                        EmasUtilities.getInstance().enableNECertificateValidation(connection);
                        if (!(connection instanceof HttpURLConnection) || 200 != (responseCode = (httpURLConnection = (HttpURLConnection)connection).getResponseCode())) break block5;
                        LOGGER.finer("Got contact with node: " + urlToNode, new Object[0]);
                        contact = true;
                    }
                    catch (NoRouteToHostException routeExep) {
                        LOGGER.finest("Got NoRouteToHostException exception while trying to get contact with the node: " + routeExep, new Object[0]);
                        Object var9_11 = null;
                        EmasUtilities.disconnect(connection);
                        break block6;
                    }
                    catch (Exception ex) {
                        LOGGER.finest("Got exception while trying to get contact with the node: " + ex, new Object[0]);
                        Object var9_12 = null;
                        EmasUtilities.disconnect(connection);
                        break block6;
                    }
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                EmasUtilities.disconnect(connection);
                throw throwable;
            }
            EmasUtilities.disconnect(connection);
        }
        LOGGER.finer("fileAvailableOnNode returning: " + contact, new Object[0]);
        return contact;
    }

    public String getFile(URL fileName, String productName, String productNumber, String productRevision, PropertyManager pm) throws VerifyException, LauncherException {
        LOGGER.finer("fileName: " + fileName + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        if (null == this.myFileHandler) {
            LOGGER.warning("NodeTypeInvestigator is not initialized. Cannot getFile fileName: " + fileName, new Object[0]);
            return "";
        }
        return this.myFileHandler.getFile(fileName, productName, productNumber, productRevision, new SimpleDownloadListener(LOGGER));
    }

    public String getEmApplicationsFileContentsFromNode(URL url, String emappFilepath) throws Exception {
        LOGGER.finer("url: " + url + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String fileContents = "";
        if (null != url) {
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), emappFilepath);
            DownloadManager downloader = new DownloadManager();
            fileContents = downloader.downloadToString(url, new SimpleDownloadListener(LOGGER));
        }
        return fileContents;
    }

    public byte[] getFileInJarAsByteArray(String filePathInsideJar, String jarFilePath) {
        LOGGER.finer("filePathInsideJar: " + filePathInsideJar + " jarFilePath: " + jarFilePath + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        byte[] fileContents = new byte[]{};
        try {
            JarFile jarF = new JarFile(jarFilePath);
            JarEntry jarentry = jarF.getJarEntry(filePathInsideJar);
            if (null == jarentry) {
                jarentry = filePathInsideJar.startsWith("/") ? jarF.getJarEntry(filePathInsideJar.substring(1)) : jarF.getJarEntry("/" + filePathInsideJar);
            }
            InputStream instr = jarF.getInputStream(jarentry);
            long size = jarentry.getSize();
            byte[] byteBuffer = new byte[(int)size];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (instr.read(byteBuffer) != -1) {
                out.write(byteBuffer);
            }
            fileContents = out.toByteArray();
            instr.close();
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return fileContents;
    }

    public String getDefaultEmApplicationsFileContents(NodeType nodeType) {
        LOGGER.finer("getDefaultEmApplicationsFileContents nodeType:" + (Object)((Object)nodeType) + " Thread: " + Thread.currentThread().getName(), new Object[0]);
        String fakeFileContents = "";
        LOGGER.finest("getDefaultEmApplicationsFileContents, file path in jar: " + nodeType.DEFAULT_EMAPPLICATIONS_XML_FILE, new Object[0]);
        if (nodeType.DEFAULT_EMAPPLICATIONS_XML_FILE.endsWith(XML_FILE_SUFFIX)) {
            fakeFileContents = this.getFileContentsAsString(nodeType, nodeType.DEFAULT_EMAPPLICATIONS_XML_FILE);
        }
        LOGGER.finest("getDefaultEmApplicationsFileContents returning contents of length: " + fakeFileContents.length(), new Object[0]);
        return fakeFileContents;
    }

    private String getFileContentsAsString(NodeType nodeType, String filePathInThisLauncherJar) {
        String fakeFileContents = "";
        try {
            JarFile jarF = new JarFile(this.getJarFilePathForThisLauncherJar());
            LOGGER.finest("getFileContentsAsString jarF: " + jarF, new Object[0]);
            LOGGER.finest("getFileContentsAsString filePathInJar: " + filePathInThisLauncherJar, new Object[0]);
            JarEntry jarentry = jarF.getJarEntry(filePathInThisLauncherJar);
            LOGGER.finest("getFileContentsAsString jarentry:" + jarentry, new Object[0]);
            InputStream instr = jarF.getInputStream(jarentry);
            LOGGER.finest("getFileContentsAsString nodeType:" + (Object)((Object)nodeType) + "  instr:" + instr, new Object[0]);
            if (null != instr) {
                ReadableByteChannel inRbs = null;
                ByteBuffer bb = ByteBuffer.allocate(4096);
                Charset charset = Charset.forName("UTF-8");
                CharsetDecoder decoder = charset.newDecoder();
                CharBuffer charBuffer = null;
                inRbs = Channels.newChannel(instr);
                StringBuffer strBuffCont = new StringBuffer();
                while (inRbs.read(bb) >= 0) {
                    bb.flip();
                    charBuffer = decoder.decode(bb);
                    strBuffCont.append(charBuffer.toString());
                    bb.clear();
                }
                fakeFileContents = strBuffCont.toString();
                inRbs.close();
            }
        }
        catch (Exception exep) {
            LOGGER.warning("Exeption in getFileContentsAsString: " + exep, new Object[0]);
        }
        return fakeFileContents;
    }

    public String getJarFilePathForThisLauncherJar() {
        LOGGER.finer("getJarFilePathForThisLauncherJar Thread: " + Thread.currentThread().getName(), new Object[0]);
        URL installedLauncherUrl = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        String launcherFileNameWithPath = "";
        try {
            launcherFileNameWithPath = new File(installedLauncherUrl.toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            LOGGER.warning("URISyntaxException when getting absolute path to this launcher.jar: " + e.getMessage(), new Object[0]);
        }
        launcherFileNameWithPath = launcherFileNameWithPath.replaceAll("%20", " ");
        LOGGER.finer(" This executable's launcherFileNameWithPath: " + launcherFileNameWithPath, new Object[0]);
        return launcherFileNameWithPath;
    }
}

