/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.utils;

import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EmLogger {
    HELP_SERVICE("se.ericsson.cello.helpservice"),
    LAUNCHER("se.ericsson.security.launcher"),
    LAUNCH_PAD("se.ericsson.cello.launchpad"),
    LICENSING("se.ericsson.cello.licensing"),
    MO_ADD("se.ericsson.cello.emt.moadd"),
    MO_PROPERTIES("se.ericsson.cello.emt.moproperties"),
    MO_SEARCH("se.ericsson.cello.emt.mosearch"),
    NEX("se.ericsson.cello.nex"),
    NODE_SERVICE("se.ericsson.cello.emt.nodeservices"),
    STARTER("se.ericsson.security.starter"),
    SSH_SFTP_SERVICE("se.ericsson.cello.emt.sshsftpservice"),
    SW_EMBEDDED("se.ericsson.cello.swe"),
    TROUBLE_SHOOTING("se.ericsson.cello.em.fm"),
    USER_PREFERENCES("se.ericsson.cello.emt.userpreferences");

    private static final String THIS_CLASS;
    private static final String INDENTATION = "\t";
    private static final String LINE_SEPARATOR;
    public static final String NEW_LINE;
    public static final String NEW_LINE_INDENTED;
    private final Logger logger;
    private Method method;

    private EmLogger(String name) {
        this.logger = Logger.getLogger(name);
        if (Boolean.valueOf(System.getProperty(name + ".debug")).booleanValue()) {
            Handler[] handlers = this.logger.getParent().getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].setLevel(Level.ALL);
            }
            this.logger.setLevel(Level.ALL);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void severe(String message, Object ... parameters) {
        this.method = Method.SEVERE;
        this.log(Level.SEVERE, message, parameters);
    }

    public void severe(String message, Throwable throwable) {
        this.method = Method.SEVERE;
        this.log(Level.SEVERE, message, throwable);
    }

    public void warning(String message, Object ... parameters) {
        this.method = Method.WARNING;
        this.log(Level.WARNING, message, parameters);
    }

    public void warning(String message, Throwable throwable) {
        this.method = Method.WARNING;
        this.log(Level.WARNING, message, throwable);
    }

    public void info(String message, Object ... parameters) {
        this.method = Method.INFO;
        this.log(Level.INFO, message, parameters);
    }

    public void info(String message, Throwable throwable) {
        this.method = Method.INFO;
        this.log(Level.INFO, message, throwable);
    }

    public void fine(String message, Object ... parameters) {
        this.method = Method.FINE;
        this.log(Level.FINE, message, parameters);
    }

    public void fine(String message, Throwable throwable) {
        this.method = Method.FINE;
        this.log(Level.FINE, message, throwable);
    }

    public void finer(String message, Object ... parameters) {
        this.method = Method.FINER;
        this.log(Level.FINER, message, parameters);
    }

    public void finer(String message, Throwable throwable) {
        this.method = Method.FINER;
        this.log(Level.FINER, message, throwable);
    }

    public void finest(String message, Object ... parameters) {
        this.method = Method.FINEST;
        this.log(Level.FINEST, message, parameters);
    }

    public void finest(String message, Throwable throwable) {
        this.method = Method.FINEST;
        this.log(Level.FINEST, message, throwable);
    }

    public void config(String message, Object ... parameters) {
        this.method = Method.CONFIG;
        this.log(Level.CONFIG, message, parameters);
    }

    public void properties(String message, Properties properties) {
        this.method = Method.PROPERTIES;
        message = this.getMethodMessage(message, properties);
        this.log(Level.FINER, message, properties);
    }

    public void entering(Object ... methodParameters) {
        this.method = Method.ENTERING;
        String message = this.getMethodMessage(methodParameters);
        this.log(Level.FINER, message, new Object[0]);
    }

    public void exiting() {
        this.method = Method.EXITING;
        String message = this.getMethodMessage(new Object[0]);
        this.log(Level.FINER, message, new Object[0]);
    }

    public void exiting(Object result) {
        this.method = Method.EXITING;
        String message = this.getMethodMessage(result);
        this.log(Level.FINER, message, new Object[0]);
    }

    public void throwing(Throwable throwable) {
        this.method = Method.THROWING;
        String message = this.getMethodMessage(new Object[0]);
        this.log(Level.FINER, message, throwable);
    }

    private void log(Level level, String message, Object ... params) {
        Caller caller = this.inferCaller();
        this.logger.logp(level, caller.clazz, caller.method, message, params);
    }

    private void log(Level level, String message, Throwable throwable) {
        Caller caller = this.inferCaller();
        this.logger.logp(level, caller.clazz, caller.method, message, throwable);
    }

    private Caller inferCaller() {
        StackTraceElement frame;
        String cname;
        int i;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (i = 0; i < stack.length && !(cname = (frame = stack[i]).getClassName()).equals(THIS_CLASS); ++i) {
        }
        while (i < stack.length) {
            frame = stack[i];
            cname = frame.getClassName();
            if (!cname.equals(THIS_CLASS)) {
                Caller caller = new Caller(cname, frame.getMethodName());
                return caller;
            }
            ++i;
        }
        return new Caller(null, null);
    }

    private String getMethodMessage(Object ... objects) {
        StringBuffer sb = new StringBuffer();
        switch (this.method) {
            case ENTERING: 
            case EXITING: {
                sb.append(this.method == Method.ENTERING ? "Entering" : "Exiting");
                sb.append(" method with ");
                sb.append(this.method == Method.ENTERING ? "parameters" : "result");
                sb.append(":");
                for (Object param : objects) {
                    sb.append(NEW_LINE_INDENTED);
                    if (param != null) {
                        sb.append(param.toString());
                        continue;
                    }
                    sb.append("null");
                }
                break;
            }
            case PROPERTIES: {
                if (objects[0] == null || objects[0].equals("")) {
                    sb.append("Properties");
                    sb.append(":");
                } else {
                    sb.append((String)objects[0]);
                }
                Properties properties = (Properties)objects[1];
                Set<Object> keys = properties.keySet();
                for (Object tmpKey : keys) {
                    String key = (String)tmpKey;
                    sb.append(NEW_LINE_INDENTED);
                    sb.append(key);
                    sb.append(" = ");
                    sb.append(properties.getProperty(key));
                }
                break;
            }
            case THROWING: {
                sb.append("Throwing");
                sb.append(":");
            }
        }
        return sb.toString();
    }

    static {
        THIS_CLASS = EmLogger.class.getName();
        NEW_LINE = LINE_SEPARATOR = System.getProperty("line.separator");
        NEW_LINE_INDENTED = LINE_SEPARATOR + INDENTATION;
    }

    private class Caller {
        final String clazz;
        final String method;

        public Caller(String clazz, String method) {
            this.clazz = clazz;
            this.method = method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        CONFIG,
        ENTERING,
        EXITING,
        FINE,
        FINER,
        FINEST,
        INFO,
        PROPERTIES,
        SEVERE,
        THROWING,
        WARNING;

    }
}

