/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class CollectInterfaceIpv4References
implements DataCollectorAction {
    static boolean checkInterfaceIpv4 = true;

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("InterfaceIpv4");
        SequenceAttribute sequenceAttribute = new SequenceAttribute("interfaceIpv4References", false);
        if (moIterator != null) {
            ManagedObject managedObject = null;
            StructAttribute structAttribute = null;
            while (moIterator.hasMoreElements() && checkInterfaceIpv4) {
                managedObject = moIterator.nextMo();
                try {
                    structAttribute = this.getRefs(managedObject);
                }
                catch (MoAccessException moAccessException) {
                    throw new AueException("Unable to process " + managedObject.getLocalDistinguishedName(), (Throwable)moAccessException);
                }
                if (structAttribute == null) continue;
                sequenceAttribute.addElement((Attribute)structAttribute);
            }
        }
        collectorContext.getDataWriter().writeData((Attribute)sequenceAttribute, collectorContext, coordinator);
    }

    private StructAttribute getRefs(ManagedObject managedObject) throws MoAccessException {
        StructAttribute structAttribute = null;
        try {
            ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute("aclIngress", null);
            if (managedObject2 != null) {
                structAttribute = new StructAttribute("interfaceIpv4Ref", false);
                structAttribute.addElement((Attribute)new ReferenceAttribute("ldn", false, managedObject));
                structAttribute.addElement((Attribute)new ReferenceAttribute("aclIngress", true, managedObject2));
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            checkInterfaceIpv4 = false;
            return structAttribute;
        }
        return structAttribute;
    }
}

