/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice.view;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.helpservice.HelpServiceLog;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.launcher.ui.AboutDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Display {
    private static final String NEWLINE = System.getProperties().getProperty("line.separator", "\n");
    private Map<String, AboutDialog> myAboutDialogs = new Hashtable<String, AboutDialog>(10);

    public void displayAbout(final String applicationTitle, final TreeSet<String> executingAppRows, final JFrame ownerFrame, final String additionalText, final String copyRightYear, final String thirdPartyText) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Display.this.displayAbout(applicationTitle, executingAppRows, ownerFrame, additionalText, copyRightYear, thirdPartyText);
                }
            });
        } else {
            HelpServiceLog.logger().info("Entering displayAbout");
            AboutDialog theAboutDialog = this.myAboutDialogs.get(applicationTitle);
            if (null == theAboutDialog) {
                JFrame frame = ownerFrame;
                theAboutDialog = new AboutDialog(frame, applicationTitle);
                theAboutDialog.initAboutDialog();
                theAboutDialog.addWindowListener((WindowListener)new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        Display.this.myAboutDialogs.remove(applicationTitle);
                    }
                });
                this.myAboutDialogs.put(applicationTitle, theAboutDialog);
            } else {
                theAboutDialog.getTextArea().setText("");
            }
            theAboutDialog.fillAboutTextAreaWithContents(applicationTitle, additionalText, copyRightYear, thirdPartyText, executingAppRows);
            theAboutDialog.pack();
            this.makeAllOfTheAboutWindowVisible(theAboutDialog);
            theAboutDialog.setVisible(true);
        }
    }

    private void makeAllOfTheAboutWindowVisible(AboutDialog aboutDialog) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension aboutWindowDimension = aboutDialog.getSize();
        int x = (screenDimension.width - aboutWindowDimension.width) / 2;
        int y = (screenDimension.height - aboutWindowDimension.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        aboutDialog.setLocation(x, y);
    }

    public static void displayUsingHelp(final JFrame ownerFrame) {
        StringBuilder strB = new StringBuilder();
        strB.append("The Help consists of documents stored on an Active Library");
        strB.append(" EXplorer (ALEX) server. It is displayed in a web browser.");
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append("The ALEX server address and library are specified in ");
        strB.append("the MO ManagedElement=1,ManagedElementData=1.");
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append("The attribute documentServerAddress gives the address to the ALEX server,");
        strB.append(" and the attribute docLibSystemDefined gives the ALEX library for this node.");
        strB.append(NEWLINE);
        strB.append(NEWLINE);
        strB.append("The settable attribute docLibUserDefined can be used ");
        strB.append("to override the read-only value of docLibSystemDefined.");
        final String msg = strB.toString();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MessageDialogFactory.createMessageDialog("Using Help", msg, false, ownerFrame).setVisible(true);
            }
        });
    }

    public static JFrame getInvisibleFrame(String iconPath) {
        IconHelper helper = new IconHelper();
        JFrame invisibleFrame = new JFrame();
        invisibleFrame.setIconImage(helper.getIconImage(iconPath));
        return invisibleFrame;
    }
}

