/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import se.ericsson.cello.emt.sshsftpservice.EmSftp;
import se.ericsson.cello.emt.sshsftpservice.EmSsh;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.cello.emt.sshsftpservice.config.ifc.Configuration;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.cello.emt.sshsftpservice.factory.impl.TheFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ReusableLaunchable;
import se.ericsson.security.utils.EmLogger;

public class SshSftpProvider
implements ReusableLaunchable,
SshSftpService {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String INTERRUPTED_WHEN_GETTING_THE_MANAGER_TITLE = "Interrupted when getting the manager title";
    private static final String INTERRUPTED_WHEN_GETTING_CONNECTION = "Interrupted when setting up %s connection";
    private static final String NOT_POSSIBLE_TO_GET_CONNECTION = "It was not possible to get an %s connection";
    private static final String HOST_IS_NULL = "Host must not be null";
    private static final String HOST_IS_DIFFERENT = "Given host is not the same as host supplied in run():\nOld host: %s\nNew host: %s";
    private static final String SFTP = "SFTP";
    private static final String SSH = "SSH";
    private static final String REMOVING_PROPERTY = "Property %s with value %s is removed from given properties.";
    private LauncherInterface launcher = null;
    private Configuration configuration = null;
    private SshSftpService sshSftpService = null;
    private CountDownLatch runMethodIsDone;

    public SshSftpProvider() {
        LOG.entering(new Object[0]);
        this.runMethodIsDone = new CountDownLatch(1);
    }

    public void reuse(String host, Properties properties, LauncherInterface launcher, Launchable parent) throws EmSshException {
        LOG.entering(new Object[]{host, properties});
        String oldHost = this.configuration.getHost();
        String newHost = properties.getProperty("address");
        if (!oldHost.equals(newHost)) {
            String msg = String.format(HOST_IS_DIFFERENT, oldHost, newHost);
            LOG.severe(msg, new Object[0]);
            throw new EmSshException(msg);
        }
        if (properties.containsKey("address")) {
            String msg = String.format(REMOVING_PROPERTY, "address", properties.getProperty("address"));
            LOG.info(msg, new Object[0]);
            properties.remove("address");
        }
        this.configuration.addProperties(properties);
    }

    public void exit() {
        LOG.entering(new Object[0]);
        this.sshSftpService = null;
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String host, Properties properties) {
        LOG.entering(new Object[]{host, properties});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String host, Properties properties, LauncherInterface launcher, Launchable parent) throws EmSshException {
        LOG.entering(new Object[]{host, properties});
        this.launcher = launcher;
        try {
            this.configuration = TheFactory.createConfiguration(properties);
            LOG.info("SshSftpProvider gets the SshSftpService", new Object[0]);
            this.sshSftpService = TheFactory.getSshSftpService();
        }
        finally {
            this.runMethodIsDone.countDown();
        }
    }

    public EmSftp getSftp(String callingApplicationTitle) throws EmSshLoginException, EmSshException {
        EmSftp emSftp = null;
        LOG.entering(new Object[0]);
        try {
            this.runMethodIsDone.await();
            emSftp = this.sshSftpService.getSftp(callingApplicationTitle);
        }
        catch (RuntimeException e) {
            String msg = String.format(NOT_POSSIBLE_TO_GET_CONNECTION, SFTP);
            LOG.severe(msg, (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            String msg = String.format(INTERRUPTED_WHEN_GETTING_CONNECTION, SFTP);
            LOG.severe(msg, (Throwable)e);
            throw new EmSshException(msg, e);
        }
        return emSftp;
    }

    public EmSsh getSsh(String callingApplicationTitle) throws EmSshLoginException, EmSshException {
        EmSsh emSsh = null;
        LOG.entering(new Object[0]);
        try {
            this.runMethodIsDone.await();
            emSsh = this.sshSftpService.getSsh(callingApplicationTitle);
        }
        catch (RuntimeException e) {
            String msg = String.format(NOT_POSSIBLE_TO_GET_CONNECTION, SSH);
            LOG.severe(msg, (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            String msg = String.format(INTERRUPTED_WHEN_GETTING_CONNECTION, SSH);
            LOG.severe(msg, (Throwable)e);
            throw new EmSshException(msg, e);
        }
        return emSsh;
    }

    public String toString() {
        try {
            this.runMethodIsDone.await();
        }
        catch (InterruptedException e) {
            String msg = INTERRUPTED_WHEN_GETTING_THE_MANAGER_TITLE;
            LOG.severe(msg, (Throwable)e);
            throw new EmSshException(msg, e);
        }
        return this.configuration.getTitle();
    }
}

