/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.credential.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.sshsftpservice.config.ifc.Configuration;
import se.ericsson.cello.emt.sshsftpservice.credential.ifc.UserCredentials;
import se.ericsson.cello.emt.sshsftpservice.credential.ifc.UserCredentialsSupplier;
import se.ericsson.cello.emt.sshsftpservice.credential.impl.LoginModel;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshException;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.cello.emt.utils.guihelper.GridBagPanel;
import se.ericsson.security.utils.EmLogger;

public class LoginControllerView
extends JDialog
implements UserCredentialsSupplier {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final long serialVersionUID = -7204413396790213704L;
    private static final String MESSAGE = "<html>SSH login to the node was not possible using central point of authentication.<p><center>Please use <u>node</u> password to log in.</center></html>";
    private static final String USER_NAME_TEXT = "User name:";
    private static final String PASSWORD_TEXT = "Password:";
    private static final String LOGIN_BUTTON_TEXT = "Log In";
    private static final String CANCEL_BUTTON_TEXT = "Cancel";
    private static final String LOGIN_BUTTON_TOOLTIP = "Log in to SSH/SFTP on the node";
    private static final String TITLE_LOGIN = "SSH/SFTP Login";
    private JPasswordField pwField;
    private JTextField userNameField;
    private LoginModel model;
    private String host = "";

    private static String constructTitle(String host, String callingApplicationTitle) {
        StringBuilder title = new StringBuilder();
        title.append(host);
        if (!"".equals(callingApplicationTitle)) {
            title.append(" - ");
            title.append(callingApplicationTitle);
        }
        title.append(" - ");
        title.append(TITLE_LOGIN);
        return title.toString();
    }

    private static JFrame constructFrameWithImage(Configuration props) {
        JFrame frame = new JFrame();
        if (null == props) {
            LOG.warning("Got no Properties. Cannot set icon to the Login window.", new Object[0]);
        } else {
            frame.setIconImage(props.getIconImage());
        }
        return frame;
    }

    public LoginControllerView(Configuration props) {
        super(LoginControllerView.constructFrameWithImage(props));
        if (null == props) {
            LOG.warning("Got no Properties. Cannot set the host address on the Login window title.", new Object[0]);
        } else {
            this.host = props.getHost();
        }
    }

    public UserCredentials getUserCredentials(final String callingApplicationTitle) throws EmSshLoginException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.initDialog();
            this.displayLoginDialog(callingApplicationTitle);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        LoginControllerView.this.initDialog();
                        LoginControllerView.this.displayLoginDialog(callingApplicationTitle);
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.warning("InterruptedException. The Login window display was interrupted", new Object[0]);
                throw new EmSshLoginException("The Login window display was interrupted.", e);
            }
            catch (InvocationTargetException e) {
                LOG.warning("InvocationTargetException. The display of the Login window failed.", new Object[0]);
                throw new EmSshLoginException("The display of the Login window failed.", e);
            }
            catch (EmSshException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warning("An exception occured when getting name and password from user. " + e.toString(), new Object[0]);
                throw new EmSshLoginException("An unexpected exception occured. Failed getting user name and password.", e);
            }
        }
        if (this.model == null) {
            throw new EmSshLoginException("Login was not possible since user name and password were not supplied.");
        }
        return this.model;
    }

    private void displayLoginDialog(String callingApplicationTitle) {
        this.setTitle(LoginControllerView.constructTitle(this.host, callingApplicationTitle));
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int xPos = (dimension.width - this.getSize().width) / 3;
        int yPos = (dimension.height - this.getSize().height) / 3;
        this.setLocation(xPos, yPos);
        this.pack();
        this.setVisible(true);
        LOG.fine("After setVisible", new Object[0]);
    }

    private void initDialog() {
        JPanel theDialogPanel = (JPanel)this.getContentPane();
        theDialogPanel.setLayout(new BorderLayout(5, 5));
        theDialogPanel.add((Component)this.getTopPanel(), "North");
        theDialogPanel.add((Component)this.getInputPanel(), "Center");
        theDialogPanel.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getTopPanel() {
        JPanel messP = new JPanel(new FlowLayout(1));
        messP.setOpaque(false);
        JLabel messageLabel = new JLabel(MESSAGE);
        messageLabel.setName("messageLabel");
        messP.add(messageLabel);
        return messP;
    }

    private JPanel getInputPanel() {
        GridBagPanel inputPanel = new GridBagPanel();
        inputPanel.setOpaque(false);
        this.pwField = new JPasswordField();
        this.pwField.setName("pwField");
        this.pwField.setPreferredSize(new Dimension(200, 21));
        this.pwField.setEchoChar('*');
        this.userNameField = new JTextField();
        this.userNameField.setName("usrNameField");
        this.userNameField.setPreferredSize(new Dimension(200, 21));
        this.userNameField.requestFocus();
        JLabel nameLabel = new JLabel(USER_NAME_TEXT);
        nameLabel.setName("usrNameLabel");
        JLabel passwordLabel = new JLabel(PASSWORD_TEXT);
        passwordLabel.setName("pwLabel");
        inputPanel.setAnchor(18);
        inputPanel.setInsets(10, 80, 2, 10);
        inputPanel.setWeightX(1);
        inputPanel.add(nameLabel, 0, 0, 1, 1);
        inputPanel.setAnchor(16);
        inputPanel.setInsets(2, 80, 10, 10);
        inputPanel.setWeightX(2);
        inputPanel.add(passwordLabel, 0, 1, 1, 1);
        inputPanel.setAnchor(12);
        inputPanel.setInsets(10, 0, 2, 80);
        inputPanel.setWeightX(1);
        inputPanel.add(this.userNameField, 1, 0, 1, 1);
        inputPanel.setAnchor(14);
        inputPanel.setInsets(2, 0, 10, 80);
        inputPanel.setWeightX(2);
        inputPanel.add(this.pwField, 1, 1, 1, 1);
        return inputPanel;
    }

    private JPanel getButtonPanel() {
        JButton loginButton = new JButton(LOGIN_BUTTON_TEXT);
        loginButton.setName("loginButton");
        loginButton.setToolTipText(LOGIN_BUTTON_TOOLTIP);
        loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginControllerView.this.loginBtnPressed();
            }
        });
        JButton cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        cancelButton.setName("cancelButton");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginControllerView.this.cancelBtnPressed();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setOpaque(true);
        buttonPanel.add(loginButton);
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(loginButton);
        return buttonPanel;
    }

    private void cancelBtnPressed() {
        LOG.fine("cancelBtnPressed in LoginGui", new Object[0]);
        this.model = null;
        this.setVisible(false);
        this.dispose();
    }

    private void loginBtnPressed() {
        LOG.fine("loginBtnPressed in LoginGui", new Object[0]);
        this.model = this.userNameField.getText().trim().length() == 0 || this.pwField.getPassword().length == 0 ? null : new LoginModel(this.userNameField.getText().trim(), this.pwField.getPassword());
        this.setVisible(false);
        this.dispose();
    }
}

