/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.utils.guihelper;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import se.ericsson.cello.emt.utils.guihelper.IconHelper;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.helpers.EmasUtilities;
import se.ericsson.security.launcher.eprops.ErrorPopUpPrinter;

public class MessageDialogImpl
implements MessageDialog {
    private static final String OS_NAME = "os.name";
    private static final String DEFAULT_TITLE = "Message";
    private static final long serialVersionUID = 1L;
    private String mySpecificMessage = null;
    private String myMainMessage = null;
    private Exception myException = null;
    private ErrorPopUpPrinter myEPropsPrinter = null;
    private boolean mySevere;
    private JFrame myOwner = null;
    private String moreStr = "More >>";
    private String lessStr = "<< Less";
    final int ROWS_DEFAULT = 10;
    final int COLUMNS_DEFAULT = 60;
    private JDialog jDialog = null;
    private JScrollPane scrollPane = null;
    private JTextArea detailsTextArea = null;
    protected static final Border loweredBorder = BorderFactory.createLoweredBevelBorder();
    private static final String LINUX = "Linux";
    private JPanel northP = null;
    private JPanel iconP = null;
    private JLabel errorLabel = null;
    private JPanel messageP = null;
    private JPanel northMessagePane = null;
    private JPanel centerMessagePane = null;
    private JTextArea messageTextArea = null;
    private JPanel buttonP = null;
    private JButton detailsB = null;
    private JButton closeBtn = null;
    private JTextArea specMessageTextArea = null;
    private JFrame frame = null;
    private String myIconPath = null;
    private String myTitle = null;

    public MessageDialogImpl() {
        this.initialize();
    }

    public MessageDialogImpl(String mainMessage, Exception exception, boolean severe, String title, JFrame owner) {
        this(mainMessage, null, exception, severe, title, owner);
    }

    public MessageDialogImpl(String mainMessage, String specificMessage, Exception exception, boolean severe, String title, JFrame owner) {
        this(mainMessage, specificMessage, exception, null, severe, title, owner);
    }

    public MessageDialogImpl(String mainMessage, String specificMessage, Exception exception, String aIconPath, boolean severe, String title, JFrame owner) {
        this.myMainMessage = mainMessage;
        this.mySpecificMessage = specificMessage;
        this.myException = exception;
        this.mySevere = severe;
        this.myOwner = owner;
        this.myIconPath = aIconPath;
        this.myTitle = title == null ? DEFAULT_TITLE : title;
        this.initialize();
    }

    public MessageDialogImpl(String mainMessage, String specificMessage, boolean severe, JFrame owner) {
        this(mainMessage, specificMessage, null, severe, null, owner);
    }

    public JDialog getMainWindow() {
        return this.jDialog;
    }

    private void initialize() {
        boolean linux;
        if (this.myException != null) {
            this.myEPropsPrinter = new ErrorPopUpPrinter((Throwable)this.myException);
        }
        if (null == this.myOwner) {
            this.frame = new JFrame();
            IconHelper helper = new IconHelper();
            this.frame.setIconImage(helper.getIconImage(this.myIconPath));
            this.myOwner = this.frame;
        }
        this.jDialog = new JDialog(this.myOwner);
        this.jDialog.getContentPane().add((Component)this.getNorthP(), "North");
        this.jDialog.getContentPane().add((Component)this.getScrollPane(), "Center");
        this.jDialog.setResizable(true);
        if (this.mySevere) {
            this.jDialog.setAlwaysOnTop(true);
            this.jDialog.setLocation(this.myOwner.getLocation().x + 30, this.myOwner.getLocation().y + 30);
        } else {
            this.jDialog.setLocation(this.myOwner.getLocation().x + 70, this.myOwner.getLocation().y + 70);
        }
        this.jDialog.setTitle(this.myTitle);
        if (this.frame == this.myOwner) {
            this.jDialog.setAlwaysOnTop(true);
        }
        boolean windows = EmasUtilities.runningOnWindows();
        boolean bl = linux = System.getProperty(OS_NAME).indexOf(LINUX) > -1;
        if (windows || linux) {
            this.jDialog.setModal(false);
        } else {
            this.jDialog.setModal(this.mySevere);
        }
    }

    public JDialog getDialog() {
        return this.jDialog;
    }

    public void setVisible(final boolean visible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageDialogImpl.this.setVisible(visible);
                }
            });
        } else {
            if (visible) {
                this.jDialog.pack();
            }
            this.jDialog.setVisible(visible);
        }
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getDetailsTextArea());
            this.scrollPane.setVisible(false);
        }
        return this.scrollPane;
    }

    private JTextArea getDetailsTextArea() {
        if (this.detailsTextArea == null) {
            this.detailsTextArea = new JTextArea();
            this.detailsTextArea.setName("detailsTextArea");
            this.detailsTextArea.setRows(10);
            this.detailsTextArea.setColumns(60);
            this.detailsTextArea.setLineWrap(false);
            this.detailsTextArea.setEditable(false);
            this.detailsTextArea.setBorder(loweredBorder);
            this.detailsTextArea.setBackground(this.messageP.getBackground());
            this.detailsTextArea.setMargin(new Insets(0, 2, 0, 5));
            int textSize = this.messageTextArea == null || this.messageTextArea.getFont() == null ? 12 : this.messageTextArea.getFont().getSize();
            FontUIResource font = new FontUIResource("Monospaced", 0, textSize);
            this.detailsTextArea.setFont(font);
            StringBuilder message = new StringBuilder();
            if (this.myMainMessage != null) {
                message.append(this.myMainMessage);
                message.append("\n");
            }
            if (this.mySpecificMessage != null) {
                message.append(this.mySpecificMessage);
                message.append("\n");
            }
            if (this.myEPropsPrinter != null) {
                message.append(this.myEPropsPrinter.getPopUpDetails());
            }
            this.detailsTextArea.setText(message.toString());
            this.detailsTextArea.setCaretPosition(0);
        }
        return this.detailsTextArea;
    }

    private JPanel getNorthP() {
        if (this.northP == null) {
            this.northP = new JPanel();
            this.northP.setLayout(new BorderLayout());
            this.northP.add((Component)this.getIconP(), "West");
            this.northP.add((Component)this.getMessageP(), "Center");
            this.northP.add((Component)this.getButtonP(), "South");
        }
        return this.northP;
    }

    private JPanel getIconP() {
        if (this.iconP == null) {
            this.iconP = new JPanel();
            this.iconP.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            this.iconP.setLayout(new BorderLayout());
            this.iconP.add((Component)this.getErrorLabel(), "North");
        }
        return this.iconP;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            Icon icon = this.mySevere ? UIManager.getIcon("OptionPane.errorIcon") : UIManager.getIcon("OptionPane.informationIcon");
            this.errorLabel = new JLabel(icon);
        }
        return this.errorLabel;
    }

    private JPanel getMessageP() {
        if (this.messageP == null) {
            this.messageP = new JPanel();
            this.messageP.setLayout(new BorderLayout());
            this.messageP.add((Component)this.getNorthMessagePane(), "North");
        }
        return this.messageP;
    }

    private JPanel getNorthMessagePane() {
        if (this.northMessagePane == null) {
            this.northMessagePane = new JPanel();
            this.northMessagePane.setLayout(new BorderLayout());
            this.northMessagePane.add((Component)this.getCenterMessagePane(), "Center");
        }
        return this.northMessagePane;
    }

    private JPanel getCenterMessagePane() {
        if (this.centerMessagePane == null) {
            this.centerMessagePane = new JPanel();
            this.centerMessagePane.setLayout(new BorderLayout());
            this.centerMessagePane.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
            if (this.myMainMessage != null) {
                this.centerMessagePane.add((Component)this.getMessageTextArea(), "North");
            }
            this.centerMessagePane.add((Component)this.getSpecMessageTextArea(), "Center");
        }
        return this.centerMessagePane;
    }

    private JTextArea getMessageTextArea() {
        if (this.messageTextArea == null) {
            String message = this.myMainMessage;
            this.messageTextArea = new JTextArea(message);
            this.messageTextArea.setName("messageTextArea");
            this.messageTextArea.setColumns(60);
            this.messageTextArea.setLineWrap(true);
            this.messageTextArea.setWrapStyleWord(true);
            this.messageTextArea.setEditable(false);
            this.messageTextArea.setOpaque(false);
            Font currentFont = this.messageTextArea.getFont();
            this.messageTextArea.setFont(new Font(currentFont.getName(), 1, currentFont.getSize()));
            this.messageTextArea.setForeground(Color.black);
            this.messageTextArea.setMargin(new Insets(0, 2, 0, 5));
            this.messageTextArea.setSize(this.messageTextArea.getPreferredSize());
            this.messageTextArea.setBackground(new Color(this.myOwner.getBackground().getRGB()));
            this.messageTextArea.validate();
        }
        return this.messageTextArea;
    }

    private JPanel getButtonP() {
        if (this.buttonP == null) {
            this.buttonP = new JPanel();
            this.buttonP = new JPanel(new FlowLayout(2));
            if (this.myException != null) {
                this.buttonP.add((Component)this.getDetailsB(), null);
            }
            this.buttonP.add((Component)this.getCloseBtn(), null);
        }
        return this.buttonP;
    }

    private JButton getDetailsB() {
        if (this.detailsB == null) {
            this.detailsB = new JButton(this.moreStr);
            this.detailsB.setName("detailsB");
            this.detailsB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MessageDialogImpl.this.detailsB.getText().equals(MessageDialogImpl.this.moreStr)) {
                        MessageDialogImpl.this.scrollPane.setPreferredSize(null);
                        MessageDialogImpl.this.scrollPane.setVisible(true);
                        MessageDialogImpl.this.detailsB.setText(MessageDialogImpl.this.lessStr);
                        MessageDialogImpl.this.jDialog.pack();
                    } else {
                        MessageDialogImpl.this.scrollPane.setPreferredSize(new Dimension(0, 0));
                        MessageDialogImpl.this.scrollPane.setVisible(false);
                        MessageDialogImpl.this.detailsB.setText(MessageDialogImpl.this.moreStr);
                        MessageDialogImpl.this.jDialog.pack();
                    }
                }
            });
        }
        return this.detailsB;
    }

    private JButton getCloseBtn() {
        if (this.closeBtn == null) {
            this.closeBtn = new JButton("Close");
            this.closeBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MessageDialogImpl.this.frame == MessageDialogImpl.this.myOwner) {
                        MessageDialogImpl.this.frame.dispose();
                    }
                    MessageDialogImpl.this.jDialog.dispose();
                }
            });
        }
        return this.closeBtn;
    }

    private JTextArea getSpecMessageTextArea() {
        if (this.specMessageTextArea == null) {
            this.specMessageTextArea = new JTextArea();
            this.specMessageTextArea.setName("specMessageTextArea");
            StringBuffer specific = new StringBuffer("");
            if (this.mySpecificMessage != null && !"".equals(this.mySpecificMessage)) {
                specific.append(this.mySpecificMessage);
                specific.append("\n");
            } else if (this.myMainMessage != null && !"".equals(this.myMainMessage)) {
                if (this.myException != null && this.myException.getMessage() != null) {
                    specific.append(this.myException.getMessage());
                }
            } else if (this.myEPropsPrinter != null && !"".equals(this.myEPropsPrinter.getPopUpMessge())) {
                specific.append(this.myEPropsPrinter.getPopUpMessge());
            } else if (this.myException != null && this.myException.getMessage() != null) {
                specific.append("INTERNAL PROGRAMMING ERROR!\n\n");
                specific.append(this.myException.getMessage());
            } else {
                specific.append("INTERNAL PROGRAMMING ERROR!\n\n");
            }
            this.specMessageTextArea.setText(specific.toString());
            this.specMessageTextArea.setColumns(60);
            this.specMessageTextArea.setLineWrap(true);
            this.specMessageTextArea.setWrapStyleWord(true);
            this.specMessageTextArea.setEditable(false);
            this.specMessageTextArea.setOpaque(false);
            this.specMessageTextArea.setMargin(new Insets(0, 2, 0, 5));
            this.specMessageTextArea.setSize(this.specMessageTextArea.getPreferredSize());
            this.specMessageTextArea.setBackground(new Color(this.myOwner.getBackground().getRGB()));
            this.specMessageTextArea.validate();
        }
        return this.specMessageTextArea;
    }
}

