/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ChangeEcPortHubPositionValueAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = ChangeEcPortHubPositionValueAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            if (tableHandler != null) {
                this.changeEcPortHubPositionValue(tableHandler);
            }
        }
        catch (TableDataException tableDataException) {
            logger.traceError(THIS_CLASS, "Could not store information in AuePersistency. Reason: " + tableDataException.getMessage());
            throw new CrbsAueException("Could not store information in AuePersistency. Reason: " + tableDataException.getMessage());
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "Convert failed: " + exception.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void changeEcPortHubPositionValue(TableHandler tableHandler) throws TableDataException, CrbsAueException {
        String string;
        String string2;
        int n;
        logger.traceEnter(THIS_CLASS, "changeEcPortHubPositionValue()");
        TableData tableData = tableHandler.getTableData("HwUnit");
        int n2 = 0;
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < tableData.getNumberOfRecords(); ++n) {
            Map map;
            try {
                map = tableData.getRecordMap(n);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            string2 = (String)map.get("unitType");
            logger.info(THIS_CLASS, "unittype: " + string2);
            if (!"SUP".equals(string2)) continue;
            ++n2;
            string = (String)map.get("ldn");
            arrayList.add(string);
            String string4 = this.getSupId(string);
            arrayList2.add(string4);
            logger.info(THIS_CLASS, "supId: (" + string4 + ")");
            if (string4.compareTo(string3) <= 0) continue;
            logger.info(THIS_CLASS, "highest supId: (" + string4 + ")");
            string3 = string4;
        }
        logger.info(THIS_CLASS, "supIdList.size(): " + arrayList2.size());
        logger.info(THIS_CLASS, "ldnList.size(): " + arrayList.size());
        logger.info(THIS_CLASS, "supCount: " + n2);
        logger.info(THIS_CLASS, "highest supId: (" + string3 + ")");
        if (n2 == 2) {
            logger.info(THIS_CLASS, "Found two SUP");
            for (n = 0; n < arrayList2.size(); ++n) {
                string2 = (String)arrayList2.get(n);
                string = (String)arrayList.get(n);
                logger.info(THIS_CLASS, "Check supId: (" + string2 + ")");
                if (!string2.equals(string3)) continue;
                logger.info(THIS_CLASS, "Found SUP with highest supId: (" + string2 + ")");
                logger.info(THIS_CLASS, "ldn: '" + string + "'");
                logger.info(THIS_CLASS, "Updating EcPort children...");
                this.findAndUpdateChildren(tableHandler, string);
            }
        } else {
            logger.info(THIS_CLASS, "Did not find two SUP, nothing to do");
        }
        logger.traceReturn(THIS_CLASS, "changeEcPortHubPositionValue()");
    }

    private String getSupId(String string) {
        String string2 = "not found";
        int n = string.lastIndexOf("HwUnit=");
        if (n > 0) {
            try {
                string2 = string.substring(n + 7);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.info(THIS_CLASS, "Unable to parse supLdn: " + string);
                logger.info(THIS_CLASS, indexOutOfBoundsException.toString());
                string2 = "not found";
            }
        } else {
            logger.info(THIS_CLASS, "Unable to parse supLdn: " + string);
        }
        return string2;
    }

    private void findAndUpdateChildren(TableHandler tableHandler, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findAndUpdateChildren");
        boolean bl = false;
        try {
            TableData tableData = tableHandler.getTableData("EcPort");
            bl = tableData.isTableDataUpdated();
            Object[] objectArray = tableData.getAttributeValues("ldn");
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = objectArray[i].toString();
                logger.info(THIS_CLASS, "Check if '" + string + "' is parent to '" + string2 + "'...");
                if (string.equalsIgnoreCase(this.getParentLdn(string2))) {
                    logger.info(THIS_CLASS, "Yes! It's the parent.");
                    logger.info(THIS_CLASS, "Update HubPosition for ldn: '" + string2 + "'");
                    tableData.setAttributeValue(i, "hubPosition", (Object)"AUX NA");
                    tableData.setTableDataUpdated(true);
                    continue;
                }
                logger.info(THIS_CLASS, "No, Mo '" + string + "' is not parent to '" + string2 + "'");
            }
            tableHandler.checkAndDropIfNotUpdated(bl, tableData);
        }
        catch (Exception exception) {
            String string3 = "Could not update '" + AueUtil.doubleQuote((String)"EcPort") + "'";
            logger.traceError(THIS_CLASS, AueUtil.appendReason((String)string3, (Throwable)exception));
            throw new CrbsAueException(string3, (Throwable)exception);
        }
        logger.traceReturn(THIS_CLASS, "findAndUpdateChildren");
    }
}

