/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeIfNotExistAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class CreateFroClimateForCabinetsAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = CreateFroClimateForCabinetsAction.class;
    private static TableHandler tableHandler;
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String CLIMATE_MO_TYPE = "Climate";
    private static final String LDN_ATTRIBUTE_NAME = "ldn";
    private static final int CLIMATE_FRO_TYPE = 117702673;
    private static final int CABINET_FRO_TYPE = 0x7040000;
    private static final String CLIMATE_CONTROL_MODE_ATTRIBUTE_NAME = "climateControlMode";
    private static final String CLIMATE_CONTROL_MODE_ATTRIBUTE_TYPE = "S32";
    private static final String CLIMATE_CONTROL_MODE_ATTRIBUTE_DEFAULT = "0";
    private static final String CONTROL_DOMAIN_REF_ATTRIBUTE_NAME = "controlDomainRef";
    private static final String CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT = "";
    private static final String CLIMATE_PARENT = "ManagedElement=1,EquipmentSupportFunction=1";
    private static final String STEP2_CLIMATE_CTRLDOMAINREF_TAG = "ctrlDomainRef";
    private static final String STEP2_CLIMATE_FROID_TAG = "climateFroId";
    private static final String STEP2_CLIMATES_LIST_TAG = "climateList";
    private static final String STEP2_CLIMATE_CREATED = "climateCreated";
    private static final AbstractLogger logger;

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        TableData tableData = null;
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            try {
                tableData = tableHandler.getTableData(CABINET_MO_TYPE);
            }
            catch (TableDataException tableDataException) {
                tableData = null;
            }
            if (tableData != null && tableData.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "createInstance(): createClimates");
                this.createClimates(tableData, aueContext);
            } else {
                logger.traceGeneral(THIS_CLASS, "createInstance(): createClimates == False");
                tableHandler.storeInAuePersistency(CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT, STEP2_CLIMATE_CREATED, Boolean.toString(false));
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet or Climate tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private boolean cabinetReferenceExist(TableData tableData, String string) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "cabinetReferenceExist()");
        if (tableData != null && tableData.isNotEmpty()) {
            Object[] objectArray = tableData.getAttributeValues(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
            for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                if (objectArray[i].toString().trim().equals(CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT) || objectArray[i].toString().length() - TableDataUtil.createEmptyArrayXmlString((String)CONTROL_DOMAIN_REF_ATTRIBUTE_NAME).length() <= 4) continue;
                String string2 = TableDataUtil.getLdnFromMoRef((String)objectArray[i].toString());
                if (!string.toLowerCase().equals(string2.toLowerCase())) continue;
                logger.traceReturn(THIS_CLASS, "cabinetReferenceExist(): True");
                return true;
            }
        }
        logger.traceReturn(THIS_CLASS, "cabinetReferenceExist(): False");
        return false;
    }

    private boolean climateLdnExist(TableData tableData, String string) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "climateLdnExist()");
        if (tableData != null && tableData.isNotEmpty()) {
            Object[] objectArray = tableData.getAttributeValues(LDN_ATTRIBUTE_NAME);
            for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                if (!objectArray[i].toString().toLowerCase().equals(string.toLowerCase())) continue;
                logger.traceReturn(THIS_CLASS, "climateLdnExist(): True");
                return true;
            }
        }
        logger.traceReturn(THIS_CLASS, "climateLdnExist(): False");
        return false;
    }

    private boolean froIdExist(TableData tableData, String string) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "froIdExist()");
        if (tableData != null && tableData.isNotEmpty()) {
            Object[] objectArray = tableData.getAttributeValues("froid");
            for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                if (!objectArray[i].toString().equals(string)) continue;
                logger.traceReturn(THIS_CLASS, "froIdExist(): True");
                return true;
            }
        }
        logger.traceReturn(THIS_CLASS, "froIdExist(): False");
        return false;
    }

    private void createClimates(TableData tableData, AueContext aueContext) throws CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "createClimates()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            try {
                try {
                    tableData2 = tableHandler.getTableData(CLIMATE_MO_TYPE);
                }
                catch (TableDataException tableDataException) {
                    tableData2 = null;
                }
                Map map = tableData.getRecordMap(i);
                String string = (String)map.get(LDN_ATTRIBUTE_NAME);
                String string2 = TableDataUtil.getFroid((String)string, (TableData)tableData);
                String string3 = map.get(CLIMATE_CONTROL_MODE_ATTRIBUTE_NAME).toString();
                String string4 = TableDataUtil.createMoRefXmlString((String)CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, (String)string, (String)Integer.toString(0x7040000), (String)string2);
                if (!this.cabinetReferenceExist(tableData2, string)) {
                    bl = true;
                    String string5 = "ManagedElement=1,EquipmentSupportFunction=1,Climate=" + ++n;
                    while (this.climateLdnExist(tableData2, string5)) {
                        string5 = "ManagedElement=1,EquipmentSupportFunction=1,Climate=" + ++n;
                    }
                    while (this.froIdExist(tableData2, Integer.toString(n2))) {
                        ++n2;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string4);
                    String string6 = TableDataUtil.createArrayXmlString((String)CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, arrayList);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("name", CLIMATE_MO_TYPE);
                    hashMap.put("frotype", Integer.toString(117702673));
                    hashMap.put("rdnValue", Integer.toString(n));
                    hashMap.put("parentldn", CLIMATE_PARENT);
                    hashMap.put("parentRefExists", Boolean.FALSE.toString());
                    hashMap.put("froid", Integer.toString(n2));
                    StringBuffer stringBuffer2 = new StringBuffer("<attributes>");
                    if (tableData2 != null && tableData2.doesAttributeExist(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME)) {
                        stringBuffer2.append("<attr name=\"controlDomainRef\" type=\"Array\" value=\"" + string6 + "\"/>");
                        stringBuffer2.append("<attr name=\"climateControlMode\" type=\"S32\" value=\"" + string3 + "\" />");
                        stringBuffer2.append("</attributes>");
                        hashMap.put("childAttributes", stringBuffer2.toString());
                    }
                    CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
                    createOneInstanceAction.setMoActionArgs(hashMap);
                    createOneInstanceAction.convert(aueContext);
                    AddAttributeIfNotExistAction addAttributeIfNotExistAction = new AddAttributeIfNotExistAction();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    hashMap2.put("Mo", CLIMATE_MO_TYPE);
                    hashMap2.put("name", CLIMATE_CONTROL_MODE_ATTRIBUTE_NAME);
                    hashMap2.put("type", CLIMATE_CONTROL_MODE_ATTRIBUTE_TYPE);
                    hashMap2.put("defaultValue", CLIMATE_CONTROL_MODE_ATTRIBUTE_DEFAULT);
                    addAttributeIfNotExistAction.setMoActionArgs(hashMap2);
                    addAttributeIfNotExistAction.convert(aueContext);
                    hashMap2.put("Mo", CLIMATE_MO_TYPE);
                    hashMap2.put("name", CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
                    hashMap2.put("type", "Array");
                    hashMap2.put("defaultValue", CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT);
                    addAttributeIfNotExistAction.setMoActionArgs(hashMap2);
                    addAttributeIfNotExistAction.convert(aueContext);
                    ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
                    HashMap<String, String> hashMap3 = new HashMap<String, String>();
                    hashMap3.put("rdnValue", Integer.toString(n));
                    hashMap3.put("Mo", CLIMATE_MO_TYPE);
                    hashMap3.put("attribute", CLIMATE_CONTROL_MODE_ATTRIBUTE_NAME);
                    hashMap3.put("newAttributeValue", string3);
                    changeAttributeValueAction.setMoActionArgs(hashMap3);
                    changeAttributeValueAction.convert(aueContext);
                    hashMap3.put("attribute", CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
                    hashMap3.put("newAttributeValue", string6);
                    changeAttributeValueAction.setMoActionArgs(hashMap3);
                    changeAttributeValueAction.convert(aueContext);
                    stringBuffer.append((stringBuffer.length() > 0 ? ":" : CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT) + string5);
                    tableHandler.storeInAuePersistency(string5, STEP2_CLIMATE_FROID_TAG, Integer.toString(n2));
                    tableHandler.storeInAuePersistency(string5, STEP2_CLIMATE_CTRLDOMAINREF_TAG, string);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            catch (NoSuchTableException noSuchTableException) {
                throw new CrbsAueException(noSuchTableException.getMessage(), (Throwable)noSuchTableException);
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                throw new CrbsAueException(tableAlreadyExistsException.getMessage(), (Throwable)tableAlreadyExistsException);
            }
            tableHandler.storeInAuePersistency(CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT, STEP2_CLIMATE_CREATED, Boolean.toString(bl));
        }
        if (stringBuffer.length() != 0) {
            try {
                tableHandler.storeInAuePersistency(CONTROL_DOMAIN_REF_ATTRIBUTE_DEFAULT, STEP2_CLIMATES_LIST_TAG, stringBuffer.toString());
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "createClimates()");
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

