/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.util;

import java.util.Map;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class FiltersHelper {
    private static final Class THIS_CLASS = FiltersHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public static boolean checkFilters(TableHandler tableHandler, Map map, Map map2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkFilters()");
        boolean bl = true;
        bl = bl && FiltersHelper.checkSupportSystemRole(tableHandler, map, map2);
        bl = bl && FiltersHelper.checkOldReferencedClassName(map, map2);
        logger.traceReturn(THIS_CLASS, "checkFilters(): " + (bl ? "true" : "false"));
        return bl;
    }

    private static boolean checkOldReferencedClassName(Map map, Map map2) {
        logger.traceEnter(THIS_CLASS, "checkOldReferencedClassName()");
        boolean bl = true;
        String string = (String)map.get("attribute");
        String string2 = (String)map.get("oldReferencedClassName");
        if (string != null && string2 != null) {
            String string3 = (String)map2.get(string);
            String string4 = TableDataUtil.getLdnFromMoRef((String)string3);
            String string5 = string4 != null && string4.trim().length() > 0 ? LdnUtil.getMoType((String)string4) : "";
            bl = string2.equals(string5);
        }
        logger.traceReturn(THIS_CLASS, "checkOldReferencedClassName():" + (bl ? "true" : "false"));
        return bl;
    }

    private static boolean checkSupportSystemRole(TableHandler tableHandler, Map map, Map map2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkSupportSystemRole()");
        boolean bl = true;
        if (map.containsKey("supportSystemRole")) {
            bl = false;
            String string = (String)map2.get("equipmentSupportFunctionRef");
            String string2 = TableDataUtil.getLdnFromMoRef((String)string);
            if (string2 != null) {
                try {
                    String string3 = (String)map.get("supportSystemRole");
                    TableData tableData = tableHandler.getTableData("EquipmentSupportFunction");
                    int n = tableData.getNumberOfRecords();
                    for (int i = 0; i < n; ++i) {
                        Map map3 = tableData.getRecordMap(i);
                        String string4 = (String)map3.get("ldn");
                        if (!string2.equals(string4)) continue;
                        Integer n2 = (Integer)map3.get("supportSystemControl");
                        if (n2 != null) {
                            bl = "secondary".equals(string3) && n2 == 0 || "primary".equals(string3) && n2 == 1;
                        }
                        break;
                    }
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("Couldn't check support system role! Reason: " + tableDataException.getMessage());
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "checkSupportSystemRole():" + (bl ? "true" : "false"));
        return bl;
    }
}

