/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.export.upgrade;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.configurationversion.export.upgrade.UpgradeBackupDataContainer;
import se.ericsson.cello.configurationversion.export.upgrade.UpgradeBackupDataException;
import se.ericsson.cello.configurationversion.export.upgrade.UpgradePackageBackupDataInterface;
import se.ericsson.cello.configurationversion.file.base.CreateFileInformation;
import se.ericsson.cello.configurationversion.file.dependency.create.DependencyFileCreator;
import se.ericsson.cello.configurationversion.file.dependency.create.DependencyFileCreatorException;
import se.ericsson.cello.configurationversion.file.upgradeftpscript.create.UpgradeFTP_ScriptDataContainer;
import se.ericsson.cello.configurationversion.file.upgradeftpscript.create.UpgradeFTP_ScriptFileCreator;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.DependencyChainContainer;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageID_IllegalFormatException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageDataContainer;
import se.ericsson.cello.upgradepackage.util.file.FileHandler;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class UpgradeBackupDataController
implements UpgradePackageBackupDataInterface {
    public UpgradeBackupDataController() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeBackupDataController()");
        }
    }

    public UpgradeBackupDataContainer createUpgradePackageBackupData(String string, String string2) throws UpgradeBackupDataException, UpgradePackageID_IllegalFormatException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createUpgradePackageBackupData(String aFilePath, String anUpgradePackageId)", "anUpgradePackageId: " + string2);
        }
        try {
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(string2);
            if (upgradePackageMoExtended == null) {
                Trace.error(this.getClass(), "createUpgradePackageBackupData(String aFilePath, String anUpgradePackageId)", "The Upgrade Package ID was not found among the Upgrade Package MO instances on the node.anUpgradePackageId: " + string2);
                throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcreateUpgradePackageBackupData(String aFilePath, String anUpgradePackageId)" + "\n\tThe Upgrade Package ID was not found among the Upgrade Package MO instances on the node." + "\n\tanUpgradePackageId: " + string2);
            }
            UpgradeBackupDataContainer upgradeBackupDataContainer = new UpgradeBackupDataContainer();
            DependencyChainContainer dependencyChainContainer = upgradePackageMO_HandlerInterface.getDependencyChainForUP(upgradePackageMoExtended);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createUpgradePackageBackupData(String aFilePath, String anUpgradePackageId", "The UCF(s) for the executing UP and dependent UP(s) are saved.");
            }
            Collection collection = this.copyUCFs(dependencyChainContainer, string);
            upgradeBackupDataContainer.add(collection);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createUpgradePackageBackupData(String aFilePath, String anUpgradePackageId", "The FTP scripts for this UP and UPs that it is dependent on are created.");
            }
            UpgradeFTP_ScriptFileCreator upgradeFTP_ScriptFileCreator = new UpgradeFTP_ScriptFileCreator();
            UpgradeFTP_ScriptDataContainer upgradeFTP_ScriptDataContainer = upgradeFTP_ScriptFileCreator.createFiles(string, dependencyChainContainer);
            upgradeBackupDataContainer.add(upgradeFTP_ScriptDataContainer.getFilePaths());
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createUpgradePackageBackupData(String aFilePath, String anUpgradePackageId", "The dependency file for UP is created.");
            }
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            boolean bl = true;
            if (!SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaCvMgmntProxyAccess)) {
                bl = false;
            }
            DependencyFileCreator dependencyFileCreator = new DependencyFileCreator();
            CreateFileInformation createFileInformation = dependencyFileCreator.createFile("1", string, dependencyChainContainer, bl, true, "");
            upgradeBackupDataContainer.add(createFileInformation.getFilePath());
            return upgradeBackupDataContainer;
        }
        catch (UpgradePackageID_IllegalFormatException upgradePackageID_IllegalFormatException) {
            throw upgradePackageID_IllegalFormatException;
        }
        catch (UpgradePackageMO_HandlerException upgradePackageMO_HandlerException) {
            throw new UpgradeBackupDataException(upgradePackageMO_HandlerException.toString());
        }
        catch (DependencyFileCreatorException dependencyFileCreatorException) {
            throw new UpgradeBackupDataException(dependencyFileCreatorException.toString());
        }
        catch (UpgradeBackupDataException upgradeBackupDataException) {
            throw upgradeBackupDataException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createUpgradePackageBackupData(String aFilePath, String anUpgradePackageId)", "Throwable caugth when collection upgrade package information for a backup CV.\n\tanUpgradePackageId: " + string2, throwable);
            throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcreateUpgradePackageBackupData(String aFilePath, String anUpgradePackageId)" + "\n\tThrowable caugth when collection upgrade package information for a backup CV." + "\n\tanUpgradePackageId: " + string2 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private String copyUCF(String string, String string2) throws UpgradeBackupDataException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)", "aSourceUCF_Path: " + string + "\n\tanUCF_DestinationPath: " + string2);
        }
        try {
            if (string != null) {
                int n = string.lastIndexOf("/");
                if (n == -1) {
                    Trace.error(this.getClass(), "copyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)", "The retreived UCF path for the UP is illegal (i.e. it do not contain any character '/'.\n\taSourceUCF_Path: " + string + "\n\tanUCF_DestinationPath: " + string2);
                    throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcopyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)" + "\n\tThe retreived UCF path for the UP is illegal (i.e. it do not contain any character '/'." + "\n\taSourceUCF_Path: " + string + "\n\tanUCF_DestinationPath: " + string2);
                }
                String string3 = string.substring(n + 1);
                FileHandler.copyFile(new File(string), new File(string2 + string3));
                int n2 = string.lastIndexOf("/");
                String string4 = string.substring(n2, string.length());
                return string2 + string4;
            }
            Trace.error(this.getClass(), "copyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)", "Failed to retreive the UCF for the UP.\n\taSourceUCF_Path: null \n\tanUCF_DestinationPath: " + string2);
            throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcopyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)" + "\n\tFailed to retreive the UCF for the UP." + "\n\taSourceUCF_Path: " + string + "\n\tanUCF_DestinationPath: " + string2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)", "Throwable caught when accessing the found UP MO.\n\tanUCF_DestinationPath: " + string2, throwable);
            throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcopyUCF(String aSourceUCF_Path, String anUCF_DestinationPath)" + "\n\tThrowable caught when accessing the found UP MO." + "\n\tanUCF_DestinationPath: " + string2 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private Collection copyUCFs(DependencyChainContainer dependencyChainContainer, String string) throws UpgradeBackupDataException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)", "aDependencyChainContainer: " + dependencyChainContainer + "\n\tanUCF_DestinationPath: " + string);
        }
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            ProductDataContainer productDataContainer = dependencyChainContainer.getProductDataContainer();
            upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(productDataContainer.getNumber(), productDataContainer.getRevision());
            String string2 = "";
            if (upgradePackageMoExtended == null) {
                Trace.error(this.getClass(), "copyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)", "No UP MO was found for the Upgrade Package with product number " + productDataContainer.getNumber() + "\n\tand product revision " + productDataContainer.getRevision() + "." + "\n\tCould not save the UCF for this UP. Aborting..." + "\n\taDependencyChainContainer: " + dependencyChainContainer);
                throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcopyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)" + "\n\tNo UP MO was found for the Upgrade Package with product number " + productDataContainer.getNumber() + "\n\tand product revision " + productDataContainer.getRevision() + "." + "\n\tCould not save the UCF for this UP. Aborting..." + "\n\taDependencyChainContainer: " + dependencyChainContainer);
            }
            string2 = this.copyUCF(upgradePackageMoExtended.getUpgradeControlFilePath(null), string);
            linkedList.add(string2);
            string2 = this.copyUCF(upgradePackageMoExtended.getOriginalUpgradeControlFilePath(null), string);
            linkedList.add(string2);
            LinkedList linkedList2 = dependencyChainContainer.getDependencyUpgradePackageDataContainers();
            Iterator iterator = linkedList2.iterator();
            UpgradePackageDataContainer upgradePackageDataContainer = null;
            while (iterator.hasNext()) {
                upgradePackageDataContainer = (UpgradePackageDataContainer)iterator.next();
                productDataContainer = upgradePackageDataContainer.getProductDataContainer();
                upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(productDataContainer.getNumber(), productDataContainer.getRevision());
                if (upgradePackageMoExtended != null) {
                    string2 = this.copyUCF(upgradePackageMoExtended.getOriginalUpgradeControlFilePath(null), string);
                    linkedList.add(string2);
                    continue;
                }
                Trace.error(this.getClass(), "copyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)", "No UP MO was found for the Upgrade Package with product number " + productDataContainer.getNumber() + "\n\tand product revision " + productDataContainer.getRevision() + "." + "\n\tCould not save the UCF for this UP. Aborting..." + "\n\taDependencyChainContainer: " + dependencyChainContainer);
                throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcopyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)" + "\n\tNo UP MO was found for the Upgrade Package with product number " + productDataContainer.getNumber() + "\n\tand product revision " + productDataContainer.getRevision() + "." + "\n\tCould not save the UCF for this UP. Aborting..." + "\n\taDependencyChainContainer: " + dependencyChainContainer);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)", "Throwable caught when accessing the found UP MO.\n\taDependencyChainContainer: " + dependencyChainContainer + "\n\tanUCF_DestinationPath: " + string, throwable);
            throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tcopyUCFs(DependencyChainContainer aDependencyChainContainer, String anUCF_DestinationPath)" + "\n\tThrowable caught when trying to access an UP MO." + "\n\taDependencyChainContainer: " + dependencyChainContainer + "\n\tanUCF_DestinationPath: " + string + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

