/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.autoconfiguration.proxy;

import java.io.File;
import java.io.PrintStream;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.AutoConfigElement;
import se.ericsson.cello.configurationversion.file.autoconfiguration.parser.SettingElement;
import se.ericsson.cello.configurationversion.file.parser.XML_ParserFactory;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.su.autoconfiguration.PlugNPlayHelper;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.DomProxy;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class AutoConfigurationProxy
extends DomProxy {
    private AutoConfigElement myAutoConfigElement = null;

    public AutoConfigurationProxy(Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "AutoConfigurationProxy(Integer aVersionValue) ", "aVersionValue: " + n);
        }
        this.myAutoConfigElement = new AutoConfigElement(n.toString());
    }

    public AutoConfigurationProxy(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "AutoConfigurationProxy(String aDirPathToAutoConfigFile", "aDirPathToAutoConfigFile: " + string);
        }
        String string2 = this.getAutoConfigFilePath(string);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "AutoConfigurationProxy(String aDirPathToAutoConfigFile)", "Created the path to autoconfig file\n\ttheFilePathToAutoConfigFile: " + string2);
        }
        try {
            XML_RootElement xML_RootElement = XML_ParserFactory.instance().parseFile(string2, true);
            if (!(xML_RootElement instanceof AutoConfigElement)) {
                String string3 = "undefined";
                if (xML_RootElement != null) {
                    string3 = xML_RootElement.getClass().getName();
                }
                throw new ConfigurationVersionException("Illegal XML file type is parsed\n\tGiven XML file: " + string2 + "\n\tRoot element type: " + string3);
            }
            this.myAutoConfigElement = (AutoConfigElement)xML_RootElement;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "AutoConfigurationProxy(String aFilePathToAutoConfigFile)", "Throwable caught.\n\ttheFilePathToAutoConfigFile: " + string2, throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tAutoConfigurationProxy(String aFilePathToAutoConfigFile)" + "\n\tThrowable caught." + "\n\ttheFilePathToAutoConfigFile: " + string2 + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void addCommentToSettingElement(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addCommentToSettingElement(String aComment)", "aComment: " + string);
        }
        if (this.myAutoConfigElement.getSettingElement() == null) {
            this.myAutoConfigElement.setSettingElement(new SettingElement());
        }
        this.myAutoConfigElement.getSettingElement().addGeneralComment(string);
    }

    public String getMode() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMode()");
        }
        if (this.myAutoConfigElement.getSettingElement() != null) {
            return this.myAutoConfigElement.getSettingElement().getMode();
        }
        return null;
    }

    public void deleteFile(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteFile(String aFilePathToAutoConfigFile)", "aFilePathToAutoConfigFile: " + string);
        }
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                file = new File(string + "/" + "autoconfig.xml");
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteFile(String aFilePathToAutoConfigFile)", "Trying to delete the autoconfig file: " + file.getAbsolutePath());
            }
            if (file.delete()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteFile(String aFilePathToAutoConfigFile)", "The autoconfig file has been deleted and node scan of slots are initiated. ");
                }
                this.startNodeSlotScan();
            } else {
                Trace.error(this.getClass(), "deleteFile(String aFilePathToAutoConfigFile)", "The autoconfig file was NOT successfully deleted (ignored, it will\n\tresult in that AutoConfiguration service not will be executed, try to\n\tmanually invoke autoconfiguration after restore has been confirmed.");
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "deleteFile(String aFilePathToAutoConfigFile)", "Throwable caught i.e. failed to delete the autoconfig file. If PnP was activated it means that this will not succeed i.e. a\n\tmanuall activation of PnP must be done after successfull restore.\n\taFilePathToAutoConfigFile: " + string + "\n\tThrowable data: " + throwable);
        }
    }

    public void startNodeSlotScan() {
        PlugNPlayHelper.getInstance().startNodeSlotScan();
    }

    public void print(PrintStream printStream) throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.myAutoConfigElement.validate();
        this.myAutoConfigElement.print(printStream);
    }

    public void setMode(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setMode(SettingModeValue aMode)", "aMode: " + string);
        }
        if (this.myAutoConfigElement.getSettingElement() == null) {
            this.myAutoConfigElement.setSettingElement(new SettingElement());
        }
        this.myAutoConfigElement.getSettingElement().setMode(string);
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate()");
        }
        this.myAutoConfigElement.validate();
    }

    private String getAutoConfigFilePath(String string) {
        String string2 = "autoconfig.xml";
        BackupRestoreDataHandler.instance().setCurrentFileName(string2);
        String string3 = string + "/" + string2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAutoConfigFilePath(String aDirPathToAutoConfigFile)", "aDirPathToAutoConfigFile: " + string);
        }
        return string3;
    }
}

