/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.parser;

import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.cello.configurationversion.file.base.UnexpectedXML_FileContentSAX_Exception;
import se.ericsson.cello.configurationversion.file.parser.XML_DocumentHandler;
import se.ericsson.cello.configurationversion.file.parser.XML_ErrorHandler;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.UnexpectedXML_FileContentException;
import se.ericsson.cello.configurationversion.util.file.factory.BackupRestoreDomProxyFactory;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class XML_ParserFactory {
    private static String ParserClass = "com.microstar.xml.SAXDriver";
    private static XML_ParserFactory myInstance = null;

    private XML_ParserFactory() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "XML_ParserFactory()");
        }
        myInstance = this;
    }

    public static XML_ParserFactory instance() {
        if (myInstance == null) {
            new XML_ParserFactory();
        }
        return myInstance;
    }

    public XML_RootElement parseFile(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseFile(String aPathToXML_File)", "aPathToXML_File: " + string);
        }
        return this.parseFile(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XML_RootElement parseFile(String string, boolean bl) throws ConfigurationVersionException {
        XML_RootElement xML_RootElement;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "aPathToXML_File: " + string + "\n\taValidationNeeded: " + bl);
        }
        InputStreamReader inputStreamReader = null;
        try {
            try {
                File file = new File(string);
                if (!file.exists()) {
                    Trace.error(this.getClass(), "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "The XML file at absolute path '" + string + "' is not found." + "\n\taValidationNeeded: " + bl);
                    throw new ConfigurationVersionException("The XML file at absolute path '" + string + "' is not found." + "\n\taValidationNeeded: " + bl);
                }
                Parser parser = this.createParser();
                XML_DocumentHandler xML_DocumentHandler = new XML_DocumentHandler(string);
                XML_ErrorHandler xML_ErrorHandler = new XML_ErrorHandler(string);
                parser.setDocumentHandler(xML_DocumentHandler);
                parser.setErrorHandler(xML_ErrorHandler);
                inputStreamReader = new FileReader(file);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "A File handle has been OPENED for the XML file: " + string);
                }
                parser.parse(new InputSource(inputStreamReader));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "The XML file has been parsed.");
                }
                XML_RootElement xML_RootElement2 = xML_DocumentHandler.getXML_RootElement();
                if (bl) {
                    xML_RootElement2.validate();
                }
                xML_RootElement = xML_DocumentHandler.getXML_RootElement();
                Object var11_13 = null;
                if (inputStreamReader == null) return xML_RootElement;
            }
            catch (ConfigurationVersionException configurationVersionException) {
                throw configurationVersionException;
            }
            catch (UnexpectedXML_FileContentSAX_Exception unexpectedXML_FileContentSAX_Exception) {
                if (!BackupRestoreDomProxyFactory.getInstance().logExpectedExceptions()) throw new UnexpectedXML_FileContentException(this.getClass().getName() + "\n\tparseFile(String aPathToXML_File, boolean aValidationNeeded" + "\n\tUnexpectedXML_FileContentSAX_Exception caugth," + "\n\taPathToXML_File: " + string + "\n\taValidationNeeded: " + bl + "\n\tUnexpectedXML_FileContentSAX_Exception data: " + unexpectedXML_FileContentSAX_Exception.toString());
                Trace.error(this.getClass(), "parseFile(String aPathToXML_File, boolean aValidationNeeded", "UnexpectedXML_FileContentSAX_Exception caugth,\n\taPathToXML_File: " + string + "\n\taValidationNeeded: " + bl, unexpectedXML_FileContentSAX_Exception);
                throw new UnexpectedXML_FileContentException(this.getClass().getName() + "\n\tparseFile(String aPathToXML_File, boolean aValidationNeeded" + "\n\tUnexpectedXML_FileContentSAX_Exception caugth," + "\n\taPathToXML_File: " + string + "\n\taValidationNeeded: " + bl + "\n\tUnexpectedXML_FileContentSAX_Exception data: " + unexpectedXML_FileContentSAX_Exception.toString());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "parseFile(String aPathToXML_File, boolean aValidationNeeded", "Throwable caugth,\n\taPathToXML_File: " + string + "\n\taValidationNeeded: " + bl, throwable);
                throw new ConfigurationVersionException(this.getClass().getName() + "\n\tparseFile(String aPathToXML_File, boolean aValidationNeeded" + "\n\tThrowable caugth," + "\n\taPathToXML_File: " + string + "\n\taValidationNeeded: " + bl + "\n\tThrowable data: " + throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                if (!Trace.valid(this.getClass(), 22)) throw throwable;
                Trace.debug(this.getClass(), 22, "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "A File handle has been CLOSED to the XML file.");
                throw throwable;
            }
            catch (Throwable throwable2) {
                Trace.error(this.getClass(), "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "An error occured when trying to close the handle to the XML file. This might result in new errors due to this error.\n\ttheXML_FileHandleReader: " + inputStreamReader + "\n\tanThrowable message: " + throwable2.getMessage(), throwable2);
                throw throwable;
            }
        }
        try {}
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "An error occured when trying to close the handle to the XML file. This might result in new errors due to this error.\n\ttheXML_FileHandleReader: " + inputStreamReader + "\n\tanThrowable message: " + throwable.getMessage(), throwable);
            return xML_RootElement;
        }
        inputStreamReader.close();
        if (!Trace.valid(this.getClass(), 22)) return xML_RootElement;
        Trace.debug(this.getClass(), 22, "parseFile(String aPathToXML_File, boolean aValidationNeeded)", "A File handle has been CLOSED to the XML file.");
        return xML_RootElement;
    }

    private Parser createParser() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createParser()");
        }
        try {
            return ParserFactory.makeParser(ParserClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.error(this.getClass(), "createParser()", "Thrown when trying to load in a class through its string name,\nbut no definition for the class with the specified name could be found.\nProbably occured when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassNotFoundException: " + classNotFoundException.getMessage(), classNotFoundException);
            throw new ConfigurationVersionException("Thrown when trying to load in a class through its string name,\nbut no definition for the class with the specified name could be found.\nProbably occured when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.error(this.getClass(), "createParser()", "Thrown when trying to load in a class, but the currently executing method does\nnot have access to the definition of the specified class, beacuse the class is not public\nor in an other package.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanIllegalAccessException: " + illegalAccessException.getMessage(), illegalAccessException);
            throw new ConfigurationVersionException("Thrown when trying to load in a class, but the currently executing method does\nnot have access to the definition of the specified class, beacuse the class is not public\nor in an other package.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanIllegalAccessException: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            Trace.error(this.getClass(), "createParser()", "Thrown when trying to create an instance of a class using the newInstance\nmethod in class Class, but the specified class object cannot be instantiated beacuse\nit is an interface or is an abstract class.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanInstantiationException: " + instantiationException.getMessage(), instantiationException);
            throw new ConfigurationVersionException("Thrown when trying to create an instance of a class using the newInstance\nmethod in class Class, but the specified class object cannot be instantiated beacuse\nit is an interface or is an abstract class.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanInstantiationException: " + instantiationException.getMessage());
        }
        catch (ClassCastException classCastException) {
            Trace.error(this.getClass(), "createParser()", "An attempt has been made to cast an object to a subclass of which it is not an instance.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassCastException: " + classCastException.getMessage(), classCastException);
            throw new ConfigurationVersionException("An attempt has been made to cast an object to a subclass of which it is not an instance.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassCastException: " + classCastException.getMessage());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createParser()", "An Throwable detected when trying to create a new parser.\n\tParserClass: " + ParserClass + "\n\taThrowable: " + throwable.getMessage(), throwable);
            throw new ConfigurationVersionException("A Throwable detected when trying to create a new parser.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taThrowable: " + throwable.getMessage());
        }
    }
}

