/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.importer;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EventObject;
import java.util.HashSet;
import se.ericsson.cello.configurationversion.base.CV_IsDamagedException;
import se.ericsson.cello.configurationversion.base.CV_IsIncompleteException;
import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.base.FTP_ServerIsNotAccessibleException;
import se.ericsson.cello.configurationversion.base.FormatOfIP_AddressIsFaultyException;
import se.ericsson.cello.configurationversion.base.IllegalInputDataException;
import se.ericsson.cello.configurationversion.base.InsufficientDiskSpaceOnNodeException;
import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.file.base.FilePath;
import se.ericsson.cello.configurationversion.importer.CV_BackupFileNotFoundException;
import se.ericsson.cello.configurationversion.importer.CV_NameAlreadyExistsException;
import se.ericsson.cello.configurationversion.importer.ImportProperties;
import se.ericsson.cello.configurationversion.importer.ImporterException;
import se.ericsson.cello.configurationversion.importer.ImporterInterface;
import se.ericsson.cello.configurationversion.importer.MaxNoOfCVsWillBeExceededException;
import se.ericsson.cello.configurationversion.importer.event.ImportConfirmedEvent;
import se.ericsson.cello.configurationversion.importer.event.ImportRejectedEvent;
import se.ericsson.cello.configurationversion.importer.event.ImportRequestEvent;
import se.ericsson.cello.configurationversion.main.event.actionresult.ActionInformationResultErrorInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_BackupNotFoundInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_IsDamagedInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_IsIncompleteInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_NameAlreadyExistsInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.FTP_ServerIsNotAccessibleInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.IllegalValueReceivedInInputParameterInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InsufficientDiskspaceOnNodeInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionGetFromFTP_ServerInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.MaxNoOfCVsWillBeExceededInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.UnspecifiedErrorInformation;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ImportOfBackupCV_RequestedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.RetreivingBackupFromRemoteServerEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.UnpackingRetreivedBackupEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.ImportingBackupCV_Event;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.event.storedconfigurationversions.CV_AddedEvent;
import se.ericsson.cello.configurationversion.main.exception.ActionNotAllowedException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.util.CV_ActionResultCreator;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationContainer;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationCreator;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.froproxy.cv.interfaces.CV_RestoreBackupResultInformation;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallFileResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.proxyhandler.swinstall.OsaSwInstallProxyHandlerException;
import se.ericsson.cello.upgradepackage.util.proxyhandler.swinstall.OsaSwInstallProxyHandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class Importer
extends CV_SubFunctionController
implements ImporterInterface,
Runnable {
    private BlockingQueue myQueue = new BlockingQueue();
    private String Anonymous = "anonymous";

    public Importer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Importer()");
        }
    }

    public void initiateThread() {
        new Thread((Runnable)this, "Importer").start();
    }

    public void importRequest(String string, String string2, String string3, String string4) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "importRequest(String aFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword)", "aFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****");
        }
        ImportRequestEvent importRequestEvent = new ImportRequestEvent(this, string, string2, string3, string4);
        this.myQueue.enqueue((Object)importRequestEvent);
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New thread handling import of a CV has been started.");
        }
        EventObject eventObject = null;
        try {
            eventObject = (EventObject)this.myQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            if (eventObject instanceof ImportRequestEvent) {
                this.handleImportRequest((ImportRequestEvent)eventObject);
            } else {
                Trace.warning(this.getClass(), "run ()", "Unexected event received (ignored)\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
        }
        catch (ImporterException importerException) {
            Trace.info(this.getClass(), "run()", "ImporterException caught while waiting for an event or executing an received event (this should not happen).\n\ttheRequestEvent: " + eventObject + "\n\tException data: " + importerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Exception caught while waiting for an event or executing an received event.theRequestEvent: " + eventObject, throwable);
            if (eventObject instanceof ImportRequestEvent) {
                this.setActionRejectedResult(new UnspecifiedErrorInformation(), throwable.toString());
            } else {
                this.setActionRejectedResult(new UnspecifiedErrorInformation(), throwable.toString() + "\n\tReceived request event: " + eventObject);
            }
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            CV_Controller.instance().importResponse();
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "Thread handling the import of a CV is now stopped.");
        }
        Trace.flushToTraceFile();
    }

    private String addCV_BackupNameToDestinationPathForUnzipFile(String string, String string2) throws ImporterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addCV_BackupNameToDestinationPathForUnzipFile(String aDestinationPathForUnzipFileOnNode, String aFilePathAndCV_BackupZipName)", "aDestinationPathForUnzipFileOnNode: " + string + "\n\taFilePathAndCV_BackupZipName: " + string2);
        }
        try {
            int n = string2.lastIndexOf("/");
            if (n == -1) {
                n = string2.lastIndexOf("\\");
            }
            if (n == -1) {
                return string + "/" + string2;
            }
            return string + "/" + string2.substring(n + 1, string2.length());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addCV_BackupNameToDestinationPathForUnzipFile(String aDestinationPathForUnzipFileOnNode, String aFilePathAndCV_BackupZipName)", "Throwable caught.\n\taDestinationPathForUnzipFileOnNode: " + string + "\n\taFilePathAndCV_BackupZipName: " + string2, throwable);
            throw new ImporterException("Class name: " + this.getClass().getName() + "\n\taddCV_BackupNameToDestinationPathForUnzipFile(String aDestinationPathForUnzipFileOnNode, String aFilePathAndCV_BackupZipName)" + "\n\taDestinationPathForUnzipFileOnNode: " + string + "\n\taFilePathAndCV_BackupZipName: " + string2 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private HashSet collectUnzipedFilesToBeMoved(String string) throws ImporterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)", "aFilePathToUnzipedFiles: " + string);
        }
        try {
            HashSet<String> hashSet = new HashSet<String>();
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "collectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)", "theFiles[" + i + "]: " + stringArray[i]);
                    }
                    ImportProperties importProperties = null;
                    importProperties = new ImportProperties();
                    if (stringArray[i].equals("ipaddress.xml") || !stringArray[i].endsWith(importProperties.xmlSuffix) && !stringArray[i].endsWith(importProperties.xmlOriginalSuffix)) continue;
                    hashSet.add(string + "/" + stringArray[i]);
                }
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "collectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)", "RETURNS theFilesToBeMoved: " + hashSet);
                }
                return hashSet;
            }
            Trace.error(this.getClass(), "collectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)", "No files where found from the unziped CV backup archive file.\n\taFilePathToUnzipedFiles: " + string);
            throw new ImporterException("Class name: " + this.getClass().getName() + "\n\tcollectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)" + "No files where found from the unziped CV backup archive file." + "\n\taFilePathToUnzipedFiles: " + string);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)", "Throwable caught.", throwable);
            throw new ImporterException("Class name: " + this.getClass().getName() + "\n\tcollectUnzipedFilesToBeMoved(String aFilePathToUnzipedFiles)" + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void copyNonRelatedCV_FilesToCV(String string, HashSet hashSet) throws ImporterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyNonRelatedCV_FilesToCV(String aCV_Name, HashSet aFilesToBeCopied)", "aCV_Name: " + string + "\n\taFilePaths: " + hashSet);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            int n = osaCvMgmntProxyAccess.sendOsaCvCopyIntoCvReq(string, hashSet);
            if (n == 0) {
                return;
            }
            throw new ImporterException("Could not copy the files to the CV due to failure in the CV FRO with reason:" + n + "\n\tcopyNonRelatedCV_FilesToCV(String aCV_Name, HashSet aFilePaths)" + "\n\taCV_Name: " + string + "\n\taFilePaths: " + hashSet);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "copyNonRelatedCV_FilesToCV(String aCV_Name, HashSet aFilesToBeCopied)", "\n\taCV_Name: " + string + "\n\taFilesToBeCopied: " + hashSet + "\n\tFroNotAccessibleException caught.", froNotAccessibleException);
            throw new ImporterException("Class name: " + this.getClass().getName() + "\n\tcopyNonRelatedCV_FilesToCV(String aCV_Name, HashSet aFilesToBeCopied)" + "\n\taCV_Name: " + string + "\n\taFilesToBeCopied: " + hashSet + "\n\tThrowable caught." + (Object)((Object)froNotAccessibleException) + "\n\tThrowable caught." + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyNonRelatedCV_FilesToCV(String aCV_Name, HashSet aFilePaths)", "\n\taCV_Name: " + string + "\n\taFilesToBeCopied: " + hashSet + "\n\tThrowable caught.", throwable);
            throw new ImporterException("Class name: " + this.getClass().getName() + "\n\tcopyNonRelatedCV_FilesToCV(String aCV_Name, HashSet aFilesToBeCopied)" + "\n\taCV_Name: " + string + "\n\taFilesToBeCopied: " + hashSet + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void downloadCvZipArchiveFile(String string, String string2, String string3, String string4, String string5) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "downloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)", "anFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5);
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            String string6 = inetAddress.getHostAddress();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "downloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)", "theFTP_ServerIP_Address: " + string6);
            }
            OsaSwInstallProxyHandlerInterface osaSwInstallProxyHandlerInterface = ServiceFinder.getOsaSwInstallProxyHandlerInterface();
            osaSwInstallProxyHandlerInterface.verifyAndGetFTP_ServerUserID_MaxLength(string3);
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "downloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)", "Sending signal 'OsaSwInstallFileReq3'.");
            }
            InstallFileResultInformation installFileResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallFileReq3(string3, string4, string6, string, string5);
            if (installFileResultInformation.result == 1) {
                return;
            }
            if (installFileResultInformation.result == 3) {
                throw new FTP_ServerIsNotAccessibleException("Could not download the CV backup archive file from the FTP server to the node  due to FTP server is not accessible.\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5);
            }
            if (installFileResultInformation.result == 4) {
                throw new CV_BackupFileNotFoundException("Could not download the CV backup archive file from the FTP server for any reason (e.g. the FTP server is full, given path on FTP server does not exist e.t.c.)\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5);
            }
            if (installFileResultInformation.result == 5) {
                throw new FormatOfIP_AddressIsFaultyException("Could not download the CV backup archive file from the FTP server to the node due to format of given IP address is faulty.\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5);
            }
            if (installFileResultInformation.result == 99999) {
                throw new InsufficientDiskSpaceOnNodeException("Could not download the CV backup archive file from the FTP server to the node due to insufficient with disk space on node.\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5);
            }
            throw new ImporterException("Could not download the CV backup archive file from the FTP server to the node due to unknown reason.\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tThe result: " + installFileResultInformation.result + "\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FTP_ServerIsNotAccessibleException("Could not look up the given host name address to the FTP Server.\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5 + "\n\tException data: " + unknownHostException.toString());
        }
        catch (OsaSwInstallProxyHandlerException osaSwInstallProxyHandlerException) {
            throw new FTP_ServerIsNotAccessibleException("Verification of length of requested FTP server user id failed.\n\tdownloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5 + "\n\tException data: " + osaSwInstallProxyHandlerException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "downloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)", "FroNotAccessibleException caught.\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5 + "FroNotAccessibleException caught.", froNotAccessibleException);
            throw new ImporterException("Class name: " + this.getClass().getName() + "downloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)" + "\n\tFroNotAccessibleException caught." + "\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5 + "\n\tFroNotAccessibleException caught." + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "downloadCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)", "Throwable caught.\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5 + "Throwable caught.", throwable);
            throw new ImporterException("Class name: " + this.getClass().getName() + "downloadCvZipArchiveFile(String anFTP_ServerFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword, String aDestinationPathOnNode)" + "\n\tThrowable caught." + "\n\tanFTP_ServerFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\taDestinationPathOnNode: " + string5 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleImportRequest(ImportRequestEvent importRequestEvent) throws ImporterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "anImportRequestEvent: " + importRequestEvent);
        }
        AdditionalInformationCreator additionalInformationCreator = new AdditionalInformationCreator();
        String string = null;
        String string2 = null;
        ImportProperties importProperties = null;
        try {
            try {
                additionalInformationCreator.activate();
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new ImportingBackupCV_Event(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ImportOfBackupCV_RequestedEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Validates input parameters.");
                }
                this.validateInputdata(importRequestEvent);
                importProperties = new ImportProperties();
                FilePath filePath = new FilePath();
                string = filePath.createValidCV_RootFilePath(importProperties.cvCMA_FileDisk, importProperties.getCV_BackupZipDirectory());
                String string3 = this.addCV_BackupNameToDestinationPathForUnzipFile(string, importRequestEvent.getFilePathAndCV_BackupZipName());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new RetreivingBackupFromRemoteServerEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Download the ZIP backup file from FTP server to the node.");
                }
                this.downloadCvZipArchiveFile(importRequestEvent.getFilePathAndCV_BackupZipName(), importRequestEvent.getFTP_ServerIP_Address(), importRequestEvent.getFTP_ServerUserID(), importRequestEvent.getFTP_ServerPassword(), string3);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new UnpackingRetreivedBackupEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Unzip the downloaded CV backup archive file.");
                }
                string2 = filePath.createValidCV_RootFilePath(importProperties.cvCMA_FileDisk, importProperties.getCV_BackupUnzipDirectory());
                String string4 = this.unzipCvZipArchiveFile(string3, string2);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Copy the non-related CV files to the CV.");
                }
                HashSet hashSet = this.collectUnzipedFilesToBeMoved(string2);
                this.copyNonRelatedCV_FilesToCV(string4, hashSet);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Removes all files that were unzipped for the downloaded CV backup archive file.");
                }
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                additionalInformationCreator.deactivate();
                this.setActionConfirmedResult(additionalInformationCreator.getAdditionalInformations(), string4);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.StoredConfigurationVersions, new CV_AddedEvent(this, string4));
            }
            catch (FTP_ServerIsNotAccessibleException fTP_ServerIsNotAccessibleException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new FTP_ServerIsNotAccessibleInformation(), fTP_ServerIsNotAccessibleException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_23 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (CV_BackupFileNotFoundException cV_BackupFileNotFoundException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_BackupNotFoundInformation(), cV_BackupFileNotFoundException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_24 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (FormatOfIP_AddressIsFaultyException formatOfIP_AddressIsFaultyException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new IllegalValueReceivedInInputParameterInformation(), formatOfIP_AddressIsFaultyException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_25 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (IllegalInputDataException illegalInputDataException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new IllegalValueReceivedInInputParameterInformation(), illegalInputDataException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_26 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (InsufficientDiskSpaceOnNodeException insufficientDiskSpaceOnNodeException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new InsufficientDiskspaceOnNodeInformation(), insufficientDiskSpaceOnNodeException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_27 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (MaxNoOfCVsWillBeExceededException maxNoOfCVsWillBeExceededException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new MaxNoOfCVsWillBeExceededInformation(), maxNoOfCVsWillBeExceededException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_28 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (CV_NameAlreadyExistsException cV_NameAlreadyExistsException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_NameAlreadyExistsInformation(), cV_NameAlreadyExistsException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_29 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (CV_IsDamagedException cV_IsDamagedException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsDamagedInformation(), cV_IsDamagedException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_30 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (CV_IsIncompleteException cV_IsIncompleteException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsIncompleteInformation(), cV_IsIncompleteException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_31 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (ImporterException importerException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), importerException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_32 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (ConfigurationVersionException configurationVersionException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), configurationVersionException.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_33 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Throwable caugth,\n\tanImportRequestEvent: " + importRequestEvent, throwable);
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), throwable.toString());
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var11_34 = null;
                Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string2);
                if (importProperties != null) {
                    this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().importResponse();
                return;
            }
            Object var11_22 = null;
        }
        catch (Throwable throwable) {
            Object var11_35 = null;
            Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
            additionalInformationCreator.deactivate();
            additionalInformationCreator = null;
            this.deleteCreatedFiles(string);
            this.deleteCreatedFiles(string2);
            if (importProperties != null) {
                this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
            }
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            Trace.flushToTraceFile();
            CV_Controller.instance().importResponse();
            throw throwable;
        }
        Trace.log1(this.getClass(), "handleImportRequest(ImportRequestEvent anImportRequestEvent)", "Cleaning up.");
        additionalInformationCreator.deactivate();
        additionalInformationCreator = null;
        this.deleteCreatedFiles(string);
        this.deleteCreatedFiles(string2);
        if (importProperties != null) {
            this.deleteCreatedFiles(importProperties.cvCMA_FileDisk + importProperties.getCV_ImportFilesDirectory());
        }
        CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
        CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
        Trace.flushToTraceFile();
        CV_Controller.instance().importResponse();
    }

    private String unzipCvZipArchiveFile(String string, String string2) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)", "aSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            CV_RestoreBackupResultInformation cV_RestoreBackupResultInformation = osaCvMgmntProxyAccess.sendOsaRestoreBackupReq(string, string2);
            int n = cV_RestoreBackupResultInformation.result;
            if (n == 0) {
                return cV_RestoreBackupResultInformation.cvName;
            }
            if (n == 11) {
                throw new MaxNoOfCVsWillBeExceededException("Max number of CVs will be exceeded on the node.\n\tunzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
            }
            if (n == 12) {
                throw new InsufficientDiskSpaceOnNodeException("Iinsufficient with disk space on node.\n\tunzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
            }
            if (n == 5) {
                throw new CV_NameAlreadyExistsException("The CV already exists on the node.\n\tunzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
            }
            if (n == 8) {
                throw new CV_IsIncompleteException("The CV backup archive file due to the CV is incomplete.\n\tunzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
            }
            if (n == 16) {
                throw new ImporterException("The CV backup archive file due to the CV zip file was not found on the node (should not happen).\n\tunzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
            }
            throw new ImporterException("The unzip of the CV backup archive file failed due to the reason cause " + n + "." + "\n\tunzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)" + "\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "unzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)", "FroNotAccessibleException caught.\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2, froNotAccessibleException);
            throw new ImporterException("Class name: " + this.getClass().getName() + "unzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)" + "\n\tFroNotAccessibleException caught." + "\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2 + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "unzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)", "Throwable caught.\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2, throwable);
            throw new ImporterException("Class name: " + this.getClass().getName() + "unzipCvZipArchiveFile(String aSourcePathForCV_ZipArchiveFile, String aDestinationPathForCV_UnzipArchiveFiles)" + "\n\tThrowable caught." + "\n\taSourcePathForCV_ZipArchiveFile: " + string + "\n\taDestinationPathForCV_UnzipArchiveFiles: " + string2 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void setActionConfirmedResult(AdditionalInformationContainer additionalInformationContainer, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionResult(AdditionalInformationContainer anAdditionalInformationContainer, String aCV_Name)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\taCV_Name: " + string);
        }
        try {
            CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
            ImportConfirmedEvent importConfirmedEvent = new ImportConfirmedEvent(this, additionalInformationContainer.getTraceInfos(), additionalInformationContainer.getTraceWarnings(), string);
            cV_ActionResultCreator.createActionResult(importConfirmedEvent, (CV_ActionResultDataTypeOfInvokedActionValue)new InvokedActionGetFromFTP_ServerInformation());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActionResult(AdditionalInformationCreator anAdditionalInformationCreator)", "Throwable caugth when attempting to set the attribute actionResult (ignored)\n\tanAdditionalInformationContainer: " + additionalInformationContainer + "\n\taCV_Name: " + string, throwable);
        }
    }

    private void setActionRejectedResult(ActionInformationResultErrorInformation actionInformationResultErrorInformation, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation)", "\n\tanActionInformationResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string);
        }
        this.setActionRejectedResult(new AdditionalInformationContainer(), actionInformationResultErrorInformation, string, "");
    }

    private void setActionRejectedResult(AdditionalInformationContainer additionalInformationContainer, ActionInformationResultErrorInformation actionInformationResultErrorInformation, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionInformationResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string);
        }
        this.setActionRejectedResult(additionalInformationContainer, actionInformationResultErrorInformation, string, "");
    }

    private void setActionRejectedResult(AdditionalInformationContainer additionalInformationContainer, ActionInformationResultErrorInformation actionInformationResultErrorInformation, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(AdditionalInformationContainer anAdditionalInformationContainer, ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionInformationResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2);
        }
        try {
            CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
            ImportRejectedEvent importRejectedEvent = new ImportRejectedEvent(this, additionalInformationContainer.getTraceInfos(), additionalInformationContainer.getTraceWarnings(), additionalInformationContainer.getTraceErrors(), actionInformationResultErrorInformation, string, string2);
            cV_ActionResultCreator.createActionResult(importRejectedEvent, (CV_ActionResultDataTypeOfInvokedActionValue)new InvokedActionGetFromFTP_ServerInformation());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActionRejectedResult(AdditionalInformationContainer anAdditionalInformationContainer, ActionInformationResultErrorInformation anActionInformationResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name)", "Throwable caugth when attempting to set the attribute actionResult (ignored).\n\tanAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2, throwable);
        }
    }

    private void validateInputdata(ImportRequestEvent importRequestEvent) throws IllegalInputDataException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateInputdata(ImportRequestEvent anImportRequestEvent)", "anImportRequestEvent: " + importRequestEvent);
        }
        this.validateMandatoryString("pathForCvBackupOnFtpServer", importRequestEvent.getFilePathAndCV_BackupZipName());
        this.validateMandatoryString("ftpServerIpAddress", importRequestEvent.getFTP_ServerIP_Address());
        if (importRequestEvent.ftpServerUserID == null || importRequestEvent.ftpServerUserID.length() == 0) {
            importRequestEvent.ftpServerUserID = this.Anonymous;
        }
        if (importRequestEvent.ftpServerPassword == null || importRequestEvent.ftpServerPassword.length() == 0) {
            importRequestEvent.ftpServerPassword = this.Anonymous;
        }
        this.validateLengthOfString(importRequestEvent.getFilePathAndCV_BackupZipName(), this.myAllowedNumberOfCharactersInAbsoluteFilePathOnFTP_Server, "The max length of the parameter pathForCvBackupOnFtpServer is " + this.myAllowedNumberOfCharactersInAbsoluteFilePathOnFTP_Server + " characters." + "\n\tpathForCvBackupOnFtpServer: " + importRequestEvent.getFilePathAndCV_BackupZipName());
        this.validateLengthOfString(importRequestEvent.getFTP_ServerIP_Address(), 256, "The max length of the parameter ftpServerIpAddress is 256 characters.\n\tftpServerIpAddress: " + importRequestEvent.getFTP_ServerIP_Address());
    }
}

