/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.control.CV_ControllerClientInterface;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.DetailedActivityEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainActivityEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.FunctionBusyException;
import se.ericsson.cello.configurationversion.main.interfaces.CV_ActionProgressInterface;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandlerException;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class CV_ActionHandler
implements PropertyChangeListener,
CV_ControllerClientInterface {
    protected CV_ActionProgressInterface myCV_ActionProgressInterface = null;
    protected int myTransactionTimeoutValue = 180;
    private boolean myDetailedActivityIdleReceived = false;
    private boolean myIsFunctionBusyMarkedByThisAction = false;
    private boolean myMainActivityIdleReceived = false;

    public String toString() {
        return "\n\tTransactionTimeoutValue: " + this.myTransactionTimeoutValue + "\n\tDetailedActivityIdleReceived: " + this.myDetailedActivityIdleReceived + "\n\tIsFunctionBusyMarkedByThisAction: " + this.myIsFunctionBusyMarkedByThisAction + "\n\tMainActivityIdleReceived: " + this.myMainActivityIdleReceived;
    }

    protected CV_ActionHandler(CV_ActionProgressInterface cV_ActionProgressInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_ActionHandler(CV_ActionProgressInterface aCV_ActionProgressInterface)", "aCV_ActionProgressInterface: " + cV_ActionProgressInterface);
        }
        this.myCV_ActionProgressInterface = cV_ActionProgressInterface;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent evt)", "evt: " + propertyChangeEvent);
        }
        if (propertyChangeEvent.getNewValue() instanceof DetailedActivityEvent) {
            if (propertyChangeEvent.getNewValue() instanceof IdleEvent) {
                this.myDetailedActivityIdleReceived = true;
            }
            this.setCurrentDetailedActivity((DetailedActivityEvent)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getNewValue() instanceof MainActivityEvent) {
            if (propertyChangeEvent.getNewValue() instanceof MainIdleEvent) {
                this.myMainActivityIdleReceived = true;
            }
            this.setCurrentMainActivity((MainActivityEvent)propertyChangeEvent.getNewValue());
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unknown type of property change value received (ignored).evt: " + propertyChangeEvent);
        }
    }

    protected void addAsListener() throws CV_ProgressInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener( )");
        }
        CV_ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingConfigurationVersionPropertyName.DetailedActivity, this);
        CV_ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingConfigurationVersionPropertyName.MainActivity, this);
    }

    protected void busyMark(ServiceSubType serviceSubType) throws FunctionBusyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark(ServiceSubType aServiceSubType)", "aServiceSubType: " + serviceSubType);
        }
        CV_Controller.instance().busyMark(this, serviceSubType);
        this.myIsFunctionBusyMarkedByThisAction = true;
    }

    protected void busyMarkClientOnly() throws FunctionBusyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMarkClientOnly( )");
        }
        CV_Controller.instance().busyMarkClientOnly(this);
        this.myIsFunctionBusyMarkedByThisAction = true;
    }

    protected void finished(ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "finished(ServiceSubType aServiceSubType))", "aServiceSubType: " + serviceSubType);
        }
        this.finished(serviceSubType, false);
    }

    protected void finished(ServiceSubType serviceSubType, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "finished(ServiceSubType aServiceSubType, boolean anIsOnlyClientToBeFreemarked))", "aServiceSubType: " + serviceSubType + "\n\tanIsOnlyClientToBeFreemarked: " + bl);
        }
        this.removeAsListener();
        if (!this.myDetailedActivityIdleReceived && Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "finished( )", "Attribute 'currentDetailedActivity' has not been set to 'IDLE' due to no property change received with this value.");
        }
        if (!this.myMainActivityIdleReceived && Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "finished( )", "Attribute 'currentMainActivity' has not been set to 'IDLE' due to no property change received with this value.");
        }
        this.freeMarkIfNeeded(serviceSubType, bl);
    }

    protected void handleThrowable(ServiceSubType serviceSubType, Throwable throwable, Class clazz, String string, String string2) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleThrowable(ServiceSubType aServiceSubType, Throwable aThrowable, Class aClass, String aMethod, String anAdditionalInfo)", "aServiceSubType: " + serviceSubType + "\n\taThrowable: " + throwable + "\n\taClass: " + clazz + "\n\taMethod: " + string + "\n\tanAdditionalInfo: " + string2);
        }
        this.handleThrowable(serviceSubType, throwable, clazz, string, string2, false);
    }

    protected void handleThrowable(ServiceSubType serviceSubType, Throwable throwable, Class clazz, String string, String string2, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleThrowable(ServiceSubType aServiceSubType, Throwable aThrowable, Class aClass, String aMethod, String anAdditionalInfo, boolean anIsOnlyClientToBeFreemarked)", "aServiceSubType: " + serviceSubType + "\n\taThrowable: " + throwable + "\n\taClass: " + clazz + "\n\taMethod: " + string + "\n\tanAdditionalInfo: " + string2 + "\n\tanIsOnlyClientToBeFreemarked: " + bl);
        }
        if (throwable instanceof FunctionBusyException) {
            throw (FunctionBusyException)((Object)throwable);
        }
        this.removeAsListener();
        this.freeMarkIfNeeded(serviceSubType, bl);
        if (throwable instanceof ConfigurationVersionException) {
            throw (ConfigurationVersionException)((Object)throwable);
        }
        Trace.error(clazz, string, string2, throwable);
        throw new ConfigurationVersionException("Excecution of an action failed,\n\tMethod: " + string + "\n\tReason: " + throwable.toString());
    }

    protected void freeMarkIfNeeded(ServiceSubType serviceSubType, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMarkIfNeeded(ServiceSubType aServiceSubType, boolean anIsOnlyClientToBeFreemarked)", "aServiceSubType: " + serviceSubType + "\n\tanIsOnlyClientToBeFreemarked: " + bl);
        }
        if (this.myIsFunctionBusyMarkedByThisAction) {
            if (bl) {
                CV_Controller.instance().freeMarkClientOnly(this);
            } else {
                CV_Controller.instance().freeMark(this, serviceSubType);
            }
            this.myIsFunctionBusyMarkedByThisAction = false;
        }
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener( )");
        }
        CV_ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingConfigurationVersionPropertyName.DetailedActivity, this);
        CV_ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingConfigurationVersionPropertyName.MainActivity, this);
    }

    protected void setCurrentDetailedActivity(DetailedActivityEvent detailedActivityEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentDetailedActivity(DetailedActivityEvent aDetailedActivityEvent)", "aDetailedActivityEvent: " + detailedActivityEvent);
        }
        Control control = null;
        try {
            control = Transaction.create(this.myTransactionTimeoutValue);
            this.myCV_ActionProgressInterface.setCurrentDetailedActivityValue(detailedActivityEvent, Transaction.getCoordinator(control));
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setCurrentDetailedActivity(DetailedActivityEvent aDetailedActivityEvent)", "Throwable caught when trying to set attribute 'currentDetailedActivity',\n\taDetailedActivityEvent: " + detailedActivityEvent, throwable);
            Transaction.rollback(control);
        }
    }

    protected void setCurrentMainActivity(MainActivityEvent mainActivityEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentMainActivity(MainActivityEvent aMainActivityEvent)", "aMainActivityEvent: " + mainActivityEvent);
        }
        Control control = null;
        try {
            control = Transaction.create(this.myTransactionTimeoutValue);
            this.myCV_ActionProgressInterface.setCurrentMainActivityValue(mainActivityEvent, Transaction.getCoordinator(control));
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setCurrentMainActivity(MainActivityEvent aMainActivityEvent)", "Throwable caught when trying to set attribute 'currentMainActivity',\n\taMainActivityEvent: " + mainActivityEvent, throwable);
            Transaction.rollback(control);
        }
    }
}

