/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.configurationversion.util.handler.SoftwareInformationHandlerException;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.SSW_UpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.FanMoSU_Access;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.WebServerMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.swmanagement.suaccess.ActiveOtherLMsMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SlotDataContainer;
import se.ericsson.cello.upgradepackage.util.datacontainer.SwAllocationDataContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.NotAbleToReadJVM_RPU_DataException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class SoftwareInformationHandler {
    public static final String SSW_UPGRADEABLE_PLUG_IN_UNIT = "SSW_UpgradeablePlugInUnit";

    public Collection getSwAllocationDataContainers() throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationDataContainers()");
        }
        Collection<SwAllocationDataContainer> collection = new Vector();
        SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
        try {
            SwAllocationMoSU_Access[] swAllocationMoSU_AccessArray = swAllocationMO_HandlerInterface.getAllSwAllocationMos();
            SwAllocationMoSU_Access swAllocationMoSU_Access = null;
            for (int i = 0; i < swAllocationMoSU_AccessArray.length; ++i) {
                swAllocationMoSU_Access = swAllocationMoSU_AccessArray[i];
                collection.add(this.getSwAllocationDataContainer(swAllocationMoSU_Access));
            }
            collection = this.updateSlotDataContainersForSSW_UpgradeablePlugInUnits(collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSwAllocationDataContainers()", "Throwable caught when getting all SwAllocation MOs.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getSwAllocationDataContainers()" + " Throwable caught when getting all SwAllocation MOs." + " Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSwAllocationDataContainers()", "Returning - theSwAllocationDataContainers: " + collection);
        }
        return collection;
    }

    public Collection getWebServerSlotDataContainers() throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getWebServerSlotDataContainers()");
        }
        return this.getCoreMPsSlotDataContainers("WebServer");
    }

    public Collection getJvmSlotDataContainers() throws SoftwareInformationHandlerException {
        Vector<SlotDataContainer> vector = new Vector<SlotDataContainer>();
        JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
        try {
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = jvmMO_HandlerInterface.getReliableProgramUniter(null);
            SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmActiveSlot(null);
            vector.add(new SlotDataContainer("Jvm", slotMoSU_Access.getLocalDistinguishedName(), this.getSmn((ManagedObject)slotMoSU_Access), this.getApn((ManagedObject)slotMoSU_Access), this.getOperProductNumberAndRevision((ManagedObject)slotMoSU_Access), this.getContainsTrustedPIU((ManagedObject)slotMoSU_Access)));
            slotMoSU_Access = (SlotMoSU_Access)reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
            if (slotMoSU_Access != null) {
                vector.add(new SlotDataContainer("Jvm", slotMoSU_Access.getLocalDistinguishedName(), this.getSmn((ManagedObject)slotMoSU_Access), this.getApn((ManagedObject)slotMoSU_Access), this.getOperProductNumberAndRevision((ManagedObject)slotMoSU_Access), this.getContainsTrustedPIU((ManagedObject)slotMoSU_Access)));
            }
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getJvmSlotDataContainers()" + " NotAbleToReadJVM_RPU_DataException caught when getting information about the JVM MO." + " NotAbleToReadJVM_RPU_DataException info: " + (Object)((Object)notAbleToReadJVM_RPU_DataException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJvmSlotDataContainers()", "Throwable caught when getting information about the JVM MO.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getJvmSlotDataContainers()" + " Throwable caught when getting information about the JVM MO." + " Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getJvmSlotDataContainers()", "Returning - theJvmSlotDataContainers: " + vector);
        }
        return vector;
    }

    public Collection getActiveOtherLMsSlotDataContainers() throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getActiveOtherLMsSlotDataContainers()");
        }
        return this.getCoreMPsSlotDataContainers("ActiveOtherLMs");
    }

    private SwAllocationDataContainer getSwAllocationDataContainer(SwAllocationMoSU_Access swAllocationMoSU_Access) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationDataContainer(SwAllocationMoSU_Access aSwAllocationMo)", "aSwAllocationMo: " + swAllocationMoSU_Access);
        }
        SwAllocationDataContainer swAllocationDataContainer = new SwAllocationDataContainer(swAllocationMoSU_Access.getLocalDistinguishedName(), this.getSlotDataContainers(swAllocationMoSU_Access), this.getRepertoireNames(swAllocationMoSU_Access));
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSwAllocationDataContainer()", "Returning - theSwAllocationDataContainer: " + swAllocationDataContainer);
        }
        return swAllocationDataContainer;
    }

    private Collection getSlotDataContainers(SwAllocationMoSU_Access swAllocationMoSU_Access) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotDataContainers(SwAllocationMoSU_Access aSwAllocationMo)", "aSwAllocationMo: " + swAllocationMoSU_Access);
        }
        Vector<SlotDataContainer> vector = new Vector<SlotDataContainer>();
        try {
            ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getSlotList(null);
            ManagedObject managedObject = null;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                managedObject = managedObjectArray[i];
                String string = this.getSwAllocationSlotType(managedObject);
                vector.add(new SlotDataContainer(string, managedObject.getLocalDistinguishedName(), this.getSmn(managedObject), this.getApn(managedObject), this.getOperProductNumberAndRevision(managedObject), this.getPiuTypeProductNumberAndRevision(managedObject, string), this.getContainsTrustedPIU(managedObject)));
            }
        }
        catch (SoftwareInformationHandlerException softwareInformationHandlerException) {
            throw softwareInformationHandlerException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getSlotDataContainers(SwAllocationMoSU_Access aSwAllocationMo)", "MoAccessException caught when collecting data from SwAllocation MO.\n\taSwAllocationMo Ldn: " + swAllocationMoSU_Access.getLocalDistinguishedName(), moAccessException);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getSlotDataContainers(SwAllocationMoSU_Access aSwAllocationMo)" + " MoAccessException caught when collecting data from SwAllocation MO." + " aSwAllocationMo Ldn: " + swAllocationMoSU_Access.getLocalDistinguishedName() + " Exception info: " + (Object)((Object)moAccessException));
        }
        return vector;
    }

    private String getSwAllocationSlotType(ManagedObject managedObject) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationSlotType(ManagedObject aManagedObject)", "aManagedObject ldn: " + managedObject.getLocalDistinguishedName());
        }
        String string = null;
        string = managedObject instanceof JvmMoSU_Access ? "Jvm" : (managedObject instanceof WebServerMoSU_Access ? "WebServer" : (managedObject instanceof ActiveOtherLMsMoSU_Access ? "ActiveOtherLMs" : (managedObject instanceof FanMoSU_Access ? "Fan" : (managedObject instanceof SlotMoSU_Access ? "PlugInUnit" : "APPLICATION_SLOT"))));
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSwAllocationSlotType(ManagedObject aManagedObject)", "Returning - theType: " + string);
        }
        return string;
    }

    private Integer getSmn(ManagedObject managedObject) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSmn(ManagedObject aManagedObject)", "aManagedObject ldn: " + managedObject.getLocalDistinguishedName());
        }
        Integer n = null;
        try {
            if (managedObject instanceof SlotMoSU_Access) {
                SubrackMO_HandlerInterface subrackMO_HandlerInterface = ServiceFinder.getSubrackMO_HandlerInterface();
                int n2 = subrackMO_HandlerInterface.getSMN((SlotMoSU_Access)managedObject);
                n = new Integer(n2);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSmn(ManagedObject aManagedObject)", "Throwable caught when trying to get smn information.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getSmn(ManagedObject aManagedObject)" + " Throwable caught when trying to get smn information." + " Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSmn(ManagedObject aManagedObject)", "Returning - theSmn: " + n);
        }
        return n;
    }

    private Integer getApn(ManagedObject managedObject) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getApn(ManagedObject aManagedObject)", "aManagedObject ldn: " + managedObject.getLocalDistinguishedName());
        }
        Integer n = null;
        try {
            if (managedObject instanceof SlotMoSU_Access) {
                int n2 = ((SlotMoSU_Access)managedObject).getAsciPortNumber(null);
                n = new Integer(n2);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getApn(ManagedObject aManagedObject)", "Throwable caught when trying to get apn information.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getApn(ManagedObject aManagedObject)" + " Throwable caught when trying to get apn information." + " Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getApn(ManagedObject aManagedObject)", "Returning - theApn: " + n);
        }
        return n;
    }

    private ProductNumberAndRevision getOperProductNumberAndRevision(ManagedObject managedObject) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOperProductNumberAndRevision(ManagedObject aManagedObject)", "aManagedObject ldn: " + managedObject.getLocalDistinguishedName());
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        try {
            if (managedObject instanceof SlotMoSU_Access) {
                SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                String string = slotMO_HandlerInterface.getSlotProductNumber((SlotMoSU_Access)managedObject);
                String string2 = slotMO_HandlerInterface.getSlotRState((SlotMoSU_Access)managedObject);
                productNumberAndRevision = new ProductNumberAndRevision(string, string2);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOperProductNumberAndRevision(ManagedObject aManagedObject)", "Throwable caught when trying to get operational product number and revision information.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getOperProductNumberAndRevision(ManagedObject aManagedObject)" + " Throwable caught when trying to get operational product number and revision information.." + " Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getOperProductNumberAndRevision(ManagedObject aManagedObject)", "Returning - theOperProductNumberAndRevision: " + productNumberAndRevision);
        }
        return productNumberAndRevision;
    }

    private ProductNumberAndRevision getPiuTypeProductNumberAndRevision(ManagedObject managedObject, String string) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeProductNumberAndRevision(ManagedObject aSwAllocationSlot, String aSwAllocationSlotType)", "aSwAllocationSlot ldn: " + managedObject.getLocalDistinguishedName() + "\n\taSwAllocationSlotType: " + string);
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        try {
            if (string.equals("PlugInUnit")) {
                UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
                Iterator iterator = upgradeablePIU_HandlerInterface.getAllConfiguredUpgradeablePIUs().iterator();
                while (iterator.hasNext()) {
                    genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                    if (!genericUpgradeablePlugInUnit.getParent().getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
                    PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                    productNumberAndRevision = ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3") ? new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null)) : new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
                    break;
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getPiuTypeProductNumberAndRevision(ManagedObject aSwAllocationSlot, String aSwAllocationSlotType)", "RETURNS - thePiuTypeProductNumberAndRevision: " + productNumberAndRevision);
            }
            return productNumberAndRevision;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPiuTypeProductNumberAndRevision(ManagedObject aSwAllocationSlot)", "Throwable caught when trying to get operational product number and revision information.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getPiuTypeProductNumberAndRevision(ManagedObject aSwAllocationSlot)" + " Throwable caught when trying to get PiuType product number and revision information." + " Throwable info: " + throwable);
        }
    }

    private Collection getRepertoireNames(SwAllocationMoSU_Access swAllocationMoSU_Access) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireNames(SwAllocationMoSU_Access aSwAllocationMo)", "aSwAllocationMo ldn: " + swAllocationMoSU_Access.getLocalDistinguishedName());
        }
        Vector<String> vector = new Vector<String>();
        try {
            ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(null);
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)managedObjectArray[i];
                vector.add(repertoireMoSU_Access.getName(null));
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getRepertoireNames(SwAllocationMoSU_Access aSwAllocationMo)", "MoAccessException caught when collecting data from SwAllocation MO.\n\taSwAllocationMo Ldn: " + swAllocationMoSU_Access.getLocalDistinguishedName(), moAccessException);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getRepertoireNames(SwAllocationMoSU_Access aSwAllocationMo)" + " MoAccessException caught when collecting data from SwAllocation MO." + " Software Ldn: " + swAllocationMoSU_Access.getLocalDistinguishedName() + " Exception info: " + (Object)((Object)moAccessException));
        }
        return vector;
    }

    private Collection getCoreMPsSlotDataContainers(String string) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCoreMPsSlotDataContainers(String aSlotType)", "aSlotType: " + string);
        }
        Vector<SlotDataContainer> vector = new Vector<SlotDataContainer>();
        ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
        try {
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
            for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)plugInUnitMoSU_AccessArray[i].getParent();
                vector.add(new SlotDataContainer(string, slotMoSU_Access.getLocalDistinguishedName(), this.getSmn((ManagedObject)slotMoSU_Access), this.getApn((ManagedObject)slotMoSU_Access), this.getOperProductNumberAndRevision((ManagedObject)slotMoSU_Access), this.getPiuTypeProductNumberAndRevision((ManagedObject)slotMoSU_Access, string), this.getContainsTrustedPIU((ManagedObject)slotMoSU_Access)));
            }
        }
        catch (SoftwareInformationHandlerException softwareInformationHandlerException) {
            throw softwareInformationHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCoreMPsSlotDataContainers(String aSlotType)", "aSlotType: " + string + "\n\tThrowable caught when getting information about the Core MPs.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + " Method: getCoreMPsSlotDataContainers(String aSlotType)" + " Throwable caught when getting information about the Core MPs." + " Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getCoreMPsSlotDataContainers(String aSlotType)", "Returning - theCoreMPsSlotDataContainers: " + vector);
        }
        return vector;
    }

    private boolean getContainsTrustedPIU(ManagedObject managedObject) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getContainsTrustedPIU(ManagedObject aSwAllocationSlot)", "aSwAllocationSlot ldn: " + managedObject.getLocalDistinguishedName());
        }
        boolean bl = false;
        if (managedObject instanceof SlotMoSU_Access) {
            try {
                MoIterator moIterator = managedObject.getChildren();
                if (moIterator != null && moIterator.hasMoreElements()) {
                    PlugInUnitMoSU_Access plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)moIterator.nextElement();
                    if (SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)plugInUnitMoSU_Access) && plugInUnitMoSU_Access.getSignatureValidationService(null) == 1) {
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "getContainsTrustedPIU(ManagedObject aSwAllocationSlot) ", "Exception caught when checking if PIU supports validation service. Assuming that it does.", throwable);
                bl = true;
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getContainsTrustedPIU(ManagedObject aSwAllocationSlot)", "Returning - theContainsTrustedPIU: " + bl);
        }
        return bl;
    }

    private Collection updateSlotDataContainersForSSW_UpgradeablePlugInUnits(Collection collection) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateSlotDataContainersForSSW_UpgradeablePlugInUnits(Collection anSwAllocationDataContainers)", "anSwAllocationDataContainers: " + collection);
        }
        try {
            Collection collection2 = this.getSSW_UpgradeablePlugInUnits();
            if (!collection2.isEmpty()) {
                Iterator iterator = collection.iterator();
                SwAllocationDataContainer swAllocationDataContainer = null;
                Collection collection3 = null;
                Collection collection4 = null;
                while (iterator.hasNext()) {
                    swAllocationDataContainer = (SwAllocationDataContainer)iterator.next();
                    collection3 = swAllocationDataContainer.getSlotDataContainers();
                    if (collection3 == null || collection3.isEmpty()) continue;
                    collection4 = this.updateSlotDataContainersForSSW_UpgradeablePlugInUnits(collection3, collection2);
                    swAllocationDataContainer.setSlotDataContainers(collection4);
                }
            }
            return collection;
        }
        catch (SoftwareInformationHandlerException softwareInformationHandlerException) {
            throw softwareInformationHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSSW_UpgradeablePlugInUnits( )", "Throwable caught when trying to get all SSW_UpgradeablePlugInUnits.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + "Method: getSSW_UpgradeablePlugInUnits( )" + "Throwable caught when trying to get all SSW_UpgradeablePlugInUnits." + "Throwable info: " + throwable);
        }
    }

    private Collection getSSW_UpgradeablePlugInUnits() throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSSW_UpgradeablePlugInUnits( )");
        }
        HashSet<GenericUpgradeablePlugInUnit> hashSet = new HashSet<GenericUpgradeablePlugInUnit>();
        try {
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
            Iterator iterator = upgradeablePIU_HandlerInterface.getAllConfiguredUpgradeablePIUs().iterator();
            while (iterator.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                if (!this.isInstanceOfSSW_UpgradeablePlugInUnit(genericUpgradeablePlugInUnit)) continue;
                hashSet.add(genericUpgradeablePlugInUnit);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSSW_UpgradeablePlugInUnits( )", "Throwable caught when trying to get all SSW_UpgradeablePlugInUnits.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + "Method: getSSW_UpgradeablePlugInUnits( )" + "Throwable caught when trying to get all SSW_UpgradeablePlugInUnits." + "Throwable info: " + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getSSW_UpgradeablePlugInUnits( )", "Returning - theSSW_UpgradeablePlugInUnits: " + hashSet);
        }
        return hashSet;
    }

    private Collection updateSlotDataContainersForSSW_UpgradeablePlugInUnits(Collection collection, Collection collection2) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateSlotDataContainersForSSW_UpgradeablePlugInUnits(Collection aSlotDataContainers, Collection anSSW_UpgradeablePlugInUnits)", "aSlotDataContainers: " + collection + "\n\tanSSW_UpgradeablePlugInUnits: " + collection2);
        }
        try {
            Vector<SlotDataContainer> vector = new Vector<SlotDataContainer>();
            Iterator iterator = collection.iterator();
            SlotDataContainer slotDataContainer = null;
            Collection collection3 = null;
            while (iterator.hasNext()) {
                slotDataContainer = (SlotDataContainer)iterator.next();
                if (slotDataContainer.getType().equals("APPLICATION_SLOT")) {
                    collection3 = this.convertSlotDataContainerForSSW_UpgradeablePlugInUnits(slotDataContainer, collection2);
                    vector.addAll(collection3);
                    continue;
                }
                vector.add(slotDataContainer);
            }
            return vector;
        }
        catch (SoftwareInformationHandlerException softwareInformationHandlerException) {
            throw softwareInformationHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateSlotDataContainersForSSW_UpgradeablePlugInUnits(Collection aSlotDataContainers, Collection anSSW_UpgradeablePlugInUnits)", "Throwable caught.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + "Method: updateSlotDataContainersForSSW_UpgradeablePlugInUnits(Collection aSlotDataContainers, Collection anSSW_UpgradeablePlugInUnits)" + "Throwable caught." + "Throwable info: " + throwable);
        }
    }

    private Collection convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer slotDataContainer, Collection collection) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, Collection anSSW_UpgradeablePlugInUnits)", "aSlotDataContainer: " + slotDataContainer + "\n\tanSSW_UpgradeablePlugInUnits: " + collection);
        }
        try {
            Collection<SlotDataContainer> collection2 = null;
            String string = slotDataContainer.getLdn();
            Iterator iterator = collection.iterator();
            SSW_UpgradeablePlugInUnit sSW_UpgradeablePlugInUnit = null;
            while (iterator.hasNext()) {
                sSW_UpgradeablePlugInUnit = (SSW_UpgradeablePlugInUnit)iterator.next();
                if (!sSW_UpgradeablePlugInUnit.getLocalDistinguishedName().startsWith(string)) continue;
                collection2 = this.convertSlotDataContainerForSSW_UpgradeablePlugInUnits(slotDataContainer, sSW_UpgradeablePlugInUnit);
                break;
            }
            if (collection2 == null) {
                collection2 = new HashSet<SlotDataContainer>();
                collection2.add(slotDataContainer);
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, Collection anSSW_UpgradeablePlugInUnits)", "Returning - [aSlotDataContainer]: " + collection2);
                }
            } else if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, Collection anSSW_UpgradeablePlugInUnits)", "Returning - theCreatedSlotDataContainers: " + collection2);
            }
            return collection2;
        }
        catch (SoftwareInformationHandlerException softwareInformationHandlerException) {
            throw softwareInformationHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, Collection anSSW_UpgradeablePlugInUnits)", "Throwable caught.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + "Method: convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, Collection anSSW_UpgradeablePlugInUnits)" + "Throwable caught." + "Throwable info: " + throwable);
        }
    }

    private Collection convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer slotDataContainer, SSW_UpgradeablePlugInUnit sSW_UpgradeablePlugInUnit) throws SoftwareInformationHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, Collection anSSW_UpgradeablePlugInUnits, Collection aCoreMPsSlotDataContainers)", "aSlotDataContainer: " + slotDataContainer + "\n\tanSSW_UpgradeablePlugInUnit: " + sSW_UpgradeablePlugInUnit);
        }
        try {
            HashSet<SlotDataContainer> hashSet = new HashSet<SlotDataContainer>();
            Collection collection = this.getCoreMPsSlotDataContainers(SSW_UPGRADEABLE_PLUG_IN_UNIT);
            Iterator iterator = collection.iterator();
            SlotDataContainer slotDataContainer2 = null;
            SlotDataContainer slotDataContainer3 = null;
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)sSW_UpgradeablePlugInUnit.getPiuType(null);
            ProductNumberAndRevision productNumberAndRevision = null;
            productNumberAndRevision = ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3") ? new ProductNumberAndRevision(piuTypeMoSU_Access.getProductNumberOpt(null), piuTypeMoSU_Access.getProductRevisionOpt(null)) : new ProductNumberAndRevision(StringHandler.optimize(piuTypeMoSU_Access.getProductNumber(null)), StringHandler.optimize(piuTypeMoSU_Access.getProductRevision(null)));
            boolean bl = false;
            if (sSW_UpgradeablePlugInUnit.getSignatureValidationService(null) == 1) {
                bl = true;
            }
            while (iterator.hasNext()) {
                slotDataContainer2 = (SlotDataContainer)iterator.next();
                slotDataContainer3 = new SlotDataContainer(SSW_UPGRADEABLE_PLUG_IN_UNIT, slotDataContainer.getLdn(), slotDataContainer2.getSmn(), slotDataContainer2.getApn(), null, productNumberAndRevision, bl);
                hashSet.add(slotDataContainer3);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, SSW_UpgradeablePlugInUnit anSSW_UpgradeablePlugInUnit)", "Throwable caught.", throwable);
            throw new SoftwareInformationHandlerException("Class name: " + this.getClass().getName() + "Method: convertSlotDataContainerForSSW_UpgradeablePlugInUnits(SlotDataContainer aSlotDataContainer, SSW_UpgradeablePlugInUnit anSSW_UpgradeablePlugInUnit)" + "Throwable caught." + "Throwable info: " + throwable);
        }
    }

    private boolean isInstanceOfSSW_UpgradeablePlugInUnit(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isInstanceOfSSW_UpgradeablePlugInUnit(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        try {
            return genericUpgradeablePlugInUnit instanceof SSW_UpgradeablePlugInUnit;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

