/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.validator;

import se.ericsson.cello.configurationversion.util.enumer.CV_InputParameterType;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.su.util.operatingsystem.OperatingSystemHandler;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_ParameterValidator {
    public static final int CV_MAX_LENGTH = 40;

    public CV_ParameterValidator() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_ParameterValidator()");
        }
    }

    public void validateString(String string, CV_InputParameterType cV_InputParameterType) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateString(String aParameterValue, CV_InputParameterType aParameterName)", "aParameterValue: " + string + "\n\taParameterName: " + cV_InputParameterType);
        }
        this.validateLength(string, cV_InputParameterType);
        if (cV_InputParameterType.getValue().equals(CV_InputParameterType.Comment.getValue())) {
            this.validateCommentOrOperatorName(string, cV_InputParameterType);
        } else if (cV_InputParameterType.getValue().equals(CV_InputParameterType.CV_Name.getValue())) {
            this.validateName(string, cV_InputParameterType);
        } else if (cV_InputParameterType.getValue().equals(CV_InputParameterType.Identity.getValue())) {
            this.validateIdentity(string, cV_InputParameterType);
        } else if (cV_InputParameterType.getValue().equals(CV_InputParameterType.OperatorName.getValue())) {
            this.validateCommentOrOperatorName(string, cV_InputParameterType);
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "validateString(String aParameterValue, CV_InputParameterType aParameterName)", "No validation os performed due to unknown parameter type.\n\taParameterValue: " + string + "\n\taParameterName: " + cV_InputParameterType.getValue());
        }
    }

    private void validateCommentOrOperatorName(String string, CV_InputParameterType cV_InputParameterType) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateCommentOrOperatorName(String aParameterValue, CV_InputParameterType aParameterName)", "aParameterValue: " + string + "\n\taParameterName: " + cV_InputParameterType);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '!' || c == '_' || c == ' ' || c == '&' || c == ':' || c == '%' || c == '.') continue;
            throw new ValueOutOfRangeException(cV_InputParameterType.getValue(), "ConfigurationVersion");
        }
    }

    private void validateLength(String string, CV_InputParameterType cV_InputParameterType) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateLength(String aParameterValue, CV_InputParameterType aParameterName)", "aParameterValue: " + string + "\n\taParameterName: " + cV_InputParameterType);
        }
        if (string.length() > 40) {
            throw new ValueOutOfRangeException(cV_InputParameterType.getValue(), "ConfigurationVersion");
        }
    }

    private void validateIdentity(String string, CV_InputParameterType cV_InputParameterType) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateIdentity(String aParameterValue, CV_InputParameterType aParameterName)", "aParameterValue: " + string + "\n\taParameterName: " + cV_InputParameterType);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '!' || c == '_' || c == '&' || c == ':' || c == '%' || c == '.') continue;
            throw new ValueOutOfRangeException(cV_InputParameterType.getValue(), "ConfigurationVersion");
        }
    }

    private void validateName(String string, CV_InputParameterType cV_InputParameterType) throws ValueOutOfRangeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateName(String aParameterValue, CV_InputParameterType aParameterName)", "aParameterValue: " + string + "\n\taParameterName: " + cV_InputParameterType);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c == ':' || c == '%' || c == '.') continue;
            throw new ValueOutOfRangeException(cV_InputParameterType.getValue(), "ConfigurationVersion");
        }
        if (string.equals("workingdb") && OperatingSystemHandler.getOperatingSystem() == 0) {
            throw new ValueOutOfRangeException(cV_InputParameterType.getValue(), "ConfigurationVersion", "Creation of CV workingdb is not allowed.");
        }
    }
}

