/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.verify.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import se.ericsson.cello.configurationversion.verify.backuprestoreinfo.BackupRestore_CompatibilityInformation;
import se.ericsson.cello.configurationversion.verify.backuprestoreinfo.BackupRestore_CompatibleInformation;
import se.ericsson.cello.configurationversion.verify.backuprestoreinfo.BackupRestore_DiffInformation;
import se.ericsson.cello.configurationversion.verify.backuprestoreinfo.BackupRestore_NotCompatibleInformation;
import se.ericsson.cello.configurationversion.verify.backuprestoreinfo.BackupRestore_PartlyCompatibleInformation;
import se.ericsson.cello.configurationversion.verify.base.ComparedInformationInterface;
import se.ericsson.cello.configurationversion.verify.base.DiffInformationInterface;
import se.ericsson.cello.configurationversion.verify.base.MasterInformationInterface;
import se.ericsson.cello.configurationversion.verify.coremp.CoreMP_CompatibilityInformation;
import se.ericsson.cello.configurationversion.verify.coremp.CoreMP_CompatibleInformation;
import se.ericsson.cello.configurationversion.verify.coremp.CoreMP_NotCompatibleInformation;
import se.ericsson.cello.configurationversion.verify.coremp.CoreMP_PartlyCompatibleInformation;
import se.ericsson.cello.configurationversion.verify.html.TableHeaderContainer;
import se.ericsson.cello.configurationversion.verify.html.VerifyResultInfoInterface;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.ComparedSlotInformation;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.HW_ConfigurationDiffInformation;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.MasterSlotInformation;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.SubrackInformation;
import se.ericsson.cello.configurationversion.verify.hwsw.PIU_PositionAndProductData;
import se.ericsson.cello.configurationversion.verify.ip.IP_InfoDiffInformation;
import se.ericsson.cello.configurationversion.verify.nodeapplconf.NodeApplConfDiffInformation;
import se.ericsson.cello.configurationversion.verify.nodeid.NodeID_DiffInformation;
import se.ericsson.cello.configurationversion.verify.subrackinfo.SubrackInfo_CompatibilityInformation;
import se.ericsson.cello.configurationversion.verify.subrackinfo.SubrackInfo_CompatibleInformation;
import se.ericsson.cello.configurationversion.verify.subrackinfo.SubrackInfo_DiffInformation;
import se.ericsson.cello.configurationversion.verify.subrackinfo.SubrackInfo_NotCompatibleInformation;
import se.ericsson.cello.configurationversion.verify.subrackinfo.SubrackInfo_NotCompatibleIntegratedHWInformation;
import se.ericsson.cello.configurationversion.verify.swintegrity.LM_Data;
import se.ericsson.cello.configurationversion.verify.swintegrity.UP_LM_Relation;
import se.ericsson.cello.configurationversion.verify.ucf.UCF_ChecksumInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfErrorIndInformation;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.verify.ssw.SSW_ValidationInformation;

public class HtmlGenerator {
    VerifyResultInfoInterface verInfo = null;
    private String title = "Verification Result";
    private String nodeIdentification = "Node Identification";
    private String missingUp = "Missing Upgrade Packages";
    private String corruptedUp = "Corrupted Upgrade Packages";
    private String corruptedUCF = "Corrupted UCFs";
    private String hwConfig = "HW Configuration";
    private String nodeApplConf = "Node Application Configuration Data";
    private String backupRestore = "BackupRestore information";
    private String subrack = "Subrack information";
    private String ipDiff = "IP Information";
    private String coreMp = "Core MP";
    private String sswInfo = "Signed software information";
    private String errorColour = "#FF0000";
    private String warningColour = "#FFCC66";
    private String NONE = "None";
    private String ERROR_MSG = "Could not generate verification data";

    public void generateVerificationHtml(String string, String string2, VerifyResultInfoInterface verifyResultInfoInterface) {
        this.verInfo = verifyResultInfoInterface;
        File file = new File(string, string2);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<html>");
            fileWriter.write("<head>");
            fileWriter.write("<title>" + this.title + "</title>");
            fileWriter.write("<body>");
            fileWriter.write("<h1 align=\"center\">" + this.title + "</h1>");
            try {
                fileWriter.write(this.generateLinks());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateLinks", throwable);
            }
            try {
                fileWriter.write(this.generateBackupRestore());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateBackupRestore", throwable);
            }
            try {
                fileWriter.write(this.generateCoreMp());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateCoreMp", throwable);
            }
            try {
                fileWriter.write(this.generateNodeId());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateNodeId", throwable);
            }
            try {
                fileWriter.write(this.generateMissingUps());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateMissingUps", throwable);
            }
            try {
                fileWriter.write(this.generateCorruptedUps());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateCorruptedUps", throwable);
            }
            try {
                fileWriter.write(this.generateCorruptedUCF());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generate CorruptedUcfs", throwable);
            }
            try {
                fileWriter.write(this.generateHwConfiguration());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateHwConfiguration", throwable);
            }
            try {
                fileWriter.write(this.getNodeApplConfDiff());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not getNodeApplConfDiff", throwable);
            }
            try {
                fileWriter.write(this.generateSubrackDiff());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateSubrackDiff", throwable);
            }
            try {
                fileWriter.write(this.generateIpDiff());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateIpDiff", throwable);
            }
            try {
                fileWriter.write(this.generateSswInfo());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "generateVerificationHtml", "Could not generateIpDiff", throwable);
            }
            fileWriter.write("</body> </html>");
            fileWriter.close();
        }
        catch (IOException iOException) {
            Trace.error(this.getClass(), "generateVerificationHtml", "Could not generate a html file for verification result", iOException);
        }
    }

    private String generateLinks() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlHRef(this.backupRestore) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.coreMp) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.nodeIdentification) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.missingUp) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.corruptedUp) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.hwConfig) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.nodeApplConf) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.subrack) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.ipDiff) + "&nbsp&nbsp");
        stringBuffer.append(this.getHtmlHRef(this.sswInfo));
        return stringBuffer.toString();
    }

    private String generateMissingUps() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlLink(this.missingUp));
        Collection collection = this.verInfo.getCustomizedMissingUPsInfo();
        if (collection != null) {
            if (!collection.isEmpty()) {
                stringBuffer.append(this.generateMissingOrCorruptedUpTableHelp());
                stringBuffer.append(this.generateMissingOrCorruptedUpTable(collection, true));
            } else {
                stringBuffer.append(this.NONE);
            }
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateCorruptedUps() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlLink(this.corruptedUp));
        Collection collection = this.verInfo.getCustomizedCorruptedUPsInfo();
        if (collection != null) {
            if (!collection.isEmpty()) {
                stringBuffer.append(this.generateMissingOrCorruptedUpTableHelp());
                stringBuffer.append(this.generateMissingOrCorruptedUpTable(collection, false));
            } else {
                stringBuffer.append(this.NONE);
            }
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateMissingOrCorruptedUpTableHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        TableData[] tableDataArray = new TableData[]{new TableData("", new HtmlAttr(this.errorColour, "", "5")), new TableData("Critical LoadModule/SignatureModule")};
        stringBuffer.append(new TableRow(tableDataArray).toHtml());
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String generateMissingOrCorruptedUpTable(Collection collection, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        TableHeaderContainer[] tableHeaderContainerArray = new TableHeaderContainer[]{new TableHeaderContainer("UpgradePackage", "2", ""), new TableHeaderContainer("Missing LoadModules", "", "2"), new TableHeaderContainer("Missing SignatureModules", "", "2"), new TableHeaderContainer("Corrupted LoadModules", "", "2"), new TableHeaderContainer("Corrupted SignatureModules", "", "2")};
        String[] stringArray = new String[]{"Product number and revision", "TypeOfUP"};
        Iterator iterator = collection.iterator();
        UP_LM_Relation uP_LM_Relation = null;
        String string = null;
        String string2 = "Unknown";
        Iterator iterator2 = null;
        LM_Data lM_Data = null;
        String string3 = null;
        StringBuffer stringBuffer2 = null;
        Iterator iterator3 = null;
        LM_Data lM_Data2 = null;
        String string4 = null;
        StringBuffer stringBuffer3 = null;
        Iterator iterator4 = null;
        LM_Data lM_Data3 = null;
        String string5 = null;
        StringBuffer stringBuffer4 = null;
        Iterator iterator5 = null;
        LM_Data lM_Data4 = null;
        String string6 = null;
        StringBuffer stringBuffer5 = null;
        while (iterator.hasNext()) {
            uP_LM_Relation = (UP_LM_Relation)iterator.next();
            string = uP_LM_Relation.upProductData.getNumber() + " " + uP_LM_Relation.upProductData.getRevision();
            if (bl) {
                string = this.markAsMissingUP(string);
            }
            if (uP_LM_Relation.activatedTypeOfUP != null) {
                string2 = uP_LM_Relation.activatedTypeOfUP.getDescription();
            }
            iterator2 = uP_LM_Relation.missingLoadModules.iterator();
            stringBuffer2 = new StringBuffer();
            while (iterator2.hasNext()) {
                lM_Data = (LM_Data)iterator2.next();
                string3 = lM_Data.productNumberAndRevision.productNumber + " " + lM_Data.productNumberAndRevision.revision + "<BR>";
                if (lM_Data.isCriticalForRestore) {
                    string3 = this.markAsCriticalLoadOrSignatureModule(string3);
                }
                stringBuffer2.append(string3);
            }
            iterator3 = uP_LM_Relation.missingSignatureModules.iterator();
            stringBuffer3 = new StringBuffer();
            while (iterator3.hasNext()) {
                lM_Data2 = (LM_Data)iterator3.next();
                string4 = lM_Data2.productNumberAndRevision.productNumber + " " + lM_Data2.productNumberAndRevision.revision + "<BR>";
                if (lM_Data2.isCriticalForRestore) {
                    string4 = this.markAsCriticalLoadOrSignatureModule(string4);
                }
                stringBuffer3.append(string4);
            }
            iterator4 = uP_LM_Relation.corruptedLoadModules.iterator();
            stringBuffer4 = new StringBuffer();
            while (iterator4.hasNext()) {
                lM_Data3 = (LM_Data)iterator4.next();
                string5 = lM_Data3.productNumberAndRevision.productNumber + " " + lM_Data3.productNumberAndRevision.revision + "<BR>";
                if (lM_Data3.isCriticalForRestore) {
                    string5 = this.markAsCriticalLoadOrSignatureModule(string5);
                }
                stringBuffer4.append(string5);
            }
            iterator5 = uP_LM_Relation.corruptedSignatureModules.iterator();
            stringBuffer5 = new StringBuffer();
            while (iterator5.hasNext()) {
                lM_Data4 = (LM_Data)iterator5.next();
                string6 = lM_Data4.productNumberAndRevision.productNumber + " " + lM_Data4.productNumberAndRevision.revision + "<BR>";
                if (lM_Data4.isCriticalForRestore) {
                    string6 = this.markAsCriticalLoadOrSignatureModule(string6);
                }
                stringBuffer5.append(string6);
            }
            TableData[] tableDataArray = new TableData[]{new TableData(string, new HtmlAttr("", "", "", "", "top")), new TableData(string2, new HtmlAttr("", "", "", "", "top")), new TableData(stringBuffer2.toString(), new HtmlAttr("", "", "", "", "top")), new TableData(stringBuffer3.toString(), new HtmlAttr("", "", "", "", "top")), new TableData(stringBuffer4.toString(), new HtmlAttr("", "", "", "", "top")), new TableData(stringBuffer5.toString(), new HtmlAttr("", "", "", "", "top"))};
            arrayList.add(new TableRow(tableDataArray));
        }
        stringBuffer.append(this.getHtmlTable(arrayList, tableHeaderContainerArray, stringArray));
        return stringBuffer.toString();
    }

    private String markAsMissingUP(String string) {
        return "<b><font color=" + this.errorColour + ">" + string + "</font></b>";
    }

    private String markAsCriticalLoadOrSignatureModule(String string) {
        return "<b><font color=" + this.errorColour + ">" + string + "</font></b>";
    }

    private String generateNodeId() {
        StringBuffer stringBuffer = new StringBuffer();
        NodeID_DiffInformation nodeID_DiffInformation = this.verInfo.getNodeIDDiff();
        String[] stringArray = new String[]{"Attribute", "Node", "CV"};
        stringBuffer.append(this.getHtmlLink(this.nodeIdentification));
        if (nodeID_DiffInformation != null) {
            stringBuffer.append(this.getHtmlTable(this.getData(nodeID_DiffInformation), stringArray));
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String getNodeApplConfDiff() {
        StringBuffer stringBuffer = new StringBuffer();
        NodeApplConfDiffInformation nodeApplConfDiffInformation = this.verInfo.getNodeApplConfDiff();
        String[] stringArray = new String[]{"Attribute", "Node", "CV"};
        stringBuffer.append(this.getHtmlLink(this.nodeApplConf));
        if (nodeApplConfDiffInformation != null) {
            stringBuffer.append(this.getHtmlTable(this.getData(nodeApplConfDiffInformation), stringArray));
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateIpDiff() {
        StringBuffer stringBuffer = new StringBuffer();
        IP_InfoDiffInformation iP_InfoDiffInformation = this.verInfo.getIPDiff();
        String[] stringArray = new String[]{"Attribute", "Node", "CV"};
        stringBuffer.append(this.getHtmlLink(this.ipDiff));
        if (iP_InfoDiffInformation != null) {
            stringBuffer.append(this.getHtmlTable(this.getData(iP_InfoDiffInformation), stringArray));
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String getHtmlTable(ArrayList arrayList, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null) {
            if (!arrayList.isEmpty()) {
                stringBuffer.append("<table border = \"1\">");
                TableData[] tableDataArray = new TableHeader[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    tableDataArray[i] = new TableHeader(stringArray[i]);
                }
                stringBuffer.append(new TableRow(tableDataArray).toHtml());
                ListIterator listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    stringBuffer.append(((TableRow)listIterator.next()).toHtml());
                }
                stringBuffer.append("</table>");
            } else {
                stringBuffer.append(this.NONE);
            }
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String getHtmlTable(ArrayList arrayList, TableHeaderContainer[] tableHeaderContainerArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null) {
            if (!arrayList.isEmpty()) {
                int n;
                stringBuffer.append("<table border = \"1\">");
                TableHeaderContainer tableHeaderContainer = null;
                TableData[] tableDataArray = new TableHeader[tableHeaderContainerArray.length];
                for (n = 0; n < tableHeaderContainerArray.length; ++n) {
                    tableHeaderContainer = tableHeaderContainerArray[n];
                    tableDataArray[n] = new TableHeader(tableHeaderContainer.value, new HtmlAttr("", tableHeaderContainer.colspan, tableHeaderContainer.rowspan, "", "", ""));
                }
                stringBuffer.append(new TableRow(tableDataArray).toHtml());
                tableDataArray = new TableHeader[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    tableDataArray[n] = new TableHeader(stringArray[n]);
                }
                stringBuffer.append(new TableRow(tableDataArray).toHtml());
                ListIterator listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    stringBuffer.append(((TableRow)listIterator.next()).toHtml());
                }
                stringBuffer.append("</table>");
            } else {
                stringBuffer.append(this.NONE);
            }
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private ArrayList getData(DiffInformationInterface diffInformationInterface) {
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        Iterator iterator = null;
        if (diffInformationInterface != null) {
            TableData[] tableDataArray;
            MasterInformationInterface masterInformationInterface;
            Collection collection = diffInformationInterface.getMatching();
            if (collection != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    masterInformationInterface = (MasterInformationInterface)iterator.next();
                    if (masterInformationInterface == null) continue;
                    tableDataArray = new TableData[]{new TableData(masterInformationInterface.getNameMaster()), new TableData(masterInformationInterface.getValueMaster()), new TableData(masterInformationInterface.getValueMaster())};
                    arrayList.add(new TableRow(tableDataArray));
                }
            }
            if ((collection = diffInformationInterface.getNotPresentInCV()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    masterInformationInterface = (MasterInformationInterface)iterator.next();
                    if (masterInformationInterface == null) continue;
                    tableDataArray = new TableData[]{new TableData(masterInformationInterface.getNameMaster()), new TableData(masterInformationInterface.getValueMaster()), new TableData("")};
                    arrayList.add(new TableRow(tableDataArray));
                }
            }
            if ((collection = diffInformationInterface.getNotPresentInNode()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    masterInformationInterface = (MasterInformationInterface)iterator.next();
                    if (masterInformationInterface == null) continue;
                    tableDataArray = new TableData[]{new TableData(masterInformationInterface.getNameMaster()), new TableData(""), new TableData(masterInformationInterface.getValueMaster())};
                    arrayList.add(new TableRow(tableDataArray));
                }
            }
            if ((collection = diffInformationInterface.getNotMatching()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    masterInformationInterface = (ComparedInformationInterface)iterator.next();
                    if (masterInformationInterface == null) continue;
                    tableDataArray = new TableData[]{new TableData(masterInformationInterface.getNameMaster()), new TableData(masterInformationInterface.getValueCompared()), new TableData(masterInformationInterface.getValueMaster())};
                    arrayList.add(new TableRow(tableDataArray));
                }
            }
        }
        return arrayList;
    }

    private ArrayList getData(BackupRestore_DiffInformation backupRestore_DiffInformation) {
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        Iterator iterator = null;
        if (backupRestore_DiffInformation != null) {
            TableData[] tableDataArray;
            BackupRestore_CompatibilityInformation backupRestore_CompatibilityInformation;
            Collection collection = backupRestore_DiffInformation.getNotMatching();
            if (collection != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    backupRestore_CompatibilityInformation = (BackupRestore_NotCompatibleInformation)iterator.next();
                    if (backupRestore_CompatibilityInformation == null) continue;
                    tableDataArray = new TableData[]{new TableData(backupRestore_CompatibilityInformation.getAttributeName()), new TableData(((BackupRestore_NotCompatibleInformation)backupRestore_CompatibilityInformation).getValue_InNode()), new TableData(backupRestore_CompatibilityInformation.getValue_InCV())};
                    arrayList.add(this.markAsNotSupported(tableDataArray));
                }
            }
            if ((collection = backupRestore_DiffInformation.getMatching()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    backupRestore_CompatibilityInformation = (BackupRestore_CompatibleInformation)iterator.next();
                    if (backupRestore_CompatibilityInformation == null) continue;
                    tableDataArray = new TableData[]{new TableData(backupRestore_CompatibilityInformation.getAttributeName()), new TableData(backupRestore_CompatibilityInformation.getValue_InCV()), new TableData(backupRestore_CompatibilityInformation.getValue_InCV())};
                    arrayList.add(new TableRow(tableDataArray));
                }
            }
            if ((collection = backupRestore_DiffInformation.getPartlyMatching()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    backupRestore_CompatibilityInformation = (BackupRestore_PartlyCompatibleInformation)iterator.next();
                    if (backupRestore_CompatibilityInformation == null) continue;
                    tableDataArray = new TableData[]{new TableData(backupRestore_CompatibilityInformation.getAttributeName()), new TableData(((BackupRestore_PartlyCompatibleInformation)backupRestore_CompatibilityInformation).getValue_InNode()), new TableData(backupRestore_CompatibilityInformation.getValue_InCV())};
                    arrayList.add(this.markAsPartlySupported(tableDataArray));
                }
            }
        }
        return arrayList;
    }

    private TableRow markAsPartlySupported(TableData[] tableDataArray) {
        for (int i = 1; i < tableDataArray.length; ++i) {
            tableDataArray[i].attr.colour = this.warningColour;
        }
        return new TableRow(tableDataArray);
    }

    private TableRow markAsNotSupported(TableData[] tableDataArray) {
        for (int i = 1; i < tableDataArray.length; ++i) {
            tableDataArray[i].attr.colour = this.errorColour;
        }
        return new TableRow(tableDataArray);
    }

    private ArrayList getData(SubrackInfo_DiffInformation subrackInfo_DiffInformation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = null;
        if (subrackInfo_DiffInformation != null) {
            TableData[] tableDataArray;
            TableData[] tableDataArray2;
            Object object;
            Object object2;
            Collection collection = subrackInfo_DiffInformation.getNotMatching();
            if (collection != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    TableData[] tableDataArray3;
                    object2 = iterator.next();
                    if (object2 instanceof SubrackInfo_NotCompatibleInformation) {
                        object = (SubrackInfo_NotCompatibleInformation)object2;
                        if (object == null) continue;
                        arrayList.add("<table border = \"1\">");
                        tableDataArray2 = new TableHeader("Subrack: " + ((SubrackInfo_CompatibilityInformation)object).getSmn(), new HtmlAttr("", "\"3\""));
                        arrayList.add(tableDataArray2.toHtml());
                        tableDataArray = new TableData[]{new TableHeader("attribute"), new TableHeader("Node"), new TableHeader("CV")};
                        arrayList.add(new TableRow(tableDataArray).toHtml());
                        tableDataArray3 = new TableData[]{new TableData(((SubrackInfo_CompatibilityInformation)object).getTypeFanConfigAttribute()), new TableData(((SubrackInfo_CompatibilityInformation)object).getFanConfigAsString()), new TableData(((SubrackInfo_NotCompatibleInformation)object).getIncompatibleCVFanConfigAsString())};
                        arrayList.add(this.markAsNotSupported(tableDataArray3).toHtml());
                        arrayList.add("</table>");
                        continue;
                    }
                    if (!(object2 instanceof SubrackInfo_NotCompatibleIntegratedHWInformation) || (object = (SubrackInfo_NotCompatibleIntegratedHWInformation)object2) == null) continue;
                    arrayList.add("<table border = \"1\">");
                    tableDataArray2 = new TableHeader("Subrack: " + ((SubrackInfo_CompatibilityInformation)object).getSmn(), new HtmlAttr("", "\"3\""));
                    arrayList.add(tableDataArray2.toHtml());
                    tableDataArray = new TableData[]{new TableHeader("attribute"), new TableHeader("Node"), new TableHeader("CV")};
                    arrayList.add(new TableRow(tableDataArray).toHtml());
                    tableDataArray3 = new TableData[]{new TableData(((SubrackInfo_CompatibilityInformation)object).getTypeIntegratedHWAttribute()), new TableData(((SubrackInfo_CompatibilityInformation)object).getIntegratedHWAsString()), new TableData(((SubrackInfo_NotCompatibleIntegratedHWInformation)object).getIncompatibleCVIntegratedHWAsString())};
                    arrayList.add(this.markAsNotSupported(tableDataArray3).toHtml());
                    arrayList.add("</table>");
                }
            }
            if ((collection = subrackInfo_DiffInformation.getNotPresentInCV()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = (SubrackInfo_CompatibleInformation)iterator.next();
                    if (object2 == null) continue;
                    arrayList.add("<table border = \"1\">");
                    object = new TableHeader("Subrack: " + ((SubrackInfo_CompatibilityInformation)object2).getSmn(), new HtmlAttr("", "\"3\""));
                    arrayList.add(((TableHeader)object).toHtml());
                    tableDataArray2 = new TableData[]{new TableHeader("attribute"), new TableHeader("Node"), new TableHeader("CV")};
                    arrayList.add(new TableRow(tableDataArray2).toHtml());
                    tableDataArray = new TableData[]{new TableData(((SubrackInfo_CompatibilityInformation)object2).getTypeFanConfigAttribute()), new TableData(((SubrackInfo_CompatibilityInformation)object2).getFanConfigAsString()), new TableData("")};
                    arrayList.add(new TableRow(tableDataArray).toHtml());
                    arrayList.add("</table>");
                }
            }
            if ((collection = subrackInfo_DiffInformation.getNotPresentInNode()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = (SubrackInfo_CompatibleInformation)iterator.next();
                    if (object2 == null) continue;
                    arrayList.add("<table border = \"1\">");
                    object = new TableHeader("Subrack: " + ((SubrackInfo_CompatibilityInformation)object2).getSmn(), new HtmlAttr("", "\"3\""));
                    arrayList.add(((TableHeader)object).toHtml());
                    tableDataArray2 = new TableData[]{new TableHeader("attribute"), new TableHeader("Node"), new TableHeader("CV")};
                    arrayList.add(new TableRow(tableDataArray2).toHtml());
                    tableDataArray = new TableData[]{new TableData(((SubrackInfo_CompatibilityInformation)object2).getTypeFanConfigAttribute()), new TableData(""), new TableData(((SubrackInfo_CompatibilityInformation)object2).getFanConfigAsString())};
                    arrayList.add(new TableRow(tableDataArray).toHtml());
                    arrayList.add("</table>");
                }
            }
            if ((collection = subrackInfo_DiffInformation.getMatching()) != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object2 = (SubrackInfo_CompatibleInformation)iterator.next();
                    if (object2 == null) continue;
                    arrayList.add("<table border = \"1\">");
                    object = new TableHeader("Subrack: " + ((SubrackInfo_CompatibilityInformation)object2).getSmn(), new HtmlAttr("", "\"3\""));
                    arrayList.add(((TableHeader)object).toHtml());
                    tableDataArray2 = new TableData[]{new TableHeader("attribute"), new TableHeader("Node"), new TableHeader("CV")};
                    arrayList.add(new TableRow(tableDataArray2).toHtml());
                    if (((SubrackInfo_CompatibilityInformation)object2).getTypeFanConfigAttribute() != null) {
                        tableDataArray = new TableData[]{new TableData(((SubrackInfo_CompatibilityInformation)object2).getTypeFanConfigAttribute()), new TableData(((SubrackInfo_CompatibilityInformation)object2).getFanConfigAsString()), new TableData(((SubrackInfo_CompatibleInformation)object2).getCompatibleFanConfigAsString())};
                        arrayList.add(new TableRow(tableDataArray).toHtml());
                    }
                    if (((SubrackInfo_CompatibilityInformation)object2).getTypeIntegratedHWAttribute() != null) {
                        tableDataArray = new TableData[]{new TableData(((SubrackInfo_CompatibilityInformation)object2).getTypeIntegratedHWAttribute()), new TableData(((SubrackInfo_CompatibilityInformation)object2).getIntegratedHWAsString()), new TableData(((SubrackInfo_CompatibleInformation)object2).getCompatibleIntegratedHWAsString())};
                        arrayList.add(new TableRow(tableDataArray).toHtml());
                    }
                    arrayList.add("</table>");
                }
            }
        }
        return arrayList;
    }

    private ArrayList getData(SSW_ValidationInformation sSW_ValidationInformation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<table border = \"1\">");
        TableHeader tableHeader = new TableHeader("Signed software validation information.", new HtmlAttr("", "\"4\""));
        arrayList.add(tableHeader.toHtml());
        TableData[] tableDataArray = new TableData[]{new TableHeader("Board position"), new TableHeader("LM filepath"), new TableHeader("Main info"), new TableHeader("Detailed info")};
        arrayList.add(new TableRow(tableDataArray).toHtml());
        Iterator iterator = null;
        OsaVerifySswConfErrorIndInformation osaVerifySswConfErrorIndInformation = null;
        if (sSW_ValidationInformation != null) {
            TableData[] tableDataArray2;
            Collection collection = sSW_ValidationInformation.getSswIndicationIndicatingWarningsForRestore();
            if (collection != null) {
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    osaVerifySswConfErrorIndInformation = (OsaVerifySswConfErrorIndInformation)iterator.next();
                    if (osaVerifySswConfErrorIndInformation == null) continue;
                    tableDataArray2 = new TableData[]{new TableData(osaVerifySswConfErrorIndInformation.getLNH_Name()), new TableData(osaVerifySswConfErrorIndInformation.getLoadModulePath()), new TableData(osaVerifySswConfErrorIndInformation.getIndicationErrorSlogan(osaVerifySswConfErrorIndInformation.getIndicationErrorReason())), new TableData(osaVerifySswConfErrorIndInformation.getErrorInformation())};
                    arrayList.add(this.markAsPartlySupported(tableDataArray2).toHtml());
                }
            }
            if ((tableDataArray2 = sSW_ValidationInformation.getSswIndicationIndicatingErrorsForRestore()) != null) {
                iterator = tableDataArray2.iterator();
                while (iterator.hasNext()) {
                    osaVerifySswConfErrorIndInformation = (OsaVerifySswConfErrorIndInformation)iterator.next();
                    if (osaVerifySswConfErrorIndInformation == null) continue;
                    TableData[] tableDataArray3 = new TableData[]{new TableData(osaVerifySswConfErrorIndInformation.getLNH_Name()), new TableData(osaVerifySswConfErrorIndInformation.getLoadModulePath()), new TableData(osaVerifySswConfErrorIndInformation.getIndicationErrorSlogan(osaVerifySswConfErrorIndInformation.getIndicationErrorReason())), new TableData(osaVerifySswConfErrorIndInformation.getErrorInformation())};
                    arrayList.add(this.markAsNotSupported(tableDataArray3).toHtml());
                }
            }
        }
        arrayList.add("</table>");
        return arrayList;
    }

    private ArrayList getData(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<table border = \"1\">");
        TableHeader tableHeader = new TableHeader("Corrupted UCFs information.", new HtmlAttr("", "\"4\""));
        arrayList.add(tableHeader.toHtml());
        TableData[] tableDataArray = new TableData[]{new TableHeader("Upgrade Package"), new TableHeader("UCF file path"), new TableHeader("Expected checksum (value in DB)"), new TableHeader("Calculated checksum")};
        arrayList.add(new TableRow(tableDataArray).toHtml());
        Iterator iterator = collection.iterator();
        UCF_ChecksumInformation uCF_ChecksumInformation = null;
        while (iterator.hasNext()) {
            uCF_ChecksumInformation = (UCF_ChecksumInformation)iterator.next();
            TableData[] tableDataArray2 = new TableData[]{new TableData(uCF_ChecksumInformation.getProdNoOfUP() + "_" + uCF_ChecksumInformation.getProdRevOfUP()), new TableData(uCF_ChecksumInformation.getUCF_FilePath()), new TableData(uCF_ChecksumInformation.getUCF_ChecksumInDB()), new TableData(uCF_ChecksumInformation.getUCF_ChecksumCalculated())};
            arrayList.add(this.markAsNotSupported(tableDataArray2).toHtml());
        }
        arrayList.add("</table>");
        return arrayList;
    }

    private String generateHwConfiguration() {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = this.verInfo.getNotSupportedHW();
        ArrayList arrayList = null;
        HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation = this.verInfo.getHWConfCvNodeDiff();
        HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation2 = this.verInfo.getHWConfNodeCvDiff();
        stringBuffer.append(this.getHtmlLink(this.hwConfig));
        if (hW_ConfigurationDiffInformation != null && hW_ConfigurationDiffInformation2 != null) {
            stringBuffer.append(this.generateHWHelp());
            stringBuffer.append("<table border = \"1\">");
            Vector vector = hW_ConfigurationDiffInformation.matchingSubracks;
            SubrackInformation[] subrackInformationArray = new SubrackInformation[vector.size()];
            vector.toArray(subrackInformationArray);
            Vector vector2 = hW_ConfigurationDiffInformation2.matchingSubracks;
            SubrackInformation[] subrackInformationArray2 = new SubrackInformation[vector2.size()];
            vector2.toArray(subrackInformationArray2);
            Arrays.sort(subrackInformationArray, new SubrackComparator());
            Arrays.sort(subrackInformationArray2, new SubrackComparator());
            for (int i = 0; i < subrackInformationArray.length; ++i) {
                if (subrackInformationArray[i] == null) continue;
                arrayList = this.createTableForHwConfig(subrackInformationArray[i], this.findSubrack(subrackInformationArray2, subrackInformationArray[i].smn));
                TableHeader tableHeader = new TableHeader("subracknumber: " + subrackInformationArray[i].smn, new HtmlAttr("", "\"3\""));
                stringBuffer.append(tableHeader.toHtml());
                this.markNotSupHw(collection, arrayList, subrackInformationArray[i].smn);
                TableData[] tableDataArray = new TableData[]{new TableHeader("Slot"), new TableHeader("Node"), new TableHeader("CV")};
                stringBuffer.append(new TableRow(tableDataArray).toHtml());
                TableRow[] tableRowArray = arrayList.toArray(new TableRow[0]);
                Arrays.sort(tableRowArray, new TableRowSort1Comparator());
                for (int j = 0; j < tableRowArray.length; ++j) {
                    stringBuffer.append(tableRowArray[j].toHtml());
                }
            }
            stringBuffer.append("</table>");
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateSubrackDiff() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlLink(this.subrack));
        stringBuffer.append(this.generateSubrackHelp());
        SubrackInfo_DiffInformation subrackInfo_DiffInformation = this.verInfo.getSubrackDiff();
        if (subrackInfo_DiffInformation != null) {
            ArrayList arrayList = this.getData(subrackInfo_DiffInformation);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append((String)listIterator.next());
            }
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateSswInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlLink(this.sswInfo));
        stringBuffer.append(this.generateSswHelp());
        SSW_ValidationInformation sSW_ValidationInformation = this.verInfo.getSSW_ValidationInformation();
        if (sSW_ValidationInformation != null) {
            ArrayList arrayList = this.getData(sSW_ValidationInformation);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append((String)listIterator.next());
            }
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateCorruptedUCF() {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = this.verInfo.getCorruptedUCFs();
        stringBuffer.append(this.getHtmlLink(this.corruptedUCF));
        if (!collection.isEmpty()) {
            stringBuffer.append(this.generateCorruptedUcfsHelp());
            ArrayList arrayList = this.getData(collection);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append((String)listIterator.next());
            }
        } else {
            stringBuffer.append(this.NONE);
        }
        return stringBuffer.toString();
    }

    private String generateBackupRestore() {
        StringBuffer stringBuffer = new StringBuffer();
        BackupRestore_DiffInformation backupRestore_DiffInformation = this.verInfo.getBackupRestoreDiff();
        String[] stringArray = new String[]{"Attribute", "Node", "CV"};
        stringBuffer.append(this.getHtmlLink(this.backupRestore));
        stringBuffer.append(this.generateBackupRestoreHelp());
        if (backupRestore_DiffInformation != null) {
            stringBuffer.append(this.getHtmlTable(this.getData(backupRestore_DiffInformation), stringArray));
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String generateBackupRestoreHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        TableData[] tableDataArray = new TableData[]{new TableData("", new HtmlAttr(this.warningColour, "", "25")), new TableData("Partly compatible backup restore"), new TableData("", new HtmlAttr(this.errorColour, "", "25")), new TableData("Not compatible backup restore")};
        stringBuffer.append(new TableRow(tableDataArray).toHtml());
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String generateSubrackHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        TableData[] tableDataArray = new TableData[]{new TableData("", new HtmlAttr(this.errorColour, "", "25")), new TableData("Not Supported Subrack difference.")};
        stringBuffer.append(new TableRow(tableDataArray).toHtml());
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String generateSswHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        TableData[] tableDataArray = new TableData[]{new TableData("", new HtmlAttr(this.warningColour, "", "25")), new TableData("SSW warning"), new TableData("", new HtmlAttr(this.errorColour, "", "25")), new TableData("SSW stopping")};
        stringBuffer.append(new TableRow(tableDataArray).toHtml());
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String generateCorruptedUcfsHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        TableData[] tableDataArray = new TableData[]{new TableData("", new HtmlAttr(this.errorColour, "", "25")), new TableData("Corrupted UCF stopping")};
        stringBuffer.append(new TableRow(tableDataArray).toHtml());
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private String generateHWHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table>");
        TableData[] tableDataArray = new TableData[]{new TableData("", new HtmlAttr(this.warningColour, "", "25")), new TableData("Incompatible HW"), new TableData("", new HtmlAttr(this.errorColour, "", "25")), new TableData("Not Supported HW")};
        stringBuffer.append(new TableRow(tableDataArray).toHtml());
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    private void markNotSupHw(Collection collection, ArrayList arrayList, int n) {
        if (collection == null || arrayList == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof PIU_PositionAndProductData)) continue;
            PIU_PositionAndProductData pIU_PositionAndProductData = (PIU_PositionAndProductData)e;
            try {
                if (n != new Integer(pIU_PositionAndProductData.getSMN_AsString())) continue;
                String string = pIU_PositionAndProductData.getAPN_AsString();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    TableRow tableRow = (TableRow)iterator2.next();
                    if (!tableRow.data[0].value.equals(string)) continue;
                    for (int i = 1; i < tableRow.data.length; ++i) {
                        tableRow.data[i].attr.colour = this.errorColour;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.debug("markNotSupHw(Collection notSup, ArrayList data, int smn)", "NumberFormatException caught, ignoring.");
            }
        }
    }

    private ArrayList createTableForHwConfig(SubrackInformation subrackInformation, SubrackInformation subrackInformation2) {
        TableData[] tableDataArray;
        TableData[] tableDataArray2;
        int n;
        String string;
        int n2;
        Collection collection = subrackInformation.getSlotsWithNoPIUs();
        Collection collection2 = subrackInformation2.getSlotsWithNoPIUs();
        MasterSlotInformation[] masterSlotInformationArray = new MasterSlotInformation[collection.size()];
        MasterSlotInformation[] masterSlotInformationArray2 = new MasterSlotInformation[collection2.size()];
        collection.toArray(masterSlotInformationArray);
        collection2.toArray(masterSlotInformationArray2);
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        for (n2 = 0; n2 < masterSlotInformationArray.length; ++n2) {
            string = masterSlotInformationArray[n2].piuProductDataInMaster.productNumber + " " + masterSlotInformationArray[n2].piuProductDataInMaster.revision;
            n = masterSlotInformationArray[n2].slotNumber;
            tableDataArray2 = new TableData[]{new TableHeader("" + n), new TableData(""), new TableData(string)};
            arrayList.add(new TableRow(tableDataArray2));
        }
        for (n2 = 0; n2 < masterSlotInformationArray2.length; ++n2) {
            string = masterSlotInformationArray2[n2].piuProductDataInMaster.productNumber + " " + masterSlotInformationArray2[n2].piuProductDataInMaster.revision;
            n = masterSlotInformationArray2[n2].slotNumber;
            tableDataArray2 = new TableData[]{new TableHeader("" + n), new TableData(string), new TableData("")};
            arrayList.add(new TableRow(tableDataArray2));
        }
        collection = subrackInformation.getSlotsWithMatchingPIUs();
        masterSlotInformationArray = new MasterSlotInformation[collection.size()];
        collection.toArray(masterSlotInformationArray);
        for (n2 = 0; n2 < masterSlotInformationArray.length; ++n2) {
            string = masterSlotInformationArray[n2].piuProductDataInMaster.productNumber + " " + masterSlotInformationArray[n2].piuProductDataInMaster.revision;
            n = masterSlotInformationArray[n2].slotNumber;
            tableDataArray2 = new TableData[]{new TableHeader("" + n), new TableData(string), new TableData(string)};
            arrayList.add(new TableRow(tableDataArray2));
        }
        collection = subrackInformation.getSlotsWithCompatiblePIUs();
        masterSlotInformationArray = new MasterSlotInformation[collection.size()];
        collection.toArray(masterSlotInformationArray);
        for (n2 = 0; n2 < masterSlotInformationArray.length; ++n2) {
            string = masterSlotInformationArray[n2].piuProductDataInMaster.productNumber + " " + masterSlotInformationArray[n2].piuProductDataInMaster.revision;
            String string2 = ((ComparedSlotInformation)masterSlotInformationArray[n2]).piuProductDataInCompared.productNumber + " " + ((ComparedSlotInformation)masterSlotInformationArray[n2]).piuProductDataInCompared.revision;
            int n3 = masterSlotInformationArray[n2].slotNumber;
            tableDataArray = new TableData[]{new TableHeader("" + n3), new TableData(string2), new TableData(string)};
            arrayList.add(new TableRow(tableDataArray));
        }
        collection = subrackInformation.getSlotsWithIncompatiblePIUs();
        masterSlotInformationArray = new MasterSlotInformation[collection.size()];
        collection.toArray(masterSlotInformationArray);
        for (n2 = 0; n2 < masterSlotInformationArray.length; ++n2) {
            string = masterSlotInformationArray[n2].piuProductDataInMaster.productNumber + " " + masterSlotInformationArray[n2].piuProductDataInMaster.revision;
            String string3 = ((ComparedSlotInformation)masterSlotInformationArray[n2]).piuProductDataInCompared.productNumber + " " + ((ComparedSlotInformation)masterSlotInformationArray[n2]).piuProductDataInCompared.revision;
            int n4 = masterSlotInformationArray[n2].slotNumber;
            tableDataArray = new TableData[]{new TableHeader("" + n4), new TableData(string3, new HtmlAttr(this.warningColour, "")), new TableData(string, new HtmlAttr(this.warningColour, ""))};
            arrayList.add(new TableRow(tableDataArray));
        }
        return arrayList;
    }

    private SubrackInformation findSubrack(SubrackInformation[] subrackInformationArray, int n) {
        for (int i = 0; i < subrackInformationArray.length; ++i) {
            if (subrackInformationArray[i] == null || subrackInformationArray[i].smn != n) continue;
            return subrackInformationArray[i];
        }
        return null;
    }

    private TableRow getRowForCoreMp(int n, String string, String string2, boolean bl) {
        TableData tableData = new TableData("" + n);
        TableData tableData2 = new TableData(string, new HtmlAttr("", "", "", "center"));
        TableData tableData3 = new TableData(string2, new HtmlAttr("", "", "", "center"));
        TableData[] tableDataArray = new TableData[]{tableData, tableData2, tableData3};
        TableRow tableRow = new TableRow(tableDataArray);
        if (n > 0 && !bl) {
            tableData2.attr.colour = this.errorColour;
            tableData3.attr.colour = this.errorColour;
        }
        return tableRow;
    }

    private String generateCoreMp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHtmlLink(this.coreMp));
        CoreMP_CompatibilityInformation coreMP_CompatibilityInformation = this.verInfo.getCoreMP();
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        int n = -1;
        if (coreMP_CompatibilityInformation != null) {
            if (coreMP_CompatibilityInformation instanceof CoreMP_PartlyCompatibleInformation) {
                n = ((CoreMP_PartlyCompatibleInformation)coreMP_CompatibilityInformation).getCompatibleSlotA();
                arrayList.add(this.getRowForCoreMp(n, "x", "x", true));
                n = ((CoreMP_PartlyCompatibleInformation)coreMP_CompatibilityInformation).getIncompatibleSlotB_InCV();
                arrayList.add(this.getRowForCoreMp(n, "", "x", false));
                n = ((CoreMP_PartlyCompatibleInformation)coreMP_CompatibilityInformation).getIncompatibleSlotB_InNode();
                arrayList.add(this.getRowForCoreMp(n, "x", "", false));
            } else if (coreMP_CompatibilityInformation instanceof CoreMP_NotCompatibleInformation) {
                n = ((CoreMP_NotCompatibleInformation)coreMP_CompatibilityInformation).getIncompatibleSlotA_InCV();
                arrayList.add(this.getRowForCoreMp(n, "", "x", false));
                n = ((CoreMP_NotCompatibleInformation)coreMP_CompatibilityInformation).getIncompatibleSlotB_InCV();
                arrayList.add(this.getRowForCoreMp(n, "", "x", false));
                n = ((CoreMP_NotCompatibleInformation)coreMP_CompatibilityInformation).getIncompatibleSlotA_InNode();
                arrayList.add(this.getRowForCoreMp(n, "x", "", false));
                n = ((CoreMP_NotCompatibleInformation)coreMP_CompatibilityInformation).getIncompatibleSlotB_InNode();
                arrayList.add(this.getRowForCoreMp(n, "x", "", false));
            } else if (coreMP_CompatibilityInformation instanceof CoreMP_CompatibleInformation) {
                n = ((CoreMP_CompatibleInformation)coreMP_CompatibilityInformation).getCompatibleSlotA();
                arrayList.add(this.getRowForCoreMp(n, "x", "x", true));
                n = ((CoreMP_CompatibleInformation)coreMP_CompatibilityInformation).getCompatibleSlotB();
                arrayList.add(this.getRowForCoreMp(n, "x", "x", true));
            }
            stringBuffer.append("<table border = \"1\">");
            TableRow[] tableRowArray = arrayList.toArray(new TableRow[0]);
            Arrays.sort(tableRowArray, new TableRowSort1Comparator());
            TableData[] tableDataArray = new TableData[]{new TableHeader("Slot"), new TableHeader("Node"), new TableHeader("CV")};
            TableRow tableRow = new TableRow(tableDataArray);
            stringBuffer.append(tableRow.toHtml());
            for (int i = 0; i < tableRowArray.length; ++i) {
                stringBuffer.append(tableRowArray[i].toHtml());
            }
            stringBuffer.append("</table>");
        } else {
            stringBuffer.append(this.ERROR_MSG);
        }
        return stringBuffer.toString();
    }

    private String getHtmlLink(String string) {
        if (string != null) {
            return "<a name=\"" + string + "\"><h2>" + string + "</h2> </a>";
        }
        return "";
    }

    private String getHtmlHRef(String string) {
        if (string != null) {
            return "<a href=\"#" + string + "\">" + string + "</a>";
        }
        return "";
    }

    private class SubrackComparator
    implements Comparator {
        private SubrackComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            if (object instanceof SubrackInformation && object2 instanceof SubrackInformation) {
                Integer n2 = new Integer(((SubrackInformation)object).smn);
                Integer n3 = new Integer(((SubrackInformation)object2).smn);
                n = n2.compareTo(n3);
            }
            return n;
        }
    }

    private class TableRowSort1Comparator
    implements Comparator {
        private TableRowSort1Comparator() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            if (object instanceof TableRow && object2 instanceof TableRow) {
                String string = ((TableRow)object).data[0].value;
                String string2 = ((TableRow)object2).data[0].value;
                Integer n2 = new Integer(string);
                Integer n3 = new Integer(string2);
                n = n2.compareTo(n3);
            }
            return n;
        }
    }

    private class HtmlAttr {
        String colour = "";
        String width = "";
        String colspan = "";
        String rowspan = "";
        String align = "";
        String valign = "";

        HtmlAttr(String string, String string2) {
            this.colour = string;
            this.colspan = string2;
        }

        HtmlAttr(String string, String string2, String string3) {
            this(string, string2);
            this.width = string3;
        }

        HtmlAttr(String string, String string2, String string3, String string4) {
            this(string, string2, string3);
            this.align = string4;
        }

        HtmlAttr(String string, String string2, String string3, String string4, String string5) {
            this(string, string2, string3, string4);
            this.valign = string5;
        }

        HtmlAttr(String string, String string2, String string3, String string4, String string5, String string6) {
            this(string, string2, string4, string5, string6);
            this.rowspan = string3;
        }

        HtmlAttr() {
        }

        public String toHtml() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.colour.equals("")) {
                stringBuffer.append(" bgcolor=" + this.colour);
            }
            if (!this.colspan.equals("")) {
                stringBuffer.append(" colspan=" + this.colspan);
            }
            if (!this.rowspan.equals("")) {
                stringBuffer.append(" rowspan=" + this.rowspan);
            }
            if (!this.width.equals("")) {
                stringBuffer.append(" width=\"" + this.width + "\"");
            }
            if (!this.align.equals("")) {
                stringBuffer.append(" align=\"" + this.align + "\"");
            }
            if (!this.valign.equals("")) {
                stringBuffer.append(" valign=\"" + this.valign + "\"");
            }
            return stringBuffer.toString();
        }
    }

    private class TableData {
        String value = "";
        HtmlAttr attr = new HtmlAttr();

        TableData(String string, HtmlAttr htmlAttr) {
            this.value = string;
            if (htmlAttr != null) {
                this.attr = htmlAttr;
            }
        }

        TableData(String string) {
            this.value = string;
        }

        public String toHtml() {
            String string = "&nbsp;";
            if (this.value == null) {
                this.value = "<b>Null Value</b>";
            } else if (!this.value.equals("")) {
                string = this.value;
            }
            return "<td" + this.attr.toHtml() + ">" + string + "</td>";
        }
    }

    private class TableRow {
        TableData[] data = null;
        HtmlAttr attr = new HtmlAttr();

        TableRow(TableData[] tableDataArray) {
            this.data = tableDataArray;
        }

        public String toHtml() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<tr" + this.attr.toHtml() + ">");
            for (int i = 0; i < this.data.length; ++i) {
                stringBuffer.append(this.data[i].toHtml());
            }
            stringBuffer.append("</tr>");
            return stringBuffer.toString();
        }
    }

    private class TableHeader
    extends TableData {
        TableHeader(String string) {
            super(string);
        }

        TableHeader(String string, HtmlAttr htmlAttr) {
            super(string, htmlAttr);
        }

        public String toHtml() {
            return "<th" + this.attr.toHtml() + ">" + this.value + "</th>";
        }
    }
}

