/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.su.convert.base.ConverterActionBase;
import se.ericsson.cello.su.convert.base.ConverterActionType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class DeleteAttributeConverterAction
extends ConverterActionBase {
    public DeleteAttributeConverterAction() {
        super(ConverterActionType.DELETE_ATTRIBUTE);
    }

    public DeleteAttributeConverterAction(String string) {
        super(ConverterActionType.DELETE_ATTRIBUTE, string);
    }

    protected void execute(Collection collection, String string, Integer n) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(Collection aMoDatas, String aMoTypeName, Integer aNewMoDataRevision)", "Number of MoDatas: " + collection.size() + "\n\taMoTypeName: " + string + "\n\taNewMoDataRevision: " + n);
        }
        MoData moData = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (!this.isMatchingMoType(moData, string)) continue;
            this.updateMoData(moData, n);
        }
    }

    private void updateMoData(MoData moData, Integer n) throws SuConvertActionException {
        Collection collection;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(MoData aMoData, Integer aNewMoDataRevision)", "aMoData: " + SuLib.toString(moData) + "\n\taNewMoDataRevision: " + n);
        }
        if ((collection = this.getNotAlreadyDeletedAttributes(moData)).isEmpty()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Integer aNewMoDataRevision)", "All attributes has already been deleted from MoData");
            }
            return;
        }
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            ConverterAttributeBase converterAttributeBase = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                converterAttributeBase = (ConverterAttributeBase)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Deleting attribute from MoData: " + converterAttributeBase);
                }
                converterAttributeBase.addPreviousValue(moData.getLocalDistinguishedName(), moData.getAttribute(converterAttributeBase.getName()));
                moData.deregisterAttribute(converterAttributeBase.getName());
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Setting new MoData revision: " + n);
            }
            moData.setRevision(n.intValue());
            control.getTerminator().commit();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "execute(MoData aMoData)", "Failed to delete persistent attribute to MoDatas, throwable caught.\n\taMoData: " + SuLib.toString(moData), throwable);
            throw new SuConvertActionException("Failed to delete persistent attribute from MoDatas, throwable caught. Throwable info: " + throwable);
        }
    }

    private Collection getNotAlreadyDeletedAttributes(MoData moData) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNotAlreadyDeletedAttributes(MoData aMoData)", "aMoData: " + SuLib.toString(moData));
        }
        Vector<ConverterAttributeBase> vector = new Vector<ConverterAttributeBase>();
        ConverterAttributeBase converterAttributeBase = null;
        Iterator iterator = this.myConverterAttributes.iterator();
        while (iterator.hasNext()) {
            converterAttributeBase = (ConverterAttributeBase)iterator.next();
            if (moData.getAttribute(converterAttributeBase.getName()) == null) continue;
            vector.add(converterAttributeBase);
        }
        return vector;
    }
}

