/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.file.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.su.convert.exception.SuConvertFileHandlerException;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.convert.file.proxy.ConverterFileProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UnConvertFileHandler {
    private String myFilePath = null;

    public UnConvertFileHandler(String string, String string2) throws SuConvertFileHandlerException {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UnConvertFileHandler(String aDirPath, String aFileName)", "aDirPath: " + string + "\n\taFileName: " + string2);
        }
        if ((file = new File(string)).exists()) {
            if (!file.isDirectory()) {
                Trace.error(this.getClass(), "SU_ConvertFileHandler(String aDirPath)", "The file path is not a directory. aDirPath: " + string);
                throw new SuConvertFileHandlerException("The dir path where the UnConvert.xml file is to be stored is not a directory. aDirPath: " + string);
            }
        } else {
            Trace.error(this.getClass(), "SU_ConvertFileHandler(String aDirPath)", "The dir path where the UnConvert.xml file is to be stored does not exist. aDirPath: " + string);
            throw new SuConvertFileHandlerException("The file path where the UnConvert.xml file is to be stored does not exist. aDirPath: " + string);
        }
        this.myFilePath = string + string2;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeUnConvertInformation(Collection collection) throws SuConvertFileHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "storeUnConvertInformation(Collection aConverterSteps)", "aConverterSteps: " + collection);
        }
        PrintStream printStream = null;
        ConverterFileProxy converterFileProxy = new ConverterFileProxy();
        converterFileProxy.createUnConvertStepsElement(collection);
        File file = new File(this.myFilePath);
        printStream = new PrintStream(new FileOutputStream(file));
        converterFileProxy.print(printStream);
        printStream.close();
        Object var6_7 = null;
        if (printStream == null) return;
        try {
            printStream.close();
            return;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "storeUnConvertInformation(Collection aConverterSteps)", "FilePath: " + this.myFilePath + "\n\tThrowable caught when trying to close the PrintStream,", throwable);
        }
        return;
        {
            catch (SuConverterException suConverterException) {
                throw new SuConvertFileHandlerException("Class name: " + this.getClass().getName() + "\n\tstoreUnConvertInformation(Collection aConverterSteps)" + "\n\tSuConverterException caught (Problem with creating the XML structure)." + "\n\tSuConverterException: " + suConverterException);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "storeUnConvertInformation(Collection aConverterSteps)", "Failed to create the unconvert file: " + this.myFilePath + "." + "\n\tThrowable caught." + "\n\tIt will not be possible to execute unconvert for SU MoData persistent attributes.", throwable);
                throw new SuConvertFileHandlerException("Class name: " + this.getClass().getName() + "\n\tstoreUnConvertInformation(Collection aConverterSteps)" + "Failed to create the file: " + this.myFilePath + "." + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (printStream == null) throw throwable;
            try {
                printStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                Trace.error(this.getClass(), "storeUnConvertInformation(Collection aConverterSteps)", "FilePath: " + this.myFilePath + "\n\tThrowable caught when trying to close the PrintStream,", throwable2);
            }
            throw throwable;
        }
    }

    public LinkedList getUnConvertSteps() throws SuConvertFileHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUnConvertSteps()");
        }
        ConverterFileProxy converterFileProxy = new ConverterFileProxy(this.myFilePath);
        try {
            return converterFileProxy.getConverterSteps();
        }
        catch (SuConverterException suConverterException) {
            throw new SuConvertFileHandlerException("Exception caught while retreiving Converter steps from UnConvert file. Exception info: " + suConverterException);
        }
    }
}

