/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.util.javaheap;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradePackageException;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.parser.MainElementHolder;
import se.ericsson.cello.sudom.parser.UpgradeControlFileParserFactory;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.PiuTypeRefInformationInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelper;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class JavaHeapHelper {
    public Integer selectJavaHeap(PiuTypeMoSU_Access piuTypeMoSU_Access, SlotMoSU_Access slotMoSU_Access) throws UpgradePackageException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\taSlotMo: " + slotMoSU_Access);
        }
        try {
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
            if (upgradePackageMoExtended == null) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "Not possible to calculate a valid javaHeap since no current UP exists on the node i.e. null is returned.");
                }
                return null;
            }
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            if (!jvmMO_HandlerInterface.isJVM_Slot(slotMoSU_Access)) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "The Slot to be reconfigured is not a JVM slot i.e. null is returned - Slot: " + slotMoSU_Access);
                }
                return null;
            }
            LinkedList linkedList = jvmMO_HandlerInterface.getJVM_SlotsList();
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            Integer n = null;
            Integer n2 = null;
            SlotMoSU_Access slotMoSU_Access2 = null;
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            MainElementHolder mainElementHolder = new MainElementHolder();
            mainElementHolder.add("Repertoire");
            DocumentObjectProxyInterface documentObjectProxyInterface = UpgradeControlFileParserFactory.instance().getDocumentObjectProxyInterface(upgradePackageMoExtended.getUpgradeControlFilePath(null), upgradePackageMoExtended.getDocumentNumber(null), upgradePackageMoExtended.getDocumentRevision(null), mainElementHolder, false);
            for (int i = 0; i < linkedList.size(); ++i) {
                slotMoSU_Access2 = (SlotMoSU_Access)linkedList.get(i);
                if (slotMoSU_Access2.equals(slotMoSU_Access)) {
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "Using given PiuType: " + piuTypeMoSU_Access + " for Slot Mo: " + slotMoSU_Access2);
                    }
                    productNumberAndRevisionInterface = piuTypeMO_HandlerInterface.getProductNumberAndRevision(piuTypeMoSU_Access);
                } else {
                    plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access2);
                    if (plugInUnitMoSU_Access != null) {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "Using configured PiuType: " + plugInUnitMoSU_Access.getPiuType(null) + " for Slot Mo: " + slotMoSU_Access2);
                        }
                        productNumberAndRevisionInterface = piuTypeMO_HandlerInterface.getProductNumberAndRevision((PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(null));
                    } else if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "A Slot Mo for JVM is not configured with a PIU Mo and hence no java heap can be calculated for that Slot\n\taSlotMo: " + slotMoSU_Access + " Jvm SlotMo: " + slotMoSU_Access2);
                    }
                }
                if (productNumberAndRevisionInterface != null) {
                    n2 = this.selectJavaHeap(slotMoSU_Access2, productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision(), documentObjectProxyInterface.getRepertoiresProxyInterface());
                    if (n == null) {
                        n = n2;
                    } else if (n2 != null && n > n2) {
                        n = n2;
                    }
                }
                productNumberAndRevisionInterface = null;
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "RETURNS - theJavaHeap: " + n);
            }
            return n;
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new UpgradePackageException(mO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "selectJavaHeap(PiuTypeMoSU_Access aPiuTypeMo, SlotMoSU_Access aSlotMo)", "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\taSlotMo: " + slotMoSU_Access, throwable);
            throw new UpgradePackageException(throwable.toString());
        }
    }

    public Integer selectJavaHeap(String string, String string2, String string3) throws UpgradePackageException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectJavaHeap(String anUCF_Path, String anUP_ProdNo, String anUP_ProdRev)", "\n\tanUCF_Path: " + string + "\n\tanUP_ProdNo: " + string2 + "\n\tanUP_ProdRev " + string3);
        }
        try {
            MainElementHolder mainElementHolder = new MainElementHolder();
            mainElementHolder.add("Repertoire");
            DocumentObjectProxyInterface documentObjectProxyInterface = UpgradeControlFileParserFactory.instance().getDocumentObjectProxyInterface(string, string2, string3, mainElementHolder, false);
            return this.selectJavaHeap(documentObjectProxyInterface.getRepertoiresProxyInterface());
        }
        catch (UpgradePackageException upgradePackageException) {
            throw upgradePackageException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "selectJavaHeap(String anUCF_Path, String anUP_ProdNo, String anUP_ProdRev)", "\n\tanUCF_Path: " + string + "\n\tanUP_ProdNo: " + string2 + "\n\tanUP_ProdRev " + string3, throwable);
            throw new UpgradePackageException(throwable.toString());
        }
    }

    public Integer selectJavaHeap(RepertoiresProxyInterface repertoiresProxyInterface) throws UpgradePackageException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectJavaHeap(RepertoiresProxyInterface aRepertoiresProxyInterface)", "aRepertoiresProxyInterface: " + repertoiresProxyInterface);
        }
        try {
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
            Integer n = null;
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            Integer n2 = null;
            for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                plugInUnitMoSU_Access = plugInUnitMoSU_AccessArray[i];
                productNumberAndRevisionInterface = piuTypeMO_HandlerInterface.getProductNumberAndRevision((PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(null));
                if (productNumberAndRevisionInterface == null) continue;
                n = this.selectJavaHeap(pIU_MO_HandlerInterface.getSlotMO(plugInUnitMoSU_Access), productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision(), repertoiresProxyInterface);
                if (n2 == null) {
                    n2 = n;
                    continue;
                }
                if (n == null || n2 <= n) continue;
                n2 = n;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "selectJavaHeap(RepertoiresProxyInterface aRepertoiresProxyInterface)", "RETURNS - theJavaHeap: " + n2);
            }
            return n2;
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            throw new UpgradePackageException(jvmMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "selectJavaHeap(RepertoiresProxyInterface aRepertoiresProxyInterface)", "aRepertoiresProxyInterface: " + repertoiresProxyInterface, throwable);
            throw new UpgradePackageException(throwable.toString());
        }
    }

    private Integer selectJavaHeap(SlotMoSU_Access slotMoSU_Access, String string, String string2, RepertoiresProxyInterface repertoiresProxyInterface) throws UpgradePackageException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectJavaHeap(SlotMoSU_Access aSlotMo, String aPiuTypeProductNumber, String aPiuTypeRevision, RepertoiresProxyInterface aRepertoiresProxyInterface)", "aSlotMo: " + slotMoSU_Access + "\n\taPiuTypeProductNumber: " + string + "\n\taPiuTypeRevision: " + string2 + "\n\taRepertoiresProxyInterface: " + repertoiresProxyInterface);
        }
        try {
            SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)slotMoSU_Access.getSwAllocation(null);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "selectJavaHeap(SlotMoSU_Access aSlotMo, String aPiuTypeProductNumber, String aPiuTypeRevision, RepertoiresProxyInterface aRepertoiresProxyInterface)", "Jvm Slot Mo " + slotMoSU_Access + " connected to SwAllocation: " + swAllocationMoSU_Access);
            }
            Vector vector = new SwAllocationHelper().getConnectedRepertoirNames(swAllocationMoSU_Access);
            Collection collection = repertoiresProxyInterface.getPiuTypeRefInformations(vector, string, string2);
            Integer n = this.selectJavaHeap(collection, string, string2);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "selectJavaHeap(SlotMoSU_Access aSlotMo, String aPiuTypeProductNumber, String aPiuTypeRevision, RepertoiresProxyInterface aRepertoiresProxyInterface)", "RETURNS - theSelectedJavaHeap: " + n);
            }
            return n;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "selectJavaHeap(SlotMoSU_Access aSlotMo, String aPiuTypeProductNumber, String aPiuTypeRevision, RepertoiresProxyInterface aRepertoiresProxyInterface)", "aPiuTypeProductNumber: " + string + "\n\taPiuTypeRevision: " + string2 + "\n\taRepertoiresProxyInterface: " + repertoiresProxyInterface, moAccessException);
            throw new UpgradePackageException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "selectJavaHeap(SlotMoSU_Access aSlotMo, String aPiuTypeProductNumber, String aPiuTypeRevision, RepertoiresProxyInterface aRepertoiresProxyInterface)", "aPiuTypeProductNumber: " + string + "\n\taPiuTypeRevision: " + string2 + "\n\taRepertoiresProxyInterface: " + repertoiresProxyInterface, throwable);
            throw new UpgradePackageException(throwable.toString());
        }
    }

    private Integer selectJavaHeap(Collection collection, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectJavaHeap(Collection anPiuTypeRefInformationInterfaces, String aPiuTypeProductNumber, String aPiuTypeProductRevision)", "anPiuTypeRefInformationInterfaces: " + collection + "\n\taPiuTypeProductNumber: " + string + "\n\taPiuTypeProductRevision: " + string2);
        }
        PiuTypeRefInformationInterface piuTypeRefInformationInterface = null;
        Iterator iterator = collection.iterator();
        Integer n = null;
        while (iterator.hasNext() && (n = (piuTypeRefInformationInterface = (PiuTypeRefInformationInterface)iterator.next()).getJavaHeapSize()) == null) {
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectJavaHeap(Collection anPiuTypeRefInformationInterfaces, String aPiuTypeProductNumber, String aPiuTypeProductRevision)", "RETURNS - theJavaHeapSize: " + n);
        }
        return n;
    }
}

