/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.xmlparser.backuprestore;

import se.ericsson.cello.upgradepackage.trace.Trace;

public class BackupRestoreDataHandler {
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    public static final String VERSION_3 = "3";
    public static final String IP_NETWORK_CONFIG_FILE_NAME = "ipnetworkconfig.xml";
    public static final String IP_NETWORK_CONFIG_2_FILE_NAME = "ipnetworkconfig2.xml";
    public static final String NODE_INFORMATION_FILE_NAME = "nodeinformation.xml";
    public static final String NODE_INFORMATION_2_FILE_NAME = "nodeinformation2.xml";
    public static final String UP_LIST_FILE_NAME = "uplist.xml";
    public static final String UP_LIST_2_FILE_NAME = "uplist2.xml";
    public static final String AUTO_CONFIG_FILE_NAME = "autoconfig.xml";
    public static final String IP_ADDRESS_FILE_NAME = "ipaddress.xml";
    public static final String IP_ADDRESS_2_FILE_NAME = "ipaddress2.xml";
    public static final String SUBRACK_INFORMATION_FILE_NAME = "subrackinformation.xml";
    public static final String ARMAMENT_FILE_NAME = "ARMAMENT";
    public static final String LLP_LMID_FILE_NAME = "LLP.LMID";
    public static final String SOFTWARE_INFORMATION_FILE_NAME = "softwareinformation.xml";
    public static final String RESTORE_PROP_FILE_NAME = "restore.prp";
    public static final String DEFAULT_FAN_CONFIGURATION_VALUE = "1";
    public static final String DEFAULT_INTEGRATED_HARDWARE_VALUE = "1";
    public static final int DEFAULT_NONE_INTEGRATED_HARDWARE_VALUE = 0;
    private static BackupRestoreDataHandler myOneAndOnlyInstance = null;
    private String myCurrentVersion = null;
    private String myCurrentFileName = null;
    private boolean myIgnoreTheUnknwn = false;

    private BackupRestoreDataHandler() {
    }

    public static BackupRestoreDataHandler instance() {
        if (myOneAndOnlyInstance != null) {
            return myOneAndOnlyInstance;
        }
        myOneAndOnlyInstance = new BackupRestoreDataHandler();
        return myOneAndOnlyInstance;
    }

    public void setCurrentUpListInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentUpListInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, BackupRestoreDataHandler.getUpListFileName(string));
    }

    public void setCurrentSubrackInformationInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentSubrackInformationInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, SUBRACK_INFORMATION_FILE_NAME);
    }

    public void setCurrentSoftwareInformationInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentSoftwareInformationInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, SOFTWARE_INFORMATION_FILE_NAME);
    }

    public void setCurrentIpNetworkConfigInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentIpNetworkConfigInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, BackupRestoreDataHandler.getIpNetworkConfigFileName(string));
    }

    public void setCurrentNodeInformationInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentNodeInformationInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, BackupRestoreDataHandler.getNodeInformationFileName(string));
    }

    public void setCurrentAutoConfigInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentAutoConfigInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, AUTO_CONFIG_FILE_NAME);
    }

    public void setCurrentIpAddressInfo(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentIpAddressInfo( String aVersion )", "aVersion: " + string);
        }
        this.setCurrentInfo(string, BackupRestoreDataHandler.getIP_AddressFileName(string));
    }

    private void setCurrentInfo(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentInfo( String aVersion )", "aVersion: " + string + "\n\taFileName: " + string2);
        }
        this.setCurrentVersion(string);
        this.setCurrentFileName(string2);
    }

    public void setCurrentVersion(String string, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentVersion(String aVersion, boolean anIgnoreTheUnknown)", "aVersion: " + string + "\n\tanIgnoreTheUnknown: " + bl);
        }
        this.myIgnoreTheUnknwn = bl;
        this.setCurrentVersion(string);
    }

    public void setCurrentVersion(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentVersion(int aVersion)", "aVersion: " + string);
        }
        this.myCurrentVersion = string;
    }

    public String getCurrentVersion() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentVersion()", "myCurrentVersion: " + this.myCurrentVersion);
        }
        return this.myCurrentVersion;
    }

    public boolean currentVersionEqualTo(String string) {
        return Integer.valueOf(this.myCurrentVersion).intValue() == Integer.valueOf(string).intValue();
    }

    public boolean currentVersionGreaterThan(String string) {
        if (Trace.valid(BackupRestoreDataHandler.class, 20)) {
            Trace.debug(BackupRestoreDataHandler.class, 20, "greaterThanVersion(String aReferenceVersion, String aVersion)", "aVersion: " + string);
        }
        return Integer.valueOf(this.myCurrentVersion) > Integer.valueOf(string);
    }

    public static boolean greaterThanVersion(String string, String string2) {
        if (Trace.valid(BackupRestoreDataHandler.class, 20)) {
            Trace.debug(BackupRestoreDataHandler.class, 20, "greaterThanVersion(String aReferenceVersion, String aVersion)", "aReferenceVersion: " + string + "\n\taVersion: " + string2);
        }
        return Integer.valueOf(string2) > Integer.valueOf(string);
    }

    public void setCurrentFileName(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentFileName(String aFileName)", "aFileName: " + string);
        }
        this.myCurrentFileName = string;
    }

    public String getCurrentFileName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentFileName()", "myCurrentFileName: " + this.myCurrentFileName);
        }
        return this.myCurrentFileName;
    }

    public static String getIpNetworkConfigFileName(String string) {
        if (string.equals("1")) {
            return IP_NETWORK_CONFIG_FILE_NAME;
        }
        return IP_NETWORK_CONFIG_2_FILE_NAME;
    }

    public static String getUpListFileName(String string) {
        if (string.equals("1")) {
            return UP_LIST_FILE_NAME;
        }
        return UP_LIST_2_FILE_NAME;
    }

    public static String getNodeInformationFileName(String string) {
        if (string.equals("1")) {
            return NODE_INFORMATION_FILE_NAME;
        }
        return NODE_INFORMATION_2_FILE_NAME;
    }

    public static String getIP_AddressFileName(String string) {
        if (string.equals("1")) {
            return IP_ADDRESS_FILE_NAME;
        }
        return IP_ADDRESS_2_FILE_NAME;
    }

    public boolean getIgnoreTheUnknown() {
        return this.myIgnoreTheUnknwn;
    }

    public void setIgnoreTheUnknown(boolean bl) {
        if (Trace.valid(BackupRestoreDataHandler.class, 20)) {
            Trace.debug(BackupRestoreDataHandler.class, 20, "setIgnoreTheUnknown(boolean anIgnoreTheUnknown)", "anIgnoreTheUnknown: " + bl);
        }
        this.myIgnoreTheUnknwn = bl;
    }
}

