/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.xmlparser.backuprestore;

import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreRevisionAndIndexException;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class BackupRestoreRevisionAndIndex {
    private static final String REVISION_A = "A";
    private static final String REVISION_B = "B";
    public static final int INDEX_0 = 0;
    public static final int INDEX_1 = 1;
    public static final int INDEX_2 = 2;
    public static final int INDEX_3 = 3;
    public static final int INDEX_4 = 4;
    public static final int INDEX_5 = 5;
    public static final int INDEX_6 = 6;
    public static final int INDEX_7 = 7;
    public static final int MASTER_BACKUP_RESTORE_INDEX = 7;

    public static String getBackupRestoreRevision() throws BackupRestoreRevisionAndIndexException {
        return BackupRestoreRevisionAndIndex.checkAndGetMasterBackupRestoreRevision();
    }

    public static int getBackupRestoreIndex() {
        return 7;
    }

    public static String getBackupRestoreIndexString() {
        return String.valueOf(BackupRestoreRevisionAndIndex.getBackupRestoreIndex());
    }

    public static String getOldestBackupRestoreRevision() {
        return REVISION_A;
    }

    public static int getOldestBackupRestoreIndex() {
        return 0;
    }

    public static boolean isEqualToMasterRevision(String string) throws BackupRestoreRevisionAndIndexException {
        String string2 = BackupRestoreRevisionAndIndex.checkAndGetMasterBackupRestoreRevision();
        if (Trace.valid(BackupRestoreRevisionAndIndex.class, 22)) {
            Trace.debug(BackupRestoreRevisionAndIndex.class, 22, "isEqualToMasterRevision(String aComparedRevision)", "aComparedRevision: " + string + "\n\ttheMasterBackupRestoreRevision: " + string2);
        }
        return string2.equalsIgnoreCase(string);
    }

    public static boolean isEqualToBackupRestoreIndex(String string) {
        Integer n;
        if (Trace.valid(BackupRestoreRevisionAndIndex.class, 22)) {
            Trace.debug(BackupRestoreRevisionAndIndex.class, 22, "isEqualToBackupRestoreIndex(String aComparedIndex)", "aComparedIndex: " + string + "\n\tMASTER_BACKUP_RESTORE_INDEX: " + 7);
        }
        return 7 == (n = new Integer(string));
    }

    private static String checkAndGetMasterBackupRestoreRevision() throws BackupRestoreRevisionAndIndexException {
        String string = BackupRestoreRevisionAndIndex.getOldestBackupRestoreRevision();
        SubrackMO_HandlerInterface subrackMO_HandlerInterface = ServiceFinder.getSubrackMO_HandlerInterface();
        try {
            if (subrackMO_HandlerInterface.existSubrackWithFanConfigurationCax()) {
                string = REVISION_B;
            }
        }
        catch (Throwable throwable) {
            throw new BackupRestoreRevisionAndIndexException("Class: " + BackupRestoreRevisionAndIndex.class + "\n\tMethod: checkAndGetMasterBackupRestoreRevision()" + "\n\tThrowable caught when checking if there exist any Cabinet switch subrack with two fans (CAX_TWO). Corresponds to backup restore revision: " + REVISION_B + "\n\tThrowable: " + throwable.toString());
        }
        if (Trace.valid(BackupRestoreRevisionAndIndex.class, 40)) {
            Trace.debug(BackupRestoreRevisionAndIndex.class, 40, "checkAndGetMasterBackupRestoreRevision()", "Returning - theMasterBackupRestoreRevision: " + string);
        }
        return string;
    }
}

