/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.extsuif.util.datacontainer;

import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.InvalidProductRevisionFormatException;

public class ProductNumberAndRevision
implements ProductNumberAndRevisionInterface {
    public String productNumber;
    public String revision;
    private String myLocatorString;
    protected static final String UNDERSCORE = "_";

    public ProductNumberAndRevision(String string, String string2) {
        this.productNumber = string;
        this.revision = string2;
        this.myLocatorString = "Locator is null";
    }

    public ProductNumberAndRevision(String string, String string2, String string3) {
        this.productNumber = string;
        this.revision = string2;
        this.myLocatorString = string3;
    }

    public String getLocatorString() {
        return this.myLocatorString;
    }

    public String getProductNumber() {
        return this.productNumber;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object object) {
        return object instanceof ProductNumberAndRevision && StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(((ProductNumberAndRevision)object).productNumber, this.productNumber) && StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(((ProductNumberAndRevision)object).revision, this.revision);
    }

    public boolean equals(String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"equals(String aProductNumber, String aProductRevision)", (String)(" aProductNumber: " + string + " aProductRevision: " + string2 + " (datacontainer)productNr: " + this.productNumber + " (datacontainer)revision: " + this.revision));
        }
        return StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string, this.productNumber) && StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string2, this.revision);
    }

    public boolean equalsShortRevision(String string, String string2) throws InvalidProductRevisionFormatException {
        return StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string, this.productNumber) && StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string2, ProductNumberAndRevision.getShortProductRevision(this.revision));
    }

    public boolean equalsWildcardRevision(String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"equalsWildcardRevision(String aProductNumber, String aProductRevision)", (String)(" aProductNumber: " + string + " aProductRevision: " + string2 + " (datacontainer)productNr: " + this.productNumber + " (datacontainer)revision: " + this.revision));
        }
        if (string2.equals("*")) {
            return StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string, this.productNumber) || string.equals("*");
        }
        return false;
    }

    public boolean equalsAnyRevisionRule(String string, String string2) throws InvalidProductRevisionFormatException {
        if (this.equals(string, string2)) {
            return true;
        }
        if (this.equalsShortRevision(string, string2)) {
            return true;
        }
        return this.equalsWildcardRevision(string, string2);
    }

    public boolean equalsAnyRevisionRuleForIn(String string, String string2) throws InvalidProductRevisionFormatException {
        if (this.equals(string, string2)) {
            return true;
        }
        if (this.equals(string, ProductNumberAndRevision.getShortProductRevision(string2))) {
            return true;
        }
        return this.equals(string, "*");
    }

    public static String getShortProductRevision(String string) throws InvalidProductRevisionFormatException {
        int n;
        char c;
        if (UpgradeTrace.valid((Class)ProductNumberAndRevision.class, (int)25)) {
            UpgradeTrace.debug((Class)ProductNumberAndRevision.class, (int)25, (String)"getShortProductRevision(String aProductRevision)", (String)("aProductRevision: " + string));
        }
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.endsWith("/")) {
            UpgradeTrace.error((Class)ProductNumberAndRevision.class, (String)"getShortProductRevision(String aProductRevision)", (String)("Product Revision can't end with '/':" + string));
            throw new InvalidProductRevisionFormatException("getShortProductRevision(String aProductRevision)\n\tProduct Revision can't end with '/':" + string);
        }
        if (string.indexOf("/") != -1 && Character.isDigit(c = string.charAt((n = string.indexOf("/")) + 1))) {
            return string;
        }
        n = string.length();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        if (Character.isLetter(cArray[0])) {
            for (n2 = 1; n2 < n && Character.isDigit(cArray[n2]); ++n2) {
            }
        }
        return string.substring(0, n2);
    }

    public String getProductNumberAndRevision() {
        return this.productNumber + UNDERSCORE + this.revision;
    }

    public String toString() {
        return "\n\t\tproductNumber: " + this.productNumber + "\n\t\trevision: " + this.revision;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

