/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import java.util.Collection;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Enumer;
import se.ericsson.cello.sudom.parser.MandatoryElementIsMissingException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionConstraints;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionValue;
import se.ericsson.cello.sudom.parser.dom.ValidateElementInterface;
import se.ericsson.cello.sudom.parser.dom.exceptions.UnexpectedElementException;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public abstract class ElementProperty
extends Enumer
implements ValidateElementInterface {
    protected boolean isMandatory = false;
    protected boolean isElementOfInterest = false;
    private UpgradePackageSyntaxVersionConstraints myUpgradePackageSyntaxVersionConstraints = null;

    public ElementProperty(String string) {
        super(string);
    }

    public ElementProperty(String string, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints, boolean bl) {
        super(string);
        this.isMandatory = bl;
        this.myUpgradePackageSyntaxVersionConstraints = upgradePackageSyntaxVersionConstraints;
    }

    public ElementProperty(String string, boolean bl) {
        super(string);
        this.isMandatory = bl;
    }

    public ElementProperty(String string, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints) {
        super(string);
        this.myUpgradePackageSyntaxVersionConstraints = upgradePackageSyntaxVersionConstraints;
    }

    public ElementProperty(String string, boolean bl, boolean bl2) {
        super(string);
        this.isMandatory = bl;
        this.isElementOfInterest = bl2;
    }

    public boolean getIsElementOfInterest() {
        return this.isElementOfInterest;
    }

    public boolean isElementOfInterest() {
        return this.isElementOfInterest;
    }

    public void setIsElementOfInterest(boolean bl) {
        this.isElementOfInterest = bl;
    }

    public UpgradePackageSyntaxVersionConstraints getUpgradePackageSyntaxVersionConstraints() {
        return this.myUpgradePackageSyntaxVersionConstraints;
    }

    public void validate(String string, Collection collection, Locator locator) throws ValidateException {
        if (collection != null) {
            if (collection.size() > 0) {
                if (!this.isAllowed()) {
                    this.handleUnexpectedElement("validate(String aParentElementName, Collection aValue, Locator aLocator)", string, this.getValue(), locator);
                }
            } else if (this.isMandatory) {
                this.errorMandatoryElementIsMissing("validate(String aParentElementName, Collection aValue, Locator aLocator)", string, this.getValue(), locator);
            }
        } else if (this.isMandatory) {
            this.errorMandatoryElementIsMissing("validate(String aParentElementName, Collection aValue, Locator aLocator)", string, this.getValue(), locator);
        }
    }

    public void validate(String string, ParsedData parsedData, Locator locator) throws ValidateException {
        if (parsedData != null) {
            if (!this.isAllowed()) {
                this.handleUnexpectedElement("validate(String aParentElementName, ParsedData aValue, Locator aLocator)", string, this.getValue(), locator);
            }
        } else if (this.isMandatory) {
            this.errorMandatoryElementIsMissing("validate(String aParentElementName, ParsedData aValue, Locator aLocator)", string, this.getValue(), locator);
        }
    }

    private void debugUnexpectedElement(String string, String string2, String string3, Locator locator) {
        if (UpgradeTrace.valid((Class)ElementProperty.class, (int)25)) {
            UpgradeTrace.debug((Class)ElementProperty.class, (int)25, (String)"debugUnexpectedElement(String anElementName, String aSubElementName, String aSyntaxVersionInfo, Locator aDocumentLocator)", (String)("Element in Upgrade Control File is not allowed for declared (or default) value of attribute 'syntaxVersion'.\n\tElement of type " + string + " contains sub element of not expected type " + string2 + "." + string3 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator) + "\n\tThis mismatch is ignored since attribute 'ignoreUnknownElements' is set to 'yes'."));
        }
    }

    private DocumentObjectInterface errorMandatoryElementIsMissing(String string, String string2, String string3, Locator locator) throws MandatoryElementIsMissingException {
        String string4 = "Upgrade control file error,\n\telement of type " + string2 + " do not contain mandatory sub element " + string3 + ".";
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string4 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new MandatoryElementIsMissingException(string4, locator);
    }

    private void errorUnexpectedElement(String string, String string2, String string3, String string4, Locator locator) throws UnexpectedElementException {
        String string5 = "Upgrade control file error,\n\telement of type " + string2 + " contains sub element of not allowed type " + string3 + "." + string4;
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string5 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedElementException(string5, locator.getLineNumber(), locator.getColumnNumber());
    }

    private void handleUnexpectedElement(String string, String string2, String string3, Locator locator) throws UnexpectedElementException {
        String string4 = "";
        String string5 = CommonDocumentObjectInformation.getInstance().getSyntaxVersion();
        if (!string5.equals("L")) {
            string4 = "\n\tValue of attribute 'syntaxVersion': " + string5 + ".";
        }
        if (CommonDocumentObjectInformation.getInstance().getIgnoreUnknownElements()) {
            this.debugUnexpectedElement(string2, string3, string4, locator);
        } else {
            this.errorUnexpectedElement(string, string2, string3, string4, locator);
        }
    }

    private boolean isAllowed() throws ValidateException {
        if (this.myUpgradePackageSyntaxVersionConstraints == null) {
            return true;
        }
        return UpgradePackageSyntaxVersionValue.isAllowed(CommonDocumentObjectInformation.getInstance().getSyntaxVersion(), this.myUpgradePackageSyntaxVersionConstraints);
    }
}

