/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.productdata;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductDataInterface;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataAttributeName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class ProductData
extends ParsedData
implements DocumentObjectInterface,
ProductDataInterface,
ProductNumberAndRevisionInterface {
    private String myNumber = null;
    private String myRevision = null;
    private String myName = null;
    private String myDate = null;
    private String myType = null;
    private String myInformation = null;
    private String myNumberRaw = null;
    private String myRevisionRaw = null;

    public ProductData(String string, String string2, String string3, String string4, String string5, String string6) {
        this.myNumber = string;
        this.myRevision = string2;
        this.myName = string3;
        this.myDate = string4;
        this.myType = string5;
        this.myInformation = string6;
        this.optimizeNumberAndRevision();
    }

    public ProductData(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProductData(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = ProductDataAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("InstallLM(AttributeList anAttributeList, Locator aLocator)", "ProductData", stringArray, locator);
        }
        this.myNumber = attributeList.getValue(ProductDataAttributeName.Number.getValue());
        this.myRevision = attributeList.getValue(ProductDataAttributeName.Revision.getValue());
        this.myName = attributeList.getValue(ProductDataAttributeName.Name.getValue());
        this.myDate = attributeList.getValue(ProductDataAttributeName.Date.getValue());
        this.myType = attributeList.getValue(ProductDataAttributeName.Type.getValue());
        this.myInformation = attributeList.getValue(ProductDataAttributeName.Information.getValue());
        this.optimizeNumberAndRevision();
    }

    public ProductData(String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProductData(String aNumber, String aRevision)", (String)("aNumber: " + string + "\n\taRevision: " + string2));
        }
        this.myNumber = string;
        this.myRevision = string2;
        this.optimizeNumberAndRevision();
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "ProductData", string, locator);
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + "ProductData");
        if (this.myNumber != null) {
            printStream.println(string + "  " + ProductDataAttributeName.Number.getValue() + " = \"" + this.getNumberRaw() + "\"");
        }
        if (this.myRevision != null) {
            printStream.println(string + "  " + ProductDataAttributeName.Revision.getValue() + " = \"" + this.getRevisionRaw() + "\"");
        }
        if (this.myName != null) {
            printStream.println(string + "  " + ProductDataAttributeName.Name.getValue() + " = \"" + this.myName + "\"");
        }
        if (this.myDate != null) {
            printStream.println(string + "  " + ProductDataAttributeName.Date.getValue() + " = \"" + this.myDate + "\"");
        }
        if (this.myType != null) {
            printStream.println(string + "  " + ProductDataAttributeName.Type.getValue() + " = \"" + this.myType + "\"");
        }
        if (this.myInformation != null) {
            printStream.println(string + "  " + ProductDataAttributeName.Information.getValue() + " = \"" + this.myInformation + "\"");
        }
        printStream.println(string + "/>");
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("validate()\n\tmyProductData: " + this));
        }
        ProductDataAttributeName.Number.validate(this.getNumberRaw(), super.getLocatorData(), false);
        ProductDataAttributeName.Revision.validate(this.getRevisionRaw(), super.getLocatorData(), false);
        ProductDataAttributeName.Name.validate(this.myName, super.getLocatorData(), false);
        ProductDataAttributeName.Date.validate(this.myDate, super.getLocatorData(), false);
        ProductDataAttributeName.Type.validate(this.myType, super.getLocatorData(), false);
        ProductDataAttributeName.Information.validate(this.myInformation, super.getLocatorData(), false);
    }

    public String getNumber() {
        return this.myNumber;
    }

    public String getProductNumber() {
        return this.getNumber();
    }

    public String getNumberRaw() {
        if (this.myNumberRaw != null) {
            return this.myNumberRaw;
        }
        return this.myNumber;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public String getRevisionRaw() {
        if (this.myRevisionRaw != null) {
            return this.myRevisionRaw;
        }
        return this.myRevision;
    }

    public String getName() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getName()");
        }
        return this.myName;
    }

    public String getDate() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDate()");
        }
        return this.myDate;
    }

    public String getType() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getType()");
        }
        return this.myType;
    }

    public String getInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInformation()");
        }
        return this.myInformation;
    }

    public void setNumber(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setNumber(String aNumber)", (String)("aNumber: " + string));
        }
        this.myNumber = string;
        this.myNumberRaw = null;
        this.optimizeNumber();
    }

    public void setRevision(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRevision(String aRevision)", (String)("aRevision: " + string));
        }
        this.myRevision = string;
        this.myRevisionRaw = null;
        this.optimizeRevision();
    }

    public void setName(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setName(String aName)", (String)("aName: " + string));
        }
        this.myName = string;
    }

    public void setDate(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDate(String aDate)", (String)("aDate: " + string));
        }
        this.myDate = string;
    }

    public void setType(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setType(String aType)", (String)("aType: " + string));
        }
        this.myType = string;
    }

    public void setInformation(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setInformation(String anInformation)", (String)("anInformation: " + string));
        }
        this.myInformation = string;
    }

    public String toString() {
        String string = "\n\tmyNumber: " + this.myNumber;
        if (this.myNumberRaw != null) {
            string = string + "\n\tmyNumberRaw: " + this.myNumberRaw;
        }
        string = string + "\n\tmyRevision: " + this.myRevision;
        if (this.myRevisionRaw != null) {
            string = string + "\n\tmyRevisionRaw: " + this.myRevisionRaw;
        }
        return string + "\n\tmyName: " + this.myName + "\n\tmyDate: " + this.myDate + "\n\tmyType: " + this.myType + "\n\tmyInformation: " + this.myInformation;
    }

    private void optimizeNumberAndRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimizeNumberAndRevision( )");
        }
        this.optimizeNumber();
        this.optimizeRevision();
    }

    private void optimizeNumber() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimizeNumber( )");
        }
        if (StringHandler.isContainingWhiteSpaceOrLowerCase(this.myNumber)) {
            this.myNumberRaw = this.myNumber;
            this.myNumber = StringHandler.optimize(this.myNumberRaw);
        }
    }

    private void optimizeRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"optimizeRevision( )");
        }
        if (StringHandler.isContainingWhiteSpaceOrLowerCase(this.myRevision)) {
            this.myRevisionRaw = this.myRevision;
            this.myRevision = StringHandler.optimize(this.myRevisionRaw);
        }
    }
}

