/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Type;
import se.ericsson.cello.sudom.parser.dom.AttributeProperty;
import se.ericsson.cello.sudom.parser.dom.AttributeValidationInterface;
import se.ericsson.cello.sudom.parser.dom.AttributeValueValidator;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionConstraints;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefLoaderNameValue;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadListSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class LoadModuleRefAttributeName
extends AttributeProperty
implements AttributeValidationInterface {
    public static final LoadModuleRefAttributeName Tag = new LoadModuleRefAttributeName("tag", true, Type.Int);
    public static final LoadModuleRefAttributeName ProductNumber = new LoadModuleRefAttributeName("productNumber", true, Type.String, 8, 24);
    public static final LoadModuleRefAttributeName Revision = new LoadModuleRefAttributeName("revision", true, Type.String, 1, 7);
    public static final LoadModuleRefAttributeName ProgramMemoryPoolSize = new LoadModuleRefAttributeName("programMemoryPoolSize", false, Type.Int);
    public static final LoadModuleRefAttributeName ProgramMemoryHeapSize = new LoadModuleRefAttributeName("programMemoryHeapSize", false, Type.Int);
    public static final LoadModuleRefAttributeName ProgramInstances = new LoadModuleRefAttributeName("programInstances", new UpgradePackageSyntaxVersionConstraints("PV1"));
    public static final LoadModuleRefAttributeName LoaderName = new LoadModuleRefAttributeName("loaderName", new UpgradePackageSyntaxVersionConstraints("PY1"));
    public static final LoadModuleRefAttributeName DeviceLoaderName = new LoadModuleRefAttributeName("deviceLoaderName", new UpgradePackageSyntaxVersionConstraints("PY1"));
    public static final LoadModuleRefAttributeName DeviceLoaderInformation = new LoadModuleRefAttributeName("deviceLoaderInformation", new UpgradePackageSyntaxVersionConstraints("PY1"));
    public static final LoadModuleRefAttributeName RestartCounterLimit = new LoadModuleRefAttributeName("restartCounterLimit", new UpgradePackageSyntaxVersionConstraints("PAG1"), Type.Int);
    public static final LoadModuleRefAttributeName RestartTimer = new LoadModuleRefAttributeName("restartTimer", new UpgradePackageSyntaxVersionConstraints("PAG1"), Type.Int);
    private Type typeOfValue = Type.String;
    private int minLength = 0;
    private int maxLength = 0;
    private static final int DeviceLoaderNameMaxLength = 80;
    private static final int DeviceLoaderInformationMaxLength = 255;

    private LoadModuleRefAttributeName(String string) {
        super(string);
    }

    private LoadModuleRefAttributeName(String string, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints) {
        super(string, upgradePackageSyntaxVersionConstraints);
    }

    private LoadModuleRefAttributeName(String string, boolean bl, Type type) {
        super(string, bl);
        this.typeOfValue = type;
    }

    private LoadModuleRefAttributeName(String string, UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints, Type type) {
        super(string, upgradePackageSyntaxVersionConstraints);
        this.typeOfValue = type;
    }

    private LoadModuleRefAttributeName(String string, boolean bl, Type type, int n, int n2) {
        super(string, bl);
        this.minLength = n;
        this.maxLength = n2;
    }

    public boolean equals(Object object) {
        if (object instanceof LoadModuleRefAttributeName) {
            return super.equals(((LoadModuleRefAttributeName)object).getValue());
        }
        return super.equals(object);
    }

    public static String[] verifyNames(AttributeList attributeList) {
        String[] stringArray = new String[]{Tag.getValue(), ProductNumber.getValue(), Revision.getValue(), ProgramMemoryPoolSize.getValue(), ProgramMemoryHeapSize.getValue(), ProgramInstances.getValue(), LoaderName.getValue(), DeviceLoaderName.getValue(), DeviceLoaderInformation.getValue(), RestartCounterLimit.getValue(), RestartTimer.getValue()};
        return LoadModuleRefAttributeName.verifyNames(attributeList, stringArray);
    }

    public void validate(String string, Locator locator, boolean bl) throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate(String aValue, Locator aLocator, boolean anIsTransform)", (String)("aValue: " + string + "\n\tanIsTransform: " + bl));
        }
        super.validate(PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), string, locator);
        if (string != null) {
            if (!this.typeOfValue.isValid(string)) {
                super.errorUnexpectedAttributeFormat(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, this.typeOfValue.getValue(), locator);
            } else if (super.getValue().equals(Tag.getValue())) {
                int n = string.lastIndexOf(" ");
                if (n != -1) {
                    String string2 = "\n\n\tThis attribute must not contain white-space characters.\n\tThe attribute contains a white-space character at position " + ++n + ".";
                    this.errorIllegalAttributeValue(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, string2, locator);
                }
            } else if (super.getValue().equals(ProductNumber.getValue()) || super.getValue().equals(Revision.getValue())) {
                AttributeValueValidator.validateLength(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, locator, this.minLength, this.maxLength);
            } else if (super.getValue().equals(ProgramInstances.getValue())) {
                ProgramInstancesValue.validate(string, locator);
            } else if (super.getValue().equals(LoaderName.getValue())) {
                if (!LoadModuleRefLoaderNameValue.validate(string)) {
                    super.errorIllegalAttributeValue(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, locator, bl);
                }
            } else if (super.getValue().equals(DeviceLoaderName.getValue())) {
                if (string.length() > 80) {
                    super.errorAttributeValueOutOfRange(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, "Max length: 80", locator);
                }
            } else if (super.getValue().equals(DeviceLoaderInformation.getValue())) {
                if (string.length() > 255) {
                    super.errorAttributeValueOutOfRange(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, "Max length: 255", locator);
                }
            } else if (super.getValue().equals(RestartCounterLimit.getValue())) {
                if (new Integer(string) < -1) {
                    String string3 = "\n\n\tThis attribute must be greater than or equal to -1.";
                    this.errorIllegalAttributeValue(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, string3, locator);
                } else if (new Integer(string) > 65535) {
                    String string4 = "\n\n\tThis attribute must be less than or equal to 65535.";
                    this.errorIllegalAttributeValue(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, string4, locator);
                }
            } else if (super.getValue().equals(RestartTimer.getValue())) {
                if (new Integer(string) < -1) {
                    String string5 = "\n\n\tThis attribute must be greater than or equal to -1.";
                    this.errorIllegalAttributeValue(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, string5, locator);
                } else if (new Integer(string) > 65535) {
                    String string6 = "\n\n\tThis attribute must be less than or equal to 65535.";
                    this.errorIllegalAttributeValue(this.getClass(), "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), super.getValue(), string, string6, locator);
                }
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

