/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.upgradelogic;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.SuLmRef;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.UpgradeLogic;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxy;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleReplacementContainer;

public class UpgradeLogicProxy
implements UpgradeLogicProxyInterface {
    private UpgradeLogic myUpgradeLogic = null;
    private static final int DEFAULT_COMPATIBILITY_INDEX = -1;
    private DocumentObjectUpgradePackage myDocumentObjectUpgradePackage = null;

    public UpgradeLogicProxy(UpgradeLogic upgradeLogic, DocumentObjectUpgradePackage documentObjectUpgradePackage) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"UpgradeLogicProxy(UpgradeLogic anUpgradeLogic, DocumentObjectUpgradePackage aDocumentObjectUpgradePackage)", (String)("anUpgradeLogic: " + upgradeLogic + "\n\taDocumentObjectUpgradePackage: " + documentObjectUpgradePackage));
        }
        this.myUpgradeLogic = upgradeLogic;
        this.myDocumentObjectUpgradePackage = documentObjectUpgradePackage;
    }

    public UpgradeLogicInterface getUpgradeLogic() {
        return this.myUpgradeLogic;
    }

    public DocumentObjectUpgradePackage getDocumentObjectUpgradePackage() {
        return this.myDocumentObjectUpgradePackage;
    }

    public void setUpgradeLogic(UpgradeLogicInterface upgradeLogicInterface) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setUpgradeLogic(UpgradeLogicInterface anUpgradeLogic)", (String)("anUpgradeLogic: " + upgradeLogicInterface));
        }
        if (upgradeLogicInterface != null) {
            this.myDocumentObjectUpgradePackage.setUpgradeLogic((UpgradeLogic)upgradeLogicInterface);
        }
    }

    public int getCompatibilityIndex() {
        if (this.myUpgradeLogic == null) {
            return -1;
        }
        return this.myUpgradeLogic.getCompatibilityIndexAsint();
    }

    public Collection getLoadModules() {
        if (this.myUpgradeLogic == null) {
            return new Vector();
        }
        return this.myUpgradeLogic.getSuLmRefs();
    }

    public LoadModulesProxyInterface getLoadModulesProxyInterface() {
        DocumentObjectProxy documentObjectProxy = new DocumentObjectProxy(this.myDocumentObjectUpgradePackage);
        return documentObjectProxy.getLoadModulesProxyInterface();
    }

    public String getName() {
        if (this.myUpgradeLogic == null) {
            return null;
        }
        return this.myUpgradeLogic.getName();
    }

    private int getIndexOfLoadModuleRef(ProductNumberAndRevision productNumberAndRevision, ProductNumberAndRevision productNumberAndRevision2, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIndexOfLoadModuleRef(ProductNumberAndRevision aProductNumberAndRevision, Vector aLoadModuleRefs)", (String)("aProductNumberAndRevisionOfOldLM: " + productNumberAndRevision + "\n\taProductNumberAndRevisionOfNewLM: " + productNumberAndRevision2 + "\n\taLoadModuleRefs: " + vector));
        }
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            SuLmRef suLmRef = (SuLmRef)iterator.next();
            if (productNumberAndRevision.revision.equals("*") && suLmRef.getProductNumber().equals(productNumberAndRevision.productNumber) && !suLmRef.getRevision().equals(productNumberAndRevision2.revision)) {
                return n;
            }
            if (productNumberAndRevision.equals(suLmRef.getProductNumber(), suLmRef.getRevision())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void replaceSuLoadModuleRefs(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"replaceSuLoadModuleRefs(Vector aLoadModuleReplacementContainers)", (String)("aLoadModuleReplacementContainers: " + vector));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            LoadModuleReplacementContainer loadModuleReplacementContainer = (LoadModuleReplacementContainer)iterator.next();
            Vector vector2 = (Vector)this.myUpgradeLogic.getSuLmRefs();
            Vector vector3 = loadModuleReplacementContainer.getOldLMs();
            ProductNumberAndRevision productNumberAndRevision = loadModuleReplacementContainer.getNewLM();
            Iterator iterator2 = vector3.iterator();
            while (iterator2.hasNext()) {
                ProductNumberAndRevision productNumberAndRevision2 = (ProductNumberAndRevision)iterator2.next();
                if (productNumberAndRevision2.equals(productNumberAndRevision)) continue;
                int n = this.getIndexOfLoadModuleRef(productNumberAndRevision2, productNumberAndRevision, vector2);
                while (n >= 0) {
                    SuLmRef suLmRef = (SuLmRef)vector2.elementAt(n);
                    Locator locator = suLmRef.getLocatorData();
                    vector2.removeElementAt(n);
                    int n2 = this.getIndexOfLoadModuleRef(productNumberAndRevision, productNumberAndRevision, vector2);
                    if (n2 < 0) {
                        vector2.addElement(new SuLmRef(locator, productNumberAndRevision));
                    }
                    n = this.getIndexOfLoadModuleRef(productNumberAndRevision2, productNumberAndRevision, vector2);
                }
            }
        }
    }
}

