/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.control;

import java.io.File;
import java.io.FileReader;
import java.util.EventObject;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.cello.configurationversion.service.ServiceController;
import se.ericsson.cello.configurationversion.service.ServiceTypeInformation;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.classloader.DynamicClassLoaderCentral;
import se.ericsson.cello.su.convert.step.SU_TriggerHandler;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradeException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.datacontainer.UpgradeProgressInformation;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.oneclickupgrade.OneClickUpgradeController;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.parser.InvalidMainElementNameException;
import se.ericsson.cello.sudom.parser.ParserFactoryException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.AWTEventMulticaster;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.create.CreateException;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreator;
import se.ericsson.cello.upgradepackage.information.ReferringConfigurationVersionsController;
import se.ericsson.cello.upgradepackage.information.event.ReadRefCV_InfoRequestEvent;
import se.ericsson.cello.upgradepackage.install.CancelInstallRequestException;
import se.ericsson.cello.upgradepackage.install.UpgradePackageInstaller;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallRejectedEvent;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallResponseEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRejectedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallResponseEvent;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.exception.BusyMarkException;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ControllerClientInterface;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.AttributePiusUpgradeInformationHandlerInterface;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.readsupportedupgradetypesstatus.ReadSupportedUpgradeTypesStatusService;
import se.ericsson.cello.upgradepackage.readsupportedupgradetypesstatus.ReadSupportedUpgradeTypesStatusServiceException;
import se.ericsson.cello.upgradepackage.readsupportedupgradetypesstatus.event.ReadSupportedUpgradeTypesStatusRequestEvent;
import se.ericsson.cello.upgradepackage.readsupportedupgradetypesstatus.event.ReadSupportedUpgradeTypesStatusResponseEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkController;
import se.ericsson.cello.upgradepackage.shrink.ShrinkRequestEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandler;
import se.ericsson.cello.upgradepackage.trace.exception.SUExceptionTrace;
import se.ericsson.cello.upgradepackage.update.UpdateController;
import se.ericsson.cello.upgradepackage.update.event.UpdateRequestEvent;
import se.ericsson.cello.upgradepackage.upgrade.UpgradePackageUpgrader;
import se.ericsson.cello.upgradepackage.upgrade.event.UpgradeRequestEvent;
import se.ericsson.cello.upgradepackage.upgrade.exception.UpgradeRejectedException;
import se.ericsson.cello.upgradepackage.upgrade.parser.opgroupcreator.OpGroupCreatorSAXdh;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.NoJvmRestartNeededSinceNoChangeInClassPathException;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootnodeupgrade.RebootNodeUpgradeOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.UnlockAndWaitOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.WaitForLockedOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.WaitOp;
import se.ericsson.cello.upgradepackage.upgrade.step.trigger.TriggerCentralHandlerInterface;
import se.ericsson.cello.upgradepackage.util.datacontainer.ExecutionOfUpgradeSequenceFinishedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.JVM_RestartRequestContinueInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeRestartFailureReqInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeRestartReqInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgramAdditionRemovalInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.RebootPlugInUnitInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.SoftPIU_UpgradeRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeExecutionFailedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.WaitingForConfirmUpgrade;
import se.ericsson.cello.upgradepackage.util.datacontainer.WaitingForResumeUpgrade;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.verify.Verifier;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;

public class UpgradeCoordinator
implements Runnable,
UpgradeParticipator,
PropertyChangeListener,
ActionListener {
    private static final int RUN_SEQ_LOOP = 0;
    private static final int STOP_GRACEFULLY = 1;
    private static final String UPGRADE_CONTROLLER_PARTICIPATOR_NAME = "Cello CMA Upgrade Package Controller";
    private boolean isBusy = false;
    private String myStepLabel;
    private String qcmdUpgCaseId;
    private int seqExecutionState;
    private ExecutableOp myStepOps;
    private boolean myStepContainsRebootProgramUpgrade = false;
    private boolean myStepContainsSoftPiuUpgrade = false;
    private UpgradePackageMoExtended myUpgradePackageMo = null;
    private UpgradePackageInstaller myUpgradePackageInstaller = null;
    private UpgradePackageInstaller myUpgradePackageCancelInstaller = null;
    private static UpgradeCoordinator instance;
    private File qcmdUpgradeControlFile;
    private UpgradePackageUpgrader myUpgradePackageUpgrader = null;
    private BlockingQueue inQueue = new BlockingQueue();
    private ActionListener observers;
    private ShrinkController myShrinkController = null;
    private UpdateController myUpdateController = null;
    private ControllerClientInterface myClient = null;
    private ReferringConfigurationVersionsController myReferringConfigurationVersionsController = null;
    private String myExecutedStepLabel = "";

    public String getMyExecutedStepLabel() {
        return this.myExecutedStepLabel;
    }

    public void setMyExecutedStepLabel(String string) {
        this.myExecutedStepLabel = string;
    }

    private UpgradeCoordinator() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeCoordinator (new) () ");
        }
        instance = this;
    }

    public UpdateController getMyUpdateController() {
        return this.myUpdateController;
    }

    public void setMyUpdateController(UpdateController updateController) {
        this.myUpdateController = updateController;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionPerformed(ActionEvent anActionEvent)", "\n\tanActionEvent: " + actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addActionListener( ActionListener al )", "al: " + actionListener);
        }
        this.observers = AWTEventMulticaster.add((ActionListener)this.observers, (ActionListener)actionListener);
    }

    public void busyMark(ControllerClientInterface controllerClientInterface, ServiceSubType serviceSubType) throws BusyMarkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark(ControllerClientInterface aClient)", "aClient: " + controllerClientInterface + "\n\taServiceSubType: " + serviceSubType);
        }
        if (controllerClientInterface == null) {
            throw new BusyMarkException("Invalid input data when attemting to busy mark the System Upgrade function.\n\taClient: null ");
        }
        if (!this.lock(serviceSubType)) {
            ServiceTypeInformation serviceTypeInformation = ServiceController.instance().getExecutingServiceTypeInformation();
            String string = "\n\texecuting service: " + serviceTypeInformation.getServiceType().getValue();
            if (!serviceTypeInformation.getServiceSubType().getValue().equals(ServiceSubType.none.getValue())) {
                string = string + "\n\texecuting function: " + serviceTypeInformation.getServiceSubType().getValue();
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "busyMark(ControllerClientInterface aClient, ServiceSubType aServiceSubType)", "Not possible to busy mark i.e. an other interacting service is already in execution.\n\taClient: " + controllerClientInterface + "\n\taServiceSubType: " + serviceSubType + "\n\tmyClient: " + this.myClient + string);
            }
            throw new BusyMarkException("Start of Execution of a System Upgrade function is currently not allowed.\n\tNot possible to busy mark due to an other interacting service is already in execution.\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient + string);
        }
        this.myClient = controllerClientInterface;
    }

    public void readReferringCvInformationRequest(ControllerClientInterface controllerClientInterface, ReadRefCV_InfoRequestEvent readRefCV_InfoRequestEvent) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "readReferringCvInformationRequest(ControllerClientInterface aClient, ReadRefCV_InfoRequestEvent aReadRefCV_InfoRequestEvent)", "aClient: " + controllerClientInterface + "\n\taReadRefCV_InfoRequestEvent: " + readRefCV_InfoRequestEvent);
        }
        if (!this.isBusy || controllerClientInterface == null || !controllerClientInterface.equals(this.myClient)) {
            throw new ActionNotAllowedException("Not allowed to continue the execution of the read referring ConfigurationVersions request since illegal input behaviour.\n\tisBusy: " + this.isBusy + "\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient);
        }
        this.inQueue.enqueue((Object)readRefCV_InfoRequestEvent);
    }

    public void readReferringCvInformationResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "readReferringCvInformationResponse()");
        }
        if (this.myReferringConfigurationVersionsController != null) {
            this.myReferringConfigurationVersionsController = null;
        }
        if (this.myClient != null) {
            this.myClient.finished();
        } else {
            Trace.warning(this.getClass(), "readReferringCvInformationResponse()", "A read referring configuration versions response was received when no client is expecting it (ignored).");
        }
    }

    public void cancelInstallRequest(CancelInstallRequestEvent cancelInstallRequestEvent) throws CancelInstallRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelInstallRequest ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "aCancelInstallRequestEvent: " + cancelInstallRequestEvent);
        }
        if (this.isLocked()) {
            if (this.myUpgradePackageInstaller == null) {
                Trace.info(this.getClass(), "cancelInstallRequest ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "Cancellation of an ongoing installation is rejected due to no installation is currently executing.\n\tisLocked: true");
                throw new CancelInstallRequestException("Cancellation of an ongoing installation is rejected due to no installation is currently executing.");
            }
        } else {
            Trace.info(this.getClass(), "cancelInstallRequest ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "Cancellation of an ongoing installation is rejected due to no installation is currently executing.\n\tisLocked: false");
            throw new CancelInstallRequestException("Cancellation of an ongoing installation is rejected due to no installation is currently executing");
        }
        this.inQueue.enqueue((Object)cancelInstallRequestEvent);
    }

    public void cancelInstallResponse(CancelInstallResponseEvent cancelInstallResponseEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelInstallResponse ( CancelInstallResponseEvent aCancelInstallResponseEvent )", "aCancelInstallResponseEvent: " + cancelInstallResponseEvent);
        }
        this.inQueue.enqueue((Object)cancelInstallResponseEvent);
    }

    public void doPerformNodeRestart(RestartReasonEnum restartReasonEnum) {
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doPerformNodeRestart ()");
        }
        String string = "doPerformNodeRestart(RestartReasonEnum anReason)";
        try {
            Trace.log1(this.getClass(), string, "Requesting node to be restarted within 5000 milliseconds.");
            TimeHandler.sleep(5000L);
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), string, "Error when attemting to inform all involved parties about the coming node restart.", exception);
        }
        try {
            configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string2 = configurationVersionMO_HandlerInterface.getStartableCV();
            if (configurationVersionMO_HandlerInterface.isAnUpgradeTemporaryCV(string2)) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Setting Rollback CV as startable.");
                }
                String string3 = configurationVersionMO_HandlerInterface.setRollbackCVAsStartable();
                UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
                configurationVersionMO_HandlerInterface.setRollbackData();
                String string4 = configurationVersionMO_HandlerInterface.createMainNameForCV("Rb", upgradePackageMoExtended.getDocumentNumber(null), upgradePackageMoExtended.getDocumentRevision(null));
                if (!string3.startsWith(string4)) {
                    Trace.info(this.getClass(), "doPerformNodeRestart ()", "The first CV in the roll back list is not the one expected.\n\ttheRollbackCVSetAsStartable: " + string3 + "\n\ttheRollbackCvNameWithoutTimestamp: " + string4);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught when trying to set rollback CV and data.", throwable);
        }
        try {
            configurationVersionMO_HandlerInterface = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo();
            ((ManagedElementMoSU_Access)configurationVersionMO_HandlerInterface).systemInitiatedRestartFromSU(0, restartReasonEnum.getValue(), "", null);
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), string, "Exception when requesting for a node restart.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedObject createUP_Request(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject3;
        block15: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createUP_Request(ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, Coordinator aContext)", "aParent: " + managedObject + "\n\tanAttributeList: " + attrList + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taContext: " + coordinator);
            }
            UpgradePackageMoImpl upgradePackageMoImpl = null;
            if (!this.lock(ServiceSubType.createUP)) {
                ServiceTypeInformation serviceTypeInformation = ServiceController.instance().getExecutingServiceTypeInformation();
                String string2 = "\n\texecuting service: " + serviceTypeInformation.getServiceType().getValue();
                if (serviceTypeInformation.getServiceSubType().getValue().equals(ServiceSubType.none.getValue())) throw new ActionNotAllowedException("The creation of the UP MO is not allowed due to that an interacting service is executing," + string2);
                string2 = string2 + "\n\texecuting function: " + serviceTypeInformation.getServiceSubType().getValue();
                throw new ActionNotAllowedException("The creation of the UP MO is not allowed due to that an interacting service is executing," + string2);
            }
            try {
                try {
                    ManagedObject managedObject4 = UpgradePackageCreator.create(managedObject, attrList, string, managedObject2, coordinator);
                    if (managedObject4 instanceof UpgradePackageMoImpl) {
                        upgradePackageMoImpl = (UpgradePackageMoImpl)managedObject4;
                    } else {
                        Trace.error(this.getClass(), "createUP_Request(ManagedObject aParent, AttrList anAttributeList, String anIdentity, ManagedObject aSource, Coordinator aContext)", "\n\ttheUpgradePackageMo " + managedObject4 + "\n\tRecevied wrong instance from upgrade package creator");
                    }
                    managedObject3 = managedObject4;
                    Object var10_14 = null;
                    if (upgradePackageMoImpl == null) break block15;
                }
                catch (CreateException createException) {
                    throw createException;
                }
                catch (Throwable throwable) {
                    SUExceptionTrace.traceWhenNeeded(this.getClass(), throwable, 0, "create ( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator aContext )", "At execution of create operation");
                    if (SUExceptionTrace.needWrapping(throwable, 0)) {
                        throw new CreateException(throwable.toString());
                    }
                    if (throwable instanceof MoAccessException) {
                        throw (MoAccessException)throwable;
                    }
                    SUExceptionTrace.throwOriginal(throwable);
                    ManagedObject managedObject5 = null;
                    Object var10_15 = null;
                    if (upgradePackageMoImpl != null && OneClickUpgradeController.isOneClickUpgrade(upgradePackageMoImpl.getDocumentNumberOpt(), upgradePackageMoImpl.getDocumentRevisionOpt())) {
                        new OneClickUpgradeController(1, upgradePackageMoImpl, coordinator);
                        return managedObject5;
                    }
                    this.unlock(ServiceSubType.createUP);
                    return managedObject5;
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (upgradePackageMoImpl != null && OneClickUpgradeController.isOneClickUpgrade(upgradePackageMoImpl.getDocumentNumberOpt(), upgradePackageMoImpl.getDocumentRevisionOpt())) {
                    new OneClickUpgradeController(1, upgradePackageMoImpl, coordinator);
                    throw throwable;
                }
                this.unlock(ServiceSubType.createUP);
                throw throwable;
            }
            if (OneClickUpgradeController.isOneClickUpgrade(upgradePackageMoImpl.getDocumentNumberOpt(), upgradePackageMoImpl.getDocumentRevisionOpt())) {
                new OneClickUpgradeController(1, upgradePackageMoImpl, coordinator);
                return managedObject3;
            }
        }
        this.unlock(ServiceSubType.createUP);
        return managedObject3;
    }

    public void executeJvmLastIteration(UpgradePackageMoImpl upgradePackageMoImpl, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, int n, boolean bl, AttributePiusUpgradeInformationHandlerInterface attributePiusUpgradeInformationHandlerInterface) throws UpgradeRejectedException, MoAccessException, SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeJvmLastIteration(UpgradePackageMoImpl anUpgradePackageMoImpl,Vector aPIUsToBeRestarted, Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsLockedByUpgrade, Vector aNonSupportedPIUsLockedByUpgrade, int aStartupDelay, boolean aNoReliableProgramMove, AttributePiusUpgradeInformationHandlerInterface anAttributePiusUpgradeInformationHandlerInterface)", "aPIUsToBeRestarted: " + vector + "\n\taFaultyPIUsLockedBeforeUpgrade: " + vector2 + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector3 + "\n\taFaultyPIUsLockedByUpgrade: " + vector4 + "\n\taNonSupportedPIUsLockedByUpgrade: " + vector5 + "\n\taStartupDelay: " + n + "\n\taNoReliableProgramMove: " + bl + "\n\tanAttributePiusUpgradeInformationHandlerInterface: " + attributePiusUpgradeInformationHandlerInterface);
        }
        WaitForLockedOp waitForLockedOp = new WaitForLockedOp((Vector)vector.clone(), attributePiusUpgradeInformationHandlerInterface);
        WaitOp waitOp = new WaitOp(n, bl);
        UnlockAndWaitOp unlockAndWaitOp = new UnlockAndWaitOp((Vector)vector.clone(), vector2, vector3, bl);
        try {
            if (bl) {
                waitOp.executeOp(null);
                unlockAndWaitOp.executeOp(null);
            } else {
                ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = this.getJvmRpu();
                if (this.isOperModeAsConfigured(reliableProgramUniterMoSU_Access)) {
                    if (this.isAffectedPiuOnPassiveSlot(reliableProgramUniterMoSU_Access, vector)) {
                        waitForLockedOp.executeOp(null);
                        waitOp.executeOp(null);
                        unlockAndWaitOp.executeOp(null);
                    } else {
                        unlockAndWaitOp.executeOp(null);
                    }
                } else {
                    waitForLockedOp.executeOp(null);
                    this.setJvmPiuEventCallback((Vector)vector.clone(), bl, n);
                    waitOp.executeOp(null);
                }
            }
        }
        catch (SAXException sAXException) {
            Trace.info(this.getClass(), "executeJvmLastIteration(UpgradePackageMoImpl anUpgradePackageMoImpl,Vector aPIUsToBeRestarted, Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsLockedByUpgrade, Vector aNonSupportedPIUsLockedByUpgrade, int aStartupDelay, boolean aNoReliableProgramMove, AttributePiusUpgradeInformationHandlerInterface anAttributePiusUpgradeInformationHandlerInterface)", "Error when continuing JVM upgrade.\n\taPIUsToBeRestarted: " + vector + "\n\taFaultyPIUsLockedBeforeUpgrade: " + vector2 + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector3 + "\n\taFaultyPIUsLockedByUpgrade: " + vector4 + "\n\taNonSupportedPIUsLockedByUpgrade: " + vector5 + "\n\taStartupDelay: " + n + "\n\taNoReliableProgramMove: " + bl + "\n\tanAttributePiusUpgradeInformationHandlerInterface: " + attributePiusUpgradeInformationHandlerInterface + "\n\tException reason: " + sAXException.toString() + sAXException);
            this.setJvmPiuEventCallback(new Vector(), bl, 0);
            if (!upgradePackageMoImpl.getIsSU_CV_ForPiuUpgradeCreated()) {
                RebootNodeUpgradeOp rebootNodeUpgradeOp = new RebootNodeUpgradeOp(upgradePackageMoImpl, this.myStepLabel, this.myUpgradePackageUpgrader);
                rebootNodeUpgradeOp.executeOpAtPiuRestartRejected(upgradePackageMoImpl.getUpgradePackageProductNumber(), upgradePackageMoImpl.getUpgradePackageProductRevision(), this.myUpgradePackageUpgrader.getTolerateErrors());
            }
            Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Not possible to restart PlugInUnit with active Core MP is faulty.");
            ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo();
            managedElementMoSU_Access.systemInitiatedRestartFromSU(0, 20, "", null);
        }
    }

    public void freeMark(ControllerClientInterface controllerClientInterface, ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMark(ControllerClientInterface aClient)", "aClient: " + controllerClientInterface + "\n\taServiceSubType: " + serviceSubType);
        }
        if (this.isBusy) {
            if (controllerClientInterface != null && controllerClientInterface.equals(this.myClient)) {
                this.unlock(serviceSubType);
                this.myClient = null;
            } else if (controllerClientInterface != null && this.isOneClickUpgrade(controllerClientInterface, controllerClientInterface.getDocumentNumberOpt(), controllerClientInterface.getDocumentRevisionOpt())) {
                this.unlock(serviceSubType);
                this.myClient = null;
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "freeMark(ControllerClientInterface aClient, ServiceSubType aServiceSubType)", "An attempt to free mark the CV function when it was busy (from an other client).\n\tThe free mark request is ignored.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "freeMark(ControllerClientInterface aClient, ServiceSubType aServiceSubType)", "An attempt to free mark the SU logic when it already was idle.\n\tThe free mark request is ignored.\n\taServiceSubType: " + serviceSubType);
        }
    }

    private boolean isOneClickUpgrade(ControllerClientInterface controllerClientInterface, String string, String string2) {
        try {
            return OneClickUpgradeController.isOneClickUpgrade(controllerClientInterface.getDocumentNumberOpt(), controllerClientInterface.getDocumentRevisionOpt());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isOneClickUpgrade(ControllerClientInterface aClient, String aProdNo, String aProdRev)", "Ignoring and returns false\n\taClient: " + controllerClientInterface + "\n\taProdNo: " + string + "\n\taProdRev: " + string2);
            return false;
        }
    }

    public void freeMarkHard() {
        Trace.warning(this.getClass(), "freeMarkHard()", "The busyMark of the SU logic is disabled!!!");
        this.isBusy = false;
        this.myClient = null;
        ServiceController.instance().freeMarkHard();
    }

    public RepertoiresProxyInterface getRepertoiresProxyInterface(String string, String string2, File file) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException, ParserFactoryException, InvalidMainElementNameException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoiresProxyInterface (File anUCF_Path)");
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(string, string2, file.getAbsolutePath(), "Repertoire");
        return documentObjectProxyInterface.getRepertoiresProxyInterface();
    }

    public ReadSupportedUpgradeTypesStatusResponseEvent readSupportedUpgradeTypesStatus(ControllerClientInterface controllerClientInterface, ReadSupportedUpgradeTypesStatusRequestEvent readSupportedUpgradeTypesStatusRequestEvent) throws ActionNotAllowedException, ReadSupportedUpgradeTypesStatusServiceException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "readSupportedUpgradeTypesStatus(ControllerClientInterface aClient, ReadSupportedUpgradeTypesStatusRequestEvent aReadSupportedUpgradeTypesStatusRequestEvent)", "aReadSupportedUpgradeTypesStatusRequestEvent: " + readSupportedUpgradeTypesStatusRequestEvent);
        }
        if (this.isBusy && controllerClientInterface != null && controllerClientInterface.equals(this.myClient)) {
            ReadSupportedUpgradeTypesStatusService readSupportedUpgradeTypesStatusService = new ReadSupportedUpgradeTypesStatusService();
            return readSupportedUpgradeTypesStatusService.readSupportedUpgradeTypesStatus(readSupportedUpgradeTypesStatusRequestEvent);
        }
        throw new ActionNotAllowedException("Not allowed to continue the execution of the retreival of the supported upgrade types status data due to illegal input behaviour.\n\tisBusy: " + this.isBusy + "\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient);
    }

    public File getUpControlFile() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpControlFile()");
        }
        return this.qcmdUpgradeControlFile;
    }

    public String getUpgradeCaseLabel() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradeCaseLabel()");
        }
        return this.qcmdUpgCaseId;
    }

    public void installProgressInformation(ActionEvent actionEvent) {
        block4: {
            try {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "installProgressInformation ( ActionEvent anInstallProgressEvent )", "anInstallProgressEvent: " + actionEvent.getID());
                }
            }
            catch (Exception exception) {
                if (!Trace.valid(this.getClass(), 20)) break block4;
                Trace.debug(this.getClass(), 20, "installProgressInformation ( ActionEvent anInstallProgressEvent )", "anInstallProgressEvent: " + actionEvent);
            }
        }
        if (this.observers != null) {
            this.observers.actionPerformed(actionEvent);
        }
    }

    public void installRequest(InstallRequestEvent installRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installRequest ( InstallRequestEvent anInstallRequestEvent )", "anInstallRequestEvent: " + installRequestEvent);
        }
        this.inQueue.enqueue((Object)installRequestEvent);
    }

    public void installResponse(InstallResponseEvent installResponseEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installResponse ( InstallResponseEvent anInstallResponseEvent )", "anInstallResponseEvent: " + installResponseEvent);
        }
        this.inQueue.enqueue((Object)installResponseEvent);
    }

    public static synchronized UpgradeCoordinator instance() {
        if (Trace.valid(UpgradeCoordinator.class, 20)) {
            Trace.debug(UpgradeCoordinator.class, 20, "instance()");
        }
        if (instance == null) {
            instance = new UpgradeCoordinator();
            new Thread((Runnable)instance, "UpgradeCoordinator").start();
        }
        return instance;
    }

    public boolean lock(String string) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "String aServiceSubTypeAsString)", "aServiceSubTypeAsString: " + string);
        }
        if (string.equals(ServiceSubType.healthCheck.getValue())) {
            return this.lock(ServiceSubType.healthCheck);
        }
        throw new ActionNotAllowedException("Failed to lock the upgrade logic, unknown serviceSubType received: " + string);
    }

    public synchronized boolean lock(ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lock(ServiceSubType aServiceSubType)", "aServiceSubType: " + serviceSubType + "\n\tisBusy: " + this.isBusy);
        }
        if (this.isBusy) {
            return false;
        }
        if (ServiceController.instance().busyMark(ServiceType.SystemUpgrade, serviceSubType)) {
            this.isBusy = true;
            return true;
        }
        return false;
    }

    public static void opIntRegister() {
        if (Trace.valid(UpgradeCoordinator.class, 20)) {
            Trace.debug(UpgradeCoordinator.class, 20, "opIntRegister ()");
        }
    }

    public void parseSequenceCallback(ExecutableOp executableOp, String string, boolean bl, boolean bl2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseSequenceCallback(ExecutableOp anExecutableOp, String aParsedStepLabel, boolean aStepContainsRebootProgramUpgrade, boolean aStepContainsSoftPiuUpgrade)", "anExecutableOp: " + executableOp + "\n\taParsedStepLabel: " + string + "\n\taStepContainsRebootProgramUpgrade: " + bl + "\n\taStepContainsSoftPiuUpgrade: " + bl2);
        }
        this.myStepOps = executableOp;
        this.myStepLabel = string;
        this.myStepContainsRebootProgramUpgrade = bl;
        this.myStepContainsSoftPiuUpgrade = bl2;
    }

    public String participatorName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "participatorName()");
        }
        return UPGRADE_CONTROLLER_PARTICIPATOR_NAME;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent.getNewValue().getClass().getName() + "\n\taPropertyChangeEvent: " + propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getNewValue() instanceof UpgradeProgressInformation) {
            UpgradeProgressInformation upgradeProgressInformation = (UpgradeProgressInformation)propertyChangeEvent.getNewValue();
            if (upgradeProgressInformation instanceof NodeRestartReqInformation || upgradeProgressInformation instanceof WaitingForConfirmUpgrade || upgradeProgressInformation instanceof WaitingForResumeUpgrade || upgradeProgressInformation instanceof JVM_RestartRequestContinueInformation) {
                this.seqExecutionState = 1;
            }
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "An unexpected type of progress information received (IGNORED)\n\taPropertyChangeEvent: " + propertyChangeEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeActionListener( ActionListener al )", "al: " + actionListener);
        }
        this.observers = AWTEventMulticaster.remove((ActionListener)this.observers, (ActionListener)actionListener);
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        TriggerCentralHandlerInterface triggerCentralHandlerInterface = (TriggerCentralHandlerInterface)ServiceLocatorFacade.getRepository().getService(TriggerCentralHandlerInterface.class);
        triggerCentralHandlerInterface.addUpgradeParticipator(this);
        block4: while (true) {
            try {
                while (true) {
                    EventObject eventObject = (EventObject)this.inQueue.dequeue();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run ()", "Received Upgrade event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
                    }
                    if (eventObject instanceof InstallRequestEvent) {
                        this.handleInstallRequestEvent((InstallRequestEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof InstallConfirmedEvent) {
                        this.handleInstallConfirmedEvent((InstallConfirmedEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof InstallRejectedEvent) {
                        this.handleInstallRejectedEvent((InstallRejectedEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof CancelInstallRequestEvent) {
                        this.handleCancelInstallRequestEvent((CancelInstallRequestEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof CancelInstallRejectedEvent) {
                        this.handleCancelInstallRejectedEvent((CancelInstallRejectedEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof CancelInstallConfirmedEvent) {
                        this.handleCancelInstallConfirmedEvent((CancelInstallConfirmedEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof UpgradeRequestEvent) {
                        try {
                            this.handleUpgradeRequestEvent((UpgradeRequestEvent)eventObject);
                            continue block4;
                        }
                        catch (Throwable throwable) {
                            Trace.error(this.getClass(), "run()", "Throwable caught when upgrade has been requested.", throwable);
                            if (OneClickUpgradeController.isOneClickUpgrade(((UpgradeRequestEvent)eventObject).upgradePackageMoImpl.getDocumentNumberOpt(), ((UpgradeRequestEvent)eventObject).upgradePackageMoImpl.getDocumentRevisionOpt())) {
                                UpgradeTraceHandler.instance().getTraceInfoData().setOneClickUpgrade(false);
                            }
                            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
                            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "run()Throwable caught when upgrade has been requested.", throwable);
                            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
                            this.doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
                            continue;
                        }
                    }
                    if (eventObject instanceof ShrinkRequestEvent) {
                        this.handleShrinkRequestEvent((ShrinkRequestEvent)eventObject);
                        continue;
                    }
                    if (eventObject instanceof ReadRefCV_InfoRequestEvent) {
                        this.handleReadRefCV_InfoRequestEvent((ReadRefCV_InfoRequestEvent)eventObject);
                        continue;
                    }
                    Trace.error(this.getClass(), "run()", "Unexpected event received in class UpgradeCoordinator.Received Upgrade event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
                    this.handleException((Throwable)((Object)new UpgradeException("Upgrade request aborted due to unexpected event received in thread UpgradeCoordinatorReceived Upgrade event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject)));
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run()", "Throwable caught. Waits for new EventObject's to be put into the BlockingQueue.", throwable);
                this.handleException(throwable);
                continue;
            }
            break;
        }
    }

    public void setJvmPiuEventCallback(Vector vector, boolean bl, int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setJvmPiuEventCallback(Vector aPIUsAffectedByTheRebootOfPIUsDuringUpgrade, boolean aNoReliableProgramMove, int aPiuStartupDelay)", "aPIUsAffectedByTheRebootOfPIUsDuringUpgrade: " + vector + "\n\taNoReliableProgramMove: " + bl + "\n\taPiuStartupDelay: " + n);
        }
        RebootPlugInUnitInformation rebootPlugInUnitInformation = new RebootPlugInUnitInformation(this, vector, bl, n);
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, rebootPlugInUnitInformation);
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        String string2 = "triggerIndicated(UpgradeMaster master, String subSpec)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "master instance class name: " + upgradeMaster + "\n\tsubSpec: " + string);
        }
        SU_TriggerHandler sU_TriggerHandler = new SU_TriggerHandler(upgradeMaster, this.qcmdUpgradeControlFile, this, this.myUpgradePackageMo, this.myUpgradePackageUpgrader);
        sU_TriggerHandler.initiateThread();
        sU_TriggerHandler.triggerIndicated(string);
    }

    public synchronized boolean unlock(ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unlock(ServiceSubType aServiceSubType)", "aServiceSubType: " + serviceSubType);
        }
        this.isBusy = false;
        ServiceController.instance().freeMark(ServiceType.SystemUpgrade, serviceSubType);
        return true;
    }

    public void shrinkRequest(ControllerClientInterface controllerClientInterface, ShrinkRequestEvent shrinkRequestEvent) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "shrinkRequest(ControllerClientInterface, ShrinkRequestEvent)(ControllerClientInterface aClient, ShrinkRequestEvent aShrinkRequestEvent )", "aClient: " + controllerClientInterface + "\n\taShrinkRequestEvent: " + shrinkRequestEvent);
        }
        if (!this.isBusy || controllerClientInterface == null || !controllerClientInterface.equals(this.myClient)) {
            throw new ActionNotAllowedException("Not allowed to continue the execution of the shrink request since illegal input behaviour.\n\tisBusy: " + this.isBusy + "\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient);
        }
        this.inQueue.enqueue((Object)shrinkRequestEvent);
    }

    public void shrinkResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "shrinkResponse ()");
        }
        if (this.myShrinkController != null) {
            this.myShrinkController = null;
        }
        if (this.myClient != null) {
            this.myClient.finished();
        }
    }

    public void updateRequest(ControllerClientInterface controllerClientInterface, UpdateRequestEvent updateRequestEvent) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateRequest(ControllerClientInterface aClient, UpdateRequestEvent anUpdateRequestEvent )", "aClient: " + controllerClientInterface + "\n\tanUpdateRequestEvent: " + updateRequestEvent);
        }
        if (!this.isBusy || controllerClientInterface == null || !controllerClientInterface.equals(this.myClient)) {
            throw new ActionNotAllowedException("Not allowed to continue the execution of the update request since illegal input behaviour.\n\tisBusy: " + this.isBusy + "\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient);
        }
        this.myUpdateController = new UpdateController();
        this.myUpdateController.initiateThread();
        this.myUpdateController.updateRequest(updateRequestEvent);
    }

    public void updateResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateResponse ()");
        }
        if (this.myUpdateController != null) {
            this.myUpdateController.cleanup();
            this.myUpdateController = null;
        }
        if (this.myClient != null) {
            this.myClient.finished();
        } else {
            Trace.warning(this.getClass(), "updateResponse()", "An update response was received when no client is expecting it (ignored).");
        }
    }

    public void upgradeRequest(ControllerClientInterface controllerClientInterface, UpgradeRequestEvent upgradeRequestEvent) throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "upgradeRequest ( ControllerClientInterface aClient, UpgradeRequestEvent anUpgradeRequestEvent )", "aClient: " + controllerClientInterface + "\n\tanUpgradeRequestEvent: " + upgradeRequestEvent);
        }
        if (this.isBusy && controllerClientInterface != null && controllerClientInterface.equals(this.myClient)) {
            this.qcmdUpgradeControlFile = upgradeRequestEvent.upgradePackageControlFile;
            this.qcmdUpgCaseId = upgradeRequestEvent.caseIdentifier;
            this.myUpgradePackageMo = upgradeRequestEvent.upgradePackageMoImpl;
            this.inQueue.enqueue((Object)upgradeRequestEvent);
        } else if (OneClickUpgradeController.isOneClickUpgrade(upgradeRequestEvent.upgradePackageMoImpl.getDocumentNumberOpt(), upgradeRequestEvent.upgradePackageMoImpl.getDocumentRevisionOpt())) {
            if (this.isBusy && this.myClient == null) {
                this.myClient = controllerClientInterface;
                this.qcmdUpgradeControlFile = upgradeRequestEvent.upgradePackageControlFile;
                this.qcmdUpgCaseId = upgradeRequestEvent.caseIdentifier;
                this.myUpgradePackageMo = upgradeRequestEvent.upgradePackageMoImpl;
                this.inQueue.enqueue((Object)upgradeRequestEvent);
            }
        } else {
            throw new ActionNotAllowedException("Not allowed to continue the execution of the upgrade request since illegal input behaviour.\n\tisBusy: " + this.isBusy + "\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient);
        }
    }

    public void verifyRequest(ControllerClientInterface controllerClientInterface, VerifyRequestEvent verifyRequestEvent) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyRequest(ControllerClientInterface aClient, VerifyRequestEvent aVerifyRequestEvent)", "aClient: " + controllerClientInterface + "\n\taVerifyRequestEvent: " + verifyRequestEvent);
        }
        if (!this.isBusy || controllerClientInterface == null || !controllerClientInterface.equals(this.myClient)) {
            throw new ActionNotAllowedException("Not allowed to continue the execution of the verify request since illegal input behaviour.\n\tisBusy: " + this.isBusy + "\n\taClient: " + controllerClientInterface + "\n\tmyClient: " + this.myClient);
        }
        Verifier verifier = new Verifier();
        verifier.verifyRequest(verifyRequestEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecuteSequence(UpgradeRequestEvent upgradeRequestEvent, UpgradePackageUpgrader upgradePackageUpgrader) throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doExecuteSequence(UpgradeRequestEvent anUpgradeRequestEvent, UpgradePackageUpgrader anUpgradePackageUpgrader)", "anUpgradeRequestEvent: " + upgradeRequestEvent + "\n\tanUpgradePackageUpgrader: " + upgradePackageUpgrader);
        }
        Parser parser = ParserFactory.makeParser("com.microstar.xml.SAXDriver");
        this.myStepLabel = upgradeRequestEvent.stepLabel;
        this.seqExecutionState = 0;
        try {
            ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
            if (!UpgradeDB_StorageUtil.isExecutedFromStateExisting()) {
                UpgradeDB_StorageUtil.saveExecutedFromState();
                UpgradeDB_StorageUtil.logUpgradeDB("----------CREATE ExecutedFromState--------");
            }
            this.deleteCertCrlProgramsFromDB();
            while (this.seqExecutionState == 0) {
                OpGroupCreatorSAXdh opGroupCreatorSAXdh = new OpGroupCreatorSAXdh(upgradeRequestEvent.upgradePackageProductNumber, upgradeRequestEvent.upgradePackageProductRevision, this.myStepLabel, upgradeRequestEvent.sequenceLabel, upgradeRequestEvent.upgradePackageMoImpl, upgradePackageUpgrader, upgradeRequestEvent.attributePiusUpgradeInformationHandlerInterface, upgradeRequestEvent.installedTypeOfUP, upgradeRequestEvent.caseIdentifier);
                parser.setDocumentHandler(opGroupCreatorSAXdh);
                parser.parse(new InputSource(new FileReader(upgradeRequestEvent.upgradePackageControlFile)));
                if (this.myStepLabel.equalsIgnoreCase("e_ndo_fseq_uence")) {
                    UpgradeDB_StorageUtil.removeExecutedFromState();
                    boolean bl = true;
                    return bl;
                }
                this.executeParsedStep(upgradeRequestEvent);
            }
            boolean bl = false;
            return bl;
        }
        catch (SAXException sAXException) {
            Trace.error(this.getClass(), "doExecuteSequence(UpgradeRequestEvent anUpgradeRequestEvent, UpgradePackageUpgrader anUpgradePackageUpgrader)", "SAXException from trigger (at execution of an Operation 'executeOp').\n\tanUpgradeRequestEvent: " + upgradeRequestEvent + "\n\tmyStepOps (ExceuteableOP) instance class name: " + this.myStepOps.getClass().getName(), sAXException);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "SAXException from trigger (at execution of an Operation 'executeOp').\n\tanUpgradeRequestEvent: " + upgradeRequestEvent + "\n\tmyStepOps (ExceuteableOP) instance class name: " + this.myStepOps.getClass().getName(), sAXException);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
            this.doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "doExecuteSequence(UpgradeRequestEvent anUpgradeRequestEvent, UpgradePackageUpgrader anUpgradePackageUpgrader)", "Throwable from trigger (at execution of an Operation 'executeOp').\n\tanUpgradeRequestEvent: " + upgradeRequestEvent + "\n\tmyStepOps (ExceuteableOP) instance class name: " + this.myStepOps.getClass().getName(), throwable);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "Throwable from trigger (at execution of an Operation 'executeOp').\n\tanUpgradeRequestEvent: " + upgradeRequestEvent + "\n\tmyStepOps (ExceuteableOP) instance class name: " + this.myStepOps.getClass().getName(), throwable);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
            this.doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
            boolean bl = false;
            return bl;
        }
        finally {
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
        }
    }

    private void deleteCertCrlProgramsFromDB() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteCertCrlProgramsFromDB");
        }
        if (UpgradeDB_StorageUtil.existsCertCrlPrograms()) {
            UpgradeDB_StorageUtil.deleteCertCrlPrograms();
        }
    }

    private void executeParsedStep(UpgradeRequestEvent upgradeRequestEvent) throws SAXException, UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeParsedStep(UpgradeRequestEvent anUpgradeRequestEvent)", "anUpgradeRequestEvent: " + upgradeRequestEvent);
        }
        if (this.myStepOps != null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "executeParsedStep(UpgradeRequestEvent anUpgradeRequestEvent)", "Execution of step label '" + this.myStepLabel + "' is starting.");
            }
            if (this.myStepContainsRebootProgramUpgrade) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ProgramAdditionRemovalInformation(this));
            }
            if (this.myStepContainsSoftPiuUpgrade) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new SoftPIU_UpgradeRequestInformation(this));
            }
            try {
                this.myStepOps.executeOp(this);
            }
            catch (NoJvmRestartNeededSinceNoChangeInClassPathException noJvmRestartNeededSinceNoChangeInClassPathException) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "executeParsedStep(UpgradeRequestEvent anUpgradeRequestEvent)", "No JVM restart was required. Ensure that coming steps in UpgradeSequence are parsed.");
                }
                this.seqExecutionState = 0;
            }
            catch (SAXException sAXException) {
                if (sAXException.toString().lastIndexOf("Handling FTC state faulty at reboot PIU") == -1) {
                    throw sAXException;
                }
                RebootNodeUpgradeOp rebootNodeUpgradeOp = new RebootNodeUpgradeOp(upgradeRequestEvent.upgradePackageMoImpl, this.myStepLabel, this.myUpgradePackageUpgrader);
                rebootNodeUpgradeOp.executeOpAtPiuRestartRejected(upgradeRequestEvent.upgradePackageProductNumber, upgradeRequestEvent.upgradePackageProductRevision, this.myUpgradePackageUpgrader.getTolerateErrors());
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "executeParsedStep(UpgradeRequestEvent anUpgradeRequestEvent)", "Execution of step label '" + this.myStepLabel + "' is finished.");
            }
        }
    }

    private ReliableProgramUniterMoSU_Access getJvmRpu() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJvmRpu( )");
        }
        ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMoSU_Access jvmMoSU_Access = (JvmMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)jvmMoSU_Access.getReliableProgramUniter(null);
            if (reliableProgramUniterMoSU_Access == null) {
                throw new SAXException("isJvmRpuAsConfigured(): ERROR: jvm RPU is null");
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getJvmRpu ()", "Exception caught when trying to get RPU of the JvmMoImpl.\n\tException: " + exception.toString(), exception);
            throw new SAXException(exception.toString());
        }
        return reliableProgramUniterMoSU_Access;
    }

    private boolean isAffectedPiuOnPassiveSlot(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access, Vector vector) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isAffectedPiuOnPassiveSlot ( ReliableProgramUniterMoSU_Access anRpuMo, Vector aPiuList )", "anRpuMo: " + reliableProgramUniterMoSU_Access + "\n\taPiuList: " + vector);
        }
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = null;
        boolean bl = false;
        try {
            managedObject = reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null);
            for (int i = 0; i < vector.size(); ++i) {
                managedObject2 = ((ManagedObject)vector.elementAt(i)).getParent();
                if (!managedObject.equals(managedObject2)) continue;
                bl = true;
                break;
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "isActiveOnAffectedPiu()", "Exception caught when trying to access MO.\n\tException: " + moAccessException.toString(), moAccessException);
            throw new SAXException(moAccessException.toString());
        }
        return bl;
    }

    private synchronized boolean isLocked() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isLocked ()");
        }
        return this.isBusy;
    }

    private boolean isOperModeAsConfigured(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isOperModeAsConfigured(ReliableProgramUniterMoSU_Access anRpuMo)", "anRpuMo: " + reliableProgramUniterMoSU_Access);
        }
        int n = 0;
        try {
            n = reliableProgramUniterMoSU_Access.getOperationalMode(null);
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "isOperModeAsConfigured()", "Exception caught when trying to get operationalMode of the RPU.\n\tException: " + moAccessException.toString(), moAccessException);
            throw new SAXException(moAccessException.toString());
        }
        return n == 1;
    }

    private void handleCancelInstallConfirmedEvent(CancelInstallConfirmedEvent cancelInstallConfirmedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleCancelInstallConfirmedEvent ( CancelInstallConfirmedEvent aCancelInstallConfirmedEvent )", "aCancelInstallConfirmedEvent: " + cancelInstallConfirmedEvent);
        }
        if (this.myUpgradePackageInstaller == null) {
            this.myUpgradePackageCancelInstaller = null;
        }
    }

    private void handleCancelInstallRejectedEvent(CancelInstallRejectedEvent cancelInstallRejectedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleCancelInstallRejectedEvent ( CancelInstallRejectedEvent aCancelInstallRejectedEvent )", "aCancelInstallRejectedEvent: " + cancelInstallRejectedEvent);
        }
        this.myUpgradePackageCancelInstaller = null;
    }

    private void handleCancelInstallRequestEvent(CancelInstallRequestEvent cancelInstallRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleCancelInstallRequestEvent ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "aCancelInstallRequestEvent: " + cancelInstallRequestEvent);
        }
        try {
            if (this.myUpgradePackageInstaller != null) {
                if (this.myUpgradePackageCancelInstaller == null) {
                    this.myUpgradePackageInstaller.setIsCancelInstallRequested(true);
                    this.myUpgradePackageCancelInstaller = new UpgradePackageInstaller();
                    this.myUpgradePackageCancelInstaller.start();
                    this.myUpgradePackageCancelInstaller.cancelInstallRequest(cancelInstallRequestEvent);
                } else {
                    Trace.info(this.getClass(), "cancelInstallRequest ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "Cancellation of an ongoing installation was rejected due to a cancel of ongoing installation already has been requested and is in progress.");
                    this.handleException((Throwable)((Object)new CancelInstallRequestException("Cancellation of an ongoing installation was rejected due to a cancel of ongoing installation already has been requested and is in progress.")));
                }
            } else {
                Trace.info(this.getClass(), "cancelInstallRequest ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "Cancellation of an ongoing installation is rejected due to no installation is currently executing.");
                this.handleException((Throwable)((Object)new CancelInstallRequestException("Cancellation of an ongoing installation is rejected due to no installation is currently executing.")));
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "cancelInstallRequest ( CancelInstallRequestEvent aCancelInstallRequestEvent )", "Exception caught when an attempt was made to cancel an ongoing installation.\n\tmyUpgradePackageInstaller: " + this.myUpgradePackageInstaller + "\n\tmyUpgradePackageCancelInstaller: " + this.myUpgradePackageCancelInstaller, exception);
            this.myUpgradePackageCancelInstaller = null;
            this.handleException(exception);
        }
    }

    private void handleException(Throwable throwable) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleException (Throwable e )", "e: " + throwable);
        }
        int n = 993;
        if (this.observers != null) {
            this.observers.actionPerformed(new ActionEvent((Object)throwable, n, "--"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInstallConfirmedEvent(InstallConfirmedEvent installConfirmedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstalConfirmedEvent ( InstallConfirmedEvent anInstallConfirmedEvent )", "anInstallConfirmedEvent: " + installConfirmedEvent);
        }
        try {
            if (this.myUpgradePackageInstaller != null) {
                this.myUpgradePackageInstaller = null;
                this.myUpgradePackageCancelInstaller = null;
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstalConfirmedEvent ( InstallConfirmedEvent anInstallConfirmedEvent )", "For some reason the UpgradeCoordinator do not suspect that an installation is ongoing when a confirmation of an executed installation is reported.\n\tanInstallConfirmedEvent: " + installConfirmedEvent);
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "handleInstalConfirmedEvent ( InstallConfirmedEvent anInstallConfirmedEvent )", "Exception caught when resets the installation variables", exception);
        }
    }

    private void handleInstallRequestEvent(InstallRequestEvent installRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallRequestEvent ( InstallRequestEvent anInstallRequestEvent )", "anInstallRequestEvent: " + installRequestEvent);
        }
        this.myUpgradePackageInstaller = new UpgradePackageInstaller();
        this.myUpgradePackageInstaller.start();
        this.myUpgradePackageInstaller.installRequest(installRequestEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInstallRejectedEvent(InstallRejectedEvent installRejectedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallRejectedEvent ( InstallRejectedEvent anInstallRejectedEvent )", "anInstallRejectedEvent: " + installRejectedEvent);
        }
        try {
            if (this.myUpgradePackageInstaller != null) {
                this.myUpgradePackageInstaller = null;
                this.myUpgradePackageCancelInstaller = null;
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "handleInstallRejectedEvent ( InstallRejectedEvent anInstallRejectedEvent )", "Exception caught when resets the installation variables", exception);
        }
    }

    private void handleShrinkRequestEvent(ShrinkRequestEvent shrinkRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpdateRequestEvent(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        this.myShrinkController = new ShrinkController();
        this.myShrinkController.shrink(shrinkRequestEvent);
    }

    private void handleReadRefCV_InfoRequestEvent(ReadRefCV_InfoRequestEvent readRefCV_InfoRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleReadRefCV_InfoRequestEvent( ReadRefCV_InfoRequestEvent aReadRefCV_InfoRequestEvent )", "aReadRefCV_InfoRequestEvent: " + readRefCV_InfoRequestEvent);
        }
        this.myReferringConfigurationVersionsController = new ReferringConfigurationVersionsController();
        this.myReferringConfigurationVersionsController.readReadReferringCvInformation(readRefCV_InfoRequestEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpgradeRequestEvent(UpgradeRequestEvent upgradeRequestEvent) {
        block22: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)", "anUpgradeRequestEvent: " + upgradeRequestEvent);
            }
            try {
                block21: {
                    try {
                        boolean bl;
                        this.myUpgradePackageUpgrader = new UpgradePackageUpgrader(upgradeRequestEvent.upgradePackageControlFile, upgradeRequestEvent.sequenceLabel, upgradeRequestEvent.upgradeClientInterface);
                        this.myUpgradePackageUpgrader.upgradeExecutionMode(upgradeRequestEvent.upgradePackageProductNumber, upgradeRequestEvent.upgradePackageProductRevision, upgradeRequestEvent.upgradePackageControlFile, upgradeRequestEvent.stepLabel, this.myExecutedStepLabel);
                        if (upgradeRequestEvent.upgradeStage != 4 && upgradeRequestEvent.upgradeStage != 2 && (upgradeRequestEvent.stepLabel != null || upgradeRequestEvent.stepLabel != null && !upgradeRequestEvent.stepLabel.equals(""))) {
                            DynamicClassLoaderCentral.getInstance().loadLoadModulesInDynClassPath(upgradeRequestEvent.upgradePackageMoImpl);
                        }
                        if (bl = this.doExecuteSequence(upgradeRequestEvent, this.myUpgradePackageUpgrader)) {
                            try {
                                DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(upgradeRequestEvent.upgradePackageMoImpl);
                            }
                            catch (Throwable throwable) {
                                Trace.error(this.getClass(), "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)", "Throwable caught when trying to unload any dynamically loaded classes (ignored)", throwable);
                            }
                            this.myUpgradePackageUpgrader.normalExecutionMode(this.myExecutedStepLabel);
                            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ExecutionOfUpgradeSequenceFinishedInformation(this));
                            break block21;
                        }
                        if (!OneClickUpgradeController.isOneClickUpgrade(upgradeRequestEvent.upgradePackageMoImpl.getDocumentNumberOpt(), upgradeRequestEvent.upgradePackageMoImpl.getDocumentRevisionOpt())) break block21;
                        UpgradeTraceHandler.instance().getTraceInfoData().setOneClickUpgrade(false);
                    }
                    catch (UpgradeRejectedException upgradeRejectedException) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)", "UpgradeRejectedException caught. Exception message: " + upgradeRejectedException.toString());
                        }
                        try {
                            if (OneClickUpgradeController.isOneClickUpgrade(upgradeRequestEvent.upgradePackageMoImpl.getDocumentNumberOpt(), upgradeRequestEvent.upgradePackageMoImpl.getDocumentRevisionOpt())) {
                                UpgradeTraceHandler.instance().getTraceInfoData().setOneClickUpgrade(false);
                            }
                        }
                        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
                            Trace.error(this.getClass(), "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)", "Exception caught when resetting flush interval");
                        }
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
                        UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)\n\tUpgradeRejectedException caught. Exception message: " + upgradeRejectedException.toString(), (Throwable)((Object)upgradeRejectedException));
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
                        this.doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
                        Object var5_11 = null;
                        if (this.myUpgradePackageUpgrader != null) {
                            this.myUpgradePackageUpgrader = null;
                        }
                        break block22;
                    }
                    catch (Exception exception) {
                        Trace.error(this.getClass(), "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)", "Exception caught. Exception message: " + exception.toString(), exception);
                        try {
                            if (OneClickUpgradeController.isOneClickUpgrade(upgradeRequestEvent.upgradePackageMoImpl.getDocumentNumberOpt(), upgradeRequestEvent.upgradePackageMoImpl.getDocumentRevisionOpt())) {
                                UpgradeTraceHandler.instance().getTraceInfoData().setOneClickUpgrade(false);
                            }
                        }
                        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
                            Trace.error(this.getClass(), "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)", "Exception caught when resetting flush interval");
                        }
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
                        UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, "handleUpgradeRequestEvent(UpgradeRequestEvent anUpgradeRequestEvent)\n\tException caught. Exception message: " + exception.toString(), exception);
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
                        this.doPerformNodeRestart(new RestartReasonEnum(21, this.getClass()));
                        Object var5_12 = null;
                        if (this.myUpgradePackageUpgrader != null) {
                            this.myUpgradePackageUpgrader = null;
                        }
                    }
                }
                Object var5_10 = null;
                if (this.myUpgradePackageUpgrader != null) {
                    this.myUpgradePackageUpgrader = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_13 = null;
                if (this.myUpgradePackageUpgrader != null) {
                    this.myUpgradePackageUpgrader = null;
                }
                throw throwable;
            }
        }
    }
}

