/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.handler.installpiutype;

import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.configurationversion.service.ServiceController;
import se.ericsson.cello.configurationversion.service.ServiceTypeInformation;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesRejectedException;
import se.ericsson.cello.upgradepackage.install.event.InstallConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRejectedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRejectedReasonEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallResponseEvent;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.ForcedInstallPiuTypeAtUpgradeInformation;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.ForcedInstallPiuTypeInformation;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.InstallPiuTypeAtUpgradeInformation;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.InstallPiuTypeInformation;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.NoCurrentUpgradePackageException;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.OngoingInstallPiuTypeInformation;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.PiuTypeInstallSupportException;
import se.ericsson.cello.upgradepackage.main.handler.installpiutype.ServiceStatusInformation;
import se.ericsson.cello.upgradepackage.main.interfaces.InstallRejectReason;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupportHandling;
import se.ericsson.cello.upgradepackage.main.interfaces.SU_ServiceStatusListener;
import se.ericsson.cello.upgradepackage.main.interfaces.SU_ServiceStatusSupportAccess;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class PiuTypeInstallSupportHandler
extends Thread
implements PiuTypeInstallSupportHandling,
SU_ServiceStatusListener,
PropertyChangeListener {
    private LinkedList myInstallRequests = new LinkedList();
    private OngoingInstallPiuTypeInformation myOngoingInstallPiuTypeInformation = null;
    private BlockingQueue myQueue = null;

    public PiuTypeInstallSupportHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PiuTypeInstallSupportHandler( )");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        InstallRejectedReasonEvent installRejectedReasonEvent;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent + "\n\tProperty name: " + propertyChangeEvent.getPropertyName() + "\n\tNew Value: " + propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getNewValue() instanceof InstallRejectedReasonEvent && (installRejectedReasonEvent = (InstallRejectedReasonEvent)propertyChangeEvent.getNewValue()).getReason() == 851 && propertyChangeEvent.getPropertyName().equals(NotifyingSystemUpgradePropertyName.InstallResult.getValue())) {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent + "\n\tProperty name: " + propertyChangeEvent.getPropertyName() + "\n\tNew Value: " + propertyChangeEvent.getNewValue() + "\n\tThe installation of load module files for a Piu Type has failed due to time out of the overall supervision timer.");
                this.handleInstallResponse(installRejectedReasonEvent);
            }
            return;
        }
        this.initiateQueue();
        this.myQueue.enqueue(propertyChangeEvent.getNewValue());
    }

    public synchronized void serviceStatusChanged(int n, int n2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "serviceStatusChanged(int aServiceName, int aServiceStatus)", "aServiceName: " + n + "\n\taServiceStatus: " + n2);
        }
        this.logServiceStatus(n, n2);
        this.initiateQueue();
        this.myQueue.enqueue((Object)new ServiceStatusInformation(this, n, n2));
    }

    public synchronized int forcedInstallPiuType(ManagedObject managedObject, PiuTypeInstallListener piuTypeInstallListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "forcedInstallPiuType(ManagedObject aPiuTypeMo, PiuTypeInstallListener aPiuTypeInstallListener)", "aPiuTypeMo: " + managedObject + "\n\taPiuTypeInstallListener: " + piuTypeInstallListener);
        }
        this.initiateQueue();
        Integer n = TimeHandler.createActionId();
        this.myQueue.enqueue((Object)new ForcedInstallPiuTypeInformation(this, n, managedObject, piuTypeInstallListener));
        return n;
    }

    public synchronized int installPiuType(ManagedObject managedObject, PiuTypeInstallListener piuTypeInstallListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installPiuType(ManagedObject aPiuTypeMo, PiuTypeInstallListener aPiuTypeInstallListener)", "aPiuTypeMo: " + managedObject + "\n\taPiuTypeInstallListener: " + piuTypeInstallListener);
        }
        this.initiateQueue();
        Integer n = TimeHandler.createActionId();
        this.myQueue.enqueue((Object)new InstallPiuTypeInformation(this, n, managedObject, piuTypeInstallListener));
        return n;
    }

    public int installPiuTypeAtUpgrade(PiuTypeMo piuTypeMo, PiuTypeInstallListener piuTypeInstallListener) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "installPiuTypeAtUpgrade(ManagedObject aPiuTypeMo, PiuTypeInstallListener aPiuTypeInstallListener)", "Requests for installation of PiuType Mo: " + piuTypeMo + "\n\taPiuTypeInstallListener: " + piuTypeInstallListener);
        }
        this.initiateQueue();
        Integer n = TimeHandler.createActionId();
        this.myQueue.enqueue((Object)new InstallPiuTypeAtUpgradeInformation(this, n, (ManagedObject)piuTypeMo, piuTypeInstallListener));
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "installPiuTypeAtUpgrade(ManagedObject aPiuTypeMo, PiuTypeInstallListener aPiuTypeInstallListener)", "RETURNS - theActionId: " + n);
        }
        return n;
    }

    public int forcedInstallPiuTypeAtUpgrade(PiuTypeMo piuTypeMo, PiuTypeInstallListener piuTypeInstallListener) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "forcedInstallPiuTypeAtUpgrade(ManagedObject aPiuTypeMo, PiuTypeInstallListener aPiuTypeInstallListener)", "Requests for installation of PiuType Mo: " + piuTypeMo + "\n\taPiuTypeInstallListener: " + piuTypeInstallListener);
        }
        this.initiateQueue();
        Integer n = TimeHandler.createActionId();
        this.myQueue.enqueue((Object)new ForcedInstallPiuTypeAtUpgradeInformation(this, n, (ManagedObject)piuTypeMo, piuTypeInstallListener));
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "forcedInstallPiuTypeAtUpgrade(ManagedObject aPiuTypeMo, PiuTypeInstallListener aPiuTypeInstallListener)", "RETURNS - theActionId: " + n);
        }
        return n;
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ()");
        }
        EventObject eventObject = null;
        while (true) {
            try {
                while (true) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "run()", "Waits for install requests/responses or status changes.\n\tthis: " + this);
                    }
                    eventObject = (EventObject)this.myQueue.dequeue();
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "run()", "De-queued object event: " + eventObject.getClass().getName() + "\n\ttheEvent: " + eventObject);
                    }
                    if (eventObject instanceof ForcedInstallPiuTypeInformation) {
                        this.handleForcedInstallPiuTypeInformation((ForcedInstallPiuTypeInformation)eventObject);
                        continue;
                    }
                    if (eventObject instanceof InstallPiuTypeInformation) {
                        this.handleInstallPiuTypeInformation((InstallPiuTypeInformation)eventObject);
                        continue;
                    }
                    if (eventObject instanceof ForcedInstallPiuTypeAtUpgradeInformation) {
                        this.handleInstallPiuTypeAtUpgradeInformation((ForcedInstallPiuTypeAtUpgradeInformation)eventObject, true);
                        continue;
                    }
                    if (eventObject instanceof InstallPiuTypeAtUpgradeInformation) {
                        this.handleInstallPiuTypeAtUpgradeInformation((InstallPiuTypeAtUpgradeInformation)eventObject, false);
                        continue;
                    }
                    if (eventObject instanceof ServiceStatusInformation) {
                        this.handleServiceStatusInformation((ServiceStatusInformation)eventObject);
                        continue;
                    }
                    if (eventObject instanceof InstallResponseEvent) {
                        this.handleInstallResponse((InstallResponseEvent)eventObject);
                        continue;
                    }
                    Trace.error(this.getClass(), "run()", "Unexpected event received (ignored)\n\ttheEvent: " + eventObject);
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run() ", "Throwable: " + throwable, throwable);
                continue;
            }
            break;
        }
    }

    private UpgradePackageMoExtended getCurrentUpgradePackage() throws NoCurrentUpgradePackageException, PiuTypeInstallSupportException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentUpgradePackage ()");
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null);
            if (upgradePackageMoExtended != null) {
                return upgradePackageMoExtended;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getCurrentUpgradePackage ()", "theUpgradePackageMo (current UP): null ");
            }
            throw new NoCurrentUpgradePackageException("No current Upgrade Package found");
        }
        catch (NoCurrentUpgradePackageException noCurrentUpgradePackageException) {
            throw noCurrentUpgradePackageException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCurrentUpgradePackage ()", "Throwable caught.", throwable);
            throw new PiuTypeInstallSupportException("Class name: " + this.getClass().getName() + "\n\tgetCurrentUpgradePackage ()" + "\n\tThrowable caught: " + throwable);
        }
    }

    private void handleForcedInstallPiuTypeInformation(ForcedInstallPiuTypeInformation forcedInstallPiuTypeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleForcedInstallPiuTypeInformation (ForcedInstallPiuTypeInformation aForcedInstallPiuTypeInformation)", "aForcedInstallPiuTypeInformation: " + forcedInstallPiuTypeInformation);
        }
        try {
            if (!SU_ServiceStatusSupportAccess.getInterface().isServiceInExecution() && this.myInstallRequests.isEmpty() && this.myOngoingInstallPiuTypeInformation == null) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "handleForcedInstallPiuTypeInformation (ForcedInstallPiuTypeInformation aForcedInstallPiuTypeInformation)", "Requests for forced install of a piu type.aForcedInstallPiuTypeInformation: " + forcedInstallPiuTypeInformation);
                }
                UpgradePackageMoExtended upgradePackageMoExtended = this.getCurrentUpgradePackage();
                int n = upgradePackageMoExtended.actionPiuTypeForcedInstall((ManagedObject)forcedInstallPiuTypeInformation.piuTypeMo, null);
                this.myOngoingInstallPiuTypeInformation = new OngoingInstallPiuTypeInformation(forcedInstallPiuTypeInformation.actionID, n, (ManagedObject)forcedInstallPiuTypeInformation.piuTypeMo, forcedInstallPiuTypeInformation.piuTypeInstallListener);
            } else {
                this.addInstallQueue(forcedInstallPiuTypeInformation);
            }
        }
        catch (NoCurrentUpgradePackageException noCurrentUpgradePackageException) {
            forcedInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(forcedInstallPiuTypeInformation.actionID, InstallRejectReason.NO_CURRENT_UPGRADE_PACKAGE, noCurrentUpgradePackageException.toString());
        }
        catch (PiuTypeInstallSupportException piuTypeInstallSupportException) {
            forcedInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(forcedInstallPiuTypeInformation.actionID, InstallRejectReason.UNSPECIFIED, piuTypeInstallSupportException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleForcedInstallPiuTypeInformation (ForcedInstallPiuTypeInformation aForcedInstallPiuTypeInformation)", "aForcedInstallPiuTypeInformation: " + forcedInstallPiuTypeInformation + "\n\tThrowable caught.", throwable);
            forcedInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(forcedInstallPiuTypeInformation.actionID, InstallRejectReason.UNSPECIFIED, throwable.toString());
        }
    }

    private void handleInstallPiuTypeInformation(InstallPiuTypeInformation installPiuTypeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallPiuTypeInformation (InstallPiuTypeInformation anInstallPiuTypeInformation)", "anInstallPiuTypeInformation: " + installPiuTypeInformation);
        }
        try {
            if (!SU_ServiceStatusSupportAccess.getInterface().isServiceInExecution() && this.myInstallRequests.isEmpty() && this.myOngoingInstallPiuTypeInformation == null) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "handleInstallPiuTypeInformation (InstallPiuTypeInformation anInstallPiuTypeInformation)", "Requests for install of a piu type.\n\tanInstallPiuTypeInformation: " + installPiuTypeInformation);
                }
                UpgradePackageMoExtended upgradePackageMoExtended = this.getCurrentUpgradePackage();
                ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
                int n = upgradePackageMoExtended.actionPiuTypeInstall((ManagedObject)installPiuTypeInformation.piuTypeMo, null);
                this.myOngoingInstallPiuTypeInformation = new OngoingInstallPiuTypeInformation(installPiuTypeInformation.actionID, n, (ManagedObject)installPiuTypeInformation.piuTypeMo, installPiuTypeInformation.piuTypeInstallListener);
            } else {
                this.addInstallQueue(installPiuTypeInformation);
            }
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "handleInstallPiuTypeInformation (InstallPiuTypeInformation anInstallPiuTypeInformation)", "The install piu type request was rejected due to the SU service was busy (anyhow).\n\taForcedInstallPiuTypeInformation: " + installPiuTypeInformation + "\n\tActionNotAllowedException data: " + (Object)((Object)actionNotAllowedException));
            }
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
            this.addInstallQueue(installPiuTypeInformation);
        }
        catch (NoCurrentUpgradePackageException noCurrentUpgradePackageException) {
            installPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeInformation.actionID, InstallRejectReason.NO_CURRENT_UPGRADE_PACKAGE, noCurrentUpgradePackageException.toString());
        }
        catch (PiuTypeInstallSupportException piuTypeInstallSupportException) {
            installPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeInformation.actionID, InstallRejectReason.UNSPECIFIED, piuTypeInstallSupportException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleForcedInstallPiuTypeInformation (InstallPiuTypeInformation anInstallPiuTypeInformation)", "aForcedInstallPiuTypeInformation: " + installPiuTypeInformation + "\n\tThrowable caught.", throwable);
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
            installPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeInformation.actionID, InstallRejectReason.UNSPECIFIED, throwable.toString());
        }
    }

    private void handleInstallPiuTypeAtUpgradeInformation(InstallPiuTypeAtUpgradeInformation installPiuTypeAtUpgradeInformation, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallPiuTypeAtUpgradeInformation (InstallPiuTypeAtUpgradeInformation anInstallPiuTypeAtUpgradeInformation, boolean anIsForcedInstall)", "anInstallPiuTypeAtUpgradeInformation: " + installPiuTypeAtUpgradeInformation + "\n\tanIsForcedInstall: " + bl);
        }
        try {
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface;
            UpgradePackageMoExtended upgradePackageMoExtended;
            ServiceTypeInformation serviceTypeInformation = ServiceController.instance().getExecutingServiceTypeInformation();
            if (!serviceTypeInformation.getServiceSubType().getValue().equals(ServiceSubType.upgrade.getValue())) {
                installPiuTypeAtUpgradeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeAtUpgradeInformation.actionID, InstallRejectReason.UNSPECIFIED, "It is not allowed to install load module files for a specific U-PIU when upgrade is not ongoing.\n\tThe operation used to request for installation is installPiuTypeAtUpgrade");
                return;
            }
            if (this.myOngoingInstallPiuTypeInformation != null) {
                installPiuTypeAtUpgradeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeAtUpgradeInformation.actionID, InstallRejectReason.UNSPECIFIED, "It is not allowed to install load module files for a specific U-PIU when an installation already is ongoing during an upgrade.\n\tThe operation used to request for installation is installPiuTypeAtUpgrade");
                return;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "handleInstallPiuTypeAtUpgradeInformation (InstallPiuTypeAtUpgradeInformation anInstallPiuTypeAtUpgradeInformation, boolean anIsForcedInstall)", "Requests for install of a piu type during an upgrade.\n\tanInstallPiuTypeAtUpgradeInformation: " + installPiuTypeAtUpgradeInformation);
            }
            if ((upgradePackageMoExtended = (upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface()).getExecutingUpgradePackageMO()) == null) {
                upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpWithState(9);
            }
            if (upgradePackageMoExtended == null) {
                installPiuTypeAtUpgradeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeAtUpgradeInformation.actionID, InstallRejectReason.UNSPECIFIED, "Couldn't find any Upgrade Package Mo where an upgrade is ongoing i.e. it is not allowed to install load module files for a specific U-PIU when upgrade is not ongoing.\n\tThe operation used to request for installation is installPiuTypeAtUpgrade");
            }
            this.myOngoingInstallPiuTypeInformation = new OngoingInstallPiuTypeInformation(installPiuTypeAtUpgradeInformation.actionID, -1, (ManagedObject)installPiuTypeAtUpgradeInformation.piuTypeMo, installPiuTypeAtUpgradeInformation.piuTypeInstallListener);
            ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
            if (bl && upgradePackageMoExtended != null) {
                upgradePackageMoExtended.forcedPiuTypeInstallAtUpgrade(installPiuTypeAtUpgradeInformation.piuTypeMo);
            } else if (upgradePackageMoExtended != null) {
                upgradePackageMoExtended.piuTypeInstallAtUpgrade(installPiuTypeAtUpgradeInformation.piuTypeMo);
            }
        }
        catch (PiuTypeInstallSupportException piuTypeInstallSupportException) {
            installPiuTypeAtUpgradeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeAtUpgradeInformation.actionID, InstallRejectReason.UNSPECIFIED, piuTypeInstallSupportException.toString());
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            installPiuTypeAtUpgradeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeAtUpgradeInformation.actionID, InstallRejectReason.LOAD_MODULE_NOT_FOUND_ON_FTP_SERVER, installOfLoadModulesRejectedException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleInstallPiuTypeAtUpgradeInformation (InstallPiuTypeAtUpgradeInformation anInstallPiuTypeAtUpgradeInformation, boolean anIsForcedInstall)", "anInstallPiuTypeAtUpgradeInformation: " + installPiuTypeAtUpgradeInformation + "\n\tanIsForcedInstall: " + bl + "\n\tThrowable caught.", throwable);
            installPiuTypeAtUpgradeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeAtUpgradeInformation.actionID, InstallRejectReason.UNSPECIFIED, throwable.toString());
        }
    }

    private void handleInstallResponse(InstallResponseEvent installResponseEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallResponse (InstallResponseEvent anInstallResponseEvent)", "anInstallResponseEvent: " + installResponseEvent);
        }
        try {
            if (this.myOngoingInstallPiuTypeInformation != null && this.myOngoingInstallPiuTypeInformation.serverActionID == installResponseEvent.getActionID()) {
                if (installResponseEvent instanceof InstallConfirmedEvent) {
                    ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
                    this.myOngoingInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeConfirmed(this.myOngoingInstallPiuTypeInformation.clientActionID);
                    Collection collection = this.getAllQueuedInstallObjects(this.myOngoingInstallPiuTypeInformation.piuTypeMo);
                    Iterator iterator = collection.iterator();
                    InstallPiuTypeInformation installPiuTypeInformation = null;
                    while (iterator.hasNext()) {
                        installPiuTypeInformation = (InstallPiuTypeInformation)iterator.next();
                        installPiuTypeInformation.piuTypeInstallListener.installPiuTypeConfirmed(installPiuTypeInformation.actionID);
                    }
                    this.myOngoingInstallPiuTypeInformation = null;
                } else if (installResponseEvent instanceof InstallRejectedReasonEvent) {
                    InstallRejectedReasonEvent installRejectedReasonEvent = (InstallRejectedReasonEvent)installResponseEvent;
                    String string = "";
                    if (installRejectedReasonEvent.getInstallRejectReason().equals(InstallRejectReason.FTP_SERVER_NOT_ACCESSIBLE)) {
                        UpgradePackageMoExtended upgradePackageMoExtended = this.getCurrentUpgradePackage();
                        if (upgradePackageMoExtended != null) {
                            String string2 = upgradePackageMoExtended.getFtpServerIpAddress(null);
                            String string3 = upgradePackageMoExtended.getUser(null);
                            string = "\n\tFTP Server IP Address: " + string2 + "\n\tFTP Server User ID: " + string3;
                        } else {
                            string = "\n\tNo current UP (this should not happen since current UP was defined when requesting for the install of the Piu Type).";
                        }
                    }
                    string = installRejectedReasonEvent.detailedReason + string;
                    this.myOngoingInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(this.myOngoingInstallPiuTypeInformation.clientActionID, installRejectedReasonEvent.getInstallRejectReason(), string);
                    ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
                    this.myOngoingInstallPiuTypeInformation = null;
                } else if (installResponseEvent instanceof InstallRejectedEvent) {
                    this.myOngoingInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(this.myOngoingInstallPiuTypeInformation.clientActionID, InstallRejectReason.UNSPECIFIED);
                    ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
                    this.myOngoingInstallPiuTypeInformation = null;
                } else {
                    Trace.info(this.getClass(), "handleInstallResponse (InstallResponseEvent anInstallResponseEvent)", "Unexpected type of install response event (ignored)\n\tanInstallResponseEvent: " + installResponseEvent + "\n\tanInstallResponseEvent class name: " + installResponseEvent.getClass().getName());
                }
            } else {
                Trace.info(this.getClass(), "handleInstallResponse (InstallResponseEvent anInstallResponseEvent)", "Unexpected install response received i.e. not waiting for any response event at all (ignored)\n\tanInstallResponseEvent: " + installResponseEvent + "\n\tmyOngoingInstallPiuTypeInformation: " + this.myOngoingInstallPiuTypeInformation);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleInstallResponse (InstallResponseEvent anInstallResponseEvent)", "anInstallResponseEvent: " + installResponseEvent + "\n\tThrowable caught.", throwable);
            this.myOngoingInstallPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(this.myOngoingInstallPiuTypeInformation.clientActionID, InstallRejectReason.UNSPECIFIED, throwable.toString());
        }
    }

    private void handleServiceStatusInformation(ServiceStatusInformation serviceStatusInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleServiceStatusInformation (ServiceStatusInformation aServiceStatusInformation)", "aServiceStatusInformation: " + serviceStatusInformation);
        }
        if (serviceStatusInformation.serviceStatus == 0) {
            if (this.myOngoingInstallPiuTypeInformation != null) {
                Trace.info(this.getClass(), "handleServiceStatusInformation (ServiceStatusInformation aServiceStatusInformation)", "No ongoing install requests shall be ongoing when state of SU is IDLE marked.\n\taServiceStatusInformation: " + serviceStatusInformation + "\n\tmyOngoingInstallPiuTypeInformation: " + this.myOngoingInstallPiuTypeInformation);
            }
            if (!this.myInstallRequests.isEmpty()) {
                this.handleRequestForPiuTypeInstall();
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleServiceStatusInformation (ServiceStatusInformation aServiceStatusInformation)", "The SU service has become IDLE when no queued install piu type objects exists in the queue.");
            }
        } else if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleServiceStatusInformation (ServiceStatusInformation aServiceStatusInformation)", "The SU service is busy");
        }
    }

    private void handleRequestForPiuTypeInstall() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleRequestForPiuTypeInstall ()");
        }
        InstallPiuTypeInformation installPiuTypeInformation = this.removeFirstInstallQueueObject();
        try {
            UpgradePackageMoExtended upgradePackageMoExtended = this.getCurrentUpgradePackage();
            int n = -1;
            if (installPiuTypeInformation instanceof InstallPiuTypeInformation) {
                ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
                n = upgradePackageMoExtended.actionPiuTypeInstall((ManagedObject)installPiuTypeInformation.piuTypeMo, null);
            } else if (installPiuTypeInformation instanceof ForcedInstallPiuTypeInformation) {
                ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
                n = upgradePackageMoExtended.actionPiuTypeForcedInstall((ManagedObject)installPiuTypeInformation.piuTypeMo, null);
            } else {
                Trace.error(this.getClass(), "handleRequestForPiuTypeInstall ()", "Unexpected type of install request (IGNORED).theInstallPiuTypeInformation: " + installPiuTypeInformation + "theInstallPiuTypeInformation clas name: " + installPiuTypeInformation.getClass().getName());
                return;
            }
            this.myOngoingInstallPiuTypeInformation = new OngoingInstallPiuTypeInformation(installPiuTypeInformation.actionID, n, (ManagedObject)installPiuTypeInformation.piuTypeMo, installPiuTypeInformation.piuTypeInstallListener);
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "handleRequestForPiuTypeInstall ()", "The install piu type request was rejected due to the SU service was busy (anyhow).\n\ttheInstallPiuTypeInformation: " + installPiuTypeInformation + "\n\tActionNotAllowedException data: " + (Object)((Object)actionNotAllowedException));
            }
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
            this.addFirstInstallQueue(installPiuTypeInformation);
        }
        catch (NoCurrentUpgradePackageException noCurrentUpgradePackageException) {
            installPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeInformation.actionID, InstallRejectReason.NO_CURRENT_UPGRADE_PACKAGE, noCurrentUpgradePackageException.toString());
        }
        catch (PiuTypeInstallSupportException piuTypeInstallSupportException) {
            installPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeInformation.actionID, InstallRejectReason.UNSPECIFIED, piuTypeInstallSupportException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleRequestForPiuTypeInstall ()", "theInstallPiuTypeInformation: " + installPiuTypeInformation + "\n\tThrowable caught.", throwable);
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.InstallResult, this);
            installPiuTypeInformation.piuTypeInstallListener.installPiuTypeRejected(installPiuTypeInformation.actionID, InstallRejectReason.UNSPECIFIED, throwable.toString());
        }
    }

    private void initiateQueue() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "initiateQueue()");
        }
        if (this.myQueue == null) {
            this.myQueue = new BlockingQueue();
            if (SU_ServiceStatusSupportAccess.getInterface().isServiceExecuting(0)) {
                this.logServiceStatus(0, 1);
            } else if (SU_ServiceStatusSupportAccess.getInterface().isServiceExecuting(1)) {
                this.logServiceStatus(1, 1);
            } else {
                this.logServiceStatus(0);
            }
            SU_ServiceStatusSupportAccess.getInterface().addAsListener(this);
            this.start();
        }
    }

    private synchronized void addInstallQueue(InstallPiuTypeInformation installPiuTypeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addInstallQueue (InstallPiuTypeInformation anInstallPiuTypeInformation)", "anInstallPiuTypeInformation: " + installPiuTypeInformation + "\n\tmyInstallRequests (queued objects): " + this.myInstallRequests);
        }
        this.myInstallRequests.add(installPiuTypeInformation);
    }

    private synchronized void addFirstInstallQueue(InstallPiuTypeInformation installPiuTypeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addFirstInstallQueue (InstallPiuTypeInformation anInstallPiuTypeInformation)", "anInstallPiuTypeInformation: " + installPiuTypeInformation + "\n\tmyInstallRequests: " + this.myInstallRequests);
        }
        this.myInstallRequests.addFirst(installPiuTypeInformation);
    }

    private Collection getAllQueuedInstallObjects(PiuTypeMoSU_Access piuTypeMoSU_Access) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllQueuedInstallObjects (PiuTypeMoSU_Access aPiuTypeMo)", "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\tmyInstallRequests: " + this.myInstallRequests);
        }
        LinkedList<InstallPiuTypeInformation> linkedList = new LinkedList<InstallPiuTypeInformation>();
        Iterator iterator = this.myInstallRequests.iterator();
        InstallPiuTypeInformation installPiuTypeInformation = null;
        while (iterator.hasNext()) {
            installPiuTypeInformation = (InstallPiuTypeInformation)iterator.next();
            if (!installPiuTypeInformation.piuTypeMo.equals(piuTypeMoSU_Access)) continue;
            linkedList.add(installPiuTypeInformation);
        }
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            installPiuTypeInformation = (InstallPiuTypeInformation)iterator2.next();
            this.myInstallRequests.remove(installPiuTypeInformation);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getAllQueuedInstallObjects (PiuTypeMoSU_Access aPiuTypeMo)", "theQueuedObjectsMatchingPiuType: " + linkedList + "\n\tmyInstallRequests: " + this.myInstallRequests + "\n\tRETURNS - " + linkedList);
        }
        return linkedList;
    }

    private synchronized InstallPiuTypeInformation removeFirstInstallQueueObject() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeFirstInstallQueue ()");
        }
        return (InstallPiuTypeInformation)this.myInstallRequests.removeFirst();
    }

    private void logServiceStatus(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "logServiceStatus (String aServiceStatus)", "aServiceStatus: " + n);
        }
        String string = "Idle";
        if (n == 1) {
            string = "Busy";
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "serviceStatusChanged(int aServiceName, int aServiceStatus)", "aServiceStatus: " + string);
        }
    }

    private void logServiceStatus(int n, int n2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "logServiceStatus (String aServiceName, String aServiceStatus)", "aServiceName: " + n + "\n\taServiceStatus: " + n2);
        }
        String string = "SystemUpgrade";
        if (n == 1) {
            string = "ConfigurationVersion";
        }
        String string2 = "Idle";
        if (n2 == 1) {
            string2 = "Busy";
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "serviceStatusChanged(int aServiceName, int aServiceStatus)", "theServiceName: " + string + "\n\ttheServiceStatus: " + string2);
        }
    }
}

