/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.equipment.suaccess.JvmMoSU_Access;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.TracePropertyFileHandler;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandlerInterface;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfoDataContainer;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNameInUseException;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotFoundException;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotInUseException;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidator;
import se.ericsson.cello.upgradepackage.trace.writers.TraceAVC_OnlyWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceFileWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceLogServiceWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceLogWriterInterface;
import se.ericsson.cello.upgradepackage.trace.writers.TraceSerialPortWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class UpgradeTraceHandler
implements UpgradeTraceHandlerInterface,
PropertyChangeListener {
    private static UpgradeTraceHandler myInstance = null;
    private static TraceLogWriterInterface myTraceWriter = null;
    private TraceInfoDataContainer myTraceInfoDataContainer = TracePropertyFileHandler.instance().getTraceInfoDataFromPropFile(true);

    private UpgradeTraceHandler() {
        this.setTraceWriter();
        this.myTraceInfoDataContainer.addPropertyChangeListener(this);
    }

    private void setTraceWriter() {
        if (myTraceWriter != null) {
            myTraceWriter.clear(this.myTraceInfoDataContainer);
        }
        if (this.myTraceInfoDataContainer.getOutputMode() == 10) {
            myTraceWriter = new TraceAVC_OnlyWriter(this.myTraceInfoDataContainer);
        } else if (this.myTraceInfoDataContainer.getOutputMode() == 0) {
            myTraceWriter = new TraceFileWriter(this.myTraceInfoDataContainer);
        } else if (this.myTraceInfoDataContainer.getOutputMode() == 3) {
            myTraceWriter = new TraceLogServiceWriter(this.myTraceInfoDataContainer);
        } else if (this.myTraceInfoDataContainer.getOutputMode() == 1) {
            myTraceWriter = new TraceSerialPortWriter(this.myTraceInfoDataContainer);
        } else if (this.myTraceInfoDataContainer.getOutputMode() == 2) {
            myTraceWriter = new TraceTE_LogWriter(this.myTraceInfoDataContainer);
        } else {
            TraceTE_LogWriter.teLogError(this.getClass(), "setTraceWriter()", "Unknown value for outputMode: " + this.myTraceInfoDataContainer.getOutputMode() + ". Default value (LOG_SERVICE) will be used.");
            myTraceWriter = new TraceLogServiceWriter(this.myTraceInfoDataContainer);
        }
    }

    public static synchronized UpgradeTraceHandler instance() {
        if (myInstance == null) {
            myInstance = new UpgradeTraceHandler();
        }
        return myInstance;
    }

    public TraceInfoDataContainer getTraceInfoData() {
        return this.myTraceInfoDataContainer;
    }

    public void reloadTraceInfoFromPropFile() {
        try {
            TraceInfoDataContainer traceInfoDataContainer = TracePropertyFileHandler.instance().getTraceInfoDataFromPropFile(false);
            this.myTraceInfoDataContainer.updateAllAttributes(traceInfoDataContainer);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "reloadTraceInfoFromPropFile", "Throwable caught.", throwable);
        }
    }

    public void reloadSWM_Version() {
        this.myTraceInfoDataContainer.setSU_VersionString(UpgradeTraceHandler.defineSWM_Version());
    }

    public String getSU_VersionString() {
        return this.myTraceInfoDataContainer.getSU_VersionString();
    }

    public void flushToTraceFile() {
        try {
            myTraceWriter.flushOut();
        }
        catch (OperationNotAllowedException operationNotAllowedException) {
            // empty catch block
        }
    }

    public TraceLogWriterInterface getTraceWriter() {
        if (myTraceWriter == null) {
            this.setTraceWriter();
        }
        return myTraceWriter;
    }

    public void deleteLogFile(String string) throws MoAccessException {
        block13: {
            if (myTraceWriter instanceof TraceFileWriter) {
                boolean bl = TraceLogServiceWriter.deleteLogFile(string);
                try {
                    if (!TraceFileWriter.deleteLogFile(string) && !bl) {
                        throw new LogFileNotFoundException("Could not find a log file with name: " + string + " to delete.");
                    }
                    break block13;
                }
                catch (LogFileNotFoundException logFileNotFoundException) {
                    throw logFileNotFoundException;
                }
                catch (LogFileNameInUseException logFileNameInUseException) {
                    if (!bl) {
                        throw logFileNameInUseException;
                    }
                    break block13;
                }
            }
            if (myTraceWriter instanceof TraceLogServiceWriter) {
                boolean bl = TraceFileWriter.deleteLogFile(string);
                try {
                    if (!TraceLogServiceWriter.deleteLogFile(string) && !bl) {
                        throw new LogFileNotFoundException("Could not find a log file with name: " + string + " to delete.");
                    }
                    break block13;
                }
                catch (LogFileNotFoundException logFileNotFoundException) {
                    throw logFileNotFoundException;
                }
                catch (LogFileNameInUseException logFileNameInUseException) {
                    if (!bl) {
                        throw logFileNameInUseException;
                    }
                    break block13;
                }
            }
            if (!TraceFileWriter.deleteLogFile(string) && TraceLogServiceWriter.deleteLogFile(string)) {
                throw new LogFileNotFoundException("Could not find a log file with name: " + string + " to delete.");
            }
        }
    }

    public Collection getNotActiveLogFiles() {
        ArrayList arrayList = new ArrayList(1);
        arrayList.addAll(TraceLogServiceWriter.getNotActiveLogFiles());
        arrayList.addAll(TraceFileWriter.getNotActiveLogFiles());
        return arrayList;
    }

    public boolean isMethodSU_ToBeLogged(String string, String string2) {
        if (this.myTraceInfoDataContainer.getActiveMethodsSU().isEmpty()) {
            return true;
        }
        if (!this.myTraceInfoDataContainer.getActiveMethodsSU().containsKey(string)) {
            return true;
        }
        String string3 = null;
        Iterator iterator = ((Collection)this.myTraceInfoDataContainer.getActiveMethodsSU().get(string)).iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (!TraceAttributeValidator.isMethodNamesEqual(string2, string3)) continue;
            return true;
        }
        return false;
    }

    public boolean isLevelSU_ToBeLogged(int n) {
        if (this.myTraceInfoDataContainer.getLevelsSU().isEmpty()) {
            return true;
        }
        return this.myTraceInfoDataContainer.getLevelsSU().contains(new Integer(n));
    }

    private static String defineSWM_Version() {
        String string = "---";
        try {
            JvmMoSU_Access jvmMoSU_Access = ServiceFinder.getJvmMO_HandlerInterface().getJvmMO();
            String string2 = jvmMoSU_Access.getClasspath(null);
            int n = string2.lastIndexOf("1729990_");
            if (n != -1) {
                String string3 = string2.substring(n + "1729990".length() + 1);
                int n2 = string3.indexOf(".jar");
                string = string3.substring(0, n2);
            } else {
                string = "----";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "SU_SW: 1..39-1 C19.Q4-LSV274-1 RncInternalDbcHealthCheck - " + string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.TypeOfStorage.getValue())) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n == 2) {
                try {
                    TracePropertyFileHandler.instance().storeTracePropValues(this.myTraceInfoDataContainer);
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), " propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Failed to store the trace settings into property file. Throwable caught.", throwable);
                }
            } else {
                TracePropertyFileHandler.instance().deletePropertyFile();
            }
        } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.OutputMode.getValue())) {
            this.setTraceWriter();
        }
    }

    public void clearTraceFile() throws LogFileNotInUseException {
        if (this.myTraceInfoDataContainer.getOutputMode() != 0 && this.myTraceInfoDataContainer.getOutputMode() != 3) {
            throw new LogFileNotInUseException("OutputMode is not to file or logService.");
        }
        myTraceWriter.clearOut();
    }
}

