/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace.writers;

import java.util.Collection;
import java.util.Vector;
import se.ericsson.cello.genericlog.Log;
import se.ericsson.cello.genericlog.LogAlreadyExistsException;
import se.ericsson.cello.genericlog.LogMgr;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.upgradepackage.trace.datacontainer.LogContainer;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfoDataContainer;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNameInUseException;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotInUseException;
import se.ericsson.cello.upgradepackage.trace.exception.TraceWriterException;
import se.ericsson.cello.upgradepackage.trace.writers.TraceLogWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;

public class TraceLogServiceWriter
extends TraceLogWriter {
    Log myGenericLog = null;
    private static String myFileNameUsed = "";
    private int myFileSizeUsed = -1;
    private int myBufferSize = -1;
    private int myInactivityTimeout = -1;
    private boolean myLastLogWriteFailed = false;

    public TraceLogServiceWriter(TraceInfoDataContainer traceInfoDataContainer) {
        myFileNameUsed = traceInfoDataContainer.getFileName(false);
        this.myFileSizeUsed = traceInfoDataContainer.getFileSize();
        this.myBufferSize = traceInfoDataContainer.getBufferSize();
        this.myInactivityTimeout = traceInfoDataContainer.getInactivityTimeout();
        try {
            this.myGenericLog = this.createLog();
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(this.getClass(), "TraceLogServiceWriter(TraceInfoDataContainer aTraceInfoDataContainer)", "Throwable caught when setting Log object reference (ignored for now)", throwable);
        }
        traceInfoDataContainer.addPropertyChangeListener(this);
    }

    public synchronized void clear(TraceInfoDataContainer traceInfoDataContainer) {
        this.myGenericLog = null;
        myFileNameUsed = "";
        this.myFileSizeUsed = 0;
        traceInfoDataContainer.removePropertyChangeListener(this);
        this.myLastLogWriteFailed = false;
    }

    public static Collection getNotActiveLogFiles() {
        Vector<String> vector = new Vector<String>(1);
        try {
            String[] stringArray = LogMgr.instance().listExistingLogs();
            Log log = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(TraceLogServiceWriter.getLogName(myFileNameUsed)) || !(log = TraceLogServiceWriter.findLog(stringArray[i])).getLocation().equals("su")) continue;
                vector.add(stringArray[i] + ".txt");
            }
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(TraceLogServiceWriter.class, "getNotActiveLogFiles()", "Failed to get list of existing logs, exception caught.", throwable);
        }
        return vector;
    }

    private static String getLogName(String string) {
        String string2 = string;
        int n = string.indexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private Log createLog() throws TraceWriterException {
        Log log = null;
        try {
            log = LogMgr.instance().lsi4CreateLog(TraceLogServiceWriter.getLogName(myFileNameUsed), this.myFileSizeUsed * 1024, LogMgr.GLOBAL_STORAGE, LogMgr.RAW_FORMAT, "su", LogMgr.PUSHED, LogMgr.NO_INFO_RECORDS, 0L, "", (long)this.myBufferSize, (long)this.myInactivityTimeout);
        }
        catch (LogAlreadyExistsException logAlreadyExistsException) {
            log = this.findLog();
        }
        catch (Throwable throwable) {
            throw new TraceWriterException("Failed to create Log object, throwable caught: " + throwable);
        }
        return log;
    }

    private Log findLog() throws TraceWriterException {
        return TraceLogServiceWriter.findLog(TraceLogServiceWriter.getLogName(myFileNameUsed));
    }

    private static Log findLog(String string) throws TraceWriterException {
        Log log = null;
        try {
            log = LogMgr.instance().findLog(string);
        }
        catch (Throwable throwable) {
            throw new TraceWriterException("Failed to find a Log object for log file, throwable caught. LogName: " + string + ". Throwable: " + throwable);
        }
        return log;
    }

    public synchronized void clearOut() throws LogFileNotInUseException {
        try {
            this.deleteLog();
            this.myGenericLog = this.createLog();
        }
        catch (TraceWriterException traceWriterException) {
            TraceTE_LogWriter.teLogError(this.getClass(), "clearOut()", "Failed to clear the generic SU trace log, TraceWriterException caught.", (Throwable)((Object)traceWriterException));
        }
    }

    public static boolean deleteLogFile(String string) throws LogFileNameInUseException {
        if (!string.endsWith(".txt")) {
            return false;
        }
        if (TraceLogServiceWriter.getLogName(string).equals(TraceLogServiceWriter.getLogName(myFileNameUsed))) {
            throw new LogFileNameInUseException(string);
        }
        boolean bl = false;
        try {
            Log log = TraceLogServiceWriter.findLog(TraceLogServiceWriter.getLogName(string));
            log.deleteLog();
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    private void deleteLog() throws TraceWriterException {
        try {
            if (this.myGenericLog != null) {
                this.myGenericLog.deleteLog();
            }
        }
        catch (Throwable throwable) {
            throw new TraceWriterException("Failed to delete the generic SU trace log, throwable caught: " + throwable);
        }
    }

    public synchronized void writeToOut(String string, String string2, String string3, Class clazz, String string4, String string5, String string6, Throwable throwable) {
        LogContainer logContainer = new LogContainer(string, string2, string3, clazz, string4, string5, string6, throwable);
        boolean bl = this.writeToOut(logContainer);
        this.writeTraceToTE_Log(logContainer, bl);
    }

    private boolean writeToOut(LogContainer logContainer) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (this.myGenericLog == null) {
                    this.myGenericLog = this.createLog();
                }
                String string = this.getLogMessageString(logContainer);
                if (this.myLastLogWriteFailed) {
                    string = "\n **** SU traces has been lost due to problem accessing the trace file. ****\n" + string;
                }
                this.myGenericLog.lsi2WriteRecord(Log.ADD_NO_TIME_STAMP, -1L, string);
                this.myLastLogWriteFailed = false;
            }
            catch (Throwable throwable) {
                bl = true;
                if (this.myLastLogWriteFailed) break block4;
                TraceTE_LogWriter.teLogError(this.getClass(), "writeToOut(LogContainer aLogContainer)", "Failed to write an upgrade trace to log file, throwable caught.", throwable);
                this.myLastLogWriteFailed = true;
            }
        }
        return bl;
    }

    private void writeTraceToTE_Log(LogContainer logContainer, boolean bl) {
        if (bl) {
            logContainer.appendBeforeMessage("SU Log redirected.) ");
        }
        if (this.isInSuSimEnvironment() && !bl) {
            System.out.println(this.getLogMessageString(logContainer));
        } else {
            TraceTE_LogWriter.writeToMessageLog(logContainer, bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FileName.getValue())) {
            myFileNameUsed = (String)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FileSize.getValue())) {
            this.myFileSizeUsed = (Integer)propertyChangeEvent.getNewValue();
        } else {
            return;
        }
        try {
            this.myGenericLog = this.createLog();
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(this.getClass(), "refreshLog()", "Throwable caught when updating Log object reference (ignored for now)", throwable);
        }
    }
}

