/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace.writers;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.trace.writers.UpgradeTraceWriter;

public class TracePropFileTemplateWriter
extends UpgradeTraceWriter {
    private static final String PROP_FILE_TEMP_FILE_NAME = "Trace_02.template";

    public void createTheTempFileIfNeeded(String string) {
        String string2 = string + PROP_FILE_TEMP_FILE_NAME;
        File file = new File(string2);
        if (!file.exists()) {
            this.createTheTempFile(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTheTempFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
            this.addHeaderInfoText(printWriter);
            this.addLevelInfo(printWriter);
            this.addActiveClassesInfo(printWriter);
            this.addActiveFunctionsInfo(printWriter);
            this.addOutputModeInfo(printWriter);
            this.addLogServiceEnabledInfo(printWriter);
            this.addFileNameInfo(printWriter);
            this.addFileSizeInfo(printWriter);
            this.addFlushIntervalInfo(printWriter);
            this.addSendLogsAsNotificationsInfo(printWriter);
            if (this.isInSuSimEnvironment()) {
                this.addSU_HeaderInfoText(printWriter);
                this.addLevelsSU_Info(printWriter);
                this.addDisableInfoAndLogSU_Info(printWriter);
                this.addActiveMethodsSU_Info(printWriter);
            }
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(TracePropFileTemplateWriter.class, "createTheTempFile(String aTempFilePath)", "Could not generate the template file: " + string + ", throwable caught.", throwable);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void addHeaderInfoText(PrintWriter printWriter) throws Throwable {
        printWriter.println("# ============================================================================================================");
        printWriter.println("# This file is a template for the Trace_02.prop file that, if it exists, is used by the upgrade trace logic.");
        printWriter.println("# Update the key values below and save the file as Trace_02.prop (in directory /c/systemfiles/cello/cma/su/prop)");
        printWriter.println("# Restart the JVM or run action reloadTraceProperties in UpgradeTrace MO to activate them.");
        printWriter.println("# ============================================================================================================");
        printWriter.println();
    }

    private void addLevelInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Trace level");
        printWriter.println("# ==============");
        printWriter.println("# Trace level is only valid for debug messages (i.e. error, warning, info and log messages are always logged).");
        printWriter.println("# A statement for one level is also valid for all lower levels.");
        printWriter.println("# Default value: 2");
        printWriter.println("# Valid range: 2 - 99");
        printWriter.println("trace.level\t\t2");
        printWriter.println();
    }

    private void addActiveClassesInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Active classes");
        printWriter.println("# ==============");
        printWriter.println("# A list of strings where the strings are the names of the classes to print logs to the selected output.");
        printWriter.println("# Each class name shall be separated with a semicolon.");
        printWriter.println("trace.active.classes\t\t");
        printWriter.println();
    }

    private void addActiveFunctionsInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Active functions");
        printWriter.println("# ==============");
        printWriter.println("# Specifies the functions that are part of the defined trace properties.");
        printWriter.println("# A maximum of four functions can be activated at the same time.");
        printWriter.println("trace.active.functions\t\t");
        printWriter.println();
    }

    private void addOutputModeInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Output mode");
        printWriter.println("# ==============");
        printWriter.println("# Define to where the trace logs shall be written.");
        printWriter.println("# 'SerialPort' indicates that the trace logs is written to standard output");
        printWriter.println("# 'File' indicates that the trace logs is written to the file specified in key 'trace.file.name' below.");
        printWriter.println("#  NOTE, key 'trace.log.service.enabled' might overide setting of the value to 'File'.");
        printWriter.println("# 'TeLog' indicates that the trace logs is written to the Trace and Error log on the active JVM board.");
        printWriter.println("trace.output.mode\t\tFile");
        printWriter.println();
    }

    private void addLogServiceEnabledInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# LogService enabled");
        printWriter.println("# ==============");
        printWriter.println("# Key to direct the traces to LogService.");
        printWriter.println("# 'true' then traces are directed to LogService if outputMode is 'File'");
        printWriter.println("# 'false' then the traces are directed to the output that is set in outputMode");
        printWriter.println("trace.log.service.enabled\t\tfalse");
        printWriter.println();
    }

    private void addFileNameInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# File name");
        printWriter.println("# ==============");
        printWriter.println("# Specifies the name of the log file to where trace logs is written when outputMode is set to File or LogService.");
        printWriter.println("# The location of the file is /c/systemfiles/cello/cma/su/trace/ when logs are written to File and");
        printWriter.println("# /c/logfiles/su when they are directed to LogService.");
        printWriter.println("# NOTE, if the traces are directed to LogService the suffix of the fileName will be 'txt', regardless what is set in this key.");
        printWriter.println("trace.file.name\t\tTrace.log");
        printWriter.println();
    }

    private void addFileSizeInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# File size");
        printWriter.println("# ==============");
        printWriter.println("# Specifies the file size in kB.");
        printWriter.println("# Default value: 2000 kB");
        printWriter.println("# Valid range: 1..1000000");
        printWriter.println("trace.file.size\t\t2000");
        printWriter.println();
    }

    private void addFlushIntervalInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Flush interval");
        printWriter.println("# ==============");
        printWriter.println("# Define number of printed logs before flush of traces to file. Only valid if files are directed to 'File'.");
        printWriter.println("# Default value: 3");
        printWriter.println("# Valid range: 1..1000000");
        printWriter.println("trace.flush.interval\t\t3");
        printWriter.println();
    }

    private void addSendLogsAsNotificationsInfo(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Send logs as notifiations");
        printWriter.println("# ==============");
        printWriter.println("# Specifies whether or not trace logs are sent as notifications (AVCs) for the attribute");
        printWriter.println("# traceInformation in UpgradeTrace MO");
        printWriter.println("trace.send.log.as.notifications\t\t0");
        printWriter.println();
    }

    private void addSU_HeaderInfoText(PrintWriter printWriter) throws Throwable {
        printWriter.println("# ============================================================================================================");
        printWriter.println("# SU hidden trace attributes (optional)");
        printWriter.println("# ============================================================================================================");
        printWriter.println();
    }

    private void addLevelsSU_Info(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Extra levels besides the one in the attribute trace.level.");
        printWriter.println("# Format 9..12;14;20;32..37");
        printWriter.println("trace.levels.su");
        printWriter.println();
    }

    private void addDisableInfoAndLogSU_Info(PrintWriter printWriter) throws Throwable {
        printWriter.println("# Used to disable writing of info and log trace printouts to file (only send AVC for them)");
        printWriter.println("# If set to true, info and log trace printouts are not written to file.");
        printWriter.println("trace.disable.infoandlog.su   false");
        printWriter.println();
    }

    private void addActiveMethodsSU_Info(PrintWriter printWriter) throws Throwable {
        printWriter.println("# If the classname is included both in this attribute and in activeClasses, only logs from the methods stated will be written to log");
        printWriter.println("# It is possible to use wildcard in the method body description, i.e. 'getA(int*String*int anAttribute)' )");
        printWriter.println("# Format <ClassName>[methodA() & methodB()];<ClassName>[methodA() & methodB()];<className[methodA()]");
        printWriter.println("trace.active.methods.su\t\t");
        printWriter.println();
    }
}

