/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.softpiuupgrade;

import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;

public final class SoftActionSwitchOp
implements ExecutableOp,
UpgradePackageConst {
    private Vector rpuList;
    private String myStepLabel = null;

    public SoftActionSwitchOp(Vector vector, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SoftActionSwitchOp(Vector programList)", "programList: " + vector);
        }
        this.rpuList = (Vector)vector.clone();
        this.myStepLabel = string;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute operation 'SoftActionSwitch',\n\tRPUs to be switched: " + this.rpuList);
        ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
        boolean bl = false;
        String string = null;
        if (this.myStepLabel != null) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
        }
        while (!bl) {
            for (int i = 0; i < this.rpuList.size(); ++i) {
                try {
                    Control control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                    Coordinator coordinator = control.getCoordinator();
                    reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)this.rpuList.elementAt(i);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Requesting switch of RPU no: " + i + 1 + " in list.");
                    }
                    string = this.rpuDataToString(reliableProgramUniterMoSU_Access);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Data for RPU to be switched:" + string);
                    }
                    Trace.flushToTraceFile();
                    reliableProgramUniterMoSU_Access.actionSwitch(coordinator);
                    control.getTerminator().commit();
                    this.rpuList.removeElementAt(i);
                    continue;
                }
                catch (MoAccessException moAccessException) {
                    Trace.error(this.getClass(), "executeOp(ActionListener observer)", "Requested switch on RPU failed, RPU:" + this.rpuDataToString(reliableProgramUniterMoSU_Access), moAccessException);
                    Trace.flushToTraceFile();
                    throw new SAXException(moAccessException.toString());
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    Trace.error(this.getClass(), "executeOp(ActionListener observer)", "Failed to do rpu actionSwitch", inactiveTransactionException);
                    continue;
                }
                catch (TransactionRolledBackException transactionRolledBackException) {
                    Trace.error(this.getClass(), "executeOp(ActionListener observer)", "Failed to do rpu actionSwitch2", transactionRolledBackException);
                }
            }
            if (this.rpuList.size() != 0) continue;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "All RPUs have been switched.");
            }
            bl = true;
        }
    }

    private String rpuDataToString(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access) {
        if (reliableProgramUniterMoSU_Access != null) {
            try {
                return "\n\tNamingAttributeValue: " + reliableProgramUniterMoSU_Access.getReliableProgramUniterId(null) + "\n\trpuID: " + reliableProgramUniterMoSU_Access.getRpuId(null) + "\n\trpLabel: " + reliableProgramUniterMoSU_Access.getReliableProgramLabel(null) + "\n\tAdmActiveSlot: " + reliableProgramUniterMoSU_Access.getAdmActiveSlot(null) + "\n\tAdmPassiveSlot: " + reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null) + "\n\tNormalisation: " + reliableProgramUniterMoSU_Access.getNormalisation(null) + "\n\tReplication: " + reliableProgramUniterMoSU_Access.getReplication(null) + "\n\tSwitchOver: " + reliableProgramUniterMoSU_Access.getSwitchOver(null) + "\n\tOperationalMode: " + reliableProgramUniterMoSU_Access.getOperationalMode(null);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "rpuDataToString(ReliableProgramUniterMoSU_Access aReliableProgramUniterMo)", "Failed to retrieve RPU data", throwable);
                return "RPU data could not be retrieved";
            }
        }
        return null;
    }
}

