/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.softpiuupgrade;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public final class WaitForSoftOperationModeSwitchedOverListOp
implements ExecutableOp,
UpgradePackageConst {
    private static final int CELLO_RPU_OPERATIONAL_MODE_AS_CONFIGURED = 1;
    private Vector myRPU_MOs;
    private String myStepLabel = null;

    public WaitForSoftOperationModeSwitchedOverListOp(Vector vector, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "\tWaitForSoftOperationModeSwitchedOverListOp(Vector rpuListunSwOver)", "\trpuListunSwOver: " + vector);
        }
        this.myRPU_MOs = (Vector)vector.clone();
        this.myStepLabel = string;
        this.printRPU_MO_Data(this.myRPU_MOs);
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        try {
            Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute operation 'WaitForSoftOperationModeSwitchedOverList'.");
            if (this.myStepLabel != null) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
            }
            this.printRPU_MO_Data(this.myRPU_MOs);
            this.myRPU_MOs = this.removeRPU_WhereOperationStateHasBeenSetTo(this.myRPU_MOs, 1);
            this.requestForSwitchOfRPU(this.myRPU_MOs);
            while (!this.myRPU_MOs.isEmpty()) {
                this.myRPU_MOs = this.removeRPU_WhereOperationStateHasBeenSetTo(this.myRPU_MOs, 1);
            }
            this.printRPU_MO_Data(this.myRPU_MOs);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Throwable caught when executing the OP: WaitForSoftOperationModeSwitchedOverList.\n\tmyRPU_MOs: " + this.myRPU_MOs + throwable);
            throw new SAXException(throwable.toString());
        }
    }

    private Vector removeRPU_WhereOperationStateHasBeenSetTo(Vector vector, int n) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeRPU_WhereOperationStateHasBeenSetTo ( Collection aRPU_MOs, int anOperationalMode )", "aRPU_MOs: " + vector + "\n\tanOperationalMode: " + n);
        }
        try {
            Vector vector2 = (Vector)vector.clone();
            Iterator iterator = vector2.iterator();
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            while (iterator.hasNext()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                if (reliableProgramUniterMoSU_Access.getOperationalMode(null) != n) continue;
                String string = this.rpuDataToString(reliableProgramUniterMoSU_Access);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "executeOp( ActionListener observer )", "The RPU has been switched back to the requested operational mode: " + string);
                }
                string = this.rpuDataToString(reliableProgramUniterMoSU_Access);
                if (vector.remove(reliableProgramUniterMoSU_Access) || !Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Failed to remove the RPU MO from the origin RPU List: " + string);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeRPU_WhereOperationStateHasBeenSetTo ( Vector aRPU_MOs, int anOperationalMode )", "Throwable caught when checking operationa state for RPU MOs.\n\taRPU_MOs: " + vector + "\n\tanOperationalMode: " + n, throwable);
            throw new SAXException(throwable.toString());
        }
    }

    private void requestForSwitchOfRPU(Vector vector) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestForSwitchOfRPU ( Vector aRPU_MOs )", "aRPU_MOs: " + vector);
        }
        try {
            Iterator iterator = vector.iterator();
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            while (iterator.hasNext()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                Control control = Transaction.create();
                Coordinator coordinator = Transaction.getCoordinator(control);
                try {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "requestForSwitchOfRPU ( Vector aRPU_MOs )", "Requests for RPU switch on RPU MO: " + reliableProgramUniterMoSU_Access);
                    }
                    Trace.flushToTraceFile();
                    reliableProgramUniterMoSU_Access.actionSwitch(coordinator);
                    Transaction.commit(control);
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "requestForSwitchOfRPU ( Vector aRPU_MOs )", "Throwable caught when trying to switch the RPU: " + this.rpuDataToString(reliableProgramUniterMoSU_Access), throwable);
                    Transaction.rollback(control);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "requestForSwitchOfRPU ( Vector aRPU_MOs )", "Throwable caught when checking operationa state for RPU MOs.\n\taRPU_MOs: " + vector, throwable);
            throw new SAXException(throwable.toString());
        }
    }

    private void printRPU_MO_Data(Vector vector) {
        try {
            Iterator iterator = vector.iterator();
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            while (iterator.hasNext()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                String string = this.rpuDataToString(reliableProgramUniterMoSU_Access);
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "printRPU_MO_Data(Vector aRPU_MOs)", "The RPU MO: " + string);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "printRPU_ProgramSwitchOH ()", "Throwable caught: " + throwable + "\n\trpuprogramList: " + vector);
        }
    }

    private String rpuDataToString(ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access) {
        if (reliableProgramUniterMoSU_Access != null) {
            try {
                return "\n\tNamingAttributeValue: " + reliableProgramUniterMoSU_Access.getReliableProgramUniterId(null) + "\n\trpuID: " + reliableProgramUniterMoSU_Access.getRpuId(null) + "\n\trpLabel: " + reliableProgramUniterMoSU_Access.getReliableProgramLabel(null) + "\n\tAdmActiveSlot: " + reliableProgramUniterMoSU_Access.getAdmActiveSlot(null) + "\n\tAdmPassiveSlot: " + reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null) + "\n\tNormalisation: " + reliableProgramUniterMoSU_Access.getNormalisation(null) + "\n\tReplication: " + reliableProgramUniterMoSU_Access.getReplication(null) + "\n\tSwitchOver: " + reliableProgramUniterMoSU_Access.getSwitchOver(null) + "\n\tOperationalMode: " + reliableProgramUniterMoSU_Access.getOperationalMode(null);
            }
            catch (Throwable throwable) {
                return "\n\tClass name: " + this.getClass().getName() + "\n\trpuDataToString(ReliableProgramUniterMoSU_Access anReliableProgramUniterMo)" + "\n\tThrowable caught: " + throwable.toString() + "\n\tanReliableProgramUniterMo: " + reliableProgramUniterMoSU_Access;
            }
        }
        return null;
    }
}

