/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.datacontainer;

import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.upgradepackage.verify.FailedUCFChecksumErrorInformation;

public class UCF_ControlResultContainer {
    String myUP_ProductNumber = null;
    String myUP_ProductRevision = null;
    ChecksumFileResultInterface myChecksumFileResultInterface = null;
    ChecksumFileResultInterface myChecksumFileOrigResultInterface = null;
    String myUCF_StoredChecksum = null;
    String myUCF_StoredOrigChecksum = null;
    String myUpgradeControlFilePath = null;
    String myOriginalUpgradeControlFilePath = null;

    public UCF_ControlResultContainer(String string, String string2, ChecksumFileResultInterface checksumFileResultInterface, ChecksumFileResultInterface checksumFileResultInterface2, String string3, String string4, String string5, String string6) {
        this.myUP_ProductNumber = string;
        this.myUP_ProductRevision = string2;
        this.myChecksumFileResultInterface = checksumFileResultInterface;
        this.myChecksumFileOrigResultInterface = checksumFileResultInterface2;
        this.myUCF_StoredChecksum = string3;
        this.myUCF_StoredOrigChecksum = string4;
        this.myUpgradeControlFilePath = string5;
        this.myOriginalUpgradeControlFilePath = string6;
    }

    public boolean isChecksumOK() {
        return this.isUcfFileChecksumOK() && this.isUcfOrigFileChecksumOK();
    }

    public boolean isUcfFileChecksumOK() {
        boolean bl = true;
        if (this.myUCF_StoredChecksum.length() != 0 && this.myChecksumFileResultInterface.getChecksum() != null && this.myChecksumFileResultInterface.getChecksum().length() != 0 && !this.myUCF_StoredChecksum.equals(this.myChecksumFileResultInterface.getChecksum())) {
            bl = false;
        }
        return bl;
    }

    public boolean isUcfOrigFileChecksumOK() {
        boolean bl = true;
        if (this.myUCF_StoredOrigChecksum.length() != 0 && this.myChecksumFileOrigResultInterface.getChecksum() != null && this.myChecksumFileOrigResultInterface.getChecksum().length() != 0 && !this.myUCF_StoredOrigChecksum.equals(this.myChecksumFileOrigResultInterface.getChecksum())) {
            bl = false;
        }
        return bl;
    }

    public String getUP_ProductNumber() {
        return this.myUP_ProductNumber;
    }

    public String getUP_ProductRevision() {
        return this.myUP_ProductRevision;
    }

    public ChecksumFileResultInterface getCalculatedChecksumUCFResultInformation() {
        return this.myChecksumFileResultInterface;
    }

    public ChecksumFileResultInterface getCalculatedChecksumUCF_OrigResultInformation() {
        return this.myChecksumFileOrigResultInterface;
    }

    public String getUCF_CalculatedChecksum() {
        return this.myChecksumFileResultInterface.getChecksum();
    }

    public String getUCF_CalculatedOrigChecksum() {
        return this.myChecksumFileOrigResultInterface.getChecksum();
    }

    public String getUCF_StoredChecksum() {
        return this.myUCF_StoredChecksum;
    }

    public String getUCF_StoredOrigChecksum() {
        return this.myUCF_StoredOrigChecksum;
    }

    public FailedUCFChecksumErrorInformation isCalculated_StoredChecksumMatched() {
        if (this.myUCF_StoredChecksum.equals(this.myChecksumFileResultInterface.getChecksum())) {
            return new FailedUCFChecksumErrorInformation(true);
        }
        return new FailedUCFChecksumErrorInformation(false, this.myUP_ProductNumber, this.myUP_ProductRevision, this.myUCF_StoredChecksum, this.myChecksumFileResultInterface.getChecksum(), this.myUpgradeControlFilePath, "The stored current ucf checksum is not matched with the calculated checksum of UCF");
    }

    public FailedUCFChecksumErrorInformation isCalculated_StoredOrigChecksumMatched() {
        if (this.myUCF_StoredOrigChecksum.equals(this.myChecksumFileOrigResultInterface.getChecksum())) {
            return new FailedUCFChecksumErrorInformation(true);
        }
        return new FailedUCFChecksumErrorInformation(false, this.myUP_ProductNumber, this.myUP_ProductRevision, this.myUCF_StoredChecksum, this.myChecksumFileOrigResultInterface.getChecksum(), this.myOriginalUpgradeControlFilePath, "The stored Orig UCF checksum is not matched with the calculated checksum of Original UCF ");
    }

    public String getCorruptFileInformation() {
        String string = "";
        if (!this.isUcfFileChecksumOK()) {
            string = "\n\tFile path: " + this.myChecksumFileResultInterface.getFilePath() + "\n\tStored checksum: " + this.myUCF_StoredChecksum + "\n\tCalculated checksum: " + this.myChecksumFileResultInterface.getChecksum();
        }
        if (!this.isUcfOrigFileChecksumOK()) {
            string = "\n\tFile path: " + this.myChecksumFileOrigResultInterface.getFilePath() + "\n\tStored checksum: " + this.myUCF_StoredOrigChecksum + "\n\tCalculated checksum: " + this.myChecksumFileOrigResultInterface.getChecksum();
        }
        return string;
    }

    public String toString() {
        return "\n\tmyUP_ProductNumber: " + this.myUP_ProductNumber + "\n\tmyUP_ProductRevision: " + this.myUP_ProductRevision + "\n\tmyChecksumUCFResultInformation: " + this.myChecksumFileResultInterface + "\n\tmyChecksumUCF_OrigResultInformation: " + this.myChecksumFileOrigResultInterface + "\n\tmyUCF_StoredChecksum: " + this.myUCF_StoredChecksum + "\n\tmyUCF_StoredOrigChecksum: " + this.myUCF_StoredOrigChecksum;
    }
}

