/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.piu;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.UpgradeablePlugInUnit;
import se.ericsson.cello.equipment.UpgradeablePlugInUnit2;
import se.ericsson.cello.equipment.eqaccess.PIU_AdmStateListenerAcessInterface;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.suaccess.FanMoSU_Access;
import se.ericsson.cello.equipment.suaccess.PiuMoAttributesInformation;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.managedelement.suaccess.FroRequestFailedInformationException;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.mao.RestartRejectedException;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.control.UpgradeRegistry;
import se.ericsson.cello.upgradepackage.control.UpgradeRegistryHandlerInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandler;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.fan.FanMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.fan.FanMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.NotAbleToReadJVM_RPU_DataException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.ClearAllPiuTypesReferencedByPlugInUnitException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeDefinitionMissingInUpgradeControlFileException;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class PIU_MO_Handler
implements PIU_MO_HandlerInterface {
    public PIU_MO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PIU_MO_Handler(MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public void clearAllPiuTypesReferencedByPlugInUnit() throws ClearAllPiuTypesReferencedByPlugInUnitException, MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearAllPiuTypesReferencedByPlugInUnit ()");
        }
        String[] stringArray = null;
        Control control = null;
        Coordinator coordinator = null;
        try {
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
                return;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "Registered Plug In Units are: " + SuLib.toString(stringArray));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                MoIterator moIterator;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "Collecting referenced PiuType MOs for plugInUnits of type: " + stringArray[i]);
                }
                if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
                while (moIterator.hasMoreElements()) {
                    try {
                        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                        if (genericUpgradeablePlugInUnit.getPiuType(null) != null) {
                            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                            coordinator = control.getCoordinator();
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "The plugInUnit MO '" + genericUpgradeablePlugInUnit + "' relation to PiuType '" + genericUpgradeablePlugInUnit.getPiuType(null) + "' is set to 'null'");
                            }
                            genericUpgradeablePlugInUnit.setPiuTypeForSwUpgrade(null, coordinator);
                            control.getTerminator().commit();
                            continue;
                        }
                        ManagedObject managedObject = genericUpgradeablePlugInUnit.getSwAllocation(null);
                        if (managedObject == null) {
                            if (!Trace.valid(this.getClass(), 22)) continue;
                            Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "The upgradeable PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not connected to a PiuTypeMO and" + "\n\tno SwAllocation Mo is connected to the PlugInUnit.");
                            continue;
                        }
                        if (!Trace.valid(this.getClass(), 22)) continue;
                        Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "The upgradeable PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not connected to a PiuTypeMO." + "\n\tThe SwAllocation Mo '" + managedObject + "' is connected to this PlugInUnit.");
                    }
                    catch (Exception exception) {
                        try {
                            Trace.error(this.getClass(), "clearAllPiuTypesReferencedByPlugInUnit ()", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\tException: " + exception.toString(), exception);
                            try {
                                if (control != null) {
                                    control.getTerminator().rollback();
                                }
                            }
                            catch (Exception exception2) {}
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                        throw new ClearAllPiuTypesReferencedByPlugInUnitException(exception.toString());
                    }
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "clearAllPiuTypesReferencedByPlugInUnit ()", "All PIU MO's references to PiuType MO's has been set to 'null'");
            }
        }
        catch (ClearAllPiuTypesReferencedByPlugInUnitException clearAllPiuTypesReferencedByPlugInUnitException) {
            throw clearAllPiuTypesReferencedByPlugInUnitException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "clearAllPiuTypesReferencedByPlugInUnit ()", "Exception caught: \n\tException: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("clearAllPiuTypesReferencedByPlugInUnit ()\n\tException caught: \n\tException: " + exception.toString());
        }
    }

    public void clearPlugInUnitsReferencesToPiuTypes(boolean bl) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "anIsInstalled: " + bl);
        }
        String[] stringArray = null;
        Control control = null;
        Coordinator coordinator = null;
        try {
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray != null && stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "Registered Plug In Units are: " + SuLib.toString(stringArray));
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    MoIterator moIterator;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "Collecting referenced PiuType MOs for plugInUnits of type: " + stringArray[i]);
                    }
                    if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
                    while (moIterator.hasMoreElements()) {
                        try {
                            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                            if (piuTypeMoSU_Access == null || piuTypeMoSU_Access.getIsInstalled(null) != bl) continue;
                            control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                            coordinator = control.getCoordinator();
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "The plugInUnit MO '" + genericUpgradeablePlugInUnit + "' relation to PiuType '" + genericUpgradeablePlugInUnit.getPiuType(null) + "' is set to 'null'" + "\n\tanIsInstalled: " + bl);
                            }
                            genericUpgradeablePlugInUnit.setPiuTypeForSwUpgrade(null, coordinator);
                            control.getTerminator().commit();
                        }
                        catch (Exception exception) {
                            try {
                                Trace.error(this.getClass(), "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\tException: " + exception.toString(), exception);
                                try {
                                    if (control != null) {
                                        control.getTerminator().rollback();
                                    }
                                }
                                catch (Exception exception2) {}
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                            throw new PIU_MO_HandlerException(exception.toString());
                        }
                    }
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "clearPlugInUnitsReferencesToPiuTypes (boolean anIsInstalled)", "PIU MO's references to PiuType MO's with state isIstalled set to '" + bl + "' has been set to 'null'");
            }
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw pIU_MO_HandlerException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "clearAllPiuTypesReferencedByPlugInUnit ()", "Exception caught: \n\tException: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("clearAllPiuTypesReferencedByPlugInUnit ()\n\tException caught: \n\tException: " + exception.toString());
        }
    }

    public void configureJVM_PIUsWithWildcards() throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configureJVM_PIUsWithWildcards ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
            for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
                this.updateJVM_PIU_ResourceWithWildcard(plugInUnitMoSU_AccessArray[i], coordinator);
                Transaction.commit(control);
            }
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            Transaction.rollback(control);
            throw new PIU_MO_HandlerException(jvmMO_HandlerException.toString());
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            Transaction.rollback(control);
            throw pIU_MO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "configureJVM_PIUsWithWildcards ()", "Throwable caught at configuration of JVM MPs with wildcards.", throwable);
            Transaction.rollback(control);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tconfigureJVM_PIUsWithWildcards()" + "\n\tThrowable caught at configuration of JVM MPs with wildcards." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public int getAdministrativeState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        return this.getAdministrativeState(genericUpgradeablePlugInUnit, coordinator, 2);
    }

    public Collection getAllPIU_MOs() throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllPIU_MOs( )");
        }
        HashSet<PlugInUnitMoSU_Access> hashSet = new HashSet<PlugInUnitMoSU_Access>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("PlugInUnit");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    hashSet.add((PlugInUnitMoSU_Access)moIterator.nextMo());
                }
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllPIU_MOs( )", "Throwable caught.\n\tThrowable: " + throwable.toString(), throwable);
            throw new PIU_MO_HandlerException("getAllPIU_MOs( )\n\tThrowable caught.\n\tThrowable: " + throwable.toString());
        }
    }

    public Vector getAllPiuTypesReferencedByPlugInUnit() throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllPiuTypesReferencedByPlugInUnit ()");
        }
        String[] stringArray = null;
        try {
            UpgradeRegistryHandlerInterface upgradeRegistryHandlerInterface = (UpgradeRegistryHandlerInterface)ServiceLocatorFacade.getRepository().getService(UpgradeRegistry.class);
            stringArray = upgradeRegistryHandlerInterface.getPlugInUnitMoTypeNames();
            if (stringArray == null || stringArray != null && stringArray.length == 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "No Upgradeable PlugInUnits exist in the node i.e. no UpgradeablePlugInUnits have been registered in the Upgrade Package function.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "Registered Plug In Units are: " + SuLib.toString(stringArray));
            }
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            Vector<PiuTypeMoData> vector = new Vector<PiuTypeMoData>();
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    MoIterator moIterator;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "Collecting referenced PiuType MOs for plugInUnits of type: " + stringArray[i]);
                    }
                    if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
                    while (moIterator.hasMoreElements()) {
                        try {
                            PiuTypeMoData piuTypeMoData;
                            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                            piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
                            if (piuTypeMoSU_Access != null) {
                                piuTypeMoData = piuTypeMO_HandlerInterface.getPiuTypeData(piuTypeMoSU_Access);
                                piuTypeMoData.setPlugInUnit(genericUpgradeablePlugInUnit);
                                vector.add(piuTypeMoData);
                                if (!Trace.valid(this.getClass(), 22)) continue;
                                Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "The PlugInUnit '" + genericUpgradeablePlugInUnit + "' and its referenced PiuType data '" + piuTypeMoData + "'\n\thas been added to the list.");
                                continue;
                            }
                            piuTypeMoData = genericUpgradeablePlugInUnit.getSwAllocation(null);
                            if (piuTypeMoData == null) {
                                if (!Trace.valid(this.getClass(), 22)) continue;
                                Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "The upgradeable PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not connected to a PiuTypeMO and" + "\n\tno SwAllocation Mo is connected to the PlugInUnit.");
                                continue;
                            }
                            if (!Trace.valid(this.getClass(), 22)) continue;
                            Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "The upgradeable PlugInUnit '" + genericUpgradeablePlugInUnit + "' is not connected to a PiuTypeMO." + "\n\tThe SwAllocation Mo '" + piuTypeMoData + "' is connected to this PlugInUnit.");
                        }
                        catch (Exception exception) {
                            try {
                                Trace.error(this.getClass(), "getAllPiuTypesReferencedByPlugInUnit ()", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\tException: " + exception.toString(), exception);
                            }
                            catch (Exception exception2) {
                                Trace.error(this.getClass(), "getAllPiuTypesReferencedByPlugInUnit ()", "Exception caught", exception2);
                            }
                            throw new PIU_MO_HandlerException("getAllPiuTypesReferencedByPlugInUnit ()\n\tException caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\tException: " + exception.toString());
                        }
                    }
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getAllPiuTypesReferencedByPlugInUnit ()", "The PiuType MOs referenced by PlugInUnits are: " + vector);
            }
            return vector;
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw pIU_MO_HandlerException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getAllPiuTypesReferencedByPlugInUnit ()", "Exception caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\tException: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("getAllPiuTypesReferencedByPlugInUnit ()\n\tException caught: \n\tThe types of UpgradeablePlugInUnits: " + SuLib.toString(stringArray) + "\n\tException: " + exception.toString());
        }
    }

    public String getOriginRevision(PlugInUnitMoSU_Access plugInUnitMoSU_Access) throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOriginRevision ( PlugInUnitMoSU_Access aPlugInUnitMo )", "aPlugInUnitMo: " + plugInUnitMoSU_Access);
        }
        SlotMoSU_Access slotMoSU_Access = null;
        try {
            slotMoSU_Access = (SlotMoSU_Access)plugInUnitMoSU_Access.getParent();
            String string = slotMoSU_Access.getRState(null);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getOriginRevision ( PlugInUnitMoSU_Access aPlugInUnitMo )", "RETURNS theOriginRevision: " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getOriginRevision ( PlugInUnitMoSU_Access aPlugInUnitMo )", "Throwable caught: \n\taPlugInUnitMo: " + plugInUnitMoSU_Access + "\n\ttheSlotMo: " + slotMoSU_Access + "\n\tThrowable: " + throwable.toString(), throwable);
            throw new PIU_MO_HandlerException("getOriginRevision ( PlugInUnitMoSU_Access aPlugInUnitMo )\n\tThrowable caught: \n\taPlugInUnitMo: " + plugInUnitMoSU_Access + "\n\ttheSlotMo: " + slotMoSU_Access + "\n\tThrowable: " + throwable.toString());
        }
    }

    public PlugInUnitMoSU_Access getPIU_MO(SlotMoSU_Access slotMoSU_Access) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPIU_MO(SlotMoSU_Access aSlotMo)", "aSlotMo: " + slotMoSU_Access);
        }
        try {
            if (slotMoSU_Access != null) {
                MoIterator moIterator = slotMoSU_Access.getChildren();
                ManagedObject managedObject = null;
                if (moIterator != null) {
                    while (moIterator.hasMoreElements()) {
                        managedObject = moIterator.nextMo();
                        if (managedObject instanceof PlugInUnitMoSU_Access) {
                            return (PlugInUnitMoSU_Access)managedObject;
                        }
                        if (!Trace.valid(this.getClass(), 20)) continue;
                        Trace.debug(this.getClass(), 20, "getPIU_MO(SlotMoSU_Access aSlotMo)", "The child MO for SlotMo is not a PlugInUnitMoSU_Access.\n\ttheMO: " + managedObject);
                    }
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPIU_MO(SlotMoSU_Access aSlotMo)", "Throwable caught ...\n\taSlotMo: " + slotMoSU_Access, throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetPIU_MO(SlotMoSU_Access aSlotMo)" + "\n\taSlotMo: " + slotMoSU_Access + "\n\tThrowable caught ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public Collection getPIU_MOs(Collection collection) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPIU_MOs(Collection aSlotMos)", "aSlotMos: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LinkedList<PlugInUnitMoSU_Access> linkedList = new LinkedList<PlugInUnitMoSU_Access>();
            SlotMoSU_Access slotMoSU_Access = null;
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            while (iterator.hasNext()) {
                slotMoSU_Access = (SlotMoSU_Access)iterator.next();
                plugInUnitMoSU_Access = this.getPIU_MO(slotMoSU_Access);
                if (plugInUnitMoSU_Access == null) continue;
                linkedList.add(plugInUnitMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getPIU_MOs(Collection aSlotMos)", "RETURNS - thePIU_MOs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPIU_MOs(Collection aSlotMos)", "Throwable caught ...\n\taSlotMos: " + collection, throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetPIU_MOs(Collection aSlotMos)" + "\n\taSlotMos: " + collection + "\n\tThrowable caught ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public ProductNumberAndRevision getPIU_ProductNumberAndRevision(PlugInUnitMoSU_Access plugInUnitMoSU_Access) throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPIU_ProductNumberAndRevision(PlugInUnitMoSU_Access aPlugInUnitMo)", "aPlugInUnitMo: " + plugInUnitMoSU_Access);
        }
        try {
            PiuMoAttributesInformation piuMoAttributesInformation = plugInUnitMoSU_Access.getPiuAttributesInformation(null);
            return new ProductNumberAndRevision(piuMoAttributesInformation.getAdmProductNumber(), piuMoAttributesInformation.getAdmProductRevision());
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw pIU_MO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPIU_ProductNumberAndRevision ( PlugInUnitMoSU_Access aPlugInUnitMo )", "aPlugInUnitMo: " + plugInUnitMoSU_Access + "Throwable caught at ...", throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetPIU_ProductNumberAndRevision ( PlugInUnitMoSU_Access aPlugInUnitMo )" + "\n\taPlugInUnitMo: " + plugInUnitMoSU_Access + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public PiuTypeMoSU_Access getPiuTypeMO(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypeMO(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        try {
            return (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getPiuTypeMO(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "MoAccessException caught when trying to get connected PiuType MO.", moAccessException);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetPiuTypeMO(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit)" + "\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tMoAccessException info: " + moAccessException.toString());
        }
    }

    public int getShutdownTimer(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        return this.getShutdownTimer(genericUpgradeablePlugInUnit, coordinator, 2);
    }

    public SlotMoSU_Access getSlotMO(PlugInUnitMoSU_Access plugInUnitMoSU_Access) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSlotMO(PlugInUnitMoSU_Access aPIU_Mo)", "aPIU_Mo: " + plugInUnitMoSU_Access);
        }
        return (SlotMoSU_Access)plugInUnitMoSU_Access.getParent();
    }

    public boolean isJVM_Slot(SlotMoSU_Access slotMoSU_Access) throws MO_HandlerException {
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            return jvmMO_HandlerInterface.isJVM_Slot(slotMoSU_Access);
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "isJVM_Slot(SlotMoSU_Access aSlotMo)", "JvmMO_HandlerException caught when checking if a Slot is of type JVM Slot,\n\tJvmMO_HandlerException info: " + jvmMO_HandlerException.toString());
            }
            throw new PIU_MO_HandlerException(jvmMO_HandlerException.toString());
        }
    }

    public boolean isSU_VersionSupported(String string) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aPlugInUnitMoSU_Accesses)", "aSU_AccessVersion: " + string);
        }
        return this.isSU_VersionSupported(string, this.getAllPIU_MOs());
    }

    public boolean isSU_VersionSupported(String string, Collection collection) throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aPlugInUnitMoSU_Accesses)", "aSU_AccessVersion: " + string + "\n\taPlugInUnitMoSU_Accesses: " + collection);
        }
        try {
            boolean bl = false;
            Iterator iterator = collection.iterator();
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            if (iterator.hasNext()) {
                plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)iterator.next();
                if (SU_AccessVersionHandler.getInstance().isSupported(string, (Object)plugInUnitMoSU_Access)) {
                    bl = true;
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aPlugInUnitMoSU_Accesses)", "RETURNS - theIsSupported: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, Collection aPlugInUnitMoSU_Accesses)", "aSU_AccessVersion: " + string + "aPlugInUnitMoSU_Accesses: " + collection + "\n\tThrowable caught", throwable);
            throw new PIU_MO_HandlerException(throwable.toString());
        }
    }

    public boolean isSU_VersionSupported(String string, PlugInUnitMoSU_Access plugInUnitMoSU_Access) throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_VersionSupported(SU_AccessVersion aSU_AccessVersion, PlugInUnitMoSU_Access aPlugInUnitMoSU_Access)", "aSU_AccessVersion: " + string + "\n\taPlugInUnitMoSU_Access: " + plugInUnitMoSU_Access);
        }
        return SU_AccessVersionHandler.getInstance().isSupported(string, (Object)plugInUnitMoSU_Access);
    }

    public boolean isSignatureValidationSupported() throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSignatureValidationSupported()");
        }
        try {
            Collection collection = this.getPIUsSupportingValidationService();
            return !collection.isEmpty();
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new PIU_MO_HandlerException(mO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSignatureValidationSupported()", "Throwable caught", throwable);
            throw new PIU_MO_HandlerException(throwable.toString());
        }
    }

    public Collection getPIUsSupportingValidationService() throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPIUsSupportingValidationService()");
        }
        try {
            LinkedList<PlugInUnitMoSU_Access> linkedList = new LinkedList<PlugInUnitMoSU_Access>();
            if (this.isSU_VersionSupported("SU_3")) {
                Iterator iterator = this.getAllPIU_MOs().iterator();
                PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
                while (iterator.hasNext()) {
                    plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)iterator.next();
                    if (plugInUnitMoSU_Access.getSignatureValidationService(null) != 1) continue;
                    linkedList.add(plugInUnitMoSU_Access);
                }
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSignatureValidationSupported()", "SU_3 is not supported by PIU MOs");
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSignatureValidationSupported()", "RETURNS - thePIUsSupportingValidationService: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPIUsSupportingValidationService()", "Throwable caught", throwable);
            throw new PIU_MO_HandlerException(throwable.toString());
        }
    }

    public void restartPIU(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, int n2, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restartPIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aRestartRank, int aRestartType, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        this.restartPIU(genericUpgradeablePlugInUnit, n, n2, coordinator, 2);
    }

    public void setAdministrativeState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        this.setAdministrativeState(genericUpgradeablePlugInUnit, n, coordinator, 2);
    }

    public void setAdministrativeStateSwitch(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, int n2, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeStateSwitch(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        this.setAdministrativeStateSwitch(genericUpgradeablePlugInUnit, n, n2, coordinator, 2);
    }

    public boolean setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access plugInUnitMoSU_Access, int n, int n2, PIU_AdmStateHandler pIU_AdmStateHandler, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        return this.setAdministrativeStateSwitchUpgrade(plugInUnitMoSU_Access, n, n2, pIU_AdmStateHandler, coordinator, 2);
    }

    public boolean setAdministrativeStateUpgrade(PlugInUnitMoSU_Access plugInUnitMoSU_Access, int n, PIU_AdmStateHandler pIU_AdmStateHandler, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        return this.setAdministrativeStateUpgrade(plugInUnitMoSU_Access, n, pIU_AdmStateHandler, coordinator, 2);
    }

    public void setShutdownTimer(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aShutdownTimeValue, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator));
        }
        this.setShutdownTimer(genericUpgradeablePlugInUnit, n, coordinator, 2);
    }

    public void updateJVM_PIUs(SlotMoSU_Access slotMoSU_Access, SlotMoSU_Access slotMoSU_Access2, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateJVM_PIUs(SlotMoSU_Access anOldSlotMo, SlotMoSU_Access aNewSlotMo, Coordinator aCoordinator)", "anOldSlotMo: " + slotMoSU_Access + "\n\taNewSlotMo: " + slotMoSU_Access2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = this.getPIU_MO(slotMoSU_Access);
            PlugInUnitMoSU_Access plugInUnitMoSU_Access2 = this.getPIU_MO(slotMoSU_Access2);
            if (plugInUnitMoSU_Access != null) {
                this.updatePIU_Resource((GenericUpgradeablePlugInUnit)plugInUnitMoSU_Access, (PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(coordinator), false, coordinator);
            }
            if (plugInUnitMoSU_Access2 != null) {
                this.updateJVM_PIU_ResourceWithWildcard(plugInUnitMoSU_Access2, coordinator);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateJVM_PIUs(SlotMoSU_Access anOldSlotMo, SlotMoSU_Access aNewSlotMo, Coordinator aCoordinator)", "anOldSlotMo: " + slotMoSU_Access + "\n\taNewSlotMo: " + slotMoSU_Access2 + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught at ...", throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tupdateJVM_PIUs(SlotMoSU_Access anOldSlotMo, SlotMoSU_Access aNewSlotMo, Coordinator aCoordinator)" + "\n\tanOldSlotMo: " + slotMoSU_Access + "\n\taNewSlotMo: " + slotMoSU_Access2 + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught at ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public void updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access plugInUnitMoSU_Access, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator )", "aPIU: " + plugInUnitMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (plugInUnitMoSU_Access != null) {
                if (!this.isSU_VersionSupported("SU_2", plugInUnitMoSU_Access)) {
                    PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(coordinator);
                    if (piuTypeMoSU_Access != null) {
                        int n = piuTypeMoSU_Access.getRole(coordinator);
                        PiuMoAttributesInformation piuMoAttributesInformation = plugInUnitMoSU_Access.getPiuAttributesInformation(coordinator);
                        Struct struct = piuTypeMoSU_Access.getProductData(coordinator);
                        Object[] objectArray = struct.getValues();
                        String string = piuMoAttributesInformation.getAdmProductNumber();
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "updateJVM_PIU_ResourceWithWildcard ( PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator  )", "theproductNumber in PIU resource: " + string);
                        }
                        if (string != null && !string.equals("*")) {
                            if (!this.isCoreMP(plugInUnitMoSU_Access)) {
                                plugInUnitMoSU_Access.setPiuAttributes(piuMoAttributesInformation.getAdministrativeState(), "*", "*", (String)objectArray[2], (String)objectArray[4], "", piuMoAttributesInformation.getPIU_GroupNumber(), piuMoAttributesInformation.getAllowedSeqRestarts(), n, coordinator);
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator )", "The JVM PIU has been updated with wildcard product data.\n\taPIU: " + plugInUnitMoSU_Access + "\n\tthePiuType prodNo: " + (String)objectArray[0] + "\n\tthePiuType prodRev: " + (String)objectArray[1]);
                                }
                            }
                        } else if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator )", "The JVM PIU FRO already has been updated with the wildcard product data.");
                        }
                    } else if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator )", "The JVM PIU's PiuType is not set (i.e. == null). Ignoring the set of wildcard product data.");
                    }
                } else if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator )", "The PIU MO supports version 2 i.e. no update of wildcard product number and revision is needed\n\taPIU: " + plugInUnitMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updateJVM_PIU_ResourceWithWildcard(PlugInUnitMoSU_Access aPIU, Coordinator  aCoordinator )", "The JVM PIU is not configured i.e. the PIU MO does not exist for the RPU slot.\n\tIgnoring the set of wildcard product data.");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "", "Throwable caught at ...", throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + "\n\tThrowable caught at ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public void updatePIU_MOsWithNewPiuTypeMOs(Vector vector) throws MO_HandlerException, PiuTypeDefinitionMissingInUpgradeControlFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePIU_MOsWithNewPiuTypeMOs ( Vector aPiuTypeMosData )", "aPiuTypeMosData: " + vector);
        }
        Enumeration enumeration = vector.elements();
        PiuTypeMoData piuTypeMoData = null;
        String string = null;
        String string2 = null;
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        Control control = null;
        Coordinator coordinator = null;
        PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
        String string3 = null;
        try {
            while (enumeration.hasMoreElements()) {
                piuTypeMoData = (PiuTypeMoData)enumeration.nextElement();
                string = piuTypeMoData.productNumber;
                string2 = piuTypeMoData.productRevision;
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                coordinator = control.getCoordinator();
                piuTypeMoSU_Access = piuTypeMO_HandlerInterface.getPiuTypeMo(string, string2, false, coordinator);
                if (piuTypeMoSU_Access == null && (string3 = upgradeablePIU_HandlerInterface.getOriginRevision(piuTypeMoData.plugInUnit)) != null) {
                    piuTypeMoSU_Access = piuTypeMO_HandlerInterface.getPiuTypeMo(string, string3, false, coordinator);
                }
                if (piuTypeMoSU_Access != null) {
                    piuTypeMoData.plugInUnit.setPiuTypeForSwUpgrade((ManagedObject)piuTypeMoSU_Access, coordinator);
                } else {
                    Trace.warning(this.getClass(), "updatePIU_MOsWithNewPiuTypeMOs ( Vector aPiuTypeMosData )", "The PlugInUnit '" + piuTypeMoData.plugInUnit + "'" + "\n\tis not supported by the upgrade package i.e. no PiuType definition containing product number" + "\n\t'" + string + "' and product revision '" + string2 + "' is present in the UCF.");
                }
                control.getTerminator().commit();
            }
        }
        catch (PiuTypeDefinitionMissingInUpgradeControlFileException piuTypeDefinitionMissingInUpgradeControlFileException) {
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw piuTypeDefinitionMissingInUpgradeControlFileException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "updatePIU_MOsWithNewPiuTypeMOs ( Vector aPiuTypeMosData )", "MoAccessException caught at deletion of all existing PiuType MO's.", moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PIU_MO_HandlerException("updatePIU_MOsWithNewPiuTypeMOs ( Vector aPiuTypeMosData )\n\taPiuTypeMosData: " + vector + "\n\tMoAccessException caught at deletion of all existing PiuType MO's." + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "updatePIU_MOsWithNewPiuTypeMOs ( Vector aPiuTypeMosData )", "Exception caught at deletion of all existing PiuType MO's.", exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PIU_MO_HandlerException("updatePIU_MOsWithNewPiuTypeMOs ( Vector aPiuTypeMosData )\n\taPiuTypeMosData: " + vector + "\n\tException caught at deletion of all existing PiuType MO's: " + exception.toString());
        }
    }

    public void updatePIU_MO_Resource(PiuTypeMoSU_Access piuTypeMoSU_Access, PlugInUnitMoSU_Access plugInUnitMoSU_Access, boolean bl, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePIU_MO_Resource(PiuTypeMoSU_Access aPiuTypeMo, PlugInUnitMoSU_Access aPIU_MO, Coordinator  aCoordinator)", "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\taPIU_MO: " + plugInUnitMoSU_Access + "\n\taCoordinator: " + coordinator);
        }
        try {
            PiuMoAttributesInformation piuMoAttributesInformation;
            Struct struct = piuTypeMoSU_Access.getProductData(coordinator);
            Object[] objectArray = struct.getValues();
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            String string3 = (String)objectArray[2];
            String string4 = (String)objectArray[4];
            int n = piuTypeMoSU_Access.getRole(coordinator);
            if (bl) {
                if (!this.isSU_VersionSupported("SU_2", plugInUnitMoSU_Access)) {
                    if (this.isJVM_PIU(plugInUnitMoSU_Access)) {
                        piuMoAttributesInformation = this.getManagedElement();
                        ManagedObject[] managedObjectArray = piuMoAttributesInformation.getFtcsMos(null);
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "updatePIU_MO_Resource(PiuTypeMoSU_Access aPiuTypeMo, PlugInUnitMoSU_Access aPIU_MO, boolean anIsJVM_PIU_toBeChecked, Coordinator aCoordinator )", "aPIU_MO: " + plugInUnitMoSU_Access + "\n\ttheFTC_PIU_MOs: " + SuLib.toString(managedObjectArray));
                        }
                        boolean bl2 = true;
                        if (managedObjectArray != null) {
                            for (int i = 0; i < managedObjectArray.length; ++i) {
                                if (managedObjectArray[i] == null || !managedObjectArray[i].getParent().equals(plugInUnitMoSU_Access.getParent())) continue;
                                bl2 = false;
                                break;
                            }
                        }
                        if (bl2) {
                            string = "*";
                            string2 = "*";
                        }
                    }
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "updatePIU_MO_Resource(PiuTypeMoSU_Access aPiuTypeMo, PlugInUnitMoSU_Access aPIU_MO, boolean anIsJVM_PIU_toBeChecked, Coordinator aCoordinator )", "The PIU Mo supports version 2 i.e. no update of wildcard for JVM PIU is required\n\taPIU_MO: " + plugInUnitMoSU_Access);
                }
            }
            piuMoAttributesInformation = plugInUnitMoSU_Access.getPiuAttributesInformation(coordinator);
            plugInUnitMoSU_Access.setPiuAttributes(piuMoAttributesInformation.getAdministrativeState(), string, string2, string3, string4, "", piuMoAttributesInformation.getPIU_GroupNumber(), piuMoAttributesInformation.getAllowedSeqRestarts(), n, coordinator);
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw pIU_MO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updatePIU_MO_Resource(PiuTypeMoSU_Access  aPiuTypeMo, PlugInUnitMoSU_Access aPIU_MO, Coordinator  aCoordinator)", "Throwable caught when attempting to update the PIU Resource,\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taPIU_MO: " + plugInUnitMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + throwable.toString(), throwable);
            throw new PIU_MO_HandlerException("updatePIU_MO_Resource(PiuTypeMoSU_Access aPiuTypeMo, PlugInUnitMoSU_Access aPIU_MO, Coordinator  aCoordinator)\n\tThrowable caught when attempting to update the PIU Resource.\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taPIU_MO: " + plugInUnitMoSU_Access + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void updatePIU_Resource(SlotMoSU_Access slotMoSU_Access, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePIU_Resource(SlotMoSU_Access aSlotMo, Coordinator aCoordinator)", "aSlotMo: " + slotMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = this.getPIU_MO(slotMoSU_Access);
            if (plugInUnitMoSU_Access != null) {
                this.updatePIU_Resource((GenericUpgradeablePlugInUnit)plugInUnitMoSU_Access, (PiuTypeMoSU_Access)plugInUnitMoSU_Access.getPiuType(coordinator), false, coordinator);
            }
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw pIU_MO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updatePIU_Resource(SlotMoSU_Access aSlotMo, Coordinator aCoordinator)", "aSlotMo: " + slotMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "Throwable caught at ...", throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tupdatePIU_Resource(SlotMoSU_Access aSlotMo, Coordinator aCoordinator)" + "\n\taSlotMo: " + slotMoSU_Access + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught at ...." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public void updatePIU_Resource(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, PiuTypeAccess piuTypeAccess, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePIU_Resource(GenericUpgradeablePlugInUnitaPIU, PiuTypeAccess aPiuTypeMo, Coordinator aCoordinator)", "aPIU: " + genericUpgradeablePlugInUnit + "\n\taPiuTypeMo: " + piuTypeAccess + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        this.updatePIU_Resource(genericUpgradeablePlugInUnit, (PiuTypeMoSU_Access)piuTypeAccess, true, coordinator);
    }

    private int getAdministrativeState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator, int n) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n);
        }
        try {
            --n;
            return genericUpgradeablePlugInUnit.getAdministrativeState(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to get the administrative state in the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.getAdministrativeState(genericUpgradeablePlugInUnit, coordinator, n);
            }
            Trace.error(this.getClass(), "getAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to get the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to retreive the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to get the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to get the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n + "\n\tException data: " + exception.toString());
        }
    }

    private int getShutdownTimer(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator, int n) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfAttempts)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n);
        }
        try {
            --n;
            return genericUpgradeablePlugInUnit.getShutDownTimer(coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getShutdownTimer(UpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to retreive the ShutdownTimer for the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.getShutdownTimer(genericUpgradeablePlugInUnit, coordinator, n);
            }
            Trace.error(this.getClass(), "getShutdownTimer(UpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to retreive the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to retreive the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, Coordinator aCoordinator, int aNumberOfAttempts)", "Exception caught when trying to retreive the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to retreive the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    public boolean isCoreMP(PlugInUnitMoSU_Access plugInUnitMoSU_Access) throws PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCoreMP ( PlugInUnitMoSU_Access aPIU )", "aPIU: " + plugInUnitMoSU_Access);
        }
        try {
            MoFactory moFactory = MoFactoryMgr.instance().lookup("ManagedElement");
            ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)((SingletonMoFactory)moFactory).getMo();
            ManagedObject[] managedObjectArray = managedElementMoSU_Access.getFtcsMos(null);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "isCoreMP ( PlugInUnitMoSystemUpgradeAccess aPIU )", "aPIU: " + plugInUnitMoSU_Access + "\n\ttheFTC_PIU_MOs: " + SuLib.toString(managedObjectArray));
            }
            boolean bl = false;
            if (managedObjectArray != null) {
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    if (managedObjectArray[i] == null || !managedObjectArray[i].getParent().equals(plugInUnitMoSU_Access.getParent())) continue;
                    bl = true;
                    break;
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "isCoreMP ( PlugInUnitMoSU_Access aPIU )", "Returns: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isCoreMP ( PlugInUnitMoSU_Access aPIU )", "Throwable caught when trying to ...\n\taPIU: " + plugInUnitMoSU_Access + throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tisCoreMP ( PlugInUnitMoSU_Access aPIU )" + "\n\taPIU: " + plugInUnitMoSU_Access + "\n\tThrowable caught." + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public boolean isJVM_PIU(PlugInUnitMoSU_Access plugInUnitMoSU_Access) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isJVM_PIU(PlugInUnitMoSU_Access aPlugInUnitMo)", "aPlugInUnitMo: " + plugInUnitMoSU_Access);
        }
        try {
            if (plugInUnitMoSU_Access != null) {
                JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
                PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
                for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                    if (!plugInUnitMoSU_Access.equals(plugInUnitMoSU_AccessArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (NotAbleToReadJVM_RPU_DataException notAbleToReadJVM_RPU_DataException) {
            return false;
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "isJVM_PIU(PlugInUnitMoSU_Access aPlugInUnitMo)", "JvmMO_HandlerException caught when checking if a PIU is of type JVM MP,\n\tJvmMO_HandlerException info: " + jvmMO_HandlerException.toString());
            }
            throw new PIU_MO_HandlerException(jvmMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isJVM_PIU(PlugInUnitMoSU_Access aPlugInUnitMo)", "Throwable caught when checking if a PIU is of type JVM MP.", throwable);
            throw new PIU_MO_HandlerException("Class name: " + this.getClass().getName() + "\n\tisJVM_PIU(PlugInUnitMoSU_Access aPlugInUnitMo)" + "\n\tThrowable caught when checking if a PIU is of type JVM MP," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    private void restartPIU(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, int n2, Coordinator coordinator, int n3) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restartPIU(UpgradeablePlugInUnit anUpgradeablePlugInUnit, int aRestartRank, int aRestartType, Coordinator aCoordinator)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n3);
        }
        try {
            --n3;
            if (genericUpgradeablePlugInUnit instanceof UpgradeablePlugInUnit) {
                Control control = Transaction.create();
                coordinator = Transaction.getCoordinator(control);
                ((UpgradeablePlugInUnit)genericUpgradeablePlugInUnit).actionRestart(n, n2, coordinator);
                Transaction.commit(control);
            } else if (genericUpgradeablePlugInUnit instanceof UpgradeablePlugInUnit2) {
                ((UpgradeablePlugInUnit2)genericUpgradeablePlugInUnit).systemInitiatedRestart(n, 30, "", coordinator);
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n3 > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restartPIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aRestartRank, int aRestartType, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to restart the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString());
                }
                this.restartPIU(genericUpgradeablePlugInUnit, n, n2, coordinator, n3);
            }
            Trace.error(this.getClass(), "restartPIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aRestartRank, int aRestartType, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to restart the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to restart the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (RestartRejectedException restartRejectedException) {
            Trace.info(this.getClass(), "restartPIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aRestartRank, int aRestartType, Coordinator aCoordinator, int aNumberOfAttempts)", "RestartRejectedException caught when trying to restart the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + restartRejectedException.toString());
            throw new PIU_MO_HandlerException("Exception caught when trying to restart the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + restartRejectedException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "restartPIU(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aRestartRank, int aRestartType, Coordinator aCoordinator, int aNumberOfAttempts)", "Throwable caught when trying to restart the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + throwable.toString(), throwable);
            throw new PIU_MO_HandlerException("Throwable caught when trying to restart the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taRestartRank: " + n + "\n\taRestartType: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + throwable.toString());
        }
    }

    private void setAdministrativeState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, Coordinator coordinator, int n2) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2);
        }
        try {
            --n2;
            Trace.flushToTraceFile();
            genericUpgradeablePlugInUnit.setAdministrativeState(n, coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n2 > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString());
                }
                this.setAdministrativeState(genericUpgradeablePlugInUnit, n, coordinator, n2);
            }
            Trace.error(this.getClass(), "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to retreive the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setAdministrativeState(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, Coordinator aCoordinator)", "Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + exception.toString());
        }
    }

    private void setAdministrativeStateSwitch(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, int n2, Coordinator coordinator, int n3) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeStateSwitch(UpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3);
        }
        try {
            --n3;
            Trace.flushToTraceFile();
            genericUpgradeablePlugInUnit.setAdministrativeStateSwitch(n, n2, coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n3 > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setAdministrativeStateSwitch(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString());
                }
                this.setAdministrativeStateSwitch(genericUpgradeablePlugInUnit, n, n2, coordinator, n3);
            }
            Trace.error(this.getClass(), "setAdministrativeStateSwitch(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setAdministrativeStateSwitch(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, Coordinator aCoordinator)", "Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + exception.toString());
        }
    }

    private boolean setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access plugInUnitMoSU_Access, int n, int n2, PIU_AdmStateHandler pIU_AdmStateHandler, Coordinator coordinator, int n3) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "anUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taSwitchAtLockOrNot: " + n2 + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3);
        }
        int n4 = plugInUnitMoSU_Access.getInvalidAdmStateValue();
        try {
            --n3;
            Trace.flushToTraceFile();
            plugInUnitMoSU_Access.setAdministrativeStateSwitchUpgrade(n, n2, (PIU_AdmStateListenerAcessInterface)pIU_AdmStateHandler, coordinator);
            return true;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n3 > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.setAdministrativeStateSwitchUpgrade(plugInUnitMoSU_Access, n, n2, pIU_AdmStateHandler, coordinator, n3);
            }
            Trace.error(this.getClass(), "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (FroRequestFailedInformationException froRequestFailedInformationException) {
            if (froRequestFailedInformationException.result == n4) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "The setting of the administrative state to '" + n + "' for" + "\n\tPIU '" + plugInUnitMoSU_Access + "' was not successfully performed." + "\n\tThis failure shall be ignored by the upgrade logic i.e. the execution of the upgrade shall continue.");
                }
                return false;
            }
            Trace.error(this.getClass(), "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "When attempting to set the administrative state to '" + n + "' an exception was caught." + "\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tException data: " + froRequestFailedInformationException.toString(), froRequestFailedInformationException);
            throw new PIU_MO_HandlerException("When attempting to set the administrative state to '" + n + "' an exception was caught." + "\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tException data: " + froRequestFailedInformationException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setAdministrativeStateSwitchUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, int aSwitchAtLockOrNot, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n3 + "\n\tException data: " + exception.toString());
        }
    }

    private boolean setAdministrativeStateUpgrade(PlugInUnitMoSU_Access plugInUnitMoSU_Access, int n, PIU_AdmStateHandler pIU_AdmStateHandler, Coordinator coordinator, int n2) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts)", "anUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2);
        }
        int n3 = plugInUnitMoSU_Access.getInvalidAdmStateValue();
        try {
            --n2;
            Trace.flushToTraceFile();
            plugInUnitMoSU_Access.setAdministrativeStateUpgrade(n, (PIU_AdmStateListenerAcessInterface)pIU_AdmStateHandler, coordinator);
            return true;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n2 > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts))", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString());
                }
                return this.setAdministrativeStateUpgrade(plugInUnitMoSU_Access, n, pIU_AdmStateHandler, coordinator, n2);
            }
            Trace.error(this.getClass(), "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts))", "FroNotAccessibleException caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (FroRequestFailedInformationException froRequestFailedInformationException) {
            if (froRequestFailedInformationException.result == n3) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts))", "The setting of the administrative state to '" + n + "' for" + "\n\tPIU '" + plugInUnitMoSU_Access + "' was not successfully performed." + "\n\tThis failure shall be ignored by the upgrade logic i.e. the execution of the upgrade shall continue.");
                }
                return false;
            }
            Trace.error(this.getClass(), "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts))", "When attempting to set the administrative state to '" + n + "' an exception was caught." + "\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tException data: " + froRequestFailedInformationException.toString(), froRequestFailedInformationException);
            throw new PIU_MO_HandlerException("When attempting to set the administrative state to '" + n + "' an exception was caught." + "\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tException data: " + froRequestFailedInformationException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setAdministrativeStateUpgrade(PlugInUnitMoSU_Access anUpgradeablePlugInUnit, int anAdminState, PIU_AdmStateHandler aPIU_AdmStateHandler, Coordinator aCoordinator, int aNumberOfRemainingAttempts))", "Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the administrative state in the PIU.\n\tanUpgradeablePlugInUnit: " + plugInUnitMoSU_Access + "\n\tanAdminState: " + n + "\n\taPIU_AdmStateHandler: " + pIU_AdmStateHandler + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfRemainingAttempts: " + n2 + "\n\tException data: " + exception.toString());
        }
    }

    private void setShutdownTimer(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, int n, Coordinator coordinator, int n2) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setShutdownTimer(UpgradeablePlugInUnit anUpgradeablePlugInUnit, int aShutdownTimeValue, Coordinator aCoordinator, int aNumberOfAttempts)", "anUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n2);
        }
        try {
            --n2;
            genericUpgradeablePlugInUnit.setShutDownTimer(n, coordinator);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (n2 > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aShutdownTimeValue, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to set the ShutdownTimer for the PIU.\n\tTrying one more time due to the FRO might have been switch after request signal has been sent but before a reply was returned.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\taNumberOfAttempts: " + n2 + "\n\tException data: " + froNotAccessibleException.toString());
                }
                this.setShutdownTimer(genericUpgradeablePlugInUnit, n, coordinator, n2);
            }
            Trace.error(this.getClass(), "setShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aShutdownTimeValue, Coordinator aCoordinator, int aNumberOfAttempts)", "FroNotAccessibleException caught when trying to set the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setShutdownTimer(GenericUpgradeablePlugInUnit anUpgradeablePlugInUnit, int aShutdownTimeValue, Coordinator aCoordinator, int aNumberOfAttempts)", "Exception caught when trying to set the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString(), exception);
            throw new PIU_MO_HandlerException("Exception caught when trying to set the ShutdownTimer for the PIU.\n\tanUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taShutdownTimeValue: " + n + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + exception.toString());
        }
    }

    private void updatePIU_Resource(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, PiuTypeMoSU_Access piuTypeMoSU_Access, boolean bl, Coordinator coordinator) throws MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePIU_Resource ( GenericUpgradeablePlugInUnit aPIU, PiuTypeMoSU_Access aPiuTypeMo, Coordinator aCoordinator )", "aPIU: " + genericUpgradeablePlugInUnit + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tanIsJVM_PIU_toBeChecked: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            if (genericUpgradeablePlugInUnit != null && piuTypeMoSU_Access != null) {
                if (genericUpgradeablePlugInUnit instanceof FanMoSU_Access) {
                    FanMO_HandlerInterface fanMO_HandlerInterface = ServiceFinder.getFanMO_HandlerInterface();
                    fanMO_HandlerInterface.updateFanMO_Resource2(piuTypeMoSU_Access, (FanMoSU_Access)genericUpgradeablePlugInUnit, coordinator);
                } else if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                    this.updatePIU_MO_Resource(piuTypeMoSU_Access, (PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit, bl, coordinator);
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "updatePIU_Resource ( UpgradeablePlugInUnit aPIU, PiuTypeMoSU_Access aPiuTypeMo, boolean anIsJVM_PIU_toBeChecked, Coordinator aCoordinator )", "The upgradeable PIU is not updated with the new product no and revision due to it is not a CPP U-PIU.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tanIsJVM_PIU_toBeChecked: " + bl);
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updatePIU_Resource ( GenericUpgradeablePlugInUnit aPIU, PiuTypeMoSU_Access aPiuTypeMo, boolean anIsJVM_PIU_toBeChecked, Coordinator aCoordinator )", "The given PIU and/or piuType was not defined (i.e. null) - ignoring the setting.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tanIsJVM_PIU_toBeChecked: " + bl);
            }
        }
        catch (FanMO_HandlerException fanMO_HandlerException) {
            throw new PIU_MO_HandlerException(fanMO_HandlerException.toString());
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            throw pIU_MO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updatePIU_Resource ( GenericUpgradeablePlugInUnit aPIU, PiuTypeMoSU_Access aPiuTypeMo, boolean anIsJVM_PIU_toBeChecked, Coordinator aCoordinator)", "Throwable caught when attempting to update the PIU Resource,\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tanIsJVM_PIU_toBeChecked: " + bl + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tException data: " + throwable.toString(), throwable);
            throw new PIU_MO_HandlerException("updatePIU_Resource ( GenericUpgradeablePlugInUnit aPIU, PiuTypeMoSU_Access aPiuTypeMo, boolean anIsJVM_PIU_toBeChecked, Coordinator aCoordinator )\n\tThrowable caught when attempting to update the PIU Resource.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tanIsJVM_PIU_toBeChecked: " + bl + "\n\taCoordinator: " + Transaction.toString(coordinator) + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private ManagedElementMoSU_Access getManagedElement() {
        return (ManagedElementMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementMoSU_Access.class);
    }
}

