/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.program;

import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramHandlerFactory;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramHandlerInterface;

public class PlugInUnitHelper {
    private GenericUpgradeablePlugInUnit plugInUnit;

    public PlugInUnitHelper(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "PlugInUnitHelper(GenericUpgradeablePlugInUnit plugInUnit)", "plugInUnit: " + genericUpgradeablePlugInUnit);
        }
        this.plugInUnit = genericUpgradeablePlugInUnit;
    }

    public void reconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reconfigureProgramPrepare(Coordinator aCoordinator)", "aCoordinator: " + coordinator);
        }
        ProgramHandlerInterface programHandlerInterface = ProgramHandlerFactory.getInstance().getProgramHandlerInterface(this.plugInUnit);
        programHandlerInterface.reconfigurePrograms(coordinator);
    }

    public void removeDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeDisabledPrograms(Coordinator aCoordinator)", "aCoordinator: " + SuLib.toString(coordinator));
        }
        ProgramHandlerInterface programHandlerInterface = ProgramHandlerFactory.getInstance().getProgramHandlerInterface(this.plugInUnit);
        programHandlerInterface.removeDisabledPrograms(coordinator);
    }
}

