/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.repertoire;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstanceRecordException;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue;
import se.ericsson.cello.swmanagement.suaccess.ExtendedLoadModuleRefInfo;
import se.ericsson.cello.swmanagement.suaccess.ExtendedLoadModuleRefInfo2;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleRefInfo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeLoadListInfo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeRefInfo;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoFactorySU_Access;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.parser.configsupport.ConfigSupportMoSAXdh;
import se.ericsson.cello.upgradepackage.upgrade.parser.configsupport.ConfigSupportMosListener;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeReplacement;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.base.MO_HandlerBase;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationData;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleRefLDN_Information;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.PiuTypeInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.PiuTypeNotReferencedException;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.TagAndLoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class RepertoireMO_Handler
extends MO_HandlerBase
implements ConfigSupportMosListener,
RepertoireMO_HandlerInterface {
    private String myUCF_Path = null;
    private String myUpgradeCaseLabel = null;
    private UpgradeReplacement[] myRepertoireExplicitReplacementInformation = null;

    public RepertoireMO_Handler(String string, String string2, MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RepertoireMO_Handler(String anUCF_Path, String anUpgradeCaseLabel, MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)", "anUCF_Path: " + string + "\n\tanUpgradeCaseLabel: " + string2);
        }
        this.myUCF_Path = string;
        this.myUpgradeCaseLabel = string2;
    }

    public RepertoireMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RepertoireMO_Handler (MO_HandlerFactoryInterface aMO_HandlerFactoryInterface)");
        }
    }

    public void clearReferencedPiuTypes() throws RepertoireMO_HandlerException {
        Control control = null;
        try {
            if (this.isSU_VersionSupported("SU_2")) {
                control = Transaction.create();
                Coordinator coordinator = Transaction.getCoordinator(control);
                Iterator iterator = this.getAllRepertoireMos().iterator();
                RepertoireMoSU_Access repertoireMoSU_Access = null;
                while (iterator.hasNext()) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                    repertoireMoSU_Access.clearReferencedPiuTypeMos(coordinator);
                }
            } else {
                Trace.info(this.getClass(), "clearReferencedPiuTypes()", "SU Access version 2 is not supported by Repertoire MOs i.e. aborts the execution.");
                throw new RepertoireMO_HandlerException("SU Access version 2 is not supported by Repertoire MOs");
            }
            Transaction.commit(control);
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            Transaction.rollback(control);
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Transaction.rollback(control);
            Trace.error(this.getClass(), "clearReferencedPiuTypes()", "Throwable caught\n\tThrowable data", throwable);
        }
    }

    public boolean isSU_VersionSupported(String string) throws RepertoireMO_HandlerException {
        MoFactory moFactory = MoFactoryMgr.instance().lookup("Repertoire");
        return SU_AccessVersionHandler.getInstance().isSupported(string, (Object)moFactory);
    }

    public boolean isRepertoireMOsDependentOnSU_DOM() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRepertoireMOsDependentOnSU_DOM()");
        }
        try {
            boolean bl = false;
            if (this.isSU_VersionSupported("SU_2")) {
                Iterator iterator = this.getRepertoireMOs().iterator();
                RepertoireMoSU_Access repertoireMoSU_Access = null;
                while (iterator.hasNext()) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                    if (!repertoireMoSU_Access.getSU_DOM_Required(null)) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isRepertoireMOsDependentOnSU_DOM()", "Throwable caught", throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public void configSupportMoCallback(UpgradeReplacement[] upgradeReplacementArray, Vector vector, Vector vector2) {
        if (upgradeReplacementArray != null) {
            try {
                String string = "[ ";
                if (upgradeReplacementArray != null) {
                    for (int i = 0; i < upgradeReplacementArray.length; ++i) {
                        string = string + upgradeReplacementArray[i];
                    }
                }
                string = string + " ]";
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "configSupportMoCallback ( UpgradeReplacement[] urList, Vector anOldRPUs, Vector aNewRPUs)", "\taRepertoireExplicitReplacementInformation: " + string + "\n\tanOldRPUs: " + vector + "\n\taNewRPUs: " + vector2);
                }
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "configSupportMoCallback ( UpgradeReplacement[] urList, Vector anOldRPUs, Vector aNewRPUs)", "Exception caught while decoding explicit replacement data for tracing. Ignoring this exception...\n\tException data: " + exception.toString(), exception);
            }
            this.myRepertoireExplicitReplacementInformation = (UpgradeReplacement[])upgradeReplacementArray.clone();
        }
    }

    public ManagedObject createRepertoire(String string, String string2, String string3, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRepertoire(String anIdentity, String anInfo, String aName, Coordinator aCoordinator)", "anIdentity:" + string + "\n\tanInfo: " + string2 + "\n\taName: " + string3 + "\n\taCoordinator: " + coordinator);
        }
        AttrListImpl attrListImpl = new AttrListImpl(4);
        attrListImpl.addElement("name", (Object)string3);
        attrListImpl.addElement("info", (Object)string2);
        SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
        MoFactory moFactory = MoFactoryMgr.instance().lookup("Repertoire");
        return moFactory.createMo(singletonMoFactory.getMo(), (AttrList)attrListImpl, string, singletonMoFactory.getMo(), coordinator);
    }

    public ManagedObject createRepertoire(String string, String string2, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRepertoire(String anInfo, String aName, Coordinator aCoordinator)", "anInfo: " + string + "\n\taName: " + string2 + "\n\taCoordinator: " + coordinator);
        }
        SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
        ManagedObject managedObject = singletonMoFactory.getMo();
        String string3 = this.calculateRDN_Value(string2, "Repertoire", managedObject.getLocalDistinguishedName());
        MoFactory moFactory = MoFactoryMgr.instance().lookup("Repertoire");
        if (!this.isSU_VersionSupported("SU_2")) {
            throw new RepertoireMO_HandlerException("SU Access version 2 is not supported by Repertoire MO");
        }
        return ((RepertoireMoFactorySU_Access)moFactory).createMoAtUpgrade(managedObject, string, string2, string3, coordinator);
    }

    public Vector createRepertoires(Vector vector, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRepertoires(Vector aRepertoires, Coordinator aCoordinator)", "aRepertoires:" + vector + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Iterator iterator = vector.iterator();
        Vector<ManagedObject> vector2 = new Vector<ManagedObject>();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            ManagedObject managedObject = this.createRepertoire(string, "SU_AutoCreated" + string, string, coordinator);
            vector2.add(managedObject);
        }
        return vector2;
    }

    public void createRepertoireMO(AttributeList attributeList, Vector vector, Vector vector2, Hashtable hashtable) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )", "aReperoireAttributeList: " + attributeList + "\n\taRepertoireData: " + vector + "\n\taCurrentRepertoireMoDatas: " + vector2);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            String string = attributeList.getValue("name");
            String string2 = attributeList.getValue("information");
            if (string2 == null) {
                string2 = "";
            }
            AttrListImpl attrListImpl = new AttrListImpl(4);
            attrListImpl.addElement("name", (Object)string);
            attrListImpl.addElement("info", (Object)string2);
            String string3 = this.calculateLDN_Value(string, vector2);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Hashtable aLoadListsForOneRepertoire )", "Creating a Repertoire MO with the data: \n\tName: " + string + "\n\tInformation: " + string2 + "\n\tLDN value: " + string3);
            }
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            SingletonMoFactory singletonMoFactory = (SingletonMoFactory)MoFactoryMgr.instance().lookup("SwManagement");
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Repertoire");
            RepertoireMoSU_Access repertoireMoSU_Access = (RepertoireMoSU_Access)moFactory.createMo(singletonMoFactory.getMo(), (AttrList)attrListImpl, string3, singletonMoFactory.getMo(), coordinator);
            control.getTerminator().commit();
            control = null;
            this.setLoadListData(repertoireMoSU_Access, attributeList, vector, hashtable);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )", "Throwable caught.", throwable);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new RepertoireMO_HandlerException("createRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )\n\taReperoireAttributeList: " + attributeList + "\n\taRepertoireData: " + vector + "\n\taCurrentRepertoireMoDatas: " + vector2 + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public void setRepertoireMO(AttributeList attributeList, Vector vector, Vector vector2, Hashtable hashtable) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )", "aReperoireAttributeList: " + attributeList + "\n\taRepertoireData: " + vector + "\n\taCurrentRepertoireMoDatas: " + vector2);
        }
        try {
            String string = attributeList.getValue("name");
            RepertoireMoSU_Access repertoireMoSU_Access = this.getRepertoireMO(string);
            if (repertoireMoSU_Access == null) {
                Trace.error(this.getClass(), "setRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )", "The repertoire MO was not found (inconsistent configuration)\n\tThe repertoire MO name: " + string);
                throw new RepertoireMO_HandlerException("Class name: " + this.getClass() + "Method: setRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )" + "The repertoire MO was not found (inconsistent configuration)" + "\n\tThe repertoire MO name: " + string);
            }
            this.setLoadListData(repertoireMoSU_Access, attributeList, vector, hashtable);
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )", "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException("setRepertoireMO ( AttributeList aReperoireAttributeList, Vector aRepertoireData, Vector aCurrentRepertoireMoDatas, Hashtable aLoadListsForOneRepertoire )\n\taReperoireAttributeList: " + attributeList + "\n\taRepertoireData: " + vector + "\n\taCurrentRepertoireMoDatas: " + vector2 + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public void setLoadListData(RepertoireMoSU_Access repertoireMoSU_Access, AttributeList attributeList, Vector vector, Hashtable hashtable) throws RepertoireMO_HandlerException {
        String string = "setLoadListData(RepertoireMoSU_Access aRepertoireMoSU_Access, AttributeList aReperoireAttributeList, Vector aRepertoireData, Hashtable aLoadListsForOneRepertoire)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aRepertoireMoSU_Access: " + repertoireMoSU_Access + "\n\taReperoireAttributeList: " + attributeList + "\n\taRepertoireData: " + vector + "\n\taLoadListsForOneRepertoire: " + hashtable);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            HashSet<PiuTypeLoadListInfo> hashSet = new HashSet<PiuTypeLoadListInfo>();
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.elementAt(i);
                Vector vector3 = (Vector)vector2.elementAt(0);
                Vector vector4 = (Vector)vector2.elementAt(1);
                PiuTypeLoadListInfo piuTypeLoadListInfo = new PiuTypeLoadListInfo();
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = null;
                Map map = this.buildSetOfLM_MOsMap();
                for (int j = 0; j < vector4.size(); ++j) {
                    string2 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.ProductNumber.getValue());
                    string3 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.Revision.getValue());
                    string4 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.Tag.getValue());
                    string5 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.ProgramMemoryHeapSize.getValue());
                    string6 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.ProgramMemoryPoolSize.getValue());
                    string7 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.LoaderName.getValue());
                    string8 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.DeviceLoaderName.getValue());
                    string9 = ((AttributeList)vector4.elementAt(j)).getValue(LoadModuleRefAttributeName.DeviceLoaderInformation.getValue());
                    string10 = this.getProgramInstances(vector4, j);
                    string11 = loadModuleMO_HandlerInterface.getLoadModuleLDN_Value(string2 = SuLib.optimize(string2), string3 = SuLib.optimize(string3), loadModuleMO_HandlerInterface, map);
                    if (string11 == null) {
                        Trace.error(this.getClass(), string, "No LM MO was found for the LoadModule product data specified within the Repertoire:\n\tLM Product number: " + string2 + "\n\tLM Product revision: " + string3 + "\n\tRepertoire MO: " + repertoireMoSU_Access);
                        throw new RepertoireMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tNo LM MO was found for the LoadModule product data specified within the Repertoire:" + "\n\tLM Product number: " + string2 + "\n\tLM Product revision: " + string3 + "\n\tRepertoire MO: " + repertoireMoSU_Access);
                    }
                    piuTypeLoadListInfo.addLoadModuleRefInfo((LoadModuleRefInfo)new ExtendedLoadModuleRefInfo(string11, string4, string5, string6, string10, string7, string8, string9));
                }
                piuTypeLoadListInfo = this.addPiuTypeRefsForA_LoadList(vector3, piuTypeLoadListInfo);
                hashSet.add(piuTypeLoadListInfo);
            }
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            repertoireMoSU_Access.setPiuTypeLoadListInfos(hashSet, coordinator);
            Transaction.commit(control);
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw new RepertoireMO_HandlerException(string + "\n\taReperoireAttributeList: " + attributeList + "\n\taRepertoireData: " + vector + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private PiuTypeLoadListInfo addPiuTypeRefsForA_LoadList(Vector vector, PiuTypeLoadListInfo piuTypeLoadListInfo) throws RepertoireMO_HandlerException {
        String string = "addPiuTypeRefsForA_LoadList (Vector aPiuTypeRefsAttributeList, PiuTypeLoadListInfo aPiuTypeLoadListInfo)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aPiuTypeRefsAttributeList: " + vector + "\n\taPiuTypeLoadListInfo: " + piuTypeLoadListInfo);
        }
        try {
            String string2 = null;
            String string3 = null;
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            PiuTypeMO_HandlerInterface piuTypeMO_HandlerInterface = ServiceFinder.getPiuTypeMO_HandlerInterface();
            for (int i = 0; i < vector.size(); ++i) {
                string2 = ((AttributeList)vector.elementAt(i)).getValue("productNumber");
                piuTypeMoSU_Access = piuTypeMO_HandlerInterface.getPiuTypeMo(string2, string3 = ((AttributeList)vector.elementAt(i)).getValue("revision"));
                if (piuTypeMoSU_Access == null) {
                    Trace.error(this.getClass(), string, "No PiuType MO was found for the PiuType product data:\n\tPiuType Product number: " + string2 + "\n\tPiuType Product revision: " + string3);
                    throw new RepertoireMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tNo PiuType MO was found for the PiuType product data:" + "\n\tPiuType Product number: " + string2 + "\n\tPiuType Product revision: " + string3);
                }
                piuTypeLoadListInfo.addPiuTypeRefInfo(new PiuTypeRefInfo(piuTypeMoSU_Access.getLocalDistinguishedName()));
            }
            return piuTypeLoadListInfo;
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            throw repertoireMO_HandlerException;
        }
        catch (PiuTypeMO_HandlerException piuTypeMO_HandlerException) {
            throw new RepertoireMO_HandlerException(piuTypeMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\taPiuTypeRefsAttributeList: " + vector + "\n\taPiuTypeLoadListInfo: " + piuTypeLoadListInfo + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private String getProgramInstances(Vector vector, int n) throws ProgramInstanceRecordException {
        String string;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProgramInstances (Vector aLoadModuleRefsAttributeList)", "aLoadModuleRefsAttributeList: " + vector);
        }
        if ((string = ((AttributeList)vector.elementAt(n)).getValue(LoadModuleRefAttributeName.ProgramInstances.getValue())) != null) {
            Collection collection = ProgramInstancesValue.getProgramInstancesExpandedFormat(string);
            Iterator iterator = collection.iterator();
            string = "";
            while (iterator.hasNext()) {
                string = string + iterator.next();
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
        }
        return string;
    }

    public void createRepertoireMOsAccordingToUCF(Vector vector) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRepertoireMOsAccordingToUCF ( Vector aCurrentRepertoireMoDatas )", "aCurrentRepertoireMoDatas: " + vector);
        }
        try {
            Parser parser = ParserFactory.makeParser("com.microstar.xml.SAXDriver");
            ConfigSupportMoSAXdh configSupportMoSAXdh = new ConfigSupportMoSAXdh("CreateRepertoiresCmd", vector, this);
            parser.setDocumentHandler(configSupportMoSAXdh);
            parser.parse(new InputSource(new FileReader(new File(this.myUCF_Path))));
        }
        catch (SAXException sAXException) {
            Trace.error(this.getClass(), "createRepertoireMOsAccordingToUCF ( Hashtable anOldRepertoiresReferencedBySwAllocationMOs )", "SAXException caught at deletion of all existing PiuType MO's.", sAXException);
            throw new RepertoireMO_HandlerException("createRepertoireMOsAccordingToUCF ( Vector aCurrentRepertoireMoDatas )\n\taCurrentRepertoireMoDatas: " + vector + "\n\tSAXException data: " + sAXException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "createRepertoireMOsAccordingToUCF ( Hashtable anOldRepertoiresReferencedBySwAllocationMOs )", "Exception caught at deletion of all existing PiuType MO's.", exception);
            throw new RepertoireMO_HandlerException("createRepertoireMOsAccordingToUCF ( Vector aCurrentRepertoireMoDatas )\n\taCurrentRepertoireMoDatas: " + vector + "\n\tException data: " + exception.toString());
        }
    }

    public void deleteRepertoire(RepertoireMoSU_Access repertoireMoSU_Access, Coordinator coordinator) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteRepertoire(RepertoireMoSU_Access aRepertoireMo, Coordinator aCoordinator)");
        }
        try {
            repertoireMoSU_Access.delete(coordinator);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteRepertoire(RepertoireMoSU_Access aRepertoireMo, Coordinator aCoordinator)", "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public void deleteCurrentRepertoires() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteCurrentRepertoires()");
        }
        Control control = null;
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteCurrentRepertoires()", "No current repertoires exist.");
                }
                return;
            }
            while (moIterator.hasMoreElements()) {
                RepertoireMoSU_Access repertoireMoSU_Access = (RepertoireMoSU_Access)moIterator.nextMo();
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                Coordinator coordinator = control.getCoordinator();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteCurrentRepertoires()", "The Repertoire MO '" + repertoireMoSU_Access.getName(coordinator) + "' with distinguised name '" + repertoireMoSU_Access + "' is deleted." + "\n\tIsInstalled: " + repertoireMoSU_Access.getIsInstalled(coordinator));
                }
                repertoireMoSU_Access.delete(coordinator);
                control.getTerminator().commit();
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "deleteCurrentRepertoires()", "MoAccessException caught.\n\tMoAccessException data: " + moAccessException.toString(), moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RepertoireMO_HandlerException("deleteCurrentRepertoires()\n\tMoAccessException caught.\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteCurrentRepertoires()", "Exception caught.\n\tException data: " + exception.getMessage(), exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new RepertoireMO_HandlerException("deleteCurrentRepertoires()\n\tException caught.\n\tException data: " + exception.toString());
        }
    }

    public Collection getAllRepertoireMos() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllRepertoireMos ( )");
        }
        try {
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    hashSet.add(moIterator.nextMo());
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getAllRepertoireMos()", "RETURNS - theCurrentRepertoireMos:" + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllRepertoireMos()", "error caught.", throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public Map getAllRepertoireMosInformation() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllRepertoireMosInformation( )");
        }
        try {
            HashMap<String, RepertoireMoSU_Access> hashMap = new HashMap<String, RepertoireMoSU_Access>();
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)moIterator.nextMo();
                    hashMap.put(repertoireMoSU_Access.getName(null), repertoireMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getAllRepertoireMosInformation()", "RETURNS - theCurrentRepertoireMosInformation:" + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllRepertoireMosInformation()", "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public Map getRepertoireSwAllocationsConnections(Map map) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireSwAllocationsConnections( )");
        }
        try {
            Iterator iterator = map.values().iterator();
            HashMap<RepertoireMoSU_Access, ManagedObject[]> hashMap = new HashMap<RepertoireMoSU_Access, ManagedObject[]>();
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            while (iterator.hasNext()) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                hashMap.put(repertoireMoSU_Access, repertoireMoSU_Access.getReservedBy(null));
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getRepertoireSwAllocationsConnections( )", "RETURNS - theRepSwA_Connections: " + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoireSwAllocationsConnections()", "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public Collection getSwAllocationsOfRepertoires(RepertoireMoSU_Access repertoireMoSU_Access) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationsOfRepertoires(SwManagementMoSU_Access aSwManagementMoSU_Access)");
        }
        try {
            ArrayList<SwAllocationMoSU_Access> arrayList = new ArrayList<SwAllocationMoSU_Access>();
            ManagedObject[] managedObjectArray = repertoireMoSU_Access.getReservedBy(null);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                arrayList.add((SwAllocationMoSU_Access)managedObjectArray[i]);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSwAllocationsOfRepertoires(RepertoireMoSU_Access aRepertoireMoSU_Access)", "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public Vector getAllCurrentRepertoireMoDatas() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllCurrentRepertoireMoDatas ( )");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            Vector<RepertoireMoData> vector = new Vector<RepertoireMoData>();
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteCurrentRepertoires()", "No current repertoires exist.");
                }
                return vector;
            }
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            while (moIterator.hasMoreElements()) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)moIterator.nextMo();
                String string = repertoireMoSU_Access.getName(null);
                String string2 = repertoireMoSU_Access.getNamingAttributeValue();
                RepertoireMoData repertoireMoData = new RepertoireMoData(repertoireMoSU_Access, string, string2);
                vector.add(repertoireMoData);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteCurrentRepertoires()", "All current repertoires are:" + vector);
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getAllCurrentRepertoireMoDatas ( )", "Mo access exception caught.", moAccessException);
            throw new RepertoireMO_HandlerException("getAllCurrentRepertoireMoDatas ( )\n\tMo access exception caught.\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getAllCurrentRepertoireMoDatas ( )", "Exception caught.", exception);
            throw new RepertoireMO_HandlerException("getAllCurrentRepertoireMoDatas ( )\n\tException caught.\n\tException data: " + exception.toString());
        }
    }

    public UpgradeReplacement[] getExplicitReplacementInformationForRepertoires() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExplicitReplacementInformationForRepertoires ()");
        }
        try {
            Parser parser = ParserFactory.makeParser("com.microstar.xml.SAXDriver");
            ConfigSupportMoSAXdh configSupportMoSAXdh = new ConfigSupportMoSAXdh("CreateReplacemListCmd", this, this.myUpgradeCaseLabel);
            parser.setDocumentHandler(configSupportMoSAXdh);
            parser.parse(new InputSource(new FileReader(new File(this.myUCF_Path))));
            return this.myRepertoireExplicitReplacementInformation;
        }
        catch (SAXException sAXException) {
            Trace.error(this.getClass(), "getExplicitReplacementInformationForRepertoires ()", "SAXException caught: \n\tMoAccessException data: " + sAXException.toString(), sAXException);
            throw new RepertoireMO_HandlerException("getExplicitReplacementInformationForRepertoires ()\n\tSAXException caught: \n\tSAXException data: " + sAXException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getExplicitReplacementInformationForRepertoires ()", "Exception caught: \n\tException data: " + exception.toString(), exception);
            throw new RepertoireMO_HandlerException("getExplicitReplacementInformationForRepertoires ()\n\tException caught: \n\tException data: " + exception.toString());
        }
    }

    public Collection getLoadModuleBaseInformations(RepertoireMoSU_Access repertoireMoSU_Access, PiuTypeMoSU_Access piuTypeMoSU_Access) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access);
        }
        try {
            Collection collection = repertoireMoSU_Access.getLoadModuleRefInfos(new PiuTypeRefInfo(piuTypeMoSU_Access.getLocalDistinguishedName()), null);
            Iterator iterator = collection.iterator();
            LoadModuleRefInfo loadModuleRefInfo = null;
            HashSet<String> hashSet = null;
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
            String string = null;
            String string2 = null;
            LinkedList<LoadModuleRefLDN_Information> linkedList = new LinkedList<LoadModuleRefLDN_Information>();
            while (iterator.hasNext()) {
                loadModuleRefInfo = (LoadModuleRefInfo)iterator.next();
                string = loadModuleRefInfo.getLdn();
                string2 = loadModuleRefInfo.getTag();
                hashSet = (HashSet<String>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                if (hashSet.add(string2)) {
                    hashMap.put(string, hashSet);
                    linkedList.add(new LoadModuleRefLDN_Information(string2, string));
                    if (!Trace.valid(this.getClass(), 40)) continue;
                    Trace.debug(this.getClass(), 40, "getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "Adding unique LoadModuleRef data to list, LDN: " + string + ", tag: " + string2 + ", RepertoireName: " + repertoireMoSU_Access.getName(null) + ", ProdNoAndRev of PiuType: " + piuTypeMoSU_Access.getProductNumber(null) + "_" + piuTypeMoSU_Access.getProductRevision(null));
                    continue;
                }
                if (!Trace.valid(this.getClass(), 40)) continue;
                Trace.debug(this.getClass(), 40, "getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "Ignoring not unique LoadModuleRef data, LDN: " + string + ", tag: " + string2 + ", RepertoireName: " + repertoireMoSU_Access.getName(null) + ", ProdNoAndRev of PiuType: " + piuTypeMoSU_Access.getProductNumber(null) + "_" + piuTypeMoSU_Access.getProductRevision(null));
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "Number of elements in returned list: " + linkedList.size() + ", RepertoireName: " + repertoireMoSU_Access.getName(null) + ", ProdNoAndRev of PiuType: " + piuTypeMoSU_Access.getProductNumber(null) + "_" + piuTypeMoSU_Access.getProductRevision(null));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "RETURNS - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tThrowable caught: " + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getLoadModuleBaseInformations(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tThrowable caught: " + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getLoadModuleInfosVersion1(RepertoireMoSU_Access repertoireMoSU_Access, PiuTypeMoSU_Access piuTypeMoSU_Access) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleInfosVersion1(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access);
        }
        try {
            Struct[] structArray = repertoireMoSU_Access.getLMData(piuTypeMoSU_Access, null);
            LinkedList<LoadModuleRefLDN_Information> linkedList = new LinkedList<LoadModuleRefLDN_Information>();
            for (int i = 0; i < structArray.length; ++i) {
                linkedList.add(new LoadModuleRefLDN_Information(repertoireMoSU_Access.getLM_DataTag(structArray[i]), repertoireMoSU_Access.getLM_DataLoadModuleLDN(structArray[i])));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleInfosVersion1(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo)", "RETURNS theLoadModuleRefBaseLDN_Informations - " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleInfosVersion1(RepertoireMoSU_Access aRepertoireMo, String aProductNumberOfPiuType, String aProductRevisionOfPiuType, PiuTypeMoSU_Access aPiuTypeMo)", "aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tThrowable caught: " + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getLoadModuleInfosVersion1(RepertoireMoSU_Access aRepertoireMo, String aProductNumberOfPiuType, String aProductRevisionOfPiuType, PiuTypeMoSU_Access aPiuTypeMo)aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tThrowable caught: " + "\n\tThrowable data: " + throwable);
        }
    }

    public TagAndLoadModuleInformation getLoadModuleInformations(Collection collection, PiuTypeMoSU_Access piuTypeMoSU_Access, Collection collection2) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleInformations(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags)", "aRepertoireMos: " + collection + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taTags: " + collection2);
        }
        try {
            TagAndLoadModuleInformation tagAndLoadModuleInformation = new TagAndLoadModuleInformation();
            Iterator iterator = collection.iterator();
            Object var6_8 = null;
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            while (iterator.hasNext()) {
                var6_8 = iterator.next();
                if (var6_8 instanceof RepertoireMoData) {
                    repertoireMoSU_Access = ((RepertoireMoData)var6_8).repertoireMo;
                } else if (var6_8 instanceof RepertoireMoSU_Access) {
                    repertoireMoSU_Access = var6_8;
                } else {
                    Trace.error(this.getClass(), "getLoadModuleInformations(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags)", "Illegal class type in input argument aRepertoireMos: " + collection);
                    throw new RepertoireMO_HandlerException("Illegal class type in input argument aRepertoireMos: " + collection);
                }
                tagAndLoadModuleInformation = this.getLoadModuleInformation(repertoireMoSU_Access, piuTypeMoSU_Access, collection2, tagAndLoadModuleInformation);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleInformations(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags)", "RETURNS - theTagAndLoadModuleRefInformations: " + tagAndLoadModuleInformation);
            }
            return tagAndLoadModuleInformation;
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleInformations(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags)", "Throwable caught: \n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getLoadModuleInformations(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags)\n\tThrowable caught: \n\tThrowable data: " + throwable);
        }
    }

    public TagAndLoadModuleInformation getLoadModuleInformation(RepertoireMoSU_Access repertoireMoSU_Access, PiuTypeMoSU_Access piuTypeMoSU_Access, Collection collection, TagAndLoadModuleInformation tagAndLoadModuleInformation) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleInformation(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags, TagAndLoadModuleInformation aTagAndLoadModuleInformation)", "aRepertoireMo: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\taTags: " + collection + "\n\taTagAndLoadModuleInformation: " + tagAndLoadModuleInformation);
        }
        try {
            PiuTypeRefInfo piuTypeRefInfo = new PiuTypeRefInfo(piuTypeMoSU_Access.getLocalDistinguishedName());
            Collection collection2 = repertoireMoSU_Access.getLoadModuleRefInfos(piuTypeRefInfo, collection, null);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getLoadModuleInformation(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags, TagAndLoadModuleInformation aTagAndLoadModuleInformation)", "theLoadModuleRefInfos: " + collection2);
            }
            Iterator iterator = collection2.iterator();
            tagAndLoadModuleInformation = SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)repertoireMoSU_Access) ? this.addTagLoadModuleInformationVersion3(iterator, tagAndLoadModuleInformation) : this.addTagLoadModuleInformationNotVersion3(iterator, tagAndLoadModuleInformation);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleInformation(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags, TagAndLoadModuleInformation aTagAndLoadModuleInformation)", "RETURNS - " + tagAndLoadModuleInformation);
            }
            return tagAndLoadModuleInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleInformation(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags, TagAndLoadModuleInformation aTagAndLoadModuleInformation)", "Throwable caught: \n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getLoadModuleInformation(RepertoireMoSU_Access aRepertoireMo, PiuTypeMoSU_Access aPiuTypeMo, Collection aTags, TagAndLoadModuleInformation aTagAndLoadModuleInformation)\n\tThrowable caught: \n\tThrowable data: " + throwable);
        }
    }

    private TagAndLoadModuleInformation addTagLoadModuleInformationVersion3(Iterator iterator, TagAndLoadModuleInformation tagAndLoadModuleInformation) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addTagLoadModuleInformationVersion3(Iterator aLoadModuleRefInfosIterator, TagAndLoadModuleInformation aTagAndLoadModuleRefInformations)", "aLoadModuleRefInfosIterator: " + iterator + "\n\taTagAndLoadModuleRefInformations: " + tagAndLoadModuleInformation);
        }
        try {
            ExtendedLoadModuleRefInfo2 extendedLoadModuleRefInfo2 = null;
            String string = null;
            LoadModuleInformationData loadModuleInformationData = null;
            while (iterator.hasNext()) {
                extendedLoadModuleRefInfo2 = (ExtendedLoadModuleRefInfo2)iterator.next();
                string = extendedLoadModuleRefInfo2.getTag();
                loadModuleInformationData = tagAndLoadModuleInformation.getLoadModuleInformationData(new Integer(string));
                if (loadModuleInformationData == null) {
                    loadModuleInformationData = new LoadModuleInformationData();
                }
                loadModuleInformationData.addLoadModuleInformation(new LoadModuleInformation(extendedLoadModuleRefInfo2.getLdn(), extendedLoadModuleRefInfo2.getTag(), extendedLoadModuleRefInfo2.getHeapSize(), extendedLoadModuleRefInfo2.getPoolSize(), extendedLoadModuleRefInfo2.getProgramInstances(), extendedLoadModuleRefInfo2.getLoaderType(), extendedLoadModuleRefInfo2.getDeviceLoaderName(), extendedLoadModuleRefInfo2.getDeviceLoaderInformation(), extendedLoadModuleRefInfo2.getRestartCounterLimit(), extendedLoadModuleRefInfo2.getRestartTimer()));
                tagAndLoadModuleInformation.set(new Integer(string), loadModuleInformationData);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "addTagLoadModuleInformationVersion3(Iterator aLoadModuleRefInfosIterator, TagAndLoadModuleInformation aTagAndLoadModuleRefInformations)", "RETURNS - " + tagAndLoadModuleInformation);
            }
            return tagAndLoadModuleInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addTagLoadModuleInformationVersion3(Iterator aLoadModuleRefInfosIterator, TagAndLoadModuleInformation aTagAndLoadModuleRefInformations)", "aLoadModuleRefInfosIterator: " + iterator + "\n\taTagAndLoadModuleRefInformations: " + tagAndLoadModuleInformation + "\n\tThrowable caught: " + throwable, throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    private TagAndLoadModuleInformation addTagLoadModuleInformationNotVersion3(Iterator iterator, TagAndLoadModuleInformation tagAndLoadModuleInformation) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addTagLoadModuleInformationNotVersion3(Iterator aLoadModuleRefInfosIterator, TagAndLoadModuleInformation aTagAndLoadModuleRefInformations)", "aLoadModuleRefInfosIterator: " + iterator + "\n\taTagAndLoadModuleRefInformations: " + tagAndLoadModuleInformation);
        }
        try {
            ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
            String string = null;
            LoadModuleInformationData loadModuleInformationData = null;
            while (iterator.hasNext()) {
                extendedLoadModuleRefInfo = (ExtendedLoadModuleRefInfo)iterator.next();
                string = extendedLoadModuleRefInfo.getTag();
                loadModuleInformationData = tagAndLoadModuleInformation.getLoadModuleInformationData(new Integer(string));
                if (loadModuleInformationData == null) {
                    loadModuleInformationData = new LoadModuleInformationData();
                }
                loadModuleInformationData.addLoadModuleInformation(new LoadModuleInformation(extendedLoadModuleRefInfo.getLdn(), extendedLoadModuleRefInfo.getTag(), extendedLoadModuleRefInfo.getHeapSize(), extendedLoadModuleRefInfo.getPoolSize(), extendedLoadModuleRefInfo.getProgramInstances(), extendedLoadModuleRefInfo.getLoaderType(), extendedLoadModuleRefInfo.getDeviceLoaderName(), extendedLoadModuleRefInfo.getDeviceLoaderInformation()));
                tagAndLoadModuleInformation.set(new Integer(string), loadModuleInformationData);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "addTagLoadModuleInformationNotVersion3(Iterator aLoadModuleRefInfosIterator, TagAndLoadModuleInformation aTagAndLoadModuleRefInformations)", "RETURNS - " + tagAndLoadModuleInformation);
            }
            return tagAndLoadModuleInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addTagLoadModuleInformationNotVersion3(Iterator aLoadModuleRefInfosIterator, TagAndLoadModuleInformation aTagAndLoadModuleRefInformations)", "aLoadModuleRefInfosIterator: " + iterator + "\n\taTagAndLoadModuleRefInformations: " + tagAndLoadModuleInformation + "\n\tThrowable caught: " + throwable, throwable);
            throw new RepertoireMO_HandlerException(throwable.toString());
        }
    }

    public PiuTypeInformation getPiuTypeInformation(PiuTypeMoSU_Access piuTypeMoSU_Access) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "getPiuTypeInformation(PiuTypeMoSU_Access aPiuTypeMo)", "aPiuTypeMo: " + piuTypeMoSU_Access);
        }
        return this.getPiuTypeInformation(this.getRepertoireMOs(), piuTypeMoSU_Access);
    }

    public PiuTypeInformation getPiuTypeInformation(Collection collection, PiuTypeMoSU_Access piuTypeMoSU_Access) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "getPiuTypeInformation(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo)", "aRepertoireMos: " + collection + "\n\taPiuTypeMo: " + piuTypeMoSU_Access);
        }
        RepertoireMoSU_Access repertoireMoSU_Access = null;
        try {
            PiuTypeInformation piuTypeInformation = new PiuTypeInformation(false);
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                PiuTypeRefInfo piuTypeRefInfo = new PiuTypeRefInfo(piuTypeMoSU_Access.getLocalDistinguishedName());
                Collection collection2 = null;
                Iterator iterator2 = null;
                LoadModuleRefInfo loadModuleRefInfo = null;
                HashSet<String> hashSet = new HashSet<String>();
                LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                while (iterator.hasNext()) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                    collection2 = repertoireMoSU_Access.getLoadModuleRefInfosOrNull(piuTypeRefInfo, null);
                    if (collection2 == null) continue;
                    piuTypeInformation.setIsPiuTypeReferencedInRepertoire(true);
                    iterator2 = collection2.iterator();
                    while (iterator2.hasNext()) {
                        loadModuleRefInfo = (LoadModuleRefInfo)iterator2.next();
                        if (!hashSet.add(loadModuleRefInfo.getLdn()) || (loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModuleMo(loadModuleRefInfo.getLdn())) == null) continue;
                        piuTypeInformation.addReferencedLoadModuleMO(loadModuleMoSU_Access);
                    }
                }
                if (Trace.valid(this.getClass(), 23)) {
                    Trace.debug(this.getClass(), 23, "getPiuTypeInformation(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo)", "returns thePiuTypeInformation: " + piuTypeInformation);
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getPiuTypeInformation(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo)", "Received Collection of Repertoire MOs is empty, returning container with empty list.");
            }
            return piuTypeInformation;
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPiuTypeInformation(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo)", "aRepertoireMos: " + collection + "\n\ttheRepertoireMO: " + repertoireMoSU_Access + "\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tThrowable caught.", throwable);
            throw new RepertoireMO_HandlerException("getPiuTypeInformation(Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo)\n\taPiuTypeMo: " + piuTypeMoSU_Access + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public Collection getPiuTypeMos(Collection collection) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "getPiuTypeMos(Collection aRepertoireMos)", "aRepertoireMos: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            ManagedObject[] managedObjectArray = null;
            while (iterator.hasNext()) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                managedObjectArray = repertoireMoSU_Access.getPiuTypeList(null);
                if (managedObjectArray == null) continue;
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    hashSet.add(managedObjectArray[i]);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getPiuTypeMos(Collection aRepertoireMos)", "RETURNS - thePiuTypes: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPiuTypeMos(Collection aRepertoireMos)", "aRepertoireMos: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getPiuTypeMos(Collection aRepertoireMos)\n\taRepertoireMos: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getPiuTypeMosMP(Collection collection) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "getPiuTypeMosMP(Collection aRepertoireMos)", "aRepertoireMos: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            ManagedObject[] managedObjectArray = null;
            PiuTypeMoSU_Access piuTypeMoSU_Access = null;
            while (iterator.hasNext()) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                managedObjectArray = repertoireMoSU_Access.getPiuTypeList(null);
                if (managedObjectArray == null) continue;
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    piuTypeMoSU_Access = (PiuTypeMoSU_Access)managedObjectArray[i];
                    if (piuTypeMoSU_Access.getRole(null) != 1) continue;
                    hashSet.add(managedObjectArray[i]);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getPiuTypeMosMP(Collection aRepertoireMos)", "RETURNS - thePiuTypes: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPiuTypeMosMP(Collection aRepertoireMos)", "aRepertoireMos: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getPiuTypeMosMP(Collection aRepertoireMos)\n\taRepertoireMos: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getReferencedLoadModules(ActualTypeOfUP actualTypeOfUP, Collection collection, PiuTypeMoSU_Access piuTypeMoSU_Access) throws RepertoireMO_HandlerException, PiuTypeNotReferencedException {
        PiuTypeInformation piuTypeInformation;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getReferencedLoadModules(ActualTypeOfUP anActualTypeOfUP, Collection aRepertoireMos, PiuTypeMoSU_Access aPiuTypeMo)", "anActualTypeOfUP: " + actualTypeOfUP + "\n\taRepertoireMos: " + collection + "\n\taPiuTypeMo: " + piuTypeMoSU_Access);
        }
        if ((piuTypeInformation = this.getPiuTypeInformation(collection, piuTypeMoSU_Access)).getIsPiuTypeReferencedInRepertoire()) {
            Collection collection2 = piuTypeInformation.getReferencedLoadModuleMOs();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getReferencedLoadModules(PiuTypeMoSU_Access aPiuTypeMo)", "returns theReferencedLoadModuleMOs: \n\t" + collection2);
            }
            return collection2;
        }
        if (actualTypeOfUP.isHW_Sensitive()) {
            throw new PiuTypeNotReferencedException("The PiuType MO '" + piuTypeMoSU_Access + "' is not referenced by any connected Repertoire MO.");
        }
        throw new PiuTypeNotReferencedException("The PiuType MO '" + piuTypeMoSU_Access + "' is not referenced by any existing Repertoire MO.");
    }

    public RepertoireMoSU_Access getRepertoireMO(String string) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireMO ( String aRepertoireName )", "aRepertoireName: " + string);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getRepertoireMO ( String aRepertoireName )", "No current repertoire MOs exist.");
                }
                return null;
            }
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            while (moIterator.hasMoreElements()) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)moIterator.nextMo();
                if (repertoireMoSU_Access.getName(null) == null || !repertoireMoSU_Access.getName(null).equals(string)) continue;
                return repertoireMoSU_Access;
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoireMO ( String aRepertoireName )", "\n\taRepertoireName: " + string + "Throwable caught." + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getRepertoireMO ( String aRepertoireName )\n\taRepertoireName: " + string + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public RepertoireMoSU_Access getRepertoireMo(String string, Coordinator coordinator) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireMo(String aName, boolean anIsInstalled, Coordinator aCoordinator)", "aName: " + string + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        return this.getRepertoireMo(string, true, coordinator);
    }

    public RepertoireMoSU_Access getRepertoireMo(String string, boolean bl, Coordinator coordinator) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireMo(String aName, boolean anIsInstalled, Coordinator aCoordinator)", "aName: " + string + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    RepertoireMoSU_Access repertoireMoSU_Access = (RepertoireMoSU_Access)moIterator.nextMo();
                    String string2 = repertoireMoSU_Access.getName(coordinator);
                    boolean bl2 = repertoireMoSU_Access.getIsInstalled(coordinator);
                    if (!string2.equals(string) || bl != bl2) continue;
                    return repertoireMoSU_Access;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoireMo(String aName, boolean anIsInstalled, Coordinator aCoordinator)", "aName: " + string + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught.", throwable);
            throw new RepertoireMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetRepertoireMo(String aName, boolean anIsInstalled, Coordinator aCoordinator)" + "\n\taName: " + string + "\n\tanIsInstalled: " + bl + "\n\taCoordinator: " + SuLib.toString(coordinator) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getRepertoireMOs(Collection collection) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireMOs ( Collection aRepertoireNames )", "aRepertoireNames: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            String string = null;
            HashSet<RepertoireMoSU_Access> hashSet = new HashSet<RepertoireMoSU_Access>();
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                repertoireMoSU_Access = this.getRepertoireMO(string);
                if (repertoireMoSU_Access != null) {
                    hashSet.add(repertoireMoSU_Access);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "getRepertoireMOs ( Collection aRepertoireNames )", "aRepertoireNames: " + collection + "\n\tA repertoire MO is missing from the node configuration. Ignoring the repertoire..." + "\n\ttheRepertoireName: " + string + "\n\taRepertoireNames: " + collection);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoireMOs ( Collection aRepertoireNames )", "\n\taRepertoireNames: " + collection + "Throwable caught." + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getRepertoireMOs ( Collection aRepertoireNames )\n\taRepertoireNames: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void reserveReferencedPiuTypes() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reserveReferencedPiuTypes()");
        }
        Control control = null;
        try {
            if (this.isSU_VersionSupported("SU_2")) {
                control = Transaction.create();
                Coordinator coordinator = Transaction.getCoordinator(control);
                Iterator iterator = this.getAllRepertoireMos().iterator();
                RepertoireMoSU_Access repertoireMoSU_Access = null;
                while (iterator.hasNext()) {
                    repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                    repertoireMoSU_Access.reserveReferencedPiuTypeMos(coordinator);
                }
            } else {
                Trace.info(this.getClass(), "reserveReferencedPiuTypes()", "SU Access version 2 is not supported by Repertoire MOs i.e. aborts the execution.");
                throw new RepertoireMO_HandlerException("SU Access version 2 is not supported by Repertoire MOs");
            }
            Transaction.commit(control);
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            Transaction.rollback(control);
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Transaction.rollback(control);
            Trace.error(this.getClass(), "reserveReferencedPiuTypes()", "Throwable caught\n\tThrowable data", throwable);
        }
    }

    public void setIsInstalledInAllRepertoireMOs() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsInstalledInAllRepertoireMOs()");
        }
        Control control = null;
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIsInstalledInAllRepertoireMOs()", "No current repertoires exist.");
                }
                return;
            }
            while (moIterator.hasMoreElements()) {
                RepertoireMoSU_Access repertoireMoSU_Access = (RepertoireMoSU_Access)moIterator.nextMo();
                control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                Coordinator coordinator = control.getCoordinator();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setIsInstalledInAllRepertoireMOs ()", "Setting attribute 'isInstalled' to true in Repertoire MO '" + repertoireMoSU_Access + "'.");
                }
                repertoireMoSU_Access.setIsInstalled(true, coordinator);
                control.getTerminator().commit();
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setIsInstalledInAllRepertoireMOs()", "MoAccessException caught.\n\tMoAccessException data: " + moAccessException.getMessage(), moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RepertoireMO_HandlerException("setIsInstalledInAllRepertoireMOs()\n\tMoAccessException caught.\n\tMoAccessException data: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setIsInstalledInAllRepertoireMOs()", "Exception caught.\n\tException data: " + exception.getMessage(), exception);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new RepertoireMO_HandlerException("setIsInstalledInAllRepertoireMOs()\n\tMoAccessException caught.\n\tMoAccessException data: " + exception.toString());
        }
    }

    public Collection getRepertoireMOs() throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireMOs()");
        }
        try {
            HashSet<ManagedObject> hashSet = new HashSet<ManagedObject>();
            MoIterator moIterator = MoRepository.instance().lookupType("Repertoire");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    hashSet.add(moIterator.nextMo());
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getRepertoireMOs()", "RETURNS - " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRepertoireMOs ( )", "Throwable caught.", throwable);
            throw new RepertoireMO_HandlerException("getRepertoireMOs ( )\n\tThrowable caught.\n\tThrowable data: " + throwable);
        }
    }

    public Collection getLoadModuleMosReferencedByRepertoires(Collection collection) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMosReferencedByRepertoires (Collection aRepertoireMoDatas)", "aRepertoireMoDatas: " + collection);
        }
        ManagedObject[] managedObjectArray = new ManagedObject[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        RepertoireMoData repertoireMoData = null;
        while (iterator.hasNext()) {
            repertoireMoData = (RepertoireMoData)iterator.next();
            managedObjectArray[n] = repertoireMoData.repertoireMo;
            ++n;
        }
        return this.getLoadModuleMosReferencedByRepertoires(managedObjectArray);
    }

    public Collection getLoadModuleMosReferencedByRepertoires(ManagedObject[] managedObjectArray) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMosReferencedByRepertoires(ManagedObject[] aRepertoireMOs)", "aRepertoireMOs: " + SuLib.toString(managedObjectArray));
        }
        try {
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            return this.getLoadModuleMosReferencedByRepertoires(managedObjectArray, loadModuleMO_HandlerInterface);
        }
        catch (RepertoireMO_HandlerException repertoireMO_HandlerException) {
            throw repertoireMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleMosReferencedByRepertoires (Collection aRepertoires)", "aRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getLoadModuleMosReferencedByRepertoires (Collection aRepertoireNames)\n\taRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private Collection getLoadModuleMosReferencedByRepertoires(ManagedObject[] managedObjectArray, LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMosReferencedByRepertoires(ManagedObject[] aRepertoireMOs, LoadModuleMO_HandlerInterface aLoadModuleMO_Handler)", "aRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\taLoadModuleMO_Handler: " + loadModuleMO_HandlerInterface);
        }
        try {
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            Iterator iterator = null;
            LoadModuleRefInfo loadModuleRefInfo = null;
            String string = null;
            HashSet<String> hashSet = new HashSet<String>();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            HashSet<LoadModuleMoSU_Access> hashSet2 = new HashSet<LoadModuleMoSU_Access>();
            for (int i = 0; i < managedObjectArray.length; ++i) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)managedObjectArray[i];
                iterator = repertoireMoSU_Access.getLoadModuleRefInfosConnectedToAnyPiuTypeRef(null).iterator();
                while (iterator.hasNext()) {
                    loadModuleRefInfo = (LoadModuleRefInfo)iterator.next();
                    string = loadModuleRefInfo.getLdn();
                    if (!hashSet.add(string) || (loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModuleMo(string)) == null) continue;
                    hashSet2.add(loadModuleMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModuleMosReferencedByRepertoires(ManagedObject[] aRepertoireMOs, LoadModuleMO_HandlerInterface aLoadModuleMO_Handler)", "RETURNS - theAllReferencedLM_MOs: " + hashSet2);
            }
            return hashSet2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleMosReferencedByRepertoires(ManagedObject[] aRepertoireMOs, LoadModuleMO_HandlerInterface aLoadModuleMO_Handler)", "aRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable, throwable);
            throw new RepertoireMO_HandlerException("getLoadModuleMosReferencedByRepertoires(ManagedObject[] aRepertoireMOs, LoadModuleMO_HandlerInterface aLoadModuleMO_Handler)\n\taRepertoireMOs: " + SuLib.toString(managedObjectArray) + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private String calculateLDN_Value(String string, Vector vector) throws RepertoireMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateLDN_Value ( String aRepertoireName, Vector anOldRepertoireMoDatas )", "aRepertoireName: " + string + "\n\tanOldRepertoireMoDatas: " + vector);
        }
        try {
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                RepertoireMoData repertoireMoData = null;
                while (enumeration.hasMoreElements()) {
                    repertoireMoData = (RepertoireMoData)enumeration.nextElement();
                    if (!string.equals(repertoireMoData.repertoireName)) continue;
                    return repertoireMoData.ldnValue;
                }
                return string;
            }
            return string;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "calculateLDN_Value ( String aRepertoireName, Vector anOldRepertoireMoDatas )", "aRepertoireName: " + string + "\n\tanOldRepertoireMoDatas: " + vector + "\n\tException caught." + "\n\tException data: " + exception.toString(), exception);
            throw new RepertoireMO_HandlerException("calculateLDN_Value ( String aRepertoireName, Vector anOldRepertoireMoDatas )\n\taRepertoireName: " + string + "\n\tanOldRepertoireMoDatas: " + vector + "\n\tException caught." + "\n\tException data: " + exception.toString());
        }
    }

    private Map buildSetOfLM_MOsMap() throws LoadModuleMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "buildSetOfLM_MOsMap()");
        }
        try {
            HashMap<String, LoadModuleMoSU_Access> hashMap = new HashMap<String, LoadModuleMoSU_Access>();
            MoIterator moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator == null) {
                return hashMap;
            }
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            String string = null;
            while (moIterator.hasMoreElements()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? loadModuleMoSU_Access.getProductNumberOpt(null) + "_" + loadModuleMoSU_Access.getProductRevisionOpt(null) : StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)) + "_" + StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null));
                if (hashMap.get(string) == null) {
                    hashMap.put(string, loadModuleMoSU_Access);
                    continue;
                }
                Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "More than one LM MO has been configured with the same product number and revision. This may result in an inconsistent configuration of the node\n\ttheProdNoRevKey: " + string + "\n\tWill use the LM MO instance: " + hashMap.get(string) + "\n\tIgnoring the LM MO instance: " + loadModuleMoSU_Access);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "buildSetOfLM_MOsMap()", "Throwable caught", throwable);
            throw new LoadModuleMO_HandlerException(throwable.toString());
        }
    }
}

