/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class TimeHandler {
    public static final int TEN_SECONDS = 10000;
    public static final long THREE_SECONDS = 3000L;

    public static Integer createActionId() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HmmssSSS", Locale.getDefault());
        return new Integer(simpleDateFormat.format(new Date()));
    }

    public static synchronized String createActionResultDataTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'Date:' yyyy-MM-dd', Time:' H:mm:ss.SSS", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    public static synchronized String createConfirmationDeadlineTimeStamp(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static synchronized String createTraceLogTextTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'Date:'\tyyyy-MM-dd', Time:' H:mm:ss.SSS", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    public static void sleep(long l) {
        try {
            Properties properties = new Properties(System.getProperties());
            String string = properties.getProperty("SU_SIM");
            if (string != null && string.equals("yes")) {
                if (l <= 1000L) {
                    if (Trace.valid(TimeHandler.class, 22)) {
                        Trace.debug(TimeHandler.class, 22, "sleep(long aTimeToSleepInMilliseconds)", "Sleeps 1 second.");
                    }
                    Thread.sleep(1000L);
                } else if (l > 1000L && l < 10000L) {
                    if (Trace.valid(TimeHandler.class, 22)) {
                        Trace.debug(TimeHandler.class, 22, "sleep(long aTimeToSleepInMilliseconds)", "Sleeps 3 second and " + l / 10L + " ms instead of " + l + " ms due to SU SIM.");
                    }
                    Thread.sleep(3000L + l / 10L);
                } else {
                    if (Trace.valid(TimeHandler.class, 22)) {
                        Trace.debug(TimeHandler.class, 22, "sleep(long aTimeToSleepInMilliseconds)", "Sleeps " + l / 10L / 1000L + " seconds instead of " + l + " ms due to SU SIM.");
                    }
                    Thread.sleep(l / 10L);
                }
            } else {
                Thread.sleep(l);
            }
        }
        catch (Exception exception) {
            Trace.error(TimeHandler.class, "sleep(long aTimeToSleepInMilliseconds)", "Exception caught while trying to sleep for " + l + " milliseconds.", exception);
        }
    }

    public static void sleepShort(long l) {
        try {
            Properties properties = new Properties(System.getProperties());
            String string = properties.getProperty("SU_SIM");
            if (string != null && string.equals("yes")) {
                if (l > 0L) {
                    long l2 = l / 100L;
                    if (l2 > 0L) {
                        if (Trace.valid(TimeHandler.class, 22)) {
                            Trace.debug(TimeHandler.class, 22, "sleep(long aTimeToSleepInMilliseconds)", "Sleeps " + l2 + " ms.");
                        }
                        Thread.sleep(l2);
                    } else {
                        if (Trace.valid(TimeHandler.class, 22)) {
                            Trace.debug(TimeHandler.class, 22, "sleep(long aTimeToSleepInMilliseconds)", "Sleeps 10 ms. The shortTime was calculated to 0 ms");
                        }
                        Thread.sleep(10L);
                    }
                }
            } else {
                Thread.sleep(l);
            }
        }
        catch (Exception exception) {
            Trace.error(TimeHandler.class, "sleep(long aTimeToSleepInMilliseconds)", "Exception caught while trying to sleep for " + l + " milliseconds.", exception);
        }
    }

    public static synchronized String createCV_TimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd'_'HHmm", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }
}

