/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomRangeImpl;
import se.ericsson.cello.mimparser.state.DefaultSettable;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MultiplicationFactorSettable;
import se.ericsson.cello.mimparser.state.ResolutionSettable;
import se.ericsson.cello.mimparser.state.UnitSettable;

public class MomCorbaTypeAttributeImpl
extends MomBase
implements MomCorbaTypeAttribute,
MaxMinSettable,
DefaultSettable,
UnitSettable,
MultiplicationFactorSettable,
ResolutionSettable {
    private static final String EMPTY_STRING = "";
    private static final String NULL = "null";
    private static final String DEFAULT_VALUE = "defaultValue: ";
    private static final String DATA_TYPE = "dataType: ";
    private static final String NEWLINE = "\n";
    private static final String RESOLUTION = "resolution: ";
    private static final String MULTIPLICATION_FACTOR = "multiplicationFactor: ";
    private static final String UNIT = "unit: ";
    private static final String VALID_VALUES = "validValues";
    private static final String MIN_VALUE_RANGE = "min: ";
    private static final String MAX_VALUE_RANGE = "max: ";
    private String javaType;
    private String validValues;
    private String unit;
    private String multiplicationFactor;
    private String resolution;
    private String parentName;
    private String defaultRawData;
    private List momRanges = new ArrayList(0);
    private Object myDefaultValue;
    private MomRangeImpl currentMomRange;

    public MomCorbaTypeAttributeImpl(String string, String string2, Attributes attributes, MimModelImpl mimModelImpl, int n) {
        super(string, attributes, mimModelImpl, n);
        this.parentName = string2;
        this.javaType = this.convertToJavaType(string);
    }

    public Iterator getRanges() {
        return this.momRanges.iterator();
    }

    public String getDefaultRawData() {
        return this.defaultRawData;
    }

    public String getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String string) {
        this.validValues = string;
    }

    public String getType() {
        return this.javaType;
    }

    public void addMinValue(String string) {
        this.currentMomRange = new MomRangeImpl();
        Number number = this.convertToNumber(string);
        this.currentMomRange.setMin(number);
        this.currentMomRange.setMinRawData(string);
        this.momRanges.add(this.currentMomRange);
    }

    public void addMaxValue(String string) {
        MomRangeImpl momRangeImpl = this.currentMomRange;
        boolean bl = true;
        if (this.currentMomRange == null) {
            bl = false;
            momRangeImpl = new MomRangeImpl();
        }
        Number number = this.convertToNumber(string);
        momRangeImpl.setMax(number);
        momRangeImpl.setMaxRawData(string);
        if (!bl) {
            this.momRanges.add(momRangeImpl);
        }
        this.currentMomRange = null;
    }

    public void setDefault(String string) {
        this.defaultRawData = string;
        this.myDefaultValue = this.convertToJavaObject(string);
    }

    public Object getDefault() {
        return this.myDefaultValue;
    }

    private Number convertToNumber(String string) {
        Number number = null;
        try {
            string = string.trim();
            if (this.getXmlType().equals("double")) {
                number = new Double(string);
            } else if (this.getXmlType().equals("float")) {
                number = new Float(string);
            } else if (this.getXmlType().equals("longlong")) {
                number = new Long(string);
            } else {
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                number = new Integer(string);
            }
            return number;
        }
        catch (Exception exception) {
            String string2 = "MomCorbaTypeAttributeImpl.convertToNumber()  Can not convert String to Number for name = " + this.getName() + " xml type=" + this.getXmlType() + "  value_to_convert=" + string + "  Exception=" + exception.toString();
            this.getModel().addToWarningList(string2);
            return number;
        }
    }

    private Object convertToJavaObject(String string) {
        try {
            if (!this.getXmlType().equals("string") && !this.getXmlType().equals("wstring")) {
                if (string.length() < 1) {
                    return null;
                }
                if ((string = string.trim()).length() < 1) {
                    return null;
                }
            }
            Object object = string;
            if (this.getXmlType().equals("boolean")) {
                object = new Boolean(string);
            } else if (this.getXmlType().equals("octet")) {
                object = new Byte(string);
            } else if (this.getXmlType().equals("char")) {
                char c = string.charAt(0);
                object = new Character(c);
            } else if (this.getXmlType().equals("double")) {
                object = new Double(string);
            } else if (this.getXmlType().equals("float")) {
                object = new Float(string);
            } else if (this.getXmlType().equals("long")) {
                object = new Integer(string);
            } else if (this.getXmlType().equals("longlong")) {
                object = new Long(string);
            } else if (this.getXmlType().equals("short")) {
                object = new Short(string);
            }
            return object;
        }
        catch (Exception exception) {
            String string2 = "MomCorbaTypeAttributeImpl.convertToJavaObject()  Can not convert String to Java Object for name = " + this.parentName + " xml type=" + this.getXmlType() + "  value_to_convert=" + string + "  Exception=" + exception.toString();
            this.defaultRawData = string;
            this.getModel().addToWarningList(string2);
            return null;
        }
    }

    private String convertToJavaType(String string) {
        String string2 = null;
        if (this.getXmlType().equals("boolean")) {
            string2 = "Boolean";
        } else if (this.getXmlType().equals("octet")) {
            string2 = "Byte";
        } else if (this.getXmlType().equals("char")) {
            string2 = "Character";
        } else if (this.getXmlType().equals("double")) {
            string2 = "Double";
        } else if (this.getXmlType().equals("float")) {
            string2 = "Float";
        } else if (this.getXmlType().equals("long")) {
            string2 = "Integer";
        } else if (this.getXmlType().equals("longlong")) {
            string2 = "Long";
        } else if (this.getXmlType().equals("short")) {
            string2 = "Short";
        } else if (this.getXmlType().equals("string")) {
            string2 = "String";
        } else if (this.getXmlType().equals("wstring")) {
            string2 = "String";
        } else {
            String string3 = "MomCorbaTypeAttributeImpl.convertToJavaType()  Can not convert corba Type to java type for element:" + this.parentName + " corba type=" + string + " reason: Unknown corbaType";
            this.getModel().addToWarningList(string3);
            this.defaultRawData = string;
        }
        return string2;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public String getMultiplicationFactor() {
        return this.multiplicationFactor;
    }

    public void setMultiplicationFactor(String string) {
        this.multiplicationFactor = string;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String string) {
        this.resolution = string;
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DATA_TYPE + this.getXmlType() + NEWLINE);
        String string = this.appendDefaultValues(this);
        if (this.getUnit() != null) {
            stringBuffer.append(UNIT + this.getUnit() + NEWLINE);
        }
        if (this.getMultiplicationFactor() != null) {
            stringBuffer.append(MULTIPLICATION_FACTOR + this.getMultiplicationFactor() + NEWLINE);
        }
        if (this.getResolution() != null) {
            stringBuffer.append(RESOLUTION + this.getResolution() + NEWLINE);
        }
        if (!string.equalsIgnoreCase(NULL) && !string.equalsIgnoreCase(EMPTY_STRING)) {
            stringBuffer.append(DEFAULT_VALUE + string + NEWLINE);
        }
        if (this.getValidValues() != null) {
            stringBuffer.append(VALID_VALUES + this.getValidValues() + NEWLINE);
        }
        Iterator iterator = this.getRanges();
        while (iterator.hasNext()) {
            MomRangeImpl momRangeImpl = (MomRangeImpl)iterator.next();
            stringBuffer.append(MIN_VALUE_RANGE + momRangeImpl.getMinRawData() + "\t");
            stringBuffer.append(MAX_VALUE_RANGE + momRangeImpl.getMaxRawData() + NEWLINE);
        }
        return stringBuffer.toString();
    }
}

