/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.ncli.mibmgr.DumpFileWriter;
import se.ericsson.cello.ncli.mibmgr.MoAttribute;
import se.ericsson.cello.ncli.server.logging.Log;

public class MoAttributesCollector {
    public static void collectAttributes(MoAttribute moAttribute, DumpFileWriter dumpFileWriter) {
        if (moAttribute.getMoFormat() == 1) {
            Log.trace(MoAttributesCollector.class, "Instance specified: " + moAttribute.getLdn());
            ManagedObject managedObject = MoRepository.instance().lookup(moAttribute.getLdn());
            if (managedObject != null) {
                try {
                    Log.trace(MoAttributesCollector.class, "Read attributes from " + managedObject.getLocalDistinguishedName());
                    moAttribute.setMo(managedObject);
                    Object[] objectArray = MoAttributesCollector.getAttributes(moAttribute.getAttributes(), managedObject);
                    moAttribute.setValues(objectArray);
                }
                catch (Exception exception) {
                    Log.trace(MoAttributesCollector.class, "Error reading attributes from " + managedObject.getLocalDistinguishedName() + ", " + exception.getMessage());
                }
                dumpFileWriter.writeMoData(moAttribute);
            }
        } else if (moAttribute.getMoFormat() == 0) {
            Log.trace(MoAttributesCollector.class, "Class specified: " + moAttribute.getMoClass());
            MoIterator moIterator = MoRepository.instance().lookupType(moAttribute.getMoClass());
            if (moIterator == null) {
                Log.trace(MoAttributesCollector.class, "No instance found");
            } else {
                while (moIterator.hasMoreElements()) {
                    ManagedObject managedObject = moIterator.nextMo();
                    Log.trace(class$se$ericsson$cello$ncli$mibmgr$MoAttributesCollector == null ? MoAttributesCollector.class$("se.ericsson.cello.ncli.mibmgr.MoAttributesCollector") : class$se$ericsson$cello$ncli$mibmgr$MoAttributesCollector, "Read attributes from " + managedObject.getLocalDistinguishedName());
                    MoAttribute moAttribute2 = new MoAttribute(managedObject, moAttribute.getAttributes());
                    try {
                        Object[] objectArray = MoAttributesCollector.getAttributes(moAttribute.getAttributes(), managedObject);
                        moAttribute2.setValues(objectArray);
                    }
                    catch (Exception exception) {
                        Log.trace(class$se$ericsson$cello$ncli$mibmgr$MoAttributesCollector == null ? MoAttributesCollector.class$("se.ericsson.cello.ncli.mibmgr.MoAttributesCollector") : class$se$ericsson$cello$ncli$mibmgr$MoAttributesCollector, "Error reading attributes from " + managedObject.getLocalDistinguishedName() + ", " + exception.getMessage());
                    }
                    dumpFileWriter.writeMoData(moAttribute2);
                }
            }
        } else {
            Log.trace(MoAttributesCollector.class, "Unknown Mib dump format");
        }
    }

    private static Object[] getAttributes(String[] stringArray, ManagedObject managedObject) throws MoAccessException {
        Object[] objectArray = managedObject.getAttributes(stringArray, null);
        return objectArray;
    }
}

